/***
*filetrck.c - file "tracking"
*
*this file is part of DISKED
*Copyright (c) 1991-1998, Gregg Jennings.  All rights reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*   limits movement to sectors allocated to a file
*
*Notice:
*   This program can be distributed only in accordance with, and
*   accompanied by, the DPU Software License. See COPYING.TXT or,
*   <http://www.diskwarez.com/dpu.htm>.
*******************************************************************************/

/*
   Versions:

   0.3   02-Jul-1998    added a case: defualt
   0.2   13-Sep-1996    #include <stdio.h>
   0.1   14-Mar-1995
   0.0   02-Sep-1994    PRELIMINARY

   Release Notes:

   To track a file - create an array holding the cluster numbers
   which are allocated to the file - that's it!

   Programming Notes:

   From this array, the current cluster (only those clusters allocated
   to the file will be able to be selected) is used to figure out the
   offset into the file for the sector buffer display.

   Much more needs to be done here. To fully edit LFN directory
   entries the entire directory needs to be edited (i.e. the LFN
   entries can cross sector boundries).

*/

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>

#include "disked.h"
#include "diskio.h"
#include "files.h"
#include "keys.h"
#include "alloc.h"
#include "arrays.h"
#include "console.h"
#include "mylib.h"

/* globals defined here */

int ft_track = 0;

/* globals referenced here

   log_sector, secs_cluster, clusters,
   cluster_size, num_clusters
*/

static unsigned int *ftarray;
static long ftsize;
static size_t ftclstrs;

extern int filetrack(const char *file, const int fnum)
{
   if (ft_track == 0)
   {
      ftsize = filesize(file);
      if (ftsize == -1L)
         return 0;
      ftclstrs = (unsigned)(ftsize / cluster_size) + 1;
      if ((ftarray = alloc(ftclstrs,sizeof(int))) == NULL)
         return -1;
      arraysub(clusters,(int *)ftarray,num_clusters,fnum);
      ft_track = 1;
   }
   else
   {
      ft_track = 0;
      if (ftarray)
         freep(ftarray);
   }
   return ft_track;
}

extern void filetell(void)
{
size_t i;

   for (i = 0; i < ftclstrs; i++)
      print("%d ",ftarray[i]);
}

extern int fileoffset(unsigned int cluster)
{
   return arrayfind((int __huge *)ftarray,ftclstrs,cluster);
}

extern long filebytes(void)
{
int j = clustersector(log_sector);
int s = fileoffset(sectortocluster(log_sector));

   return (long)(((long)s*(long)secs_cluster) + (long)j) * (long)sec_size;
}

/***
*trackfile -
*
*
****/

extern int trackfile(KEY *c)
{
int r = 1;

   if (!ft_track)
      return 0;      /* tracking off */

   switch (*c)
   {
      case 'q':
      case '.':
      case ESC:
         if (Display || Verify)
            print(" exit tracking");
         if (*c != ESC && Verify && !getver("",0))
            break;
         filetrack(NULL,0);
         r = -1;
         break;
      case 'n':                           /* next sector */
      case DOWN:
         if (clustersector(log_sector) == secs_cluster-1)
            *c = 'j';
         break;
      case 'N':
      case RIGHT:                         /* next cluster */
         *c = 'j';
         break;
      case 'b':                           /* back sector */
      case UP:
         if (clustersector(log_sector) == 0)
            *c = 'J';
         break;
      case 'B':
      case LEFT:
         *c = 'J';
         break;
      case 'H':
      case HOME:
         *c = CHOME;
         break;
      case 'E':
      case END:
         *c = CEND;
         break;

      /* commands to ignore */

      case 'r':      /* */
      case 'R':
      case 'R'-'@':
      case F10:
      case 'f':
      case '\\':
      case 'F'-'@':
      case 'G'-'@':
      case '+':
      case '-':      /* */
      case 'N'-'@':
      case PGDN:
      case 'B'-'@':
      case PGUP:
      case 'S'-'@':
      case 'S':
      case 's':
      case 'h':
         r = -1;     /* ignore */
         break;

      default:
         break;
   }
   return r;            /* performed a conversion or ok */
}

#if 0
extern int filefind(int kase)
{
int i;                                    /* return value */
char str[SEARCH+1];                       /* 4 times max string length */
static char findstr[SEARCH+1];            /* string to search disk for */
static char tmpfstr[SEARCH+1];            /* plus a bunch extra */
static unsigned int findlen=0;

   i = -1;
   str[0] = '\0';

   if (getstr(str,SEARCH,_TEXT) == ABORT) /* get string */
      return(ABORT);                      /* return on ESC or ^C */
   if (str[0] == '\0' && findlen == 0)    /* is no string to search for */
      return(ABORT);                      /* then return ABORT */
   if (str[0])                            /* save the string in tempstr */
   {
      strcpy(findstr,str);                /* to search for the same string */
      strcpy(tmpfstr,str);                /* tmpfstr holds the un-converted */
      findlen = convert(findstr);         /* convert if needed */
   }
   else
      print(tmpfstr);

   i = dsk_search((byte *)findstr,findlen, (kase) ? isearch : search);

   return i;
}

static int search(byte *str, int strcnt, int (func(byte*,byte*,word,word)))
{
unsigned long ntimes;
register int io,i;
byte *xbuf,*lxbuf;
int bcnt,first;

   if ((xbuf = (byte *)alloc(1,sec_size+strcnt)) == NULL)
      return -1;

   i = -1;
   io = 0;
   ntimes = 0L;
   bcnt = sec_size - strcnt;
   first = 1;

   for (;;)
   {
      if ((io = diskio(DISK_INC,1L,xbuf+strcnt)) != DISK_OK)
      {
         printerror(Debug);
         if (!getver("continue",CLR_ARG))
            break;
      }
      if (first)
      {
         i = func(lxbuf=xbuf+strcnt,str,sec_size-strcnt,strcnt);
         first = 0;
      }
      else
         i = func(lxbuf=xbuf,str,sec_size,strcnt);

      if (i != -1)                              /* found? */
      {
         if (i < strcnt)
         {
            if (lxbuf != xbuf)      /* first */
               break;
            movesector(-1);
            i = sec_size - (strcnt - i);
         }
         else if (i > strcnt)
         {
            if (lxbuf != xbuf)      /* first */
               break;
            i -= strcnt;
         }
         break;
      }
      if (++ntimes >= num_sectors)
      {
         print(" not found");
         break;
      }
      /* copy end of sector */
      memcpy(xbuf,xbuf+bcnt+strcnt,strcnt);

      /* check for abort */
      if (kbhit())
         break;
   }
   freep(xbuf);
   return i;
}
#endif
