	PAGE

;ANALIZE EQUIPMENT AND BUILD LIST

INTR77	LABEL	FAR
GETEQP	PROC	FAR
	PUSH	SI
	PUSH	DI
	CALL	GETCPU		;FIND CPU TYPE
	MOV WORD PTR CPUTYP,AX
	CALL	GETNPX		;NPX TYPE
	MOV WORD PTR NPXTYP,AX
	CALL	VCNFIG		;GET VIDEO CONFIGURATION
	MOV WORD PTR VIDTYP,AX
	CALL	SPEED		;GET CPU SPEED
	MOV WORD PTR CPUSPD,AX
	MOV AX,OFFSET EQARAY	;GET ADDRESS OF ARRAY
	POP	DI
	POP	SI
	RET
GETEQP	ENDP

	PAGE

;ARRAY OF EQUIPMENT AVAILABLE

DSEG	SEGMENT WORD PUBLIC 'DATA'
EQARAY	LABEL	WORD
CPUTYP	DW	0		;HOLDS CPU TYPE
NPXTYP	DW	0		;HOLDS COPROCESSOR TYPE
VIDTYP	DW	0		;VIDEO AND MONITOR TYPE
CPUSPD	DW	0		;HOLDS PROCESSOR SPEED
	DW	XPLVER		;XPL VERSION NUMBER
	DW	XPLTYP		;XPL TYPE (NATIVE/INTERPRETER)

;LOCAL VARIABLES
	EVEN			;TO MAKE TIMES CONSISTENT
NPXTMP	DW	3 DUP(?)	;TEMPORARY FOR NPX AND SPEED TEST
DSEG	ENDS


;TEST CPU TYPE, RETURN 86,286,386 OR 486 IN AX

GETCPU:	PUSHF				;SAVE COPY OF FLAGS AND
	PUSH	BX			;OTHER AFFECTED REGISTERS
	PUSH	CX
	PUSHF				;NOW TRY TO CLEAR BITS 12-15
	POP	AX			;OF CPU FLAGS
	AND	AX,0FFFH
	PUSH	AX			;SET MODIFIED CPU FLAGS
	POPF
	PUSHF
	POP	AX			;GET FLAGS AGAIN
	AND	AX,0F000H		;IF BITS 12-15 ARE STILL
	CMP	AX,0F000H		;SET, THIS IS 8086/88
	JNE	CPU1			;JUMP, NOT 8086/88
	MOV	AX,86			;SET AX = 86/88 CPU TYPE
	JMP	CPUX			;AND EXIT

CPU1:	OR	AX,0F000H		;MUST BE 286 OR LATER,
	PUSH	AX			;NOW TRY TO SET BITS 12-15
	POPF				;OF CPU FLAGS
	PUSHF
	POP	AX			;IF BITS 12-15 CAN'T BE
	AND	AX,0F000H		;SET, THIS IS A 286
	JNZ	CPU2			;JUMP, NOT 80286
	MOV	AX,286			;SET AX = 286 CPU TYPE
	JMP	CPUX			;AND EXIT
	PAGE
	.386
CPU2:	MOV	BX,SP			;386 OR LATER, SAVE SP
	AND	SP,NOT 3		;AVOID STACK ALIGNMENT FAULT
	PUSHFD				;GET VALUE OF EFLAGS
	POP	EAX
	MOV	ECX,EAX			;SAVE COPY OF EFLAGS
	XOR	EAX,40000H		;FLIP AC BIT IN EFLAGS
	PUSH	EAX			;TRY AND FORCE EFLAGS
	POPFD
	PUSHFD				;GET BACK EFLAGS VALUE
	POP	EAX
	MOV	SP,BX			;RESTORE OLD STACK POINTER
	XOR	EAX,ECX			;CAN AC BIT BE CHANGED?
	JNZ	CPU3			;JUMP IF SO, NOT JUST A 386
	MOV	AX,386			;SET AX = 386 CPU TYPE
	JMP	CPUX			;AND EXIT
CPU3:
	AND	SP,NOT 3		;AVOID STACK ALIGNMENT FAULT
	PUSH	ECX			;RESTORE AC BIT
	POPFD
	MOV	SP,BX			;RESTORE OLD STACK POINTER
	MOV	EAX,ECX			;GET ORIGINAL EFLAGS
	XOR	EAX,200000H		;FLIP ID BIT IN EFLAGS
	PUSH	EAX			;TRY AND FORCE EFLAGS
	POPFD
	PUSHFD				;GET BACK EFLAGS VALUE
	POP	EAX
	XOR	EAX,ECX			;CAN ID BIT BE CHANGED?
	JNZ	CPU4			;JUMP IF SO, NOT JUST A 486
	MOV	AX,486			;SET AX = 486 CPU TYPE
	JMP	CPUX			;AND EXIT
CPU4:	MOV	AX,586			;SET AX = 586 CPU TYPE (PENTIUM)

	.8086
CPUX:	POP     CX			;RESTORE REGISTERS
	POP	BX
	POPF				;RESTORE ORIGINAL FLAGS
	RET				;RETURN WITH AX = CPU TYPE
	PAGE

;!! THESE ROUTINES MUST BE ASSEMBLED IN 8086 MODE OR THE ASSEMBLER
;WILL USE 386 JUMP INSTRUCTIONS AND THE CODE WON'T RUN ON AN 8086 !!

	.8087			
	.8086

;ROUTINES TO TEST FOR AND SETUP COPROCESSOR

GETNPX:	FNINIT				;INITIALIZE USING NON-WAIT FORM
	MOV	SI,OFFSET NPXTMP	;POINT TO TEMPORARY
	MOV WORD PTR [SI],5A5AH		;SET TEMP TO NON ZERO VALUE
	FNSTSW	[SI]			;GET PROCESSOR STATUS (NON-WAIT)
	CMP BYTE PTR [SI],0		;STATUS ZERO IF COPROCESSOR PRESENT
	JNE	NONPX			;EXIT IF NO COPROCESSOR

;CAN WE ACCESS THE CONTROL REGISTER?

	FNSTCW	[SI]			;GET CONTROL WORD
	MOV	AX,[SI]
	AND	AX,103FH		;TEST SELECTED BITS
	CMP	AX,3FH			;CHECK THAT ONES AND ZEROS CORRECT
	JNE	NONPX			;EXIT IF NO COPROCESSOR

;NOW CHECK FOR 87/287 VS 387

	FLD1				;FORM INFINITY (ONE DIVIDED BY ZERO)
	FLDZ
	FDIV
	FLD	ST			;DUPLICATE TOS
	FCHS				;MAKE TOS NEGATIVE INFINITY
	FCOMPP				;POS AND NEG INFINITY NOT EQUAL ON 387
	FSTSW	[SI]			;GET STATUS IN CPU FLAGS
	MOV	AX,[SI]
	SAHF
	JNE	FND387			;EXIT IF 387

;HERE IF IT'S A 87/287

	MOV	AX,87
	FINIT
	RET

;HERE IF WE FOUND A 387

FND387:	MOV	AX,387		;FLAG 387 FOUND
	FINIT
	RET

;HERE IF NO 387 IS PRESENT

NONPX:	MOV	AX,0		;FLAG NO PROCESSOR FOUND
	RET
	PAGE

;ROUTINES TO DETERMINE THE VIDEO ADAPTER AND MONITOR TYPE

;These codes indicate the type of video adapter used

;MDPA		- 01H	Monochrome Display Adapter		
;CGA		- 02H	Color Graphics Adapter			
;EGA		- 04H	Enhanced Graphics Adapter		
;VGA		- 08H	Video Graphics Array			
;MCGA		- 10H	MultiColor Graphics Array		
;HGC		- 20H	Hercules Graphics Card			

;These codes indicate the type of monitor used

;MONO		- 01H	Monochrome
;COLOR		- 02H	Color (or Enhanced emulating color)
;ENHCOLOR	- 04H	Enhanced Color
;ANALOGMONO	- 08H	Analog Monochrome only
;ANALOGCOLOR	- 10H	Analog Color only
;ANALOG		- 18H	Analog Monochrome and Color modes


;BIOS RAM CONFIGURATION MEMORY ADDRESSES

BIODEV	EQU	410H		;BIOS DEVICE TABLE
BIOSWT	EQU	488H		;BIOS VGA SWITCH SETTINGS
BIOCON	EQU	489H		;BIOS VGA CONTROL SETTINGS

	;LOCAL VARIABLES
DSEG	SEGMENT	WORD PUBLIC 'DATA'

FUNBUF	DB	40H DUP(?)	;TABLE TO HOLD FUNCTIONALITY/STATE INFO

MONFLG	DB	0	;FLAGS MONOCHROME MONITOR
SWITCH	DB	0	;VGA SWITCH SETTINGS
CONTRL	DB	0	;HOLDS VGA CONTROL BITS

ADAPTR	DB	0	;ADAPTER TYPE
MONITR	DB	0	;MONITOR TYPE
DSEG	ENDS
	PAGE

;ROUTINE RETURNS THE VIDEO CONFIGURATION OF THE COMPUTER
;CONFIGURATE CODE RETURNED IN AX, AH=MONITOR TYPE AL=ADAPTOR TYPE

VCNFIG:				;ASSUME CGA AND COLOR MONITOR
	MOV	ADAPTR,2	;SET CGA ADAPTER
	MOV	MONITR,2	;SET COLOR ADAPTER

;READ BIOS RAM FLAG AND SAVE FOR LATER USE

	PUSH	ES		;SAVE ES
	SUB	AX,AX		;POINT TO BIOS RAM DATA AREA
	MOV	ES,AX

;CHECK BIOS FOR MONOCHROME AT STARTUP, SET FLAG ACCORDINGLY

	MOV	MONFLG,0	;PRESET FLAG FALSE
	MOV	AL,ES:[BIODEV]	;LOOK AT BIOS MONITOR
	AND	AL,30H		;MASK VIDEO BITS
	CMP	AL,30H		;MONOCHROME?
	JNZ	VCNFG9		;SKIP IF NOT MONO
	MOV	MONFLG,0FFH	;FLAG MONO

;READ VGA FEATURE SWITCH AND SAVE FOR LATER

VCNFG9:	MOV	AL,ES:[BIOSWT]	;GET SWITCH SETTINGS
	AND	AL,0AH		;MASK THE APPROPRIATE BITS
	MOV	SWITCH,AL
	MOV	AL,ES:[BIOCON]	;GET VGA CONTROL BITS
	MOV	CONTRL,AL

;CALL BIOS AND READ FUNCTIONALITY/STATE INFORMATION

	MOV	AX,DS			;POINT TO FUNCT/STATE BUFFER
	MOV	ES,AX
	MOV	DI,OFFSET FUNBUF	;STORE FUNCT/STATE INFO HERE
	MOV	BX,0			;IMPLEMENTATION TYPE
	MOV	AX,1B00H		;SET SUBFUNCTION
	INT	10H			;CALL BIOS
	POP	ES			;RESTORE ES

;TEST BIOS VGA SUPPORT AND ACTIVE DISPLAY

	CMP	AL,1BH			;CALL NOT SUPPORTED IF AL # 1B
	JNE	VCNFG1			;CAN'T BE VGA IF NO BIOS SUPPORT
	CMP	FUNBUF+37,6		;CHECK DISPLAY CODE AGAINST PGA
	JB	VCNFG1			;SKIP TO EGA TEST IF EGA OR LESS
	CALL	VGATST			;TEST SPECIFIC VGA
	JMP	VCNFG2			;ENTER COMMON CODE

VCNFG1:	CALL	EGATST			;TEST FOR EGA VS CGA SUPPORT

;TEST FOR HERCULES ROM SUPPORT

VCNFG2:	MOV	DX,0FFFFH		;CALL HERCULES ROUTINES
	MOV	AX,0EF00H
	INT	10H
	CMP	DL,0FFH			;EXIT IF NO HERCULES SUPPORT
	JE	VCNFG3
	MOV	AL,ADAPTR		;EXIT IF MONITOR NOT MONO
	AND	AL,1
	JZ	VCNFG3
	MOV	ADAPTR,20H		;FLAG HERCULES SUPPORT

VCNFG3:	MOV	AH,MONITR		;PUT MONITOR AND ADAPTER TYPE
	MOV	AL,ADAPTR		;ON STACK
	RET
	PAGE

;SUBROUTNE TO TEST FOR BETTER THAN EGA SYTESM

VGATST:	MOV	ADAPTR,10H		;ASSUME MCGA ADAPTER
	MOV	MONITR,10H		;ASSUME ANALOG COLOR MONITOR

;GET ADDRESS OF STATIC FUNC TABLE AND READ MODE BITS

	PUSH	ES			;SAVE ES
	MOV AX,WORD PTR FUNBUF+2	;GET ADDRESS OF STATIC FUNC TABLE
	MOV	ES,AX
	MOV BX,WORD PTR FUNBUF
	MOV	AL,ES:[BX+2]		;READ MODES SUPPORTED
	POP	ES			;RESTORE ES

;TEST TO SEE IF MODE 12 IS SUPPORTED, MODE 12 IS VGA

	TEST	AL,4			;BIT 4= MODE 12 SUPPORTED
	JNZ	VGATS1			;SKIP IF MODE 12
	RET				;MUST BE MCGA

;MUST BE VGA, NOW GET MORE INFORMATION

VGATS1:	MOV	MONITR,18H		;SELECT BW AND COLOR ANALOG

;CHECK VGA DATA SWITCH

	TEST	CONTRL,1		;TEST VGA IN VGA MODE
	JZ	VGATS2			;SKIP IF NOT
	MOV	ADAPTR,8		;FLAG VGA
	RET
	PAGE

;VGA EMULATING OTHER MODES?

VGATS2:	CMP	MONFLG,0	;MONOCHROME?
	JE	VGATNM		;SKIP IF COLOR

;HERE IF INITIAL SETTING WAS MONO

	CMP	SWITCH,0	;SWITCH=0
	JE	SET88		;THEN ANALOG COLOR VGA
	CMP	SWITCH,0AH	;SWITCH=0A
	JE	SET88		;THEN ANALOG COLOR VGA
	CMP	SWITCH,2	;SWITCH=2
	JE	SET11		;THEN MONO MDAG
	CMP	SWITCH,8	;SWITCH=8
	JE	SET11		;THEN MONO MDA
	RET

;HERE IF INITIAL SETTING WAS COLOR

VGATNM:	CMP	SWITCH,0	;SWITCH=0
	JE	SET22		;THEN COLOR CGA
	CMP	SWITCH,0AH	;SWITCH=0A
	JE	SET22		;THEN COLOR CGA
	CMP	SWITCH,2	;SWITCH=2
	JE	SET108		;THEN ANALOG COLOR VGA
	CMP	SWITCH,8	;SWITCH=8
	JE	SET108		;THEN ANALOG COLOR VGA
	RET

;SET MONITOR=ANALOG MONO, ADAPTER=VGA
 
SET88:	MOV	MONITR,8
	MOV	ADAPTR,8
	RET

;SET MONITOR=MONO, ADAPTER=MDA

SET11:	MOV	MONITR,1
	MOV	ADAPTR,1
	RET

;SET MONITOR=COLOR, ADAPTER=CGA

SET22:	MOV	MONITR,2
	MOV	ADAPTR,2
	RET

;SET MONITOR=ANALOG COLOR, ADAPTER=VGA

SET108:	MOV	MONITR,10H
	MOV	ADAPTR,8
	RET

;IF MONOFLAG IS TRUE DECREMENT MONITOR AND ADAPTER TYPE

MONTST:	CMP	MONFLG,0
	JE	MONTS1
	DEC	MONITR
	DEC	ADAPTR	
MONTS1:	RET
	PAGE


;SUBROUTINE TO TEST FOR EGA VS CGA ETC

EGATST:	MOV	BX,10H		;GET CONFIGURATION INFORMATION
	MOV	AX,1200H
	INT	10H		;CALL BIOS

	TEST	BX,00FCH		;BIOS CALL UNSUPPORTED?
	JNZ	MONTST			;THEN TEST FOR MONOMODE

;TEST FOR EGA MONO MODE

	MOV	BL,0		;PRESET FLAG
	AND	BH,1		;TEST EGA MONO MODE
	JZ	EGATS1		;SKIP IF NOT
	MOV	BL,0FFH		;FLAG EGA MONO

;TEST IF MONO FLAG MATCHES EGA MONO FLAG

EGATS1:	CMP BL,BYTE PTR MONFLG	;DO FLAGS MATCH?
	JNE	MONTST		;TEST MONO IF NOT

	MOV	ADAPTR,4	;SELECT EGA

;EXAMINE EGA DIP SWITCH SETTINGS

	AND	CL,0FH		;MASK SWITCH BITS
	CMP	CL,9		;GREATER THAN 9?
	JA	SETM1		;THEN MUST BE MONOCHROME

	CMP	CL,9		;BITS= 9?
	JE	SETM4		;THEN ENHANCED COLOR MONITOR
	CMP	CL,3		;BITS=3?
	JE	SETM4		;THEN ENHANCE COLOR MONITOR
	CMP	CL,4		;BITS=4?
	JE	SETM1		;THEN MONOCHROME MONITOR
	CMP	CL,5		;BITS=5?	
	JE	SETM1		;THEN MONOCHROME MONITOR
	RET

;SET MONOCHROME MONITOR

SETM1:	MOV	MONITR,1
	RET

;SET ENHANCED COLOR MONITOR

SETM4:	MOV	MONITR,4
	RET
	PAGE

;Subroutine to measure CPU speed. The relative speed is returned in ax.
; Speed is in MHz times 10, i.e: a 4.77 MHz PC returns 5. This counts the
; number of times a sample of XPL code is executed in approximately 1/18th of a
; second. (Originally this routine used the 8254 timer chip directly, but this
; does not work under Windows XP.)

SPEED:	push	es

	xor	dx, dx		;init loop counter and point es to 0
	mov	es, dx
	mov	bx, 046Ch	;point to BIOS's system timer tick counter

	mov	ax, es:[bx]	;get system timer tick count (low word)
spd10:	mov	cx, es:[bx]	;wait for it to change
	cmp	ax, cx
	je	spd10		;this is the start of a 1/18th sec interval

;Wait for system timer to change again while counting the number of times a
; sample of XPL code is executed

spd20:	mov	NPXTMP+2, 770	;set timing constant
	mov	si, offset NPXTMP ;point to scratch memory area
	align	4		;align so loop time doesn't change
				; every time Native is modified
spd30:	mov	ax, [si]+2	;typical XPL-type code
	add	ax, [si]
	sub	ax, 1234h
	mov	[si]+4, ax
	dec	word ptr [si]+2
	jne	spd30

	inc	dx		;count number of loops until next tick
	cmp	cx, es:[bx]	;loop until system timer changes
	je	spd20

	mov	ax, dx		;return loop count in ax
	pop	es
	ret
	PAGE

;INTRINSIC TO SHRINK PROGRAM SIZE TO HEAP SIZE PLUS SOME MARGIN
;MARGIN IS IN AX

INTR78	LABEL	FAR
SHRINK	PROC	FAR
	MOV	CX,CSEG		;GET START OF CODE
	MOV	BX,DSEG		;GET START OF DATA	
	SUB	BX,CX		;FIND TOTAL CODE SIZE
	ADD	BX,16		;ADD IN PSP
	IF	FLAGOPT
	ADD	AX,DI		;ADD MARGIN AND HEAP SIZE
	ELSE
	ADD	AX,HP		;ADD MARGIN AND HEAP SIZE
	ENDIF
	JC	SHRNK1		;EXIT IF OVER 64K
	MOV	HEAPHI,AX	;SET NEW LIMIT ON USER MEMORY
	MOV	CX,4		;CONVERT TO PARAGRAPHS
	SHR	AX,CL		;BY DIVIDING BY 16	
	INC	AX		;PLUS ONE FOR MODULO
	ADD	BX,AX		;COMBINE CODE, PSP, AND HEAP SIZE

	MOV	AH,DOSMMA	;RESIZE THIS PROGRAM
	MOV	DOSINT,21H
	PUSH	ES		;SAVE ES
	MOV	ES,PSPSEG	;POINT TO PSP
	INT	21H		;CALL DOS FUNCTION
	POP	ES		;RESTORE ES
SHRNK1:	RET
SHRINK	ENDP
