	PAGE

;*** I2L INTRINSICS MODULE ***


;INTRINSIC ROUTINE JUMP TABLE

INTTBL	DW	ABSFUN		;0 ABSOLUTE VALUE
	DW	RANFUN		;1 RANDOM NUMBER
	DW	REMFUN		;2 REMAINDER OF LAST DIVIDE
	DW	RESERV		;3 RESERVE ARRAY
	DW	SWAPFU		;4 SWAP BYTES
	DW	EXTEN		;5 EXTEND SIGN FROM LOW BYTE
	DW	RESTRT		;6 RESTART CURRENT PROGRAM
	DW	CHIN		;7 INPUT A BYTE
	DW	CHOUT		;8 OUTPUT A BYTE
	DW	SKIP		;9 NEW LINE (CRLF)
	DW	INTIN		;10 INPUT AN INTEGER
	DW	INTOUT		;11 OUTPUT AN INTEGER
	DW	TEXT		;12 OUTPUT A STRING
	DW	IDEVIN		;13 INITIALIZE INPUT DEVICE
	DW	ODEVIN		;14 INITIALIZE OUTPUT DEVICE
	DW	ODEVCL		;15 CLOSE AN OUTPUT DEVICE
	DW	ABORT		;16 ABORT PROGRAM (LIKE A CTRL-P)
	DW	TRAP		;17 SET TRAP FLAG
	DW	SPACE		;18 DETERMINE REMAINING SPACE
	DW	RERUN		;19 TEST RERUN FLAG
	DW	TSTHP		;20 GET CURRENT HEAP POINTER
	DW	SETHP		;21 SET HEAP POINTER
	DW	GETERR		;22 GET I2L ERROR NUMBER
	DW	CURSOR		;23 SET TV CURSOR POSITION
	DW	FSET		;24 SET A FILE HANDLE
	DW	SETRUN		;25 SET THE RERUN FLAG
	DW	HEXI		;26 INPUT HEX INTEGER
	DW	HEXO		;27 OUTPUT HEX INTEGER
	DW	CHAIN		;28 CHAIN TO A SAVE FILE
	DW	FOPEN		;29 OPEN NEW FILE
	DW	FWRITE		;30 WRITE DISK BLOCKS
	DW	FREAD		;31 READ DISK BLOCKS
	DW	FCLOSE		;32 CLOSE DISK FILE

	DW	CHKKEY		;33 CHECK FOR KEY STRIKE
	DW	SFTINT		;34 DO SOFTWARE INTERRUPT
	DW	GETREG		;35 GET REGISTER ADDRESS
	DW	BLKTRN		;36 BLOCK TRANSFER
	DW	PEEK		;37 PEEK MEMORY

	DW	POKE		;38 POKE INTO MEMORY
	DW	SOUND		;39 SQUEAK THE SPEAKER
	DW	VCLEAR		;40 CLEAR VIDEO DISPLAY
	DW	DOT		;41 PLOT HI-RES POINT
	DW	LINE		;42 DRAW A HI-RES LINE
	DW	MOVE		;43 HI-RES MOVE
	DW	REDDOT		;44 READ BACK PIXEL
	DW	SETVID		;45 SET VIDEO MODE
	PAGE

	DW	FLRES		;46 RESERVE MEMORY FOR REALS
	DW	FLIN		;47 INPUT A REAL NUMBER
	DW	FLOUT		;48 OUTPUT A REAL NUMBER
	DW	FLTFUN		;49 CONVERT INTEGER TO REAL
	DW	FIXFUN		;50 CONVERT REAL TO INTEGER
	DW	FLABS		;51 ABSOLUTE VALUE OF REAL
	DW	FMTFUN		;52 PLACES BEFORE & AFTER DEC POINT

	DW	FLSQRT		;53 TOS:=SQRT(TOS)
	DW	FLLN		;54 TOS:=LN(TOS)
	DW	FLEXP		;55 TOS:=EXP(TOS)
	DW	FLSIN		;56 TOS:=SIN(TOS)
	DW	FLAT2		;57 TOS:=ATAN(NOS/TOS)
	DW 	FLMOD		;58 TOS:= NOS MOD TOS
	DW	FLLOG		;59 TOS:=LOG(TOS)
	DW 	FLCOS		;60 TOS:=COS(TOS)
	DW	FLTAN		;61 TOS:=TAN(TOS)
	DW	FLASIN		;62 TOS:=ASIN(TOS)
	DW	FLACOS		;63 TOS:=ACOS(TOS)

	DW	POUT		;64 OUTPUT TO PORT
	DW	PIN		;65 INPUT FROM PORT
	DW	INTRET		;66 EXIT I2L VIA IRET
	DW	EXTJMP		;67 JUMP TO FAR ROUTINE
	DW	EXTCAL		;68 CALL FAR ROUTINE
	PAGE

	DW	SETATT		;69 SET WINDOW ATTRIBUTE
	DW	SETWND		;70 SET DIMENSIONS AND MODE
	DW	RAWTXT		;71 OUTPUT RAW TEXT STRING
	DW	HLIGHT		;72 HIGHLIGHT PART OF SCREEN

	DW	MALLOC		;73 ALLOCATE MEMORY FOR DOS
	DW	RELEAS		;74 RELEASE MEMORY TO DOS
	DW	TRAPC		;75 TURN ON OR OFF CTR-C TRAP
	DW	TESTC		;76 TEST FOR RECENT CTR-C
	DW	GETEQP		;77 GET EQUIPMENT LIST
	DW	SHRINK		;78 SHRINK MEMORY ALLOCATION
	DW	RANSEED		;79 SET RANDOM NUMBER SEED
	DW	IRQ		;80 TURN ON OR OFF INTERRUPTS
	PAGE

;START UP INITIALIZATION FOR INTRINSICS MODULE

SETINT	PROC	NEAR
	CALL	RANINT		;INITALIZE RANDOM NUMBER
	CALL	RESFULLWND	;RESET DEVICE 6 TO FULL SCREEN
	CALL	RESDIB		;INITALIZE DISK BUFFERS
	CALL	RESDOB
	RET
SETINT	ENDP

;**  INTRINSIC #0
;INTRINSIC TO RETURN THE ABSOLUTE VALUE OF TOP OF STACK

ABSFUN	PROC	NEAR
	POP	AX
	TEST	AX,8000H
	JZ	ABS10
	NEG	AX
ABS10:	PUSH	AX
	JMP	OPGO
ABSFUN	ENDP


;RANDOMIZE RANDOM NUMBER GENERATOR
;USES SYSTEM INTERRUPT COUNTER

RANLOC	EQU	46CH		;LOCATION OF RANDOMIZER
RANSEG	EQU	0		;SEGMENT OF RANDOMIZER

RANINT	PROC	NEAR
	PUSH	ES		;SAVE SEGMENT
	MOV	AX,RANSEG	;SET SEGMENT
	MOV	ES,AX
	MOV	AX,ES:RANLOC	;GET RANDOM SEED
	OR	AX,4		;MAKE SURE ITS NOT
	MOV	RANK,AX		;SET SEED
	POP	ES		;RESTORE SEGMENT
	RET
RANINT	ENDP
	PAGE

;**  INTRINSIC #2
;GENERATE RANDOM NUMBER BETWEEN 0 AND (TOP OF STACK)-1
; IF TOS = 0 THEN INITIALIZE SEED FOR REPEATABLE SEQUENCE
; IF TOS < 0 THEN RANDOMIZE AND RETURN RAN(-TOS)

RANFUN	PROC	NEAR
	POP	BX		;GET MAXIMUM
	TEST	BX,BX		;CHECK FOR ZERO
	JNE	RAN01		;BRANCH IF NOT ZERO

	MOV	RANK,2537	;SET FIXED SEQUENCE SEEDS
	MOV	RANL,5149
	MOV	RANM,7026

	PUSH	BX		;RETURN A ZERO ON THE STACK
	JMP	CMLRET

RAN01:	JNS	RAN05		;JUMP IF POSITIVE ARGUMENT
	NEG	BX
	CALL	RANINT		;RANDOMIZE SEED
RAN05:	CALL	RANDOM		;GET RANDOM NUMBER
	PUSH	DX		;RETURN REMAINDER ON STACK
	JMP	CMLRET
RANFUN	ENDP
	PAGE

;"A GOOD RANDOM NUMBER GENERATOR"

RANK	DW	2537
RANL	DW	5149
RANM	DW	7026

MODK	EQU	33049		;PRIME NUMBERS THAT GIVE GOOD RESULTS
MODL	EQU	32909
MODM	EQU	32771

;----------------------------------------------------------------------
;THIS RETURNS A RANDOM NUMBER BETWEEN 0 AND THE ARGUMENT -1.
;ARGUMENT IS IN BX, RESULT RETURNED IN DX

RANDOM:	MOV	AX,RANK		;RANK:= REM((RANK+RANK) /MODK);
	ADD	AX,AX
	CMP	AX,MODK
	JB	RAN10
	SUB	AX,MODK
RAN10:	MOV	RANK,AX

	MOV	AX,RANL		;RANL:= REM((RANL+RANL) /MODL);
	ADD	AX,AX
	CMP	AX,MODL
	JB	RAN20
	SUB	AX,MODL
RAN20:	MOV	RANL,AX

	ADD	AX,RANK		;RANM:= REM((RANK+RANL+RANM) /MODM);
	ADD	AX,RANM
RAN30:	CMP	AX,MODM
	JB	RAN35
	SUB	AX,MODM
	JMP	SHORT RAN30
RAN35:	MOV	RANM,AX

	MOV	DH,AL		;MAKE BIT 15 IN AX RANDOM (IT'S USUALLY 0)
	AND	DH,80H		;ESSENTIALLY COPY BIT 7 INTO BIT 15
	XOR	AH,DH

	MOV	DL,AL		;AVOID BIAS ERRORS FOR LARGE RANDOM NUMBERS
	SUB	DH,DH		; BY USING A LARGE DIVIDEND
	TEST	BH,BH		;AVOID DIVIDE OVERFLOW ERROR
	JNZ	RAN40
	SUB	DL,DL
RAN40:	DIV	BX		;UNSIGNED DIVIDE BX INTO DX:AX
	RET

;** INTRINSIC #79
;SET SEED FOR RANDOM NUMBER GENERATOR.

RANSEED	PROC	NEAR
	POP	AX
	MOV	RANK,AX
	MOV	RANL,5149	;SET OTHER SEEDS FOR A REPEATABLE SEQUENCE
	MOV	RANM,7026
	JMP	CMLRET
RANSEED	ENDP
	PAGE

;**  INTRINSIC #2
;GET REMAINDER OF MOST RECENT DIVISION. THE ARGUMENT IS AN
; EXPRESSION WHOSE RESULT IS THROWN AWAY. THIS EXPRESSION CAN
; CONTAIN A DIVISION OR BE ZERO TO GET THE RESULT OF AN EARLIER
; DIVISION.

REMFUN	PROC	NEAR
	ADD	SP,2		;THROW AWAY ARGUMENT
	PUSH	REMAIN		;PUSH REMAINDER
	JMP	OPGO
REMFUN	ENDP

;**  INTRINSIC #3
;RESERVE BYTES ON HEAP AND RETURN THE ADDRESS OF THE RESERVED
; SPACE. THIS IS THE TRICK BY WHICH XPL HANDLES DYNAMIC STORAGE
; FOR ARRAYS. SINCE THE SPACE IS RESERVED IN THE HEAP ALLOCATION
; OF A PROCEDURE, THE ARRAY WILL DISAPPEAR WHEN THE PROCEDURE IS
; EXITED.

RESERV	PROC	NEAR
	POP	AX		;GET AMOUNT TO RESERVE
	PUSH	HP		;RETURN HEAP ADDRESS
	ADD	HP,AX
	JC	RES80		;ERROR IF IT WRAPS AROUND SEGMENT
	MOV	AX,HEAPHI	;ERROR IF PAST TOP OF HEAP
	CMP	HP,AX
	JB	RES90

RES80:	MOV	AL,2		; I2L ERROR # 2
	CALL	ERROR
RES90:	JMP	OPGO
RESERV	ENDP


;**  INTRINSIC #4
;SWAP HIGH AND LOW BYTES OF TOP OF STACK.

SWAPFU	PROC	NEAR
	POP	AX
	XCHG	AL,AH
	PUSH	AX
	JMP	CMLRET
SWAPFU	ENDP
	PAGE

;**  INTRINSIC #5
;INTRINSIC TO EXTEND SIGN OF LOW BYTE INTO HIGH BYTE

EXTEN	PROC	NEAR
	POP	AX
	CBW
	PUSH	AX
	JMP	OPGO
EXTEN	ENDP


;**  INTRINSIC #6
;INTRINSIC TO RESTART THE CURRENT PROGRAM

RESTRT	PROC	NEAR
	MOV	RERUNF,TRUVAL	;SET FLAG
	MOV	SP,ENTSTK	;RESTORE ENTRY STACK POINTER
	JMP	START		;NUMBER SEQUENCE
RESTRT	ENDP


;**  INTRINSIC #7
;INTRINSIC TO INPUT A BYTE AND PUSH IT ONTO THE STACK.

CHIN	PROC	NEAR
	POP	NOWDEV			;GET DEVICE NUMBER
	MOV BYTE PTR NOWFUN,INPFUN	;SET FUNCTION
	CALL	KHAND
	XOR	AH,AH			;ZERO HIGH BYTE
	PUSH	AX			;PUSH ON STACK
	JMP	CMLRET
CHIN	ENDP


;**  INTRINSIC #8
;OUTPUT THE BYTE ON TOP OF THE STACK

CHOUT	PROC	NEAR
	POP	AX		;GET CHAR
	POP	NOWDEV		;GET DEVICE CHANNEL
 	MOV BYTE PTR NOWFUN,OUTFUN
	CALL	KHAND		;SEND IT
	JMP	CMLRET		;RETURN
CHOUT	ENDP
	PAGE

;**  INTRINSIC #9
;INTRINSIC TO PRINT AN END-OF-LINE (CR & LF)

SKIP	PROC	NEAR
	POP	NOWDEV		;GET DEVICE #
	MOV BYTE PTR NOWFUN,OUTFUN
	CALL	CRLF
	JMP	CMLRET		;RETURN
SKIP	ENDP


;**  INTRINSIC #10
;INTRINSIC TO INPUT A SIGNED INTEGER TO TOP OF STACK

INTIN	PROC	NEAR
	POP	NOWDEV		;GET AND SAVE DEV #
	CALL	GETNMB		;GET A SIGNED INTEGER
	PUSH	AX
	JMP	CMLRET		;RETURN
INTIN	ENDP


;**  INTRINSIC #11
;INTRINSIC TO OUTPUT THE SIGNED INTEGER ON TOP OF STACK

INTOUT	PROC	NEAR
	POP	AX		;GET NUMBER
	POP	NOWDEV		;GET DEVICE #
	CALL	PUTNMB		;PRINT IT
	JMP	CMLRET		;RETURN
INTOUT	ENDP
	PAGE

;**  INTRINSIC #12
;INTRINSIC TO PRINT A TEXT STRING. THE STARTING ADDRESS IS
; ON TOP OF STACK. THE STRING TERMINATES ON CHARACTER WITH
; BIT 7 SET.

TEXT	PROC	NEAR
	POP	SI			;GET ADDRESS FROM STACK
	POP	NOWDEV			;SET DEVICE #
	CALL	TXTLOP			;OUTPUT STRING
	JMP	CMLRET			;RETURN
TEXT	ENDP

;SUBROUTINE TO OUTPUT A STRING TO NOWDEV
;ADDRESS OF THE STRING IS IN SI

TXTLOP	PROC	NEAR
	MOV BYTE PTR NOWFUN,OUTFUN
	CLD				;FORCE INCREMENT MODE
	JMP SHORT TXTLP1		;ENTER LOOP

TXTLP2:	CALL	KHAND			;OUT IT GOES
TXTLP1:	LODSB				;GET CHAR
	TEST	AL,080H			;LAST CHAR?
	JZ	TXTLP2			;LOOP IF NOT

	AND	AL,7FH			;MASK TO 7 BITS
	JMP	KHAND			;OUTPUT LAST CHAR
TXTLOP	ENDP


;**  INTRINSIC #13
;INTRINSIC TO OPEN AN INPUT DEVICE

IDEVIN	PROC	NEAR
	MOV BYTE PTR NOWFUN,INIFUN	;SET FUNCTION
IDEVN1:	POP	NOWDEV			;GET DEVICE #
	CALL	KHAND			;DO IT
	JMP	CMLRET			;RETURN
IDEVIN	ENDP
	PAGE

;**  INTRINSIC #14
;INTRINSIC TO OPEN AN OUTPUT DEVICE

ODEVIN	PROC	NEAR
	MOV BYTE PTR NOWFUN,INOFUN	;GET FUNCTION
	JMP	IDEVN1			;ENTER COMMON CODE
ODEVIN	ENDP


;**  INTRINSIC #15
;INTRINSIC TO CLOSE AN OUTPUT DEVICE

ODEVCL	PROC	NEAR
	MOV BYTE PTR NOWFUN,CLOFUN	;GET FUNCTION
	JMP	IDEVN1			;ENTER COMMON CODE
ODEVCL	ENDP


;**  INTRINSIC #16
;INTRINSIC TO ABORT PROGRAM (LIKE A CTRL-P)

ABORT	PROC	NEAR
	JMP	EXITDO
ABORT	ENDP


;**  INTRINSIC #17
;INTRINSIC TO SET THE ERROR TRAP FLAGS

TRAP	PROC	NEAR
	POP	AX
	MOV	TRAPS,AX
	JMP	CMLRET
TRAP	ENDP
	PAGE

;**  INTRINSIC #18
;INTRINSIC TO TELL A USER HOW MANY BYTES OF SPACE HE HAS LEFT.
; OF COURSE HE MAY NOT RESERVE ALL OF IT, SINCE HE MUST LEAVE A
; WORKING HEAP FOR SUBSEQUENT PROCEDURE CALLS ETC. SINCE ONLY
; THE USER KNOWS HOW MUCH THIS MIGHT BE, IT IS LEFT TO HIM TO
; DECIDE HOW MUCH HE HAS FREE TO PLAY WITH.

SPACE	PROC	NEAR
	MOV	AX,HEAPHI
	SUB	AX,HP
	PUSH	AX
	JMP	CMLRET
SPACE	ENDP


;**  INTRINSIC #19
;INTRINSIC TO TEST THE RERUN FLAG.

RERUN	PROC	NEAR
	MOV	AX,RERUNF
	PUSH	AX
	JMP	CMLRET
RERUN	ENDP


;**  INTRINSIC #20
;INTRINSIC TO RETURN THE CURRENT VALUE OF THE HEAP POINTER
; THIS INTRINSIC IS USED FOR SAVING THE HEAP POINTER FOR
; LATER RESTORATION WITH SETHP. THE USER HAD BETTER HAVE
; A GOOD IDEA OF THE FUNTIONING OF I2L BEFORE DINGING
; WITH THE HEAP POINTER OR HE WILL SURELY BOMB HIMSELF!

TSTHP	PROC	NEAR
	MOV	AX,HP
	PUSH	AX
	JMP	CMLRET
TSTHP	ENDP
	PAGE

;**  INTRINSIC #21
;INTRINSIC TO RESET THE HEAP POINTER--A VERY DANGEROUS
; THING TO DO! SEE TSTHP'S COMMENTS.

SETHP	PROC	NEAR
	POP	AX
	MOV	HP,AX
	JMP	CMLRET
SETHP	ENDP


;**  INTRINSIC #22
;INTRINSIC TO RETURN THE I2L ERROR NUMBER AND THEN CLEAR IT

GETERR	PROC	NEAR
	MOV	AL,ERRNUM
	XOR	AH,AH
	PUSH	AX
	MOV	ERRNUM,0
	JMP	CMLRET
GETERR	ENDP

;**  INTRINSIC #23
;THIS INTRINSIC SETS THE TV CURSOR TO A SPECIFIC POSITION

CURSOR	PROC	NEAR
	POP	AX		;GET Y-POSITION
	POP	BX		;GET X-POSITION
	CALL	MCURSE
	JMP	CMLRET
CURSOR	ENDP


;**  INTRINSIC #25
;INTRINSIC TO SET THE RERUN FLAG DIRECTLY

SETRUN	PROC	NEAR
	POP	AX
	MOV	RERUNF,AX
	JMP	CMLRET
SETRUN	ENDP
	PAGE

;**  INTRINSIC #26
;INTRINSIC TO INPUT A HEX INTEGER TO TOP OF STACK

HEXI	PROC	NEAR
	POP	NOWDEV		;GET DEVICE NUMBER
	CALL	HEXIN		;INPUT WORD
	PUSH	AX
	JMP	CMLRET
HEXI	ENDP


;**  INTRINSIC #27
;INTRINSIC TO OUTPUT THE TOP OF STACK IN HEX FORMAT

HEXO	PROC	NEAR
	POP	AX		;GET VALUE
	POP	NOWDEV		;GET DEVICE NUMBER
	CALL	WRDOUT		;OUTPUT WORD
	JMP	CMLRET
HEXO	ENDP

	PAGE

;DECIMAL INTEGER IO ROUTINES, RESULT IN AX

SIGN	DB	0	;SIGN OF REG1
NUMFLG	DB	0	;NUMERICAL FLAG
TENBYT	DW	10	;FOR IMMEDIATE MULTIPLY

;INPUT A SIGNED INTEGER IN AX

GETNMB	PROC	NEAR
	MOV BYTE PTR NOWFUN,INPFUN	;SET FUNCTION
	CALL	KHAND			;GET CHAR
	MOV	CX,0			;CLEAR REGISTER
	MOV	SIGN,0			;CLEAR SIGN
	MOV	NUMFLG,0		;CLEAR NUMBER FLAG

	CMP	AL,'-'		;NEGATIVE NUMBER?
	JNE	INTIN2		;SKIP IF NOT
	NOT 	SIGN

INTIN1:	PUSH	CX
INTIN1A:CALL	KHAND		;GET CHAR
	CMP	AL,'_'		;IGNORE ANY UNDERLINES
	JE	INTIN1A
	POP	CX

INTIN2:	CMP	AL,EOF		;END OF FILE
	JE	INTIN5		;YES, THEN EXIT
	SUB	AL,'0'		;CONVERT TO BINARY
	JL	INTIN4		;SKIP IF NOT A DIGIT
	CMP	AL,10		;TEST IT DIGIT
	JGE	INTIN4		;SKIP IF NOT
	INC	NUMFLG		;INDICATE ITS A DIGIT

	MOV	AH,0		;ZERO HIGH BYTE
	XCHG	AX,CX		;GET ACCUMULATED VALUE
	MUL	TENBYT		;TIME TEN
	ADD	CX,AX		;ADD IT IN
	JMP	INTIN1		;LOOP

INTIN4:	TEST	NUMFLG,0FFH	;END OF NUMBER?
	JZ	GETNMB		;START OVER IF NOT
INTIN5:	TEST	SIGN,0FFH	;NEGATIVE?
	JZ	INTIN3		;SKIP IF NOT
	NEG	CX		;NEGATE IT
INTIN3:	MOV	AX,CX
	RET
GETNMB	ENDP

	PAGE

;OUTPUT THE INTEGER IN AX

REG1	DW	0	;TEMPORARY REGISTER
SUPRES	DB	0	;TO SUPRESS LEADING ZEROS

PUTNMB	PROC	NEAR
	MOV BYTE PTR NOWFUN,OUTFUN	;SET FUNCTION
	MOV	SUPRES,0		;FLAG LEADING ZEROS
	MOV	REG1,AX			;SAVE WORD
	TEST	AX,8000H		;NEGATIVE?
	JZ	INTOT1			;SKIP IF NOT
	NEG	REG1			;NEGATE THE WORD
	MOV	AL,'-'			;PRINT MINUS
	CALL	KHAND			;OUTPUT CHAR

INTOT1:	MOV	SI,6		;SET POWER POINTER
INTOT2:	MOV	AX,REG1		;GET THE WORD
	MOV	DX,0
	DIV	POWER[SI]	;DIVIDE BY POWER OF 10
	MOV	REG1,DX		;SAVE REMAINDER
	TEST	AX,0FFFFH	;ZERO DIGIT?
	JNZ	INTOT4		;SKIP IF NOT
	TEST	SUPRES,0FFH	;STILL SUPRESSING?
	JZ	INTOT3		;SKIP IF YES
INTOT4:	INC	SUPRES		;FLAG NO MORE SUPRESS
	OR	AL,30H		;CONVERT DIGIT TO ASCII
	PUSH	SI		;SAVE INDEX
	CALL	KHAND		;PRINT DIGIT
	POP	SI		;RESTORE INDEX
INTOT3:	SUB	SI,2		;POINT TO NEXT POWER
	JNS	INTOT2		;LOOP TILL DONE
	MOV	AL,BYTE PTR REG1;GET ONES DIGIT
	OR	AL,30H		;CONVERT TO ASCII
	JMP	KHAND		;PRINT IT
PUTNMB	ENDP

;POWER OF TEN TABLE

POWER	DW	10
	DW	100
	DW	1000
	DW	10000
	PAGE

;DISPLAY HEX WORD IN AX

WRDOUT	PROC	NEAR
	PUSH	AX		;SAVE WORD
	MOV	AL,AH		;GET HIGH BYTE
	CALL	HEXOUT		;DISPLAY IT
	POP	AX		;GET LOW BYTE
	JMP SHORT HEXOUT	;DISPLAY
WRDOUT	ENDP


;DISPLAY BYTE IN AL AS HEX ON CONSOLE

HEXOUT	PROC	NEAR
	MOV BYTE PTR NOWFUN,OUTFUN	;SET I/O FUNCTION
	CALL	MAKHEX			;CONVERT TO HEX
	PUSH	AX
	MOV	AL,AH			;GET HIGH WORD
	CALL	KHAND			;DISPLAY IT
	POP	AX
	JMP	KHAND
HEXOUT	ENDP


;CONVERT BYTE IN AL TO ASCII HEX IN AX

MAKHEX	PROC	NEAR
	MOV	AH,AL		;SAVE THE BYTE
	MOV	CL,4		;SHIFT INTO LOW NIBBLE
	SHR	AL,CL
	CALL	MAKNIB		;CONVERT TO HEX
	XCHG	AL,AH		;PUT IN HIGH BYTE
	JMP SHORT MAKNIB	;CONVERT LOW NIBBLE TO HEX
MAKHEX	ENDP


;CONVERT LOW NIBBLE IN AL TO ASCII HEX IN AL

MAKNIB	PROC	NEAR
	AND	AL,0FH		;MASK EXTRA BITS
	CMP	AL,0AH		;<A ?
	JL	MAKNB1
	ADD	AL,37H		;CONVERT TO ASCII
	RET
MAKNB1:	ADD	AL,30H		;CONVERT TO ASCII
	RET
MAKNIB	ENDP
	PAGE

;ROUTINE TO INPUT A HEX NUMBER

HEXIN	PROC	NEAR
	MOV	BX,0			;ZERO REGISTER
	MOV	NUMFLG,0		;FLAG NO DIGITS YET
	MOV BYTE PTR NOWFUN,INPFUN	;SET I/O FUNCTION

HEXIN1:	PUSH	BX			;SAVE VALUE
HEXIN1A:CALL	KHAND			;GET CHAR
	CMP	AL,'_'			;IGNORE ANY UNDERLINES
	JE	HEXIN1A
	POP	BX			;RESTORE VALUE
	CMP	AL,EOF			;END OF FILE?
	JE	HEXIN3			;YES, THEN EXIT
	CALL	MAKBIN			;CONVERT TO BINARY
	JNC	HEXIN2			;SKIP IF HEX

	CMP	NUMFLG,0		;LAST DIGIT?
	JNE	HEXIN3			;THEN EXIT
	JMP	HEXIN1			;ELSE TRY AGAIN

HEXIN2:	INC	NUMFLG			;FLAG WERE GETTING DIGITS
	MOV	CL,4
	SAL	BX,CL			;MULTIPLY BY 16
	ADD	BX,AX			;COMBINE WITH NEW DIGIT
	JMP	HEXIN1			;LOOP

HEXIN3:	MOV	AX,BX			;GET RESULT
	RET
HEXIN	ENDP


;OUTPUT A NEWLINE

CRLF	PROC	NEAR
	MOV BYTE PTR NOWFUN,OUTFUN	;SET I/O FUNCTION
	MOV	AL,CR
	CALL	KHAND
	MOV	AL,LF
	JMP	KHAND
CRLF	ENDP
