	PAGE

;*** LOW LEVEL I/O ROUTINES FOR MS-DOS ENVIRONMENT ***

;DEFINE SOME CHARACTERS

CR	EQU	0DH		;DEFINE RETURN
LF	EQU	0AH		;DEFINE LINE FEED
EOF	EQU	1AH		;END OF FILE
BEL	EQU	07H		;BELL CHARACTER

;DUMMY I/O, FLUSH INTO BIT BUCKET

DUMMIO	PROC	NEAR
	MOV	AX,001AH	;RETURN EOF
	CLC
	RET
DUMMIO	ENDP


;CONVERT CHARACTER IN AL TO UPPER CASE IF IT IS LOWER

MAKUPP:	CMP	AL,'a'		;TEST IF LOWER
	JB	MAKUP1
	CMP	AL,'z'
	JA	MAKUP1
	SUB	AL,20H		;CONVERT TO UPPER
MAKUP1:	RET
	PAGE


;CONVERT ASCII CHAR IN AL TO BINARY, CARRY SET IF NOT VALID HEX

MAKBIN	PROC	NEAR
	AND	AX,007FH	;MASKOUT UNUSED BITS
	CALL	MAKUPP		;MAKE UPPER CASE
	CMP	AL,'0'		;<0?
	JB	NOTHEX		;SKIP IF NOT
	CMP	AL,'F'		;>F?
	JA	NOTHEX
	CMP	AL,'9'+1	;<=9?
	JB	HEXNUM
	CMP	AL,'A'-1	;>=A?
	JA	HEXCHR
NOTHEX:	STC			;FLAG BAD HEX
	RET
HEXCHR:	SUB	AL,'A'-10	;CONVERT TO BINARY
	CLC			;FLAG GOOD HEX
	RET
HEXNUM:	SUB	AL,'0'		;CONVERT TO BINARY
	CLC			;FLAG GOOD HEX
	RET
MAKBIN	ENDP


	PAGE

;** ROUTINES TO HANDLE BUFFERED CONSOLE

BUFSIZ	EQU	128		;DEFINE BUFFER SIZE

DSEG	SEGMENT WORD PUBLIC 'DATA'
INPSIZ	DB	BUFSIZ		;TELL DOS HOW BIG IT
OUTSIZ	DB	?		;STRING LENGTH FROM DOS
KEYBUF	DB	BUFSIZ DUP(?)	;INPUT BUFFER
KEYPTR	DW	BUFSIZ		;WORKING POINTER
DSEG	ENDS

;RESET INPUT BUFFER POINTER

RESBUF	PROC	NEAR
	MOV	BX,BUFSIZ	;ZERO I2L INPUT BUFFER
	MOV	KEYPTR,BX
	MOV	AH,0CH		;ZERO DOS INPUT BUFFER
	SUB	AL,AL		;CALL NO OTHER FUNCTIONS
	INT	21H
	CLC
	RET
RESBUF	ENDP


;DO BUFFERED KEYBOARD INPUT, CHAR IN AL

BUFKEY	PROC	NEAR
	MOV	BX,KEYPTR	;GET POINTER
	CMP	BX,BUFSIZ	;TEST EMPTY
	JNE	GETBUF		;SKIP NOT EMPTY

;GET A NEW BUFFER

	LEA	DX,INPSIZ	;POINT TO START OF BUFFER
	MOV	AH,0AH		;BUFFERED KEY INPUT
	INT	21H		;DOS CALL
	MOV	AL,LF		;ADD LINE FEED
	CALL	TVOUT
	MOV	BX,0

;GET A BYTE FROM BUFFER

GETBUF:	MOV	AL,KEYBUF[BX]
	INC	BX
	CMP	AL,CR		;RETURN?
	JNE	BUFKY1
	MOV	BX,BUFSIZ	;THEN BUFFER'S EMPTY
BUFKY1:	MOV	KEYPTR,BX
	CLC
	RET

BUFKEY	ENDP
	PAGE

;*** BASIC IBM LOW LEVEL DEVICE DRIVERS ***

;MOVE CURSOR, X POSITION IN BX, Y POSITION IN AX

MCURSE	PROC	NEAR
	MOV	DL,BL		;SET POSITION
	MOV	DH,AL
	CALL	GETPAG		;GET SCREEN PAGE
	MOV	AH,02H		;SET FUNCTION
	INT	10H		;DO BIOS VECTOR
	RET
MCURSE	ENDP


;NORMAL CONSOLE OUTPUT ROUTINE, WITH CHARACTER HANDLING
;OUTPUT CHAR IN AL

CONOUT	PROC	NEAR
	CMP	AL,0CH		;FORM FEED?
	JNE	CONO10		;JUMP IF NOT
	CALL	CLEAR		;CLEAR SCREEN
	MOV	AL,CR		;FOLLOW WITH A CR TO MAKE TABS WORK RIGHT
CONO10:	MOV	DL,AL		;GET CHAR
	MOV	AH,02H		;SET FUNCTION
	INT	21H		;CALL DOS
	CLC
	RET
CONOUT	ENDP
	PAGE


;LOW LEVEL TVOUT, NO CTL-C, NO TAB HANDLING ETC.
;OUTPUT CHAR IN AL TO VIDEO DISPLAY

TVOUT	PROC	NEAR
	MOV	BL,7		;SET FOREGROUND COLOR FOR GRAPHICS MODES
	MOV	BH,0		;SET DISPLAY PAGE
	MOV	AH,0EH		;SET TTY SERVICE
	INT	10H		;DO BIOS VECTOR
	CLC
	RET
TVOUT	ENDP


;CLEAR KEYSTROKES FOR CHAN 1 INPUT
RESKEY	PROC	NEAR
	MOV	AH,01		;GET KEYBOARD STATUS
	INT	16H
	JZ	RESK90		;JUMP IF NO KEY IS WAITING
	SUB	AH,AH		;READ CHARACTER FROM KEYBOARD
	INT	16H
	JMP SHORT RESKEY
RESK90:	CLC
	RET
RESKEY	ENDP


;INPUT A CHAR FROM KEYBOARD, NO ECHO, CHAR IN AL
;CHAN 1 INPUT

KEYIN	PROC	NEAR
	MOV	AH,08H		;SET FOR KEYIN
	INT	21H		;DO DOS VECTOR
	CLC
	RET
KEYIN	ENDP
	PAGE


;BIOS VARIABLES:
VMODE	EQU	0449H		;CURRENT VIDEO MODE
SWIDTH	EQU	044AH		;SCREEN WIDTH IN CHARACTERS
SCROWS	EQU	0484H		;NUMBER OF CHARACTER ROWS -1 ON SCREEN
VPAGE	EQU	0462H		;CURRENT VIDEO PAGE


;ROUTINE TO CLEAR THE SCREEN FOR BOTH GRAPHICS AND TEXT
; USING THE BIOS SCROLLING ROUTINE

CLEAR	PROC	NEAR
	PUSH	ES		;SAVE SEGMENT

;SET SCROLLING WINDOW

	XOR	CX,CX		;SET UPPER LEFT CORNER OF WINDOW
	MOV	ES,CX		;POINT TO SEGMENT ZERO
	MOV	DH,ES:SCROWS	;GET LAST ROW NUMBER

	CMP	DH,36		;CLEARS BOTTOM 8 GRAPHIC LINES FOR MODE 6AH
	JNE	CLEAR5		; WHEN CHARACTER HEIGHT = 16.  16*(36+1) = 592
	INC	DH		; (16*38*800/8 = 60800 WHICH IS LESS THAN F000H
	MOV	ES:SCROWS,DH	;COMPAQ PRESARIO 1240 LAPTOP REQUIRES THIS
CLEAR5:
	CMP	DH,41		;CLEARS BOTTOM 12 GRAPHIC LINES FOR MODE 6AH
	JNE	CLEAR4		; WHEN CHAR HEIGHT = 14. 14*(41+1) = 588
	INC	DH		; (14*43*800/8 = 60200 WHICH IS < F000H
	MOV	ES:SCROWS,DH	;COMPAQ PRESARIO 1240 LAPTOP REQUIRES THIS
CLEAR4:
	CMP	DH,127		;OUT OF RANGE? (1024 PIXELS / 8 PIXELS/CHAR)
	JBE	CLEAR3		;SKIP IF NOT
	MOV	DH,127		;SET LARGEST POSSIBLE SCREEN (1024/8 = 128)
CLEAR3:	CMP	DH,0		;ZERO?
	JNE	CLEAR2		;SKIP IF ADVANCED BIOS
	MOV	DH,24		;MUST BE CGA OR MGA, USE 25-1
CLEAR2:	MOV	DL,ES:SWIDTH	;GET WIDTH
	DEC	DL		;MINUS ONE

;SELECT PROPER ATTRIBUTE FOR GRAPHICS VERSUS TEXT MODE

	MOV	BH,07H		;SET NORMAL ATTRIBUTE
	MOV	BL,ES:VMODE	;GET VIDEO MODE
	CMP	BL,3		;MODE 3 OR LESS?
	JLE	CLEAR1		;JUMP IF SO

	CMP	BL,007H		;MODE SEVEN?
	JE 	CLEAR1		;JUMP IF SO
	MOV	BH,0		;USE ZERO ATTRIBUTE TO BLANK FOR GRAPHICS MODES
CLEAR1:	MOV	AX,0600H	;CALL SCROLL FUNCTION TO CLEAR SCREEN
	call	nVidia		;compensate for nVidia card bug
	INT	10H		;CALL BIOS

	DEC	DH		;RESTORE SCROWS IF IT WAS CHANGED ABOVE
	CMP	DH,36		;ALL THIS TROUBLE IS FOR THE COMPAQ PRESARIO
	JNE	CLEAR0		; MODEL 1240--800X600 NEOMAGIC DISPLAY
	MOV	ES:SCROWS,DH
CLEAR0:	CMP	DH,41
	JNE	CLEAR9
	MOV	ES:SCROWS,DH
CLEAR9:
	MOV	BH,ES:VPAGE	;GET CURRENT PAGE
	XOR	DX,DX		;SET CURSOR TO HOME POSITION
	MOV	AH,002H		;SET CURSOR FUNCTION
	INT	10H		;CALL BIOS

	POP	ES		;RESTORE EXTENDED SEGMENT
	CLC
	RET
CLEAR	ENDP
	PAGE

;PSEUDO DEVICE HANDLER ROUTINES
; THE PSEUDO DEVICE IS A CIRCULAR MEMORY BUFFER WHICH CAN BE 
; READ OR WRITEN TO. SIMPLIFIES STRING PARSING AND NUMBER
; CONVERSION

DSEG	SEGMENT WORD PUBLIC 'DATA'
PSUSIZ	EQU	256		;SIZE OF BUFFER
PSUBUF	DB PSUSIZ DUP(?)	;PSEUDO DEVICE BUFFER
PSIRED	DW	0		;READ POINTER
PSIWRT	DW	0		;WRITE POINTER
PSISTR	DW	0		;START POINTER
DSEG	ENDS

;OPEN PSEUDO DEVICE FOR OUTPUT

PSOPNO:	MOV	PSIWRT,0	;ZERO WRITE POINTER
	MOV	PSISTR,0	;ZERO START POINTER

;OPEN PSEUDO DEVICE FOR INPUT

PSOPNI:	MOV	BX,PSISTR	;SET READ POINTER TO START
	MOV	PSIRED,BX
	CLC
	RET

;OUTPUT A BYTE TO PSEUDO DEVICE

PSOUT:	MOV	BX,PSIWRT	;GET WRITE POINTER
	MOV PSUBUF[BX],AL	;STORE CHAR IN BUFFER
	CALL	INCWRT		;INCREMENT WRITE POINTER
	CLC
	RET

;INPUT A BYTE FROM PSEUDO DEVICE

PSIN:	MOV	BX,PSIRED	;GET READ POINTER
	CMP	BX,PSIWRT	;READ=WRITE IF EMPTY
	JNE	PSIN1		;SKIP IF MORE TO READ
	MOV	AL,1AH		;SIGNAL END OF FILE
	CLC			;FLAG NO ERROR
	RET

PSIN1:	MOV	AL,PSUBUF[BX]	;READ BYTE
	INC	PSIRED		;ADVANCE POINTER
	CMP	PSIRED,PSUSIZ	;WRAP AROUND?
	JNE	PSIN2		;SKIP IF NOT
	MOV	PSIRED,0	;START OVER
PSIN2:	CLC			;FLAG NO ERROR
	RET
	PAGE

;ROUTINE TO INCREMENT WRITE POINTER AND HANDLE WRAP AROUND
;AND COLLISIONS

INCWRT:	INC	PSIWRT		;INCREMENT WRITE POINTER
	CMP	PSIWRT,PSUSIZ	;WRAP AROUND?
	JB	INCWT1		;SKIP IF NOT
	MOV	PSIWRT,0	;THEN START OVER

INCWT1:	MOV	BX,PSIWRT	;CAUGHT START POINTER?
	CMP	BX,PSISTR
	JNE	INCWT2		;SKIP IF NOT

	INC	PSISTR		;INCREMENT START POINTER
	CMP	PSISTR,PSUSIZ	;WRAP AROUND?
	JB	INCWT2		;SKIP IF NOT
	MOV	PSISTR,0	;START OVER

INCWT2:	CMP	BX,PSIRED	;CAUGHT READ POINTER?
	JNE	INCWT3		;SKIP IF NOT

	INC	PSIRED		;INCREMENT READ POINTER
	CMP	PSIRED,PSUSIZ	;WRAP AROUND?
	JB	INCWT3		;SKIP IF NOT
	MOV	PSIRED,0	;START OVER
INCWT3:	RET
