	PAGE
;********************************************
;**** LOW LEVEL ROUTINES FOR FLOATING IO ****
;********************************************
	.8087

;UNPACKED TEMPORARY REAL CONSTANTS

DSEG	SEGMENT WORD PUBLIC 'DATA'
TENCON	DW	0,0,0		;10 CONSTANT
	DW	0A000H,3,0

KILCON	DW	0,0,0		;1000 CONSTANT
	DW	0FA00H,9,0
DSEG	ENDS


;ADD A DIGIT INTO THE MANTISSA

ADDIN:	PUSH	AX		;SAVE DIGIT
	CALL	MULTEN		;MULTIPLY FAC1 BY TEN
	POP	AX		;RESTORE DIGIT
	CALL	ADD8
	RET

;ADD IN A NIBBLE

ADD8:	MOV DI,OFFSET FACT2	;POINT TO ACCUMLATOR
	CALL	FLTNIB		;FLOAT THE NIBBLE
	CALL	SETFAG		;SET ARGUMENTS
	JMP	FADDE		;DO THE ADD


;MULTIPLY NUMBER IN FACT1 BY TEN

MULTEN:	CALL	SETTEN		;SET ARGUMENTS
	JMP	FMULE		;MULTIPLY

;DIVIDE NUMBER IN FACT1 BY TEN

DIVTEN:	CALL	SETTEN		;SET ARGUMENTS
	JMP	FDIVE
	PAGE

;MULTIPLY NUMBER IN FACT1 BY 1000

MULKIL:	MOV SI,OFFSET KILCON	;POINT TO CONSTANT
	CALL	SETTN1		;SET UP ARGUMENTS
	JMP	FMULE		;MULTIPLY


;DIVIDE NUMBER IN FACT1 BY 1000

DIVKIL:	MOV SI,OFFSET KILCON	;POINT TO CONSTANT
	CALL	SETTN1		;SET UP ARGUMENTS
	JMP	FDIVE		;MULTIPLY


;SET ARGUMENTS SO FACT1 AND FACT2 ARE THE ARGUMENTS
;AND FACT1 GETS THE RESULT

SETFAG:	MOV	SI,OFFSET FACT2	;POINT TO FACT2
	JMP SHORT SETTN1	;ENTER COMMON CODE


;SET ARGUMENTS FOR TEN BASED OPERATIONS

SETTEN:	MOV SI,OFFSET TENCON	;TEN AS ARGUMENT
SETTN1:	MOV RESLTP,OFFSET FACT1	;PUT RESULT IN FAC1
	MOV DI,OFFSET FACT1	;USE FAC1 AS ARGUMENT
	RET
	PAGE
;********************************************
;***** FLOATING POINT UTILITY ROUTINES ******
;********************************************

;CONVERT WORD IN AX TO UNPACKED TEMPOARAY REAL
;RESULT STORED IN LOCATION POINTED TO BY DI

FLTWRD:	XOR	BX,BX		;ZERO TAG AND SIGN
	OR 	AX,AX		;NEGATIVE?
	JNS	FLTWD1		;SKIP IF NOT
	NEG	AX		;CONVERT TO POSITIVE
	MOV	BL,80H		;SET SIGN BIT
FLTWD1:	MOV	CX,15		;START WITH EXP=15
	JMP SHORT FLTNB1	;ENTER COMMON CODE

;CONVERT UNSIGNED NIBBLE IN AL TO TEMPORARY REAL
;STORE RESULT AT LOCATION POINTED TO BY DI

FLTNIB	PROC	NEAR
	XCHG	AH,AL		;NIBBLE IN HIGH BYTE
	XOR	AL,AL		;MAKE SURE LOW IS ZERO
	MOV	CX,7		;START WITH EXP OF 6
	XOR	BX,BX		;ZERO SIGN AND TAG

;NORMALIZE BY SHIFT TILL MSB IS A ONE

FLTNB1:	JS	FLTNB2		;EXIT IF NORMAL
	SHL	AX,1		;SHIFT IT
	LOOP	FLTNB1		;LOOP

FLTNB2:	JNZ	FLTNB3		;SKIP IF NOT ZERO
	MOV	BH,01H		;TAG FOR ZERO

FLTNB3:	MOV WORD PTR [DI],0	;ZERO M0
	MOV WORD PTR [DI+2],0	;ZERO M1
	MOV WORD PTR [DI+4],0	;ZERO M2
	MOV	[DI+6],AX	;STORE M3
	MOV	[DI+8],CX	;STORE EXP
	MOV	[DI+10],BX	;STORE SIGN & TAG
	RET
FLTNIB	ENDP
	PAGE

;CONVERT THE INTEGER IN BX TO A LONG REAL
;RETURNS SIGN, EXPONENT AND MANTISSA IN AX
;MANTISS IN BX. REST OF MANTISSA IS ZERO

FLOAT	PROC	NEAR
	OR	BX,BX		;ZERO INTEGER?
	JZ	FLOAT6		;SKIP IF SO

	MOV	DH,BH		;GET THE SIGN BYTE
	AND	DH,80H		;ISOLATE THE BIT
	JNS	FLOAT1		;SKIP IF POSITIVE
	NEG	BX		;MAKE POSITIVE

;SHIFT MANTISSA UNTIL MSB IS ONE

FLOAT1:	MOV	AX,15		;SET THE EXPONENT
	TEST	BX,0FF00H	;HIGH BYTE ZERO?
	JNZ	FLOAT2		;SKIP IF NOT
	XCHG	BH,BL		;DO 8 BIT "SHIFT"
	MOV	AX,7		;FIX EXPONENT

FLOAT2:	TEST	BX,8000H	;HIGH BIT SET?
	JNZ	FLOAT4		;EXIT IF SO
FLOAT3:	DEC	AX		;ADJUST EXPONENT
	SHL	BX,1		;SHIFT
	JNS	FLOAT3		;LOOP UNTIL MSB SET

FLOAT4:	ADD	AX,03FFH	;BIAS EXPONENT
	SHL	BX,1		;THROW AWAY IMPLIED ONE

;ALIGN EXPONENT AND MANTISSA WITH LONG REAL FORMAT

	MOV	CX,4
FLOAT5:	SHL	BX,1		;SHIFT MANTISSA
	RCL	AX,1		;SHIFT EXPONENT
	LOOP	FLOAT5		;LOOP
	
	OR	AH,DH		;OR IN THE SIGN
	RET

;HERE IF ZERO INTEGER, MANTISSA AND EXPONET ZERO

FLOAT6:	MOV	AX,0
	MOV	BX,AX
	RET
FLOAT	ENDP
	PAGE

;ROUTINE TO CONVERT UNPACKED TEMPORARY REAL AT SI
;TO INTEGER IN AX

FIXNIB:	MOV	AX,[SI]+8	;GET EXPONENT
	OR	AX,AX		;NEGATIVE?
	JS	FIXNB9		;SKIP IF SO

	MOV	DH,[SI]+10	;GET THE SIGN
	MOV	BX,[SI]+6	;GET MANTISSA

	MOV	CX,15		;TEST EXPONENT TOO BIG
	SUB	CX,AX
	JL	FIXERR		;THEN HANDLE FIX ERROR
	JE	FIXNB2		;SKIP NO ADJUSTMENT NEEDED
	SHR	BX,CL		;SHIFT TO  PROPER MAGNITUDE
FIXNB2:	OR	DH,DH		;TEST THE SIGN
	JNS	FIXNB3		;SKIP IF POSITIVE
	NEG	BX
FIXNB3:	CLC			;NO ERROR
	MOV	AX,BX		;PUT RESULT IN AX
	RET

FIXNB9:	XOR	AX,AX		;RETURN ZERO
	RET			;CARRY CLEARED BY XOR
	PAGE

;ROUTINE TO CONVERT A LONG REAL TO AN INTEGER
;WORD 3 AND 2 OF REAL IN AX AND BX, RESULT IN BX

FIX	PROC	NEAR
	MOV	DH,AH		;SAVE SIGN
	AND	AX,07FFFH	;STRIP SIGN BIT

;SHIFT EXPONENT AND MANTISSA TO WORD BOUNDRY

	MOV	CX,4		;SHIFT 4 RIGHT
FIX1:	SHR	AX,1
	RCR	BX,1
	LOOP	FIX1		;LOOP

;UNBIAS NUMBER AND CHECK FOR N>1

	SUB	AX,03FFH	;UNBIAS EXPONENT
	JNS	FIX4		;POSITIVE THEN N>=1

	CMP	AX,-1		;IF -1 THEN N >= .5
	JNZ	FIXZER		;SKIP N<1
	MOV	BX,1		;ROUND .5 TO 1
	JMP SHORT FIX5		;ENTER COMMON CODE

;SHIFT MANTISSA TO PROPER MAGNITUDE

FIX4:	MOV	CX,15		;TEST EXPONENT TOO BIG
	SUB	CX,AX		;AND CALCULATE # SHIFTS
	JL	FIXERR		;HANDLE TOO BIG TO SHIFT

	STC			;SET IMPLIED ONE BIT
	RCR	BX,1		;SHIFT INTO PLACE
	JCXZ	FIX2		;SKIP NO SHIFTING NEEDED
	SHR	BX,CL		;SHIFT TO  PROPER MAGNITUDE

FIX2:	ADC	BX,0		;ROUND IF CARRY SET
FIX5:	OR	DH,DH		;TEST THE SIGN
	JNS	FIX3		;SKIP IF POSITIVE
	NEG	BX
FIX3:	CLC			;NO ERROR
	RET

;HERE IF NUMBER IS A FRACTION

FIXZER:	MOV	BX,0		;ZERO THE INTEGER
	CLC			;NO ERROR
	RET

FIXERR:	STC			;FLAG ERROR
	RET
FIX	ENDP
	PAGE

;ZERO A FLOATING POINT ACCUMULATOR, UNPACKED TEMPORARY REAL FORMAT
;POINTED TO BY DI

ZFACT:	MOV	CX,5		;6 WORDS LONG
	CALL	ZERFAC		;ZERO MANTISSA AND EXPONENT
	MOV WORD PTR [DI],0100H	;SET TAG FOR ZERO
	RET

;ZERO A FLOATING POINT ACCUMULATOR, LONG REAL FORMAT
;POINT TO BY DI

ZFACL:	MOV	CX,4		;4 WORDS LONG

;GENERAL PURPOSE ROUTINE TO ZERO A FLOATING POINT ACCUMULATOR
;POINTED TO DI, SIZE IN CX

ZERFAC:	XOR	AX,AX		;GET A ZERO
	CLD			;SET FOR INCREMENT
REP	STOSW			;STORE IT
	RET


;SWAP UNPACKED TEMPORARY REALS POINTED TO BY SI AND DI

FSWAP:	MOV	CX,6		;COPY SIX WORDS
FSWAP1:	MOV	AX,[DI]		;T:=DI
	MOVSW			;DI:=SI
	MOV	[SI]-2,AX	;SI:=T
	LOOP	FSWAP1
	RET

	PAGE

;ROUTINE TO COMPARE UNPACKED TEMPORARY REALS
;COMPARE NUMBERS POINTED TO BY SI AND DI
;i.e. [SI] > [DI] = JA
;USE UNSIGNED OPERATORS: JA,JAE,JE,JNE,JBE,JB

FCMPT:	MOV	AH,[SI]+10	;COMPARE SIGNS
	MOV	AL,[DI]+10	;(REVERSED)
	AND	AX,8080H	;STRIP REST OF BYTE
	CMP	AL,AH
	JNE	FCMP1		;EXIT IF NOT SAME
	CMP	AX,8080H	;BOTH NEGATIVE?
	JNE	FCMPT1		;SKIP IF NOT
	XCHG	SI,DI		;SWAP NUMBERS IF BOTH NEGATIVE

FCMPT1:	MOV	AX,[SI]+8	;COMPARE EXPONENTS
	MOV	BX,[DI]+8
	ADD	AX,3FFFH	;BIAS EXPONENTS
	ADD	BX,3FFFH
	CMP	AX,BX		;NOW COMPARE
	JNE	FCMP1		;EXIT IF NO SAME
	JMP SHORT FCMP2		;COMPARE MANTISSAS


;ROUTINE TO COMPARE LONG REALS
;COMPARE NUMBERS POINTED TO BY SI AND DI
;i.e. [SI] > [DI] = JA
;USE UNSIGNED OPERATORS: JA,JAE,JE,JNE,JBE,JB

FCMP:	MOV	AH,[SI]+7	;GET SIGN BYTES
	MOV	AL,[DI]+7
	AND	AX,8080H	;STRIP EXPONENT PART
	CMP	AL,AH		;COMPARE SIGNS (REVERSED)
	JNE	FCMP1		;EXIT IF SIGN NOT SAME
	CMP	AX,8080H	;BOTH NEGATIVE?
	JNE	FCMP2		;SKIP IF NOT
	XCHG	SI,DI		;SWAP NUMBERS IF BOTH NEGATIVE

;DO INTEGER COMPARE IF SIGNS ARE THE SAME

FCMP2:	STD			;SET DECREMNT MODE
	ADD	SI,6		;POINT TO HIGH WORD
	ADD	DI,6
	MOV	CX,4		;COMPARE FOUR BYTES
REPE	CMPSW			;COMPARE UNTIL NOT EQUAL
	CLD			;RESET INCREMENT MODE
FCMP1:	RET

	PAGE
;**********************************************
;********  FLOATING POINT PACKAGE  ************
;**********************************************

;PACKAGE USES IEEE FORMAT FLOATING POINT FORMAT
;INPUT AND OUTPUT TO THE PACKAGE IS THROUGH 4 WORD
;LONG REALS, INTERNAL CALCULATIONS ARE 5 WORD
;TEMPORARY REALS

;LONG REAL FORMAT:

;/------ W3 -----------\  /------ W2 -------\
;SEEE-EEEE EEEE-(1).MMMM  MMMM-MMMM MMMM-MMMM

;/------ W1 -------\  /------ W0 -------\
;MMMM-MMMM MMMM-MMMM  MMMM-MMMM MMMM-MMMM


;LONG REAL UNPACKED INTO TEMPORARY REAL FORMAT

;/------ W5 -------\  /------ W4 -------\
;TTTT-TTTT SXXX-XXXX  0000-0EEE EEEE-EEEE

;/------ W3 -------\  /------ W2 -------\
;1MMM-MMMM MMMM-MMMM  MMMM-MMMM MMMM-MMMM

;/------ W1 -------\  /------ W0 -------\
;MMMM-MMMM MMMM-MMMM  MMMM-M000 0000-0000


;S=SIGN BIT	E=EXPONENT	M=MANTISSA
;X=UNUSED	T=TAG BYTE

;THE TAG BYTE FLAGS SPECIAL VALUES IN THE NUMBER
;TAG: 00=VALID, 01=ZERO, 10=SPECIAL, 11=EMPTY
	PAGE

;FLOATING POINT ACCUMULATORS FOR UNPACKED TEMPORARY REAL FORMAT

DSEG	SEGMENT WORD PUBLIC 'DATA'
FACT1	DW	0	;MANTISSA 0
	DW	0	;MANTISSA 1
	DW	0	;MANTISSA 2
	DW	0	;MANTISSA 3
	DW	0	;EXPONENT
	DB	0	;SIGN
	DB	0	;TAG BYTE

FACT2	DW	0	;MANTISSA 0
	DW	0	;MANTISSA 1
	DW	0	;MANTISSA 2
	DW	0	;MANTISSA 3
	DW	0	;EXPONENT
	DB	0	;SIGN
	DB	0	;TAG BYTE

FACT3	DW	0	;MANTISSA 0
	DW	0	;MANTISSA 1
	DW	0	;MANTISSA 2
	DW	0	;MANTISSA 3
	DW	0	;EXPONENT
	DB	0	;SIGN
	DB	0	;TAG BYTE

FACT4	DW	0	;MANTISSA 0
	DW	0	;MANTISSA 1
	DW	0	;MANTISSA 2
	DW	0	;MANTISSA 3
	DW	0	;EXPONENT
	DB	0	;SIGN
	DB	0	;TAG BYTE

	PAGE
;POINTER TO WHERE RESULTS SHOULD BE PLACED

RESLTP	DW	0

;VARIABLE STORAGE

DIVARG	DW	0		;DIVISION ARGUMENT


;BITS SET IN THIS WORD FLAGS ANY FLOATING POINT ERRORS
;1=INVALID, 2=DENORMAL RESULT, 4=DIVIDE BY ZERO
;8=OVERFLOW, 10=UNDERFLOW, 20=LOSS OF PRECISION

FSTAT	DB	0		;STATUS BYTE

;TEMPORARY MANTISSA FOR DIVIDES

MTEMP0	DW	0
MTEMP1	DW	0
MTEMP2	DW	0
MTEMP3	DW	0
	PAGE

;FLOATING POINT CONSTANTS
;UNPACKED TEMPORARY REAL FORMAT

;ZERO CONSTANT

ZERCTR	DW	0	;M0
	DW	0	;M1
	DW	0	;M2
	DW	0	;M3
	DW	0C001H	;EXP
	DB	0	;SIGN
	DB	1	;TAG

;EMPTY CONTSTANT

EMTCTR	DW	0	;M0
	DW	0	;M1
	DW	0	;M2
	DW	0	;M3
	DW	04000H	;EXP
	DB	0	;SIGN
	DB	3	;TAG

;SPECIAL CONSTANT

SPECTR	DW	0	;M0
	DW	0	;M1
	DW	0	;M2
	DW	0	;M3
	DW	04000H	;EXP
	DB	80H	;SIGN
	DB	2	;TAG

;HUGE NUMBER CONSTANT

BIGCTR	DW	0FFFFH	;M0
	DW	0FFFFH	;M1
	DW	0FFFFH	;M2
	DW	0FFFFH	;M3
	DW	03FFFH	;EXP
	DB	0	;SIGN
	DB	0	;TAG


;LONG REAL CONSTANTS

EMTCLR	DW	0
	DW	0
	DW	0
	DW	07FF0H
DSEG	ENDS

	PAGE

;*** FLOATING POINT ROUTINE ENTRY POINTS ***
;NUMBERS MUST BE UNPACKED TEMPORARY REALS
;NUMBERS ARE UNPACKED BY "FLOAD" AND PACKED
;BY "FSTORE"

;ARGUEMNENTS ARE POINTED TO BY DI AND SI
;RESULT STORED AT ADDRESS POINTED BY "RESLTP"

;FLOATING POINT SUBTRACT ENTRY POINT
;[RESLTP]:=[DI]-[SI]

FSUBE:	MOV	DX,0080H	;REVERSE SIGN FOR SUBTRACT
	JMP SHORT FADD1


;FLOATING MULTIPLY ENTRY POINT
;[RESLTP]:=[DI]*[SI]

FMULE:	XOR	DX,DX		;ZERO DX
	MOV BX,OFFSET FMLTAB	;POINT TO TABLE
	JMP SHORT FGOTO

;FLOATING DIVIDE ENTRY POINT
;[RESLTP]:=[DI]/[SI]

FDIVE:	XOR	DX,DX		;ZERO DX
	XCHG	SI,DI		;SWAP POINTERS
	MOV BX,OFFSET FDVTAB	;POINT TO TABLE
	JMP SHORT FGOTO

;FLOATING DIVIDE REVERSED ENTRY POINT
;[RESLTP]:=[SI]/[DI]

FDIVRE:	XOR	DX,DX		;ZERO DX
	MOV BX,OFFSET FDVTAB	;POINT TO TABLE
	JMP SHORT FGOTO

;FLOATING ADD ENTRY POINT

FADDE:	XOR	DX,DX		;ZERO DX
FADD1:	MOV BX,OFFSET FADTAB	;POINT TO TABLE
	PAGE

;DISPATCH TO CORRECT ROUTINE BY TAKING THE TAG WORD FOR EACH OPERAND
;AND FORMING AN ADDRESS

FGOTO:	CLD			;DO EVERYTHING INCREMENT
	MOV	AL,[DI+11]	;GET TAG WORD
	SHL	AL,1		;PUT IN HIGH NIBBLE
	SHL	AL,1
	OR	AL,[SI+11]	;COMBINE WITH OTHER
	CBW			;FORM A WORD
	SHL	AX,1		;TIMES 2
	ADD	BX,AX		;ADD TO BASE ADDRESS

	XOR	DH,[DI+10]	;GET BOTH SIGNS
	XOR	DL,[SI+10]
	MOV	CX,[DI+8]	;GET BOTH EXPONENTS
	MOV	AX,[SI+8]
	JMP	[BX]		;DISPATCH TO ROUTINE

	PAGE


;FLOATING ADD/SUBTRACT DISPATCH TABLE

DSEG	SEGMENT WORD PUBLIC 'DATA'
FADTAB	DW	ADDF	;VALID - VALID
	DW	FSPE	;VALID - ZERO
	DW	FSPC	;VALID - SPECIAL
	DW	FSPD	;VALID - EMPTY
	DW	FSPD	;ZERO - VALID
	DW	FSPE	;ZERO - ZERO
	DW	FSPC	;ZERO - SPECIAL
	DW	FSPD	;ZERO - EMPTY
	DW	FSPB	;SPECIAL - VALID
	DW	FSPB	;SPECIAL - ZERO
	DW	FSPK	;SPECIAL - SPECIAL
	DW	FSPB	;SPECIAL - EMPTY
	DW	FSPE	;EMPTY - VALID
	DW	FSPE	;EMPTY - ZERO
	DW	FSPC	;EMPTY - SPECIAL
	DW	FSPK	;EMPTY - EMPTY


;FLOATING MULTIPLY DISPATCH ROUTINES

FMLTAB	DW	MULF	;VALID - VALID
	DW	FSPF	;VALID - ZERO
	DW	FSPC	;VALID - SPECIAL
	DW	FSPH	;VALID - EMPTY
	DW	FSPF	;ZERO - VALID
	DW	FSPF	;ZERO - ZERO
	DW	FSPC	;ZERO - SPECIAL
	DW	FSPJ	;ZERO - EMPTY
	DW	FSPB	;SPECIAL - VALID
	DW	FSPB	;SPECIAL - ZERO
	DW	FSPK	;SPECIAL - SPECIAL
	DW	FSPB	;SPECIAL - EMPTY
	DW	FSPH	;EMPTY - VALID
	DW	FSPJ	;EMPTY - ZERO
	DW	FSPC	;EMPTY - SPECIAL
	DW	FSPH	;EMPTY - EMPTY
	PAGE


;FLOATING DIVIDE ROUTINES DISPATCH TABLE

FDVTAB	DW	DIVF	;VALID - VALID
	DW	FSPF	;VALID - ZERO
	DW	FSPC	;VALID - SPECIAL
	DW	FSPH	;VALID - EMPTY
	DW	FSPG	;ZERO - VALID
	DW	FSPI	;ZERO - ZERO
	DW	FSPA	;ZERO - SPECIAL
	DW	FSPG	;ZERO - EMPTY	++ DIVIDE BY ZERO
	DW	FSPB	;SPECIAL - VALID
	DW	FSPB	;SPECIAL - ZERO
	DW	FSPK	;SPECIAL - SPECIAL
	DW	FSPB	;SPECIAL - EMPTY
	DW	FSPF	;EMPTY - VALID
	DW	FSPF	;EMPTY - ZERO
	DW	FSPC	;EMPTY - SPECIAL
	DW	FSPJ	;EMPTY - EMPTY
DSEG	ENDS

	PAGE

;** HANDLE VARIOUS COMBINATION OF SPECIAL OPERANDS ***

;RETURN THE 'SPECIAL' VALUE FROM [SI]
;HERE IF (D zs)

FSPA:	OR	FSTAT,04H	;FLAG DIVIDE BY ZERO
	JMP SHORT FSPC

;RETURN THE 'SPECIAL' VALUE FROM [DI]
;HERE IF (D sv,se)

FSPB:	MOV	SI,DI

;RETURN THE 'SPECIAL' OR 'EMPTY' VALUE FROM SI
;HERE IF (A es,se,zs,vs) (M zs,vs,sv,sz,se,es) (D vs,sz)

FSPC:	OR	FSTAT,01H	;INVALID OPERATION
	MOV	DI,RESLTP
	CMP	SI,DI
	JNZ	FCOPY
	RET

;RETURN THE VALUE IN [SI]
;HERE IF (A ve,zv,ze)

FSPD:	MOV	DH,DL
	JMP SHORT FSPE1

;RETURN THE VALUE IN [DI]
;HERE IF (A ev,ez,zz,vz)

FSPE:	MOV	SI,DI
FSPE1:	MOV	DI,RESLTP
	CALL	FCOPY
	MOV	[DI+10],DH
	RET

;RETURN ZERO CONSTANT
;HERE IF (M zz,zv,vz) (D vz,es,ev,ez)

FSPF:	MOV SI,OFFSET ZERCTR	;USE ZERO CONSTANT
FSPF1:	XOR	DH,DL
	AND	DH,7FH
	MOV	DI,RESLTP
	CALL	FCOPY
	OR	[DI+10],DH
	RET

;RETURN EMPTY CONSTANT
;HERE IF (D ze,vz)

FSPG:	OR	FSTAT,04H	;DIVIDE BY ZERO

;RETURN EMPTY CONSTANT
;HERE IF (M ve,ev,ee) (D ve)

FSPH:	MOV SI,OFFSET EMTCTR	;USE EMPTY CONSTANT
	JMP SHORT FSPF1

;RETURN SPECIAL CONSTANT
;HERE IF (D zz)

FSPI:	OR	FSTAT,04H	;DIVIDE BY ZERO

;RETURN SPECIAL CONSTANT
;HERE IF (M ez,ze) (D ee) (A ss) (M ss) (D ss)

FSPJ:	MOV SI,OFFSET SPECTR	;USE SPECIAL CONSTANT
	OR	FSTAT,01H	;INVALID OPERATION
	MOV	DI,RESLTP

;COPY FROM SI TO DI

FCOPY:	CLD			;MAKE SURE INCREMENT MODE
	MOVSW			;COPY UNPACK REAL
	MOVSW
	MOVSW
	MOVSW
	MOVSW
	MOVSW
	SUB	SI,12
	SUB	DI,12
	RET


;HERE IF (A ss) (M ss) (D ss)

FSPK:	MOV	AX,SI		;SAVE POINTERS
	MOV	BX,DI
	MOV	CX,4		;COMPARE MANTISSAS
REPZ	CMPSW
	JA	FSPK1
	MOV	SI,AX
	JMP	FSPC

FSPK1:	MOV	SI,BX
	JMP	FSPC
	PAGE

;** NORMAL FLOATING ADD/SUBTRACT ROUTINE ***

ADDF:	SUB	AX,CX	;COMPARE EXPONENTS
	JL	ADDF1	;SKIP IF NEGATIVE DIFFERENCE
	XCHG	SI,DI	;SWAP POINTERS
	XCHG	DH,DL	;SWAP SIGNS
	ADD	CX,AX	;RESTORE OLD VALUE
	NEG	AX	;MAKE NEGATIVE SO IT'LL BE POSITIVE

ADDF1:	NEG	AX	;MAKE NEGATIVE
	CMP	AX,67	;67 BITS DIFFERENT?
	JLE	ADDF4	;SKIP IF NOT

;HERE IF EXPONENTS TOO DIFFERENT

	PUSH	BP
	PUSH	DX		;SAVE THE SIGNS
	MOV	SI,[DI+8]	;POINT EXPONENT
	MOV	BP,1
	XOR	DL,DH		;TEST SIGNS
	JNS	ADDF2		;SKIP IF SAME SIGN
	NEG	BP
ADDF2:	MOV	DX,[DI]		;GET THE MANTISSA
	MOV	CX,[DI+2]
	MOV	BX,[DI+4]
	MOV	DI,[DI+6]
	OR	BP,BP		;TEST IF SIGNS WERE OPOSITE
	JS	ADDF3		;SKIP IF SIGNS WERE DIFFERENT
	JMP	FEXT		;ENTER COMMON EXIT

;DECREMENT MANTISSA

ADDF3:	SUB	DX,1
	SBB	CX,0
	SBB	BX,0
	SBB	DI,0
	JMP	FNOR		;TAKE NORMALIZE EXIT
	PAGE

;HERE IF EXPONENTS ARE WITHIN RANGE OF EACH OTHER

ADDF4:	PUSH	BP
	PUSH	DX		;SAVE SIGNS
	PUSH	CX		;SAVE ONE EXPONENT
	XOR	DL,DH		;TEST IF SIGNS THE SAME
	PUSHF			;SAVE THE FLAGE
	MOV	BP,AX		;SAVE EXPONENT  DIFFERENCE

	LODSW			;GET MANTISSA
	MOV	DX,AX
	LODSW
	MOV	CX,AX
	LODSW
	MOV	BX,AX
	LODSW
	XOR	SI,SI		;ZERO SI
	XCHG	BP,SI		;GET EXPONENT DIFFERENCE
	OR	SI,SI		;SAME EXPONENT?
	JZ	ADDF12		;SKIP IF YES
	PAGE

;NOW ALIGN EXPONENTS BY SWAPPING WORDS, THEN BYTES,
;AND THEN SHIFTING BITS

ADDF5:	CMP	SI,14		;GREATER THAN 14
	JL	ADDF7		;SKIP IF NOT
	OR	BP,BP
	JZ	ADDF6
	OR	DX,1

;DO 16 BIT WORD SHIFTS

ADDF6:	MOV	BP,DX		;SHIFT 16
	MOV	DX,CX
	MOV	CX,BX
	MOV	BX,AX
	XOR	AX,AX		;"SHIFT" IN ZERO
	SUB	SI,+10H		;SUBTRACT SHIFTS FROM EXPONENT

	JA	ADDF5		;LOOP IF MORE 16 SHIFTS
	JZ	ADDF12		;SKIP NO MORE TO DO DONE?
	JB	ADDF9		;OVER SHIFT?

ADDF7:	CMP	SI,6
	JL	ADDF10
	XCHG	AX,BP
	OR	AL,AL
	JZ	ADDF8
	OR	AH,1
	PAGE

;DO 8 BIT BYTE SHIFTS

ADDF8:	MOV	AL,AH
	MOV	AH,DL
	XCHG	AX,BP
	MOV	DL,DH
	MOV	DH,CL
	MOV	CL,CH
	MOV	CH,BL
	MOV	BL,BH
	MOV	BH,AL
	MOV	AL,AH
	XOR	AH,AH		;"SHIFT" IN ZERO
	SUB	SI,8		;SUBTRACT SHIFT FROM EXPONENT
	JA	ADDF10
	JZ	ADDF12

;HERE IF WE'VE OVER SHIFTED

ADDF9:	SHL	BP,1
	RCL	DX,1
	RCL	CX,1
	RCL	BX,1
	RCL	AX,1
	INC	SI
	JNZ	ADDF9
	JMP SHORT ADDF12

ADDF10:	XCHG	CX,SI
	TEST	BP,003FH
	JZ	ADDF11
	OR	BP,0020H

;HERE IF WE NEED TO SHIFT MORE BITS

ADDF11:	SHR	AX,1
	RCR	BX,1
	RCR	SI,1
	RCR	DX,1
	RCR	BP,1
	LOOP	ADDF11
	MOV	CX,SI
	PAGE

;HERE WHEN  EXPONENTS ARE THE SAME

ADDF12:	MOV	SI,DI
	MOV	DI,AX
	TEST	BP,3FFFH
	JZ	ADDF13
	OR	BP,1

ADDF13:	POPF			;GET EXPONENT COMPARE
	POP	AX		;GET EXPONENT RESULT
	JS	ADDF16		;SKIP IF OPOSITE SIGNS


	ADD	DX,[SI]		;ADD MANTISSAS
	ADC	CX,[SI+2]
	ADC	BX,[SI+4]
	ADC	DI,[SI+6]
	JNC	ADDF15		;SKIP IF NO OVERFLOW

	RCR	DI,1		;SHIFT TO HANDLE OVERFLOW
	RCR	BX,1
	RCR	CX,1
	RCR	DX,1
	RCR	BP,1
	JNC	ADDF14		;SKIP IF WE LOST NO BITS

	OR	BP,1	;FLAG LOST PRECISION

ADDF14:	INC	AX		;ADJUST EXPONENT FOR OVERFLOW
ADDF15:	MOV	SI,AX		;GET EXPONENT
	JMP	FEXT


ADDF16:	SUB	DX,[SI]		;SUBTRACT MANTISSAS
	SBB	CX,[SI+2]
	SBB	BX,[SI+4]
	SBB	DI,[SI+6]
	JNB	ADDF17		;SKIP IF POSITIVE
	PAGE

;HERE IF NEGATIVE RESULT

	XOR	SI,SI		;GET A ZERO
	NOT	DI		;COMPLIMENT MANTISSA
	NOT	BX
	NOT	CX
	NOT	DX
	NEG	BP
	CMC			;CONVERT BORROW TO CARRY
	ADC	DX,SI		;AND ADD BACK IN
	ADC	CX,SI
	ADC	BX,SI
	ADC	DI,SI
	MOV	SI,AX		;GET EXPONENT
	JMP	FNOR		;GOTO NORMALIZE EXIT

ADDF17:	MOV	SI,AX		;GET EXPONENT
	POP	AX		;COMPLEMENT SIGN
	XOR	AH,80H
	PUSH	AX		;AND PUT BACK ON STACK
	JMP	FNOR		;GOTO NORMALIZE EXIT
	PAGE

;** NORMAL FLOATING MULTIPLY ROUTINE **

MULF:	PUSH	BP
	MOV	BH,DH		;SAVE SIGN
	XOR	DH,DL		;TEST OPOSITE SIGNS
	PUSH	DX
	ADD	AX,CX		;ADD EXPONENTS
	INC	AX		;PLUS 1
	PUSH	AX		;SAVE EXPONENT RESULT

	AND	BH,DL		;## BULLSHIT ##

	XOR	BX,BX		;ZERO BX,CX, BP
	MOV	BP,BX
	MOV	CX,BX

;MAIN MULTIPLY: MULTIPLY WORD BY WORD, ADD IN CARRIES
;DON'T MULTIPLY ANY ZERO TERMS

;TEST A0=0 ! B0=0

	MOV	AX,[SI]		;GET LSW OF MANTISSA
	OR	AX,AX		;ZERO?
	JZ	MULF1		;SKIP IF SO

	MOV	DX,[DI]		;GET LSW OF MANTISSA
	OR	DX,DX
	JZ	MULF1

;MULTIPLY A0 X B0

	MUL	DX		;MULTIPLY
	MOV	BP,AX		;SAVE RESULT
	MOV	CX,DX		;SAVE CARRY

;TEST A0=0 ! B1=0

MULF1:	PUSH	BP
	MOV	AX,[SI]
	OR	AX,AX
	JZ	MULF2

	MOV	DX,[DI+2]	;GET  MANTISSA
	OR	DX,DX
	JZ	MULF2

;MULTIPLY A0 X B1

	MUL	DX		;MULTIPY
	ADD	CX,AX		;ADD CARRIES
	ADC	BX,DX
	ADC	BP,0

;TEST A1=0 ! B1=0

MULF2:	MOV	AX,[SI+2]
	OR	AX,AX
	JZ	MULF3
	MOV	DX,[DI]
	OR	DX,DX
	JZ	MULF3

;MULTIPLY A1 X B1

	MUL	DX
	ADD	CX,AX
	ADC	BX,DX
	ADC	BP,0
MULF3:	POP	AX
	OR	AX,CX
	PUSH	AX
	XOR	CX,CX

;TEST A0=0 ! B2=0

	MOV	AX,[SI]
	OR	AX,AX
	JZ	MULF4
	MOV	DX,[DI+4]
	OR	DX,DX
	JZ	MULF4

;MULTIPLY A0 X B2

	MUL	DX
	ADD	BX,AX
	ADC	BP,DX
	ADC	CX,0

;TEST A1=0 ! B2=0

MULF4:	MOV	AX,[SI+2]
	OR	AX,AX
	JZ	MULF5
	MOV	DX,[DI+2]
	OR	DX,DX
	JZ	MULF5

;MULTIPLY A1 X B2

	MUL	DX
	ADD	BX,AX
	ADC	BP,DX
	ADC	CX,0

;TEST A2=0 ! B0=0

MULF5:	MOV	AX,[SI+4]
	OR	AX,AX
	JZ	MULF6
	MOV	DX,[DI]
	OR	DX,DX
	JZ	MULF6

;MULTIPLY A2 X B0

	MUL	DX
	ADD	BX,AX
	ADC	BP,DX
	ADC	CX,0
MULF6:	POP	AX
	OR	AX,BX
	PUSH	AX
	XOR	BX,BX

;TEST A0=0

	MOV	AX,[SI]
	OR	AX,AX
	JZ	MULF7

;MULTIPLY A0 X B3

	MUL	Word Ptr [DI+6]
	ADD	BP,AX
	ADC	CX,DX
	ADC	BX,0

;TEST A1=0 ! B2=0

MULF7:	MOV	AX,[SI+2]
	OR	AX,AX
	JZ	MULF8
	MOV	DX,[DI+4]
	OR	DX,DX
	JZ	MULF8

;MULTIPLY A1 X B2

	MUL	DX
	ADD	BP,AX
	ADC	CX,DX
	ADC	BX,0

;TEST A2=0 ! B1=0

MULF8:	MOV	AX,[SI+4]
	OR	AX,AX
	JZ	MULF9
	MOV	DX,[DI+2]
	OR	DX,DX
	JZ	MULF9

;MULTIPLY A2 X B1

	MUL	DX
	ADD	BP,AX
	ADC	CX,DX
	ADC	BX,0

;TEST B0=0

MULF9:	MOV	AX,[SI+6]
	MOV	DX,[DI]
	OR	DX,DX
	JZ	MULF10

;MULTIPLY A3 X B0

	MUL	DX
	ADD	BP,AX
	ADC	CX,DX
	ADC	BX,0
MULF10:	MOV	DX,BP
	AND	BP,3FFFH
	POP	AX
	OR	AX,BP
	PUSH	AX
	XOR	BP,BP
	PUSH	DX

;TEST A1=0

	MOV	AX,[SI+2]
	OR	AX,AX
	JZ	MULF11

;MULTIPLY A1 X B3

	MUL	Word Ptr [DI+6]
	ADD	CX,AX
	ADC	BX,DX
	ADC	BP,0

;TEST A2=0 ! B2=0

MULF11:	MOV	AX,[SI+4]
	OR	AX,AX
	JZ	MULF12
	MOV	DX,[DI+4]
	OR	DX,DX
	JZ	MULF12

;MULTIPLY A2 X B2

	MUL	DX
	ADD	CX,AX
	ADC	BX,DX
	ADC	BP,0

;TEST B1=0

MULF12:	MOV	AX,[SI+6]
	MOV	DX,[DI+2]
	OR	DX,DX
	JZ	MULF13

;MULTIPLY A3 X B1

	MUL	DX
	ADD	CX,AX
	ADC	BX,DX
	ADC	BP,0
MULF13:	PUSH	CX
	XOR	CX,CX

;TEST A2=0

	MOV	AX,[SI+4]
	OR	AX,AX
	JZ	MULF14

;MULTIPLY A2 X B3

	MUL	Word Ptr [DI+6]
	ADD	BX,AX
	ADC	BP,DX
	ADC	CX,0

;TEST B2=0

MULF14:	MOV	AX,[SI+6]
	MOV	DX,[DI+4]
	OR	DX,DX
	JZ	MULF15

;MULTIPLY A3 X B2

	MUL	DX
	ADD	BX,AX
	ADC	BP,DX
	ADC	CX,0

;MULTIPLY A3 X B3

MULF15:	MOV	AX,[SI+6]
	MUL	Word Ptr [DI+6]
	ADD	AX,BP
	ADC	DX,CX
	POP	CX
	POP	BP
	MOV	DI,DX
	MOV	DX,CX
	MOV	CX,BX
	MOV	BX,AX
	POP	AX
	OR	AX,AX
	JZ	MULF16

	OR	BP,1
MULF16:	POP	SI
	JMP	FNOR4
	PAGE

;** NORMAL FLOATING POINT DIVIDE **
;DI=DENOMINATOR, SI=NUMERATOR

DIVF:	STC			;PLUS 1
	SBB	AX,CX		;SUBTRACT EXPONENTS
	XOR	DH,DL		;TEST EXPONENTS
	PUSH	BP
	PUSH	DX		;SAVE SIGNS
	PUSH	SI		;SAVE POINTERS
	PUSH	DI

	ADD	SI,6		;COMPARE MANTISSAS
	ADD	DI,6
	MOV	CX,4
	STD
REPZ	CMPSW			;D-N

	CLD
	POP	DI		;RESTORE POINTERS
	POP	SI
	PUSHF			;SAVE COMPARE FLAGS

	MOV	BP,AX		;GET MANTISSA OF NUMERATOR
	LODSW
	MOV	CX,AX
	LODSW
	MOV	BX,AX
	LODSW
	MOV	DX,AX
	LODSW
	XCHG	AX,DX

	MOV	SI,DI		;PUT MANTISSA OF DENOMINATOR
	MOV DI,OFFSET MTEMP0	;IN TEMPORARY
	MOVSW
	MOVSW
	MOVSW
	MOVSW

	XOR	DI,DI		;ZERO DI
	POPF			;GET COMPARE FLAGS
	JB	DIVF1		;SKIP IF N<D

	SHR	DX,1		;REDUCE NUMERATOR BY
	RCR	AX,1		;DIVIDING BY 2
	RCR	BX,1
	RCR	CX,1
	RCR	DI,1
	INC	BP		;ADVANCE EXPONENT

DIVF1:	PUSH	BP		;SAVE EXPONENT

	MOV	DIVARG,DI
	CALL	FDVM		;DO DIVIDE
	PUSH	DI		;SAVE QUOTIENT DIGIT

	MOV Word Ptr DIVARG,0
	CALL	FDVM		;DO DIVIDE
	PUSH	DI		;SAVE QUOTIENT DIGIT

	CALL	FDVM		;DO DIVIDE
	PUSH	DI		;SAVE QUOTIENT DIGIT

	CALL	FDVM		;DO DIVIDE
	MOV	BP,8001H	;-32767
	SHL	CX,1
	RCL	BX,1
	RCL	AX,1
	RCL	DX,1
	JC	DIVF3

	MOV SI,OFFSET MTEMP0	;COMPARE D3 AND N3
	CMP	DX,[SI+6]
	JNZ	DIVF2

	CMP	AX,[SI+4]	;COMPARE D2 AND N2
	JNZ	DIVF2

	CMP	BX,[SI+2]	;COMPARE D1 AND N1
	JNZ	DIVF2

	CMP	CX,[SI]		;COMPARE D0 AND N0
DIVF2:	JNB	DIVF3

	OR	AX,DX		;TEST FOR ZERO
	OR	AX,CX
	OR	AX,BX
	OR	AL,AH
	XOR	AH,AH
	MOV	BP,AX

DIVF3:	MOV	DX,DI
	POP	CX		;GET QUOTIENT DIGITS
	POP	BX
	POP	DI
	POP	SI
	JMP	FEXT		;GOTO COMMON EXIT


;ROUTINE TO DIVIDE MANTISSAS, SINGLE DIGIT RETURNED IN DI

FDVM:	MOV	SI,MTEMP3	;GET D3
	XOR	DI,DI		;ZERO DI
	CMP	DX,SI		;COMPARE N3 TO D3
	JNB	FDVM8		;SKIP IF N3<=D3

	OR	DX,DX		;N3=0?
	JNZ	FDVM1		;SKIP IF NOT

	CMP	SI,AX		;COMPARE D3 TO N2
	JA	FDVM5		;SKIP IF D3.N2

FDVM1:	DIV	SI		;N3,N2/D3
	PUSH	DX		;SAVE REMAINDER
	PUSH	BX		;SAVE N1
	XCHG	AX,DI		;PUT QUOTIENT IN DI
	XOR	BP,BP		;ZERO BP
	MOV	SI,BP		;AND SI
	MOV	AX,MTEMP0	;GET D0
	OR	AX,AX		;D0=0?
	JZ	FDVM2		;SKIP IF ZERO

	MUL	DI		;D0 * Q
	MOV	SI,DX		;SAVE REMAINDER
FDVM2:	PUSH	AX		;SAVE RESULT
	MOV	AX,MTEMP1	;GET D1
	OR	AX,AX		;D1=0?
	JZ	FDVM3		;SKIP IF ZERO

	MUL	DI		;D1 * Q
	ADD	SI,AX		;ADD TO REMAINDER
	ADC	BP,DX		;ADD IN CARRY

FDVM3:	MOV	AX,MTEMP2	;GET D2
	OR	AX,AX		;D2=0?
	JZ	FDVM4		;SKIP IF ZERO

	MUL	DI		;D2 * Q
	ADD	BP,AX
	ADC	DX,0
	XCHG	AX,DX

FDVM4:	MOV	DX,DIVARG
	POP	BX		;GET OLD RESULT
	SUB	DX,BX
	SBB	CX,SI
	POP	BX		;GET N1
	SBB	BX,BP
	POP	BP		;GET REMAINDER
	SBB	BP,AX

	XCHG	AX,BP		;SHIFT NUMERATOR 16 LEFT
FDVM5:	XCHG	AX,DX
	XCHG	AX,CX
	XCHG	AX,BX
	JNB	FDVM7

;ADD BACK DENOMINATORE UNTIL THERE A CARRY

FDVM6:	DEC	DI
	ADD	CX,MTEMP0
	ADC	BX,MTEMP1
	ADC	AX,MTEMP2
	ADC	DX,MTEMP3
	JNC	FDVM6
FDVM7:	RET

;SUBTRACT BACK THE DEMONINATOR

FDVM8:	DEC	DI
	SUB	CX,MTEMP0
	SBB	BX,MTEMP1
	SBB	AX,MTEMP2
	ADD	CX,MTEMP1
	ADC	BX,MTEMP2
	ADC	AX,DX
	MOV	DX,MTEMP0
	CMC
	JMP SHORT FDVM5
	PAGE

;NORMALIZE NUMBER AND TAKE ROUNDING EXIT
;NORMALIZE BY SHIFTING UNTIL BIT 15 OF M3#0
;M0=DX M1=CX M2=BX M3=DI EXP=SI SIGN=TOS BP=TAG INFO

FNOR:	MOV	AL,4		;ONLY 4 16-BIT SHIFTS
FNOR1:	OR	DI,DI		;M3=0?
	JNZ	FNOR3		;SKIP IF NOT

	SUB	SI,16		;ADJUST EXPONENT
	DEC	AL		;COUNT SHIFTS
	JZ	FNOR2		;SKIP IF MANTISSA ZERO

	MOV	DI,BX		;DO 16 BIT "SHIFT"
	MOV	BX,CX
	MOV	CX,DX
	MOV	DX,BP
	XOR	BP,BP		;"SHIFT" IN ZERO
	JMP SHORT FNOR1		;LOOP

;HERE IF MANTISSA IS ZERO

FNOR2:	MOV SI,OFFSET ZERCTR	;USE ZERO CONSTANT
	MOV	DI,RESLTP	;WHERE TO PUT IT
	POP	AX		;GET SIGN
	POP	BP
	JMP	FCOPY		;EXIT

;HERE WHEN M3#0

FNOR3:	TEST	DI,0FF00H	;HIGH BYTE OF M3#0?
	JNZ	FNOR4		;SKIP IF SO
	PAGE

;DO AN 8 BIT SHIFT

	SUB	SI,8		;ADJUST EXPONENT
	XCHG	AX,DI		;"SHIFT" 8 BITS
	MOV	AH,AL
	MOV	AL,BH
	MOV	BH,BL
	MOV	BL,CH
	MOV	CH,CL
	MOV	CL,DH
	MOV	DH,DL
	XCHG	AX,DI
	XCHG	AX,BP
	MOV	DL,AH
	MOV	AH,AL
	XOR	AL,AL		;"SHIFT" IN ZERO
	XCHG	AX,BP
FNOR4:	TEST	DI,8000H	;HIGH BIT OF M3 SET?
	JNZ	FEXT		;SKIP IF SO

;DO BIT SHIFTS UNTIL HIGH BIT OF M3 IS SET

FNOR5:	DEC	SI		;ADJUST EXPONENT
	SHL	BP,1		;SHIFT MANTISSA
	RCL	DX,1
	RCL	CX,1
	RCL	BX,1
	RCL	DI,1
	TEST	DI,8000H	;MSB OF M3 SET?
	JZ	FNOR5		;LOOP IF NOT
	JMP SHORT FEXT		;TAKE ROUNDING EXIT
	PAGE

;EXIT TO HANDLING ROUNDING AND STORAGE OF RESULT
;M0=DX M1=CX M2=BX M3=DI EXP=SI SIGN=TOS BP=TAG INFO

FEXT:	OR	BP,BP		;TAG PROBLEM
	JZ	FEXT2		;EXIT IF NOT

	OR	FSTAT,20H	;FLAG LOSS OF PRECISION

;HERE IF "ROUNDING TO NEAREST OR EVEN"

	CMP	BP,8000H	;
	JA	FEXT1
	JB	FEXT2

	TEST	DL,1		;TEST LOW BIT
	JZ	FEXT2
	JMP SHORT FEXT1

;ROUND BY INCREMENTING MANTISSA

FEXT1:	XOR	BP,BP		;GET ZERO
	ADD	DX,1		;ADD 1
	ADC	CX,BP
	ADC	BX,BP
	ADC	DI,BP
	JNC	FEXT2		;EXIT IF NO OVERFLOW

	MOV	DI,8000H	;PRESET M3
	INC	SI		;ADVANCE EXPONENT
	PAGE

;HERE TO STORE RESULT AND EXIT

FEXT2:	MOV	AX,RESLTP	;GET PLACE TO STORE RESULT
	XCHG	AX,DI		;PUT IN INDEX
	MOV	[DI],DX		;STORE MANTISSA
	MOV	[DI+2],CX
	MOV	[DI+4],BX
	MOV	[DI+6],AX
	POP	AX		;GET SIGN
	POP	BP
	AND	AH,80H		;ISOLATE SIGN BIT
	MOV	[DI+10],AH	;STORE IT
	CMP	SI,4000H	;EXP >= 16384?
	JGE	FEXT4		;THEN SKIP
	CMP	SI,0C001H	;EXP <= -16383?
	JLE	FEXT3		;THEN SKIP

	MOV	[DI+8],SI	;STORE EXPONENT
	MOV Byte Ptr [DI+11],0	;ZERO TAG BYTE
	RET

;HERE IF EXPONENT TOO SMALL

FEXT3:	MOV SI,OFFSET ZERCTR	;USE ZERO CONSTANT
	CALL	FCOPY		;MOVE IT
	MOV	[DI+10],AH	;STORE SIGN
	RET

;HERE IF EXPONENT TOO LARGE

FEXT4:	OR	FSTAT,08H	;FLAG OVER FLOW
	MOV SI,OFFSET EMTCTR	;USE EMPTRY CONSTANT
	CALL	FCOPY		;STORE IT
	MOV	[DI+10],AH	;STORE SIGN
	RET
	PAGE

;********************************
;*** FLOATING LOAD ROUTINES *****
;********************************

;FLOATING LOAD AND CONVERT FROM LONG REAL TO TEMPORARY
;SOURCE IN SI, DESTINATION IN DI

;LOAD LONG REAL INTO AX,BX,CX,DX, AND BP

FLOAD:	CLD			;ALWAY INCREMENT
	LODSW			;LOAD LONG REAL
	MOV	BP,AX 
	LODSW
	MOV	DX,AX 
	LODSW
	MOV	CX,AX 
	LODSW
	XCHG	DI,SI 
	MOV	BX,AX 

;CONVERT LONG REAL IN AX,BX,CX,DX AND BP TO TEMPORAY REAL
; SHIFT LEFT 3 TO ALIGN LONG REAL WITH TEMPORARY

	SHL	BP,1		;SHIFT MANTISSA 1
	RCL	DX,1 
	RCL	CX,1 
	RCL	BX,1 
	SHL	BP,1		;SHIFT MANTISSA 2
	RCL	DX,1 
	RCL	CX,1 
	RCL	BX,1 
	SHL	BP,1		;SHIFT MANTISSA 3
	RCL	DX,1 
	RCL	CX,1 
	RCL	BX,1 
	OR	BL,80H		;OR IN IMPLIED 1.

;STORE MANTISSA

	MOV	[SI+7],BL
	MOV	[SI+5],CX
	MOV	[SI+3],DX
	MOV	[SI+1],BP
	PAGE

;TEST FOR ZERO MANTISSA

	OR	CX,BP
	OR	CX,DX 

;ISOLATED AND SAVE SIGN

	MOV	DH,AH
	AND	DH,80H
	MOV	[SI+10],DH

;ZERO LOW ORDER OF T-REAL

	XOR	DH,DH		;ZERO LOW ORDER T-REAL
	MOV	[SI],DH

;ALIGN EXPONENT WITH T-REAL FORMAT

	AND	AH,7FH		;STRIP SIGN BIT
	SHR	AX,1		;SHIFT INTO LOW
	SHR	AX,1		;PART OF WORD
	SHR	AX,1 
	SHR	AX,1 

;TEST FOR MAX EXPONENT

	CMP	AX,07FFH
	JZ	FLOD1

;TEST FOR ZERO EXPONENT

	CMP	AX,0
	JZ	FLOD2


	SUB	AX,03FFH	;UNBIAS EXPONENT
FLOD:	MOV	[SI+8],AX	;STORE EXPONENT
	MOV	[SI+11],DH	;SAVE SIGN AGAIN
	RET
	PAGE

;HERE IF MAX EXPONENT (7FF)

FLOD1:	MOV	AX,4000H
	MOV	DH,02 
	CMP	BL,80H 
	JNZ	FLOD 

	OR	CX,CX 
	JNZ	FLOD 
	OR	DH,1 
	JMP SHORT FLOD 

;HERE IF EXPONENT IS ZERO

FLOD2:	CMP	BL,80H		;IMPLIED ONE IN PLACE?
	JNZ	FLOD3		;SKIP IF NOT

	OR	CX,CX		;ZERO MANTISSA?
	JNZ	FLOD3 		;SKIP IF NOT
	MOV	AX,0C001H
	MOV	DH,1 
	JMP SHORT FLOD

;HERE IF ZERO EXPONENT AND NON-ZERO MANTISSA OR NO IMPLIED ONE

FLOD3:	OR	FSTAT,02H	;FLAG DENORMAL RESULT
	SUB	AX,03FFH
	MOV	BP,[SI]
	MOV	DX,[SI+2]
	MOV	CX,[SI+4]
	MOV	BX,[SI+6]
	INC	AX
FLOD4:	DEC	AX
	SHL	BP,1
	RCL	DX,1
	RCL	CX,1
	RCL	BX,1
	OR	BX,BX
	JNS	FLOD4
	MOV	[SI],BP
	MOV	[SI+2],DX
	MOV	[SI+4],CX
	MOV	[SI+6],BX
	XOR	DH,DH
	JMP SHORT FLOD
	PAGE

;*******************************
;*** FLOATING STORE ROUTINES ***
;*******************************

;HERE IF TAG BYTE NOT ZERO

FSEX:	TEST	CL,02
	JNZ	FSEX1		;SKIP BIT ONE SET

;HERE IF TAG=01 ZERO RESULT

	XOR	AX,AX		;GET A ZERO NUMBER
	STOSW
	STOSW
	STOSW
	STOSW
	RET			;EXIT
	PAGE

FSEX1:	TEST	CL,1
	JNZ	FSEX2

;HERE IF TAG=10 SPECIAL NUMBER

	MOV	DX,[SI+1]	;GET MANTISSA
	MOV	BX,[SI+3]
	MOV	AX,[SI+5]
	MOV	CL,[SI+7]

	SHR	CL,1		;ALIGN WITH L-REAL FORMAT
	RCR	AX,1
	RCR	BX,1
	RCR	DX,1
	SHR	CL,1
	RCR	AX,1
	RCR	BX,1
	RCR	DX,1
	SHR	CL,1
	RCR	AX,1
	RCR	BX,1
	RCR	DX,1

	XCHG	AX,DX		;STORE MANTISSA
	STOSW
	MOV	AX,BX
	STOSW
	MOV	AX,DX
	STOSW
	MOV	BH,[SI+10]	;GET SIGN
	AND	BH,80H		;ISOLATE THE BIT
	MOV	AX,7FF0H	;MAKE BIASED EXPONENT OF 0
	OR	AH,BH		;ADD IN SIGN
	OR	AL,CL		;ADD MANTISSA NIBBLE
	STOSW			;STORE IT
	RET			;EXIT

;HERE IF TAG=11, EMPTY 

FSEX2:	MOV	BL,[SI+10]	;GET SIGN
	AND	BL,80H		;ISSOLATE IT
	JMP	FSTR7

FSEX3:	JMP	FSTR6		;EXP>1024
FSEX4:	JMP	FSTR9		;EXP<-1024
FSEX5:	JMP	FSEX		;TAG PROBLEMS
	PAGE

;****** MAIN ENTRY POINT *********
;STORE FLOATING POINT NUMBER
;CONVERT FROM UNPACKED TEMPORARY REAL TO
;LONG REAL, SOURCE IN SI, DESTINATION IN DI

FSTORE:	CLD			;SET INCREMNT 
	MOV	CL,[SI+11]	;GET TAG WORD?
	OR	CL,CL		;ANY PROBLEMS?
	JNZ	FSEX5		;JUMP IF SO

	MOV	CL,[SI+10]	;GET SIGN
	MOV	BP,[SI+8]	;GET EXPONENT
	CMP	BP,0400H	;COMPARE WITH 1024
	JGE	FSEX3		;JUMP >=1024

	CMP	BP,0FC01H	;COMPARE WITH -1024
	JLE	FSEX4		;JUMP <=-1024

	MOV	AL,[SI]		;GET LSB OF MANTISSA
	MOV	DX,[SI+1]	;GET MORE MANTISSA
	OR	AL,AL		;LSB BITS?
	JZ	FSTR		;SKIP NO LSB

	OR	DL,1		;OR IN A ONE

;HERE IF NO LSB

FSTR:	TEST	DL,07H		;BITS SET LSB OF L-REAL PART?
	JZ	FSTR2		;SKIP IF NOT
	PAGE
;HERE IF BIT 0,1,2 OF LSB OF LONG-REAL PART OF T-REAL ARE SET

	OR	FSTAT,20H	;FLAG ROUNDED RESULT
	MOV	BX,[SI+3]	;GET REST OF MANTISSA
	MOV	AX,[SI+5]
	MOV	CL,[SI+7]
	AND	CL,7FH		;STRIP IMPLIED ONE
	ADD	DX,8		;ADD IN ROUND FACTOR?
	ADC	BX,0
	ADC	AX,0
	ADC	CL,0
	JNS	FSTR3		;JUMP IF NO OVERFLOW

	AND	CL,7FH		;STRIP OVER FLOW
	INC	BP		;ADVANCE EXPONENT
	CMP	BP,0400H	;OVER 1024?
	JL	FSTR3		;SKIP IF NOT
	JMP SHORT FSTR5

;JUST STORE HIGH PART OF MANTISSA

FSTR2:	MOV	BX,[SI+3]	;GET PART OF MANTISSA
	MOV	AX,[SI+5]
	MOV	CL,[SI+7]
	AND	CL,7FH

;ALIGN MANTISSA WITH LONG REAL FORMAT

FSTR3:	SHR	CL,1
	RCR	AX,1
	RCR	BX,1
	RCR	DX,1

	SHR	CL,1
	RCR	AX,1
	RCR	BX,1
	RCR	DX,1

	SHR	CL,1
	RCR	AX,1
	RCR	BX,1
	RCR	DX,1
	PAGE

;STORE INTO MEMORY

	XCHG	AX,DX		;STORE MANTISSA
	STOSW
	MOV	AX,BX
	STOSW
	MOV	AX,DX
	STOSW
	MOV	AX,BP		;GET EXPONENT

	ADD	AX,03FFH	;BIAS EXPONENT
	SHL	AX,1		;ALIGN EXPONENT
	SHL	AX,1
	SHL	AX,1
	SHL	AX,1
	OR	AL,CL		;OR IN MSB MANTISS
	MOV	CL,[SI+10]	;GET SIGN BIT
	AND	CL,80H		;ISOLATE IT
	OR	AH,CL		;OR IT IN
	STOSW			;STORE IT
	RET

;HERE IF EXPONENT TOO LARGE

FSTR5:	SUB	DI,6

;HERE IF EXPONENT TOO LARGE

FSTR6:	OR	FSTAT,28H	;FLAG PRECISION+OVERFLOW
	MOV	BL,[SI+10]	;GET SIGN
	AND	BL,80H		;ISOLATE THE BIT

;HERE IF OVERFLOW

FSTR7:	MOV SI,OFFSET EMTCLR	;USE EMPTY CONSTANT
	MOVSW
	MOVSW
	MOVSW
	LODSW
	OR	AH,BL
	STOSW
	RET			;EXIT
	PAGE

;HERE IF EXPONENT TOO SMALL, UNDERFLOW

FSTR9:	OR	FSTAT,10H	;FLAG UNDER FLOW
	ADD	BP,03FFH
	NEG	BP
	MOV	CX,BP
	ADD	CX,4
	MOV	DH,[SI+10]
	AND	DH,80H
	MOV	DL,[SI+7]
	MOV	BX,[SI+5]
	MOV	BP,[SI+3]
	MOV	AX,[SI+1]

FSTR10:	SHR	DL,1
	RCR	BX,1
	RCR	BP,1
	RCR	AX,1
	LOOP	FSTR10
	STOSW
	MOV	AX,BP
	STOSW
	MOV	AX,BX
	STOSW
	MOV	AX,DX
	STOSW
	RET
