	PAGE

;AFTER THE LOADER RUNS, THE HARDWARE STACK WILL USE THE LOADER'S MEMORY

STACKLO	LABEL	WORD		;BOTTOM OF HARDWARE STACK

	PAGE

;	*** I2L INTERPRETER LOADER MODULE ***
;
;LOAD FORMAT IS NORMAL ASCII INTERPRETED AS FOLLOWS:
;  ; =	RELATIVE LOAD ADDRESS FOLLOWS (4 CHARS). THE PC IS SET
;	TO THIS VALUE PLUS THE BASE LOAD ADDRESS.
;  * =	RELATIVE ADDRESS FOLLOWS (4 CHARS). THIS ADDRESS IS TO
;	BE RELOCATED BY ADDING ITS MODULE LOAD ADDRESS TO IT.
;  ^ =	RELATIVE ADDRESS FOLLOWS (4 CHARS). THIS ADDRESS IS TO
;	HAVE THE CURRENT PC VALUE STORED INTO IT. (THIS ENABLES
;	FORWARD REFERENCES TO BE RESOLVED BY THE LOADER.)
;  % =  NO LONGER HANDLED DIRECTLY BY THE LOADER, THIS COMMAND
;	IS HANDLED BY XLINK. IT IS USED TO INDICATE THAT THE
;	FOLLOWING ASCII STRING IS A LABEL WHICH IS THE START OF
;	A 'PUBLIC' PROCEDURE. THE LABEL IS IGNORED HERE SO THAT
;	'PUBLIC' IS IGNORED UNLESS XLINK IS USED.
;  # =  NO LONGER HANDLED DIRECTLY BY THE LOADER, THIS COMMAND
;	IS HANDLED BY XLINK. IT IS USED TO INDICATE THAT THE
;	FOLLOWING ASCII STRING IS REFERENCE TO A LABEL.
;
; AFTER ANY OF THE ABOVE THERE MAY FOLLOW 2 CHARACTERS OF HEX FOR
;EACH LOADED BYTE FOR ANY NUMBER OF BYTES.
;NOTE THAT THE BASE LOAD ADDRESS AND THE MODULE LOAD ADDRESS ARE
;ARE EQUIVALENT EXCEPT WHEN LOADING SECONDARY MODULES.
;  $ =	END OF (.I2L) FILE
;
;THE BYTE ORDER OF ADDRESSES IN THE ".I2L" FILE IS HIGH, LOW; BUT
; IN THE LOADED I2L CODE THE ORDER IS ALWAYS LOW, HIGH.


PC	DW	0		;LOAD PROGRAM COUNTER
ABASE	DW	0		;ABSOLUTE RELOCATION BASE (#)
MBASE	DW	0		;MODULE RELOCATION BASE (@)
LNKPNT	DW	0		;LINK TABLE POINTER ('EPROC')

BYTSAV	DB	0		;TEMPORARY FOR "BYTE2" ROUTINE
PROSIZ	DW	0		;HOLDS PROGRAM SIZE
	PAGE

LOADER:	CALL	STROUT		;DISPLAY TITLE INFO
	DB	"I2L INTERPRETER/LOADER, I2.9"
	DB	CR,LF
	DB	"COPYRIGHT 2011 P. BOYLE, L. FISH"
	DB	CR,LF,0

	MOV	RERUNF,0	;CLEAR THE RERUN FLAG
	CALL	INTLOD		;INIT LOAD DEVICE
	JNC	LOD10		;SKIP IF FILE ON COMMAND LINE
	CALL	STROUT		;TELL USER
	DB	'REQUIRED PARAMETER MISSING'
	DB	CR,LF,0
	RET

LOD10:	CALL	STROUT		;DISPLAY TITLE INFO
	DB	"LOADING..."
	DB	CR,LF,0

	MOV	DI,OFFSET PSTART;POINT TO START OF PROGRAM AREA
	MOV	[DI],BYTE PTR 0	;STORE AN "EXIT" CODE AS 1st BYTE
	MOV	PROGLO,DI	;SET PROGLO
	INC	DI		;ADVANCE PC
	MOV	PC,DI		;SAVE IT
	MOV	ABASE,DI	;SET RELOCATION BASE
	MOV	MBASE,DI	;SET MODULE BASE
	MOV	LNKPNT,DI	;SET LINK POINT TO EXTERNAL TABLE
	INC	LNKPNT		; WHICH BEGINS AFTER JUMP TO MAIN
	CALL	GETBYT		;GET FIRST CHAR OF FILE
	JMP SHORT LODLP2
	PAGE

;BEGIN THE .I2L LOAD PROPER

LODLP:	CALL	INHEX		;GET A CHAR & CHECK FOR HEX
	JC	LODLP2		;IF NOT HEX TRY CONTROL
	CALL	BYTE2		;WAS HEX, FORM A BYTE
	CALL	STOPC		;STORE AT PC
	JMP	LODLP		;BACK FOR MORE


;SPECIAL CHARACTER DISPATCHER

LODLP2:	CMP	AL,';'
	JE	NEWADR
	CMP	AL,'^'
	JE	FIXUP
	CMP	AL,'*'
	JE	RELAD
	CMP	AL,'$'
	JE	ENDUP
	CMP	AL,EOF
	JE	ENDUP
	CMP	AL,'%'
	JE	EATLAB
	CMP	AL,CR		;IGNORE CR'S AND LF'S
	JE	LODLP
	CMP	AL,LF
	JE	LODLP
	JMP	FATAL		;ELSE FATAL ERROR--ILLEGAL CHAR
	PAGE

; (;) HANDLE NEW PC ADDRESS

NEWADR:	CALL	READR		;(;) FETCH NEW ADDRESS
	MOV	PC,AX		;SET NEW PC
	JMP	LODLP

; (*) HANDLE RELATIVE ADDRESS

RELAD:	CALL	READR		;(*) GET AND RELOCATE THE ADDRESS
	CALL	STOWRD		;AND STORE IT
	JMP	LODLP		;BACK FOR MORE


; (^) HANDLE FIXUP

FIXUP:	CALL	READR		;(^) GET ADRESS TO FIX
	CMP	AX,USRTOP	;TOO BIG?
	JAE	TOOBIG
	MOV	BX,AX		;USE AS INDEX
	MOV	DI,PC		;GET PC
	MOV	[BX],DI		;PUT PC THERE
	JMP	LODLP

; ($) HANDLE END OF I2L FILE

ENDUP:	CALL	OPNEXT		;(EOF)
	JC	ALLDON
	MOV	DI,PC		;GET PC
	MOV	MBASE,DI	;SET BASE OF NEW MODULE
	JMP	LODLP

; (%) IGNORE 'PUBLIC' LABELS (XLINK WAS NOT USED BUT IT MIGHT NOT BE NECESSARY)

EATLAB:	CALL	GETBYT
	CMP	AL,21H		;LABELS ARE TERMINATED WITH A CR LF
	JAE	EATLAB
	JMP	LODLP
	PAGE

;HERE IF ALL MODULES ARE LOADED

ALLDON:	MOV	DI,PC			;GET PC
	MOV	HEAPLO,DI		;SET START OF HEAP
	SUB	DI,OFFSET START		;PC-START=PROGRAM LENGTH
	MOV	PROSIZ,DI		;SET SAVE SIZE
	MOV	word ptr ENTVEC,OFFSET I2LENT	;SET ENTRY VECTOR
	CALL	STROUT
	DB	"SAVING .COM FILE TO DISK..."
	DB	CR,LF,0

	CALL	OPNSAV			;OPEN SAVE FILE
	CALL	SAVFIL			;SAVE THE FILE
	CALL	CLOI2L			;CLOSE INPUT FILE
	CALL	CLOSAV			;CLOSE SAVE FILE
	CALL	STROUT

	DB	'FILE SAVED; PROGRAM CREATED'
	DB	CR,LF,0

	JMP	LABORT

	CALL	KEYIN		;WAIT FOR USER TO HIT RETURN
	JMP	START		;START THE PROGRAM


;LOW LEVEL SUBROUTINES TO HANDLE THE LOADING PROCESS

READR:	CALL	RDADDR		;READ AN ADDRESS
	ADD	AX,MBASE	;RELOACTE IT
	RET

;ROUTINE TO STORE AX AS A WORD IN MEMORY

STOWRD:	MOV	DI,PC		;GET PC
	MOV	[DI],AX		;STORE INT
	ADD	PC,2		;ADVANCE PC
	JMP SHORT STOPC1	;ENTER COMMON CODE
	PAGE

;STORE BYTE IN AL AT THE PC

STOPC:	MOV	DI,PC		;GET PC
	MOV	[DI],AL		;STORE IT
	INC	DI		;INCREMENT PC
	MOV	PC,DI		;SAVE PC
STOPC1:	CMP	DI,USRTOP	;TOO BIG?
	JAE	TOOBIG
	RET


;ROUTINE TO HANDLE OUT OF MEMORY ERROR

TOOBIG:	CALL	STROUT
	DB	BEL,"OUT OF MEMORY"
	DB	CR,LF,0
	JMP SHORT LABORT


;READ IN A 16-BIT VALUE AND RETURN IT IN "ADRES" AND AX

ADRES	DW	0		;WORD TEMPORARY

RDADDR:	CALL	BYTEIN			;READ AN ADDRESS
	JC	FATAL			;ERROR IF NOT HEX
	MOV	BYTE PTR ADRES+1,AL
	CALL	BYTEIN
	JC	FATAL
	MOV	BYTE PTR ADRES,AL
	MOV	AX,ADRES
	RET

;HANDLE FATAL LOAD ERROR

FATAL:	CALL	STROUT		;SEND MESSAGE
	DB	BEL,'\ILLEGAL CHARACTER FOUND'
	DB	CR,LF,0
	JMP SHORT LABORT	;ABORT THE LOAD
	PAGE


;GET A BYTE REPRESENTED IN ASCII HEX,
; RETURN CARRY SET IF BAD CHARACTER,
; ELSE RETURN WITH BYTE IN ACC

BYTEIN:	CALL	INHEX		;GET NIBBLE
	JC	BYTEXT		;IF NOT HEX, EXIT

;SECOND ENTRY TO BYTEIN ALLOWS ONE
; CHAR LOOK AHEAD, OTHERWISE SAME.

BYTE2:	MOV	CL,4		;TIMES 16
	SAL	AL,CL
	MOV	BYTSAV,AL	;SAVE IT
	CALL	INHEX		;GET NIBBLE
	JC	FATAL
	OR	AL,BYTSAV	;COMBINE NIBBLES
BYTEXT:	RET



;GET A SINGLE HEX DIGIT FROM THE LOAD DEVICE.
; RETURN CARRY SET IF NOT A HEX DIGIT,
; RETURN WITH VALUE IN AL IF A HEX DIGIT.

INHEX:	CALL	GETBYT
	CALL	MAKBIN
	RET

;PROGRAM COMES HERE TO ABORT OR EXIT FROM THE LOADER

LABORT:	INT	20H

	PAGE

;*** ROUTINES TO HANDLE LOADING AND SAVING I2L FILES ***

;FILE PARAMETERS

SAVHND	DW	0		;OUTPUT FILE HANDLE

;READ A CHARACTER FROM THE DISK INPUT FILE

GETBYT	PROC	NEAR
	CALL	BUFDIN			;DO THE READ
	JNC	GETBT1			;SKIP IF NO ERROR
	JMP	IOERR			;HANDLE ERROR
GETBT1:	RET
GETBYT	ENDP


;SAVE LOADED FILE TO DISK

SAVFIL	PROC	NEAR
	MOV	AH,40H			;SET WRITE FUNCTION
	MOV	BX,SAVHND		;GET SAVE 'HANDLE'
	MOV	CX,PROSIZ		;SET WRITE SIZE
	MOV	DX,OFFSET START		;POINT TO START OF PROG
	CALL	DOSCAL			;DO THE WRITE
	JNC	SAVFL1			;SKIP IF NO ERROR
	JMP	IOERR			;HANDLE ERROR
SAVFL1:	CMP	AX,PROSIZ		;ALL OF PROGRAM SAVED?
	JE	SAVFL2			;SKIP IF OK
	CALL	STROUT			;PRINT ERROR MESSAGE
	DB	BEL,"DISK FULL"
	DB	CR,LF,0
	JMP	LABORT

SAVFL2:	RET
SAVFIL	ENDP
	PAGE

;SETUP FILE FOR LOADING AND SAVING

INTLOD:	CALL	SETFLN		;PARSE FILE NAMES INTO MEMORY
	JC	INTLD1		;SKIP IF NOT FILE
	CALL	OPNI2L		;OPEN THE I2L FILE
INTLD1:	RET
	PAGE

;SCAN COMMAND TAIL AND SETUP INPUT AND OUTPUT FILE NAMES
;CARRY CLEAR IF SUCESSFULL

INPFIL	DB	80 DUP(?)	;INPUT FILE NAME
OUTFIL	DB	80 DUP(?)	;OUTPUT FILE NAME

INEXT	DB	".I2L",0	;DEFAULT EXTENSION FOR INPUT
OUTEXT	DB	".COM",0	;EXTENSION FOR OUTPUT

SETFLN:	CALL	PARSE		;PARSE COMMAND TAIL
	CMP	NSTART,0	;BAD FILE NAME?
	JE	SETFN1		;SKIP IF BAD
	CALL	INNAME		;SETUP INPUT NAME
	CALL	OUTNAM		;SETUP OUTPUT NAME
	CLC			;FLAG SUCCESSFUL
	RET

SETFN1:	STC			;FLAG BAD FILE NAME
	RET

;SETUP INPUT FILE NAME STRING

INNAME:	MOV	SI,NSTART	;POINT TO START OF FILE NAME
	MOV DI,OFFSET INPFIL	;POINT TO INPUT NAME STRING
	MOV	CX,TAILEN	;GET THE NAME LENGTH
REP	MOVSB			;COPY THE STRING
	CMP	ESTART,0	;IS THERE AN EXTENSION?
	JNE	OUTNM2		;THEN JUST USE IT
	MOV	SI,OFFSET INEXT	;POINT TO DEFAULT EXTENSION
	JMP SHORT OUTNM1	;ENTE COMMON CODE

;SETUP OUTPUT FILE NAME STRING

OUTNAM:	MOV	SI,NSTART	;POINT TO START OF FILE NAME
	MOV DI,OFFSET OUTFIL	;POINT OUTPUT FILE NAME
	MOV	CX,ESTART	;CALCULATE NAME PART LENGTH
	SUB	CX,NSTART
	JNS	OUTNM3		;SKIP IF THERE IS AN EXTENSION
	MOV	CX,TAILEN	;IF NO EXTENSION, USE TAIL LENGTH

OUTNM3:
REP	MOVSB			;COPY NAME PART
	MOV SI,OFFSET OUTEXT	;POINT TO OUTPUT EXTENSION
OUTNM1:	MOV	CX,5		;GET THE STRING LENGTH
REP	MOVSB			;COPY EXTENSION
OUTNM2:	MOV BYTE PTR [DI],0	;ZERO LAST BYTE
	RET
	PAGE

TAIL	EQU	81H	;LOCATION OF TAIL IN THE PSP
TAILEN	DW	0	;LENGTH OF COMMAND TAIL

NSTART	DW	0	;START OF FILE NAME
ESTART	DW	0	;START OF FILE EXTENSION

;PARSE THE COMMAND LINE, SCANNING FOR FILE NAME AND EXTENSION
;NSTART WILL BE ZERO IF THERE'S NO FILE NAME 
;ESTART WILL BE ZERO IF THERE'S NO EXTENSION

PARSE:	CLD			;INCREMENT MODE
	MOV	DI,TAIL		;POINT TO COMMAND TAIL
	XOR	CH,CH		;ZERO HIGH BYTE
	MOV	CL,[DI]-1	;GET TAIL LENGTH
	JCXZ	NOFILE		;SKIP IF EMPTY TAIL

	MOV	AL,20H		;GET SPACE CHARACTER
REPE	SCASB			;SCAN FOR SPACE
	JE	NOFILE		;SKIP IF ALL SPACES
	MOV	TAILEN,CX	;SAVE LENGTH
	INC	TAILEN		;ADJUST COUNT
	MOV	NSTART,DI	;SAVE POINTER
	DEC	NSTART		;POINT AT START OF NAME

	MOV	AL,'.'		;GET DOT CHARACTER
REPNE	SCASB			;SCAN FOR DOT
	JCXZ	NOEXT		;SKIP IF NO EXTENSION
	MOV	ESTART,DI	;SAVE POINTER
	DEC	ESTART		;POINT TO START OF EXTENSION
	RET

NOEXT:	MOV	ESTART,0	;FLAG NO EXTENSION
	RET

NOFILE:	MOV	NSTART,0	;FLAG NO FILE NAME
	RET
	PAGE

;OPEN NEXT MODULE FILE

OPNEXT:	STC
	RET
	PAGE

;OPEN I2L INPUT FILE

OPNI2L	PROC	NEAR
	MOV	AH,3DH			;GET FUNCTION NUMBER
	MOV	AL,0H			;SET READ MODE
	MOV	DX,OFFSET INPFIL	;POINT TO FILE NAME
	CALL	DOSCAL			;CALL DOS ROUTINE
	JNC	OPNIL1			;SKIP NO ERROR
	CALL	STROUT			;PRINT ERROR MESSAGE
	DB	BEL,"FILE NOT FOUND"
	DB	CR,LF,0
	JMP	LABORT			;ABORT

OPNIL1:	MOV	INHAND,AX		;SAVE FILE 'HANDLE'
	MOV	INBFLG,"I"		;USE BIG BUFFERS
	CALL	RESDIB			;RESET BUFFER POINTER
	RET
OPNI2L	ENDP


;OPEN SAVE FILE

OPNSAV	PROC	NEAR
	MOV	AH,3CH			;GET FUNCTION NUMBER
	MOV	CX,0			;SET NORMAL MODE
	MOV	DX,OFFSET OUTFIL	;SET FILE NAME
	CALL	DOSCAL			;CALL DOS ROUTINE
	JNC	OPNSV1			;SKIP NO ERROR
	JMP SHORT IOERR			;HANDLE I/O ERROR
OPNSV1:	MOV	SAVHND,AX		;SAVE FILE 'HANDLE'
	RET
OPNSAV	ENDP



;CLOSE I2L INPUT FILE

CLOI2L	PROC	NEAR
	MOV	BX,INHAND		;GET HANDLE
	JMP	CLFDSK			;ENTER COMMON CODE
CLOI2L	ENDP


;CLOSE SAVE FILE

CLOSAV	PROC	NEAR
	MOV	BX,SAVHND		;GET HANDLE
	JMP	CLFDSK			;ENTER COMMON CODE
CLOSAV	ENDP
	PAGE

;HANDLE I/O ERRORS, FUNCTION NUMBER IN DOSFUN, ERROR IN AL

IOERR	PROC	NEAR
	PUSH	AX		;SAVE ERROR CODE
	CALL	STROUT		;DISPLAY ERROR MESSAGE
	DB	'DOS  ERROR ',0

	MOV	AL,DOSFUN	;DISPLAY DOS FUNCTION
	CALL	HEXOUT
	MOV	AL,' '
	CALL	TVOUT
	POP	AX		;DISPLAY ERROR NUMBER
	CALL	HEXOUT
	CALL	STROUT
	DB	0DH,0AH,0
	JMP	LABORT
IOERR	ENDP
	EVEN
STACKHI	LABEL	WORD		;TOP OF HARDWARE STACK IS HERE
PSTART	LABEL	BYTE		;START OF PROGRAM STORAGE
