\XPLI.XPL	29-JAN-2010
\XPL0 COMPILER
\COPYRIGHT 1984-2010 P.J.R. BOYLE
\FLOATING POINT VERSION BY LOREN BLANEY
\IBM PC VERSION BY LARRY FISH
\
\This program is free software; you can redistribute it and/or modify it under
\ the terms of the GNU General Public License version 2 as published by the
\ Free Software Foundation.
\This program is distributed in the hope that it will be useful, but WITHOUT
\ ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
\ FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
\ details.
\You should have received a copy of the GNU General Public License along with
\ this program (in the file LICENSE.TXT); if not, write to the Free Software
\ Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\
\You can reach the authors at: loren.blaney@idcomm.com
\
\REVISIONS:
\V2.0 AUG-14-93
\V2.1 FEB-16-94, INDENT INCLUDED FILES ACCORDING TO NESTED LEVEL.
\V2.2 MAR-05-95, 16 SIG CHARS IN A NAME; '_' IN FRONT OF PUBLIC & EXTERNAL
\ NAMES; COMMENTS IN PARENTHESIS ALLOWED AFTER ALL EXTERNAL PROCEDURE
\ DECLARATIONS; 'ADDR' OPERATOR HANDLES ARRAYS; 'EXIT' STATEMENT CAN RETURN
\ A VALUE; ETC.
\V2.2.2 MAR-22-95, DECLAIRED ARRAYS, MULTI-DIMENSIONAL CHAR ARRAYS.
\V2.3 JUL-01-95, RELEASED.
\V2.3.4 MAY-04-99, Distribute under GNU General Public License.
\V2.4 24-FEB-2001, Fixed "~" in constant calculations.
\V2.4.3 23-APR-2002, Fix bug caused by declaring arrays totalling more than 32K.
\V2.4.4 28-MAY-2002, Link with NATIVE, which fixed Ctrl-C vector.
\V2.5 4-OCT-2006, Improved hash codes for reserved words (like for XPLX). Fix
\ bug involving optimized procedures and dimensioned array declarations.
\V2.6 17-MAR-2008, Added binary notation (e.g: $1e = %11110); underlines are
\ allowed in numbers (123_456.78); variables can be declared after procedures.
\ New GETCH routine handles missing EOF when a program ends with a comment.
\V2.7 29-JAN-2010, Allow 'to' to replace ',' in 'for' loops; implement 'downto'.
\ Added arithmetic shift right operator "->>". Minor fixes to warnings (/w).
\ Added 'port' command.
\
\CONTENTS:
\ MAIN--DISPLAY TITLE AND INITIALIZE
\	ERROR--DISPLAY ERROR MESSAGE AND OPTIONALLY CONTINUE
\	GETCH--GET A CHARACTER FROM THE SOURCE DEVICE
\	RATOM--READ AN ATOM FROM SOURCE DEVICE
\	SKIPIT--SKIP STATEMENT FOR ERRORS
\	HEXB--OUTPUT A HEX BYTE (IN ASCII) TO BINARY DEVICE
\	GEN--OUTPUT I2L CODE TO BINARY DEVICE
\	FIX--CHANGE A SPECIFIC I2L LOCATION TO THE CURRENT PC
\	LOOKUP--LOOK UP AN IDENTIFIER NAME IN THE SYMBOL TABLE
\	INSERT--INSERT AN IDENTIFIER INTO THE SYMBOL TABLE
\	GETCON--GET A CONSTANT (EITHER VALUE OR NAME)
\	CONEXPRESS--EVALUATES A CONSTANT EXPRESSION
\	PROCAL--PROCEDURE CALLS
\	BOOLEXP--GENERATE I2L CODE FOR A BOOLEAN EXPRESSION
\		FACTOR--GENERATE CODE FOR A FACTOR
\			STRCON--TEXT STRING CONSTANT
\			ARRAYCON--CONSTANT ARRAY
\			SPECFAC--SPECIAL FACTORS (addr,STRING)
\			IDFAC--IDENTIFIER FACTORS
\				FUNCTION--PROCEDURE AS A FACTOR
\		SHIFTEXP: GENERATE CODE FOR A SHIFT (E.G. A<<B)
\		TERM--GENERATE CODE FOR A TERM (E.G. A*B)
\			TERMX--
\		ALGEXP--ALGEBRAIC EXPRESSION (E.G. A+B)
\			ALGX--
\		LOGEXP--LOGICAL EXPRESSION (E.G. A=B)
\			LOGX--
\		BOOLTERM--BOOLEAN TERM (E.G. A&B)
\	SSTATEMENT--(FOR 'QUIT'S IN 'CASE' STATEMENTS)
\		STATEMENT--PARSE AND GENERATE CODE
\			ASSIGN--ASSIGNMENT STATEMENTS
\				ASSX--
\			CASER--CASE STATEMENTS
\				CASER2--
\	PROCEDURE--PARSE AND GENERATE CODE
\		CODDEC--'CODE' DECLARATION
\		CONDEC--'DEFINE' DECLARATION
\		VARDEC--'INT','REAL', AND 'ADDR' DECLARATIONS
\		EXTDEC--'EXTERNAL' PROCEDURE DECLARATION
\		FPRDEC--FORWARD PROCEDURE DECLARATIONS
\		PROCDEC--'PROCEDURE' DECLARATIONS

code	ABS=0		REM=2		RESERVE=3	SWAP=4
	CHIN=7		CHOUT=8		CRLF=9		INTIN=10
	INTOUT=11	TEXT=12		OPENI=13	OPENO=14
	CLOSE=15	HEXOUT=27
	TRAP=17,	GETERR=22,	FSET=24,	FOPEN=29,
	FCLOSE=32,	GETREG=35,	BLIT=36;
code real		FLOAT=49,	RLRES=46;

def	TV=0, KB=0, NULDEV=7, EOF=$1A, BEL=$07, EOL=$0A; \I/O STUFF
def	SYMAX=1600,	\SIZE OF THE SYMBOL TABLE
	EMTPTR=-1,	\EMPTY SYMBOL POINTER
	BOXNUM=256,	\NUMBER OF BOXES
	HASHMSK=$FF,	\HASH MASK

	RLMAX=160,	\SIZE OF REAL-CONSTANT SYMBOL TABLE
	
	RLSIZE=8,	\NO. OF BYTES IN A REAL NUMBER

	SIGCHAR=16,	\NO. OF SIGNIFICANT CHARS IN AN IDENT
	QUITMAX=160;	\MAXIMUM NO. OF 'QUIT'S IN A 'LOOP'

int	DEBFLG		\FLAGS DEBUG MODE IS ON
	WARNFLAG	\FLAGS WARNING MESSAGES ARE ON
	ERRCNT		\ERROR COUNTER
	DEVICE		\DEFAULT DEVICE ARRAY.  WARNING!  NOT ROMMABLE
	LSTDEV		\LISTING OUTPUT DEVICE NUMBER
	SRCDEV		\SOURCE INPUT DEVICE NUMBER
	BINDEV		\BINARY OUTPUT DEVICE NUMBER
	CONDITIONAL	\FLAG: CONDITIONAL COMPILE
	CHAR		\CURRENT CHARACTER.  MOST OF THE TIME IT
			\ CONTAINS THE TERMINATOR OF THE CURRENT ATOM
	ATOM		\PRESENT ATOM DESCRIPTOR
			\CONTAINS RESERVED WORD HASH OR THE ASCII FOR
			\ A SPECIAL CHARACTER; 0 IF THE ATOM IS A
			\ CONSTANT OR AN IDENTIFIER
	ATYPE;		\PRESENT ATOM TYPE DESCRIPTOR
def	\ATYPE\ SPECIAL,IDENTIFIER,INTCON,REALCON;
char	IDENT;		\ARRAY--CURRENT IDENTIFIER NAME
int	HASH		\CURRENT IDENTIFIER HASH CODE
	IATOM;		\VALUE OF CURRENT INTEGER CONSTANT
real	RLATOM;		\REAL CONSTANT FROM PROC "RATOM"

int	IDTYPE;		\PRESENT IDENTIFIER TYPE DESCRIPTOR
def	UNDEF=0,	\UNDEFINED ID (NO. ORDER IS CRITICAL)
	ADDRVAR=1,	\ADDRESS VARIABLE ID (TYPE = INTEGER)
	INVAR=3,	\INTEGER VARIABLE ID (ODD NOS.=INTEGER)
	RLVAR=4,	\REAL VARIABLE ID
	INCON=5,	\INTEGER CONSTANT ID
	RLCON=6,	\REAL CONSTANT ID
	INPROC=7,	\INTEGER PROCEDURE ID
	RLPROC=8,	\REAL PROCEDURE ID
	INFPROC=9,	\INTEGER FORWARD PROCEDURE ID
	RLFPROC=10,	\REAL FORWARD PROCEDURE ID
	INOPT=11,	\INTEGER OPTIMIZED PROCEDURE ID
	RLOPT=12,	\REAL OPTIMIZED PROCEDURE ID
	INEPRO=13,	\INTEGER EXTERNAL I2L PROCEDURE ID
	RLEPRO=14,	\REAL EXTERNAL I2L PROCEDURE ID
	ININT=15,	\INTEGER INTRINSIC ID
	RLINT=16,	\REAL INTRINSIC ID
	INEXT=17,	\INTEGER EXTERNAL ASSEMBLY PROCEDURE ID
	RLEXT=18,	\REAL EXTERNAL ASSEMBLY PROCEDURE ID
	INSEG=19,	\INTEGER SEGMENT VARIABLE ID
	RLSEG=20,	\REAL SEGMENT VARIABLE ID
	ADSEG=21,	\ADDRESS VARIABLE ID
	SHSEG=22;	\SHORT SEGMENT VARIABLE ID

int	LEV		\STATIC LEVEL OF CURRENT IDENTIFIER
	VAL		\VALUE OR ADDRESS OF CURRENT IDENTIFIER
	SYMNUM		\POSITION IN "SYMTBL" OF CURRENT IDENTIFER
	FACTYP;		\FACTOR (OR OPERAND) TYPE (REAL OR INTEGER)
def	\FACTYP\ REAL,INTEGER;
int	FIXES		\ARRAY--'QUIT' FIXES STILL OUTSTANDING
	PC		\THE I2L PROGRAM COUNTER
	OLDPC		\PC VARIABLE USED BY PROCEDURE "GEN"
	LEVEL		\STATIC LEVEL OF CURRENT PROCEDURE
	NOSYM		\CURRENT NUMBER OF SYMBOLS IN SYMBOL TABLE
	FIXCNT		\COUNT OF THE NUMBER OF OUTSTANDING 'QUIT'S
	STKLOD		\NO. OF INTEGERS LEFT ON STACK BY 'FOR' ! 'CASE'
	OPTPROC		\BOOLEAN--GENERATE AN OPTIMIZED PROCEDURE CALL
	NORLSY		\CURRENT NUMBER OF REAL CONSTANTS IN TABLE
	II;		\SCRATCH
char	HEXDIGIT; 	\ARRAY OF HEX DIGITS (0 - F)
	\ -- SYMBOL TABLE ARRAYS --
char	SYMBOL		\IDENTIFIER NAME (IDENT)
	SYMTYP		\TYPE DESCRIPTORS (IDTYPE)
	SYMLEV		\LEVEL (LEV)
	SYMTAG;		\TAG FOR WARNINGS (0=UNUSED, 1=USED)
int	SYMPNT,		\LIST LINKAGE POINTERS
	SYMVAL;		\VALUE OR ADDRESS (VAL)

int	BOX;		\HASH BOXES (SYMBOL LIST HEADERS)
real	RLTBL;		\REAL CONSTANT TABLE

\VARIABLES FOR DOS DISKIO
int	INHAND,		\INPUT HANDLE
	OUTHAND,	\OUTPUT HANDLE
	HANPTR,		\POINTER TO OLD INCLUDE HANDLES
	OLDHAN; 	\ARRAY OF OLD INCLUDE HANDLES

def	HANMAX=8;	\MAXIMUM NUMBER OF INCLUDE HANDLES (NESTING DEPTH)

\RESERVED WORD HASHES:
def	ADRSYM=$88E4,	BEGSYM=$84C7,	CASEYM=$8053,	CODSYM=$8184,
	DEFSYM=$9CC6,	DOSYM=$0CEF,	ELSEYM=$99F3,	ENDSYM=$99A4,
	EXITYM=$9B69,	EXTNYM=$9B74,	FALSYM=$944C,	FFUNYM=$94B5,
	FORSYM=$9592,	FPRSYM=$9672,	FUNSYM=$96CE,	GESYM=$0C85,
	GETSYM=$90D4,	IFSYM=$0D46,	INTSYM=$A9B4,	LESYM=$0DE5,
	LOOPYM=$BD8F,	NOTSYM=$B594,	OFSYM=$0D86,	PROCYM=$CE2F,
	QUITYM=$CAC9,	REALYM=$C4C1,	REPSYM=$C4D0,	RETSYM=$C4D4,
	THENYM=$DD65,	TRUSYM=$DE35,	UNTSYM=$D9B4,	WHILYM=$D169,
	CHARYM=$8161,	EPRSYM=$9A72,	EFUNYM=$98B5,	PUBSYM=$CEC2,
	OTHSYM=$B2E8,	INCSYM=$A9A3,	LSLSYM=$BE0C,	LSRSYM=$BE92,
	SEGSYM=$C0C7,	SHTSYM=$C16F,	CONSYM=$818E,	\ABSSYM=$8833,\
	\REMSYM=$C4CD,	SWAPYM=$C281,	EXTSYM=$9B74,\	PORTYM=$CD92,
	STRSYM=$C2F2,	ASMSYM=$8A0D,	TOSYM=$0EEF,	DOWNYM=$9D97,
	ASRSYM=$8A12;



proc	ERROR; int N;	\SEND ERROR MESSAGE TO THE TV
int	ERR,CH,I;
char	STRING;
def	MAXERR=74;	\MAXIMUM ERROR NUMBER
begin
ERR:=RESERVE((MAXERR+1)*2);
for I:=0,MAXERR do ERR(I):="? ";	\UNUSED ERROR NOS. ="?"

ERR(1):="TOO MANY VARIABLES ";
ERR(2):="TOO MANY REAL CONSTANT NAMES ";
ERR(3):="TOO MANY NAMES ";
ERR(4):="TOO MANY 'QUITS' ";
ERR(5):="TOO MANY STATIC LEVELS ";
ERR(6):="NUMBER OUT OF RANGE ";
ERR(7):=ERR(6);		\FOR INTRINSIC DECLARATIONS
ERR(10):="UNDECLARED NAME ";
ERR(11):="NAME ALREADY DECLARED ";
ERR(20):="ILLEGAL START OF A STATEMENT ";	\IN "ASSIGN"
ERR(21):="^":=^"* ";
ERR(22):="'THEN'* ";
ERR(23):="'DO'* ";
ERR(24):="'TO' OR 'DOWNTO'* ";
ERR(26):="ILLEGAL FACTOR ";	\UNRECOGNIZABLE SPECIAL FACTOR
ERR(27):="STATEMENT STARTING WITH A CONSTANT "; \IN "ASSIGN"
ERR(28):="'UNTIL'* ";
ERR(29):="'OTHER'* ";
ERR(30):="'ELSE'* ";
ERR(31):="DIGIT* ";
ERR(33):="INTEGER VARIABLE* ";	\IN A 'FOR' STATEMENT
ERR(38):="^">^"* ";		\ASR ->>
ERR(39):="^"(^"* ";
ERR(40):="^"=^"* ";
ERR(41):="^";^"* ";
ERR(42):="CONSTANT* ";		\IN "GETCON"
ERR(43):="VARIABLE* ";		\FOR AN 'ADDR' OPERATOR
ERR(44):="^")^"* ";
ERR(45):="NAME* ";
ERR(46):="MIXED MODE ";
ERR(47):="INTEGER* ";
ERR(48):="'OF'* ";
ERR(49):="^":^"* ";
ERR(50):="^"]^"* ";
ERR(51):="NO ARGUMENTS DECLARED ";
ERR(52):="STATEMENT STARTING WITH 'ELSE' ";
ERR(53):="STATEMENT STARTING WITH 'OTHER' ";
ERR(60):="'QUIT' NOT IN A 'LOOP' ";
ERR(61):="EOF* ";
ERR(62):="EOF INSIDE A BLOCK ";
ERR(63):="EOF INSIDE A STRING ";
ERR(65):="'FPROC' & ITS 'PROC' NOT AT SAME LEVEL ";
ERR(66):="'FPROC' REFERENCE NOT FOUND ";
ERR(67):="'PROC' OR 'FUNC'* ";
ERR(68):="'EPROC'S AND 'PUBLIC'S MUST BE GLOBAL ";
ERR(69):="'INCLUDE'S NESTED TOO DEEP ";
ERR(70):="BAD FILE SPEC SYNTAX ";
ERR(71):="FILE NOT FOUND ";
ERR(72):="'INT', 'REAL', 'CHAR' or 'ADDR'* ";
ERR(73):="DIVIDE BY ZERO IN A CONSTANT EXPRESSION ";
ERR(74):="MATH ERROR IN A CONSTANT EXPRESSION ";

if LSTDEV=8 then
	begin
	OPENI(8);
	loop	begin
		CH:=CHIN(8);
		\INCLUDES CAUSE NESTED EOFs
		if CH=EOF then
			begin
			I:=I+1;
			if I>=HANMAX then quit;
			end
		else [I:=0; CHOUT(0,CH)];
		end;
	CRLF(0);
	end;


CHOUT(TV,BEL); CHOUT(TV,$0A);	\(DAMN LINEFEEDS!)
TEXT(TV,"
***** ERROR NO. "); INTOUT(TV,N); TEXT(TV," *****
");
STRING:=ERR(N);
I:=0;
loop	[CH:=STRING(I);		\OUTPUT MESSAGE
	if CH>=$80 then quit;
	if CH=^* then TEXT(TV," EXPECTED BUT NOT FOUND")
		else CHOUT(TV,CH);
	I:=I+1];
CRLF(TV);
TEXT(TV,"ATTEMPT TO CONTINUE (Y/N)? ");
OPENI(KB);
case CHIN(KB) of ^N,^n :[CLOSE(LSTDEV); exit 1] other;
BINDEV:=NULDEV;		\THERE SHALL BE NO OUTPUT FILE
ERRCNT:=ERRCNT+1;
end;	\ERROR



proc	WARNING; int N;	\SEND WARNING MESSAGE TO THE TV
int	WARN,CH,I;
char	STRING;
def	MAXWARN=9;	\MAXIMUM WARNING NUMBER
begin
if ~WARNFLAG then return;
WARN:=RESERVE((MAXWARN+1)*2);
for I:=0,MAXWARN do WARN(I):="? ";	\UNUSED WARNING NOS. ="?"

WARN(1):="LOCAL NAME SAME AS MORE-GLOBAL NAME ";
WARN(2):="ROUNDING ERRORS MAKE EQUALITY UNLIKELY ";
WARN(3):="CONTROL CHARACTER ";
WARN(4):="USE 'OTHER' INSTEAD OF 'ELSE' ";
WARN(5):="COMMAS MISSING IN 'DEFINE' ";
WARN(6):="'DEFINE' MIXES ENUMERATIONS WITH '=' ";
WARN(7):="DOUBLED UNARY OPERATOR: ++, --, OR ~~ ";
WARN(8):="DEFINED BUT NOT USED ";
WARN(9):="'ADDR' OF 'FOR' LOOP CONTROL VARIABLE ";

if LSTDEV=8 then
	begin
	OPENI(8);
	loop	begin
		CH:=CHIN(8);		\INCLUDES CAUSE NESTED EOFs
		if CH=EOF then
			begin
			I:=I+1;
			if I>=HANMAX then quit;
			end
		else [I:=0; CHOUT(0,CH)];
		end;
	CRLF(0);
	end;

\CHOUT(TV,BEL);\ CHOUT(TV,$0A);	\(DAMN LINEFEEDS!)
TEXT(TV,"
***** WARNING NO. "); INTOUT(TV,N); TEXT(TV," *****
");
STRING:=WARN(N);
I:=0;
loop	[CH:=STRING(I);		\OUTPUT MESSAGE
	if CH>=$80 then quit;
	if CH=^* then TEXT(TV," EXPECTED BUT NOT FOUND")
		else CHOUT(TV,CH);
	I:=I+1];
CRLF(TV);
TEXT(TV,"CONTINUE (Y/N)? ");
OPENI(KB);
case CHIN(KB) of ^N,^n: [CLOSE(LSTDEV); exit 1] other;
end;	\WARNING



proc	CHKUSE(LIM);	\Display unused identifier (symbol) names
int	LIM;
int	F, I, K, N, C;
begin
if not WARNFLAG then return;
F:= false;
N:= NOSYM;
C:= 0;
while N>LIM do
	begin
	N:= N-1;
	if SYMTAG(N)=0 then	\UNUSED
		begin
		if ~F then
			begin
			CRLF(TV);
			for I:= 0, 78 do CHOUT(TV, ^*);
			CRLF(TV);
			F:= true;
			end;
		K:= N;
		for I:= 0, SIGCHAR-1 do
			[CHOUT(TV, SYMBOL(K));  K:= K+SYMAX];
		TEXT(TV, "  ");
		C:= C+1;
		if (C&3)=3 then CRLF(TV);
		end;
	end;
if F then
	begin
	if (C&3)#3 then CRLF(TV);
	for I:= 0, 78 do CHOUT(TV, ^*);
	CRLF(TV);
	WARNING(8);
	end;
end;	\CHKUSE



proc	GETCH;	\GET A CHARACTER FROM THE SOURCE DEVICE
\ FILTERS OUT COMMENTS
\(THIS PROCEDURE IS OPTIMIZED FOR SPEED.)
begin
CHAR:=CHIN(SRCDEV); CHOUT(LSTDEV,CHAR);
while CHAR=^\ do			\FILTER OUT COMMENTS
	begin
	loop	[CHAR:=CHIN(SRCDEV); CHOUT(LSTDEV,CHAR);
		case CHAR of
		  $0D:	return;		\CR
		  ^\:	[CHAR:= ^ ; return];
		  EOF:	return
		other	[]];
	end;
end;	\GETCH



proc	GETCH_;	\GET A NON-UNDERLINE CHARACTER FROM THE SOURCE DEVICE
repeat GETCH until CHAR#^_;

\-------------- ROUTINES TO HANDLE INCLUDES ---------------

procedure FALLBACK;
\TERMINATE AN INCLUDE AND FALL BACK TO PREVIOUS HANDLE
begin
HANPTR:=HANPTR-1;
FCLOSE(INHAND);
INHAND:=OLDHAN(HANPTR);
\ONLY THE MAIN FILE GETS A BIG BUFFERS
FSET(INHAND,if HANPTR=0 then ^I else ^i);
end;


procedure INCLUDE;	\SET UP AN INCLUDE FILE
char NAME; def NAMMAX=80;
integer NEWHAND, I;

	procedure GETC;
	\RETURN A CHARACTER WITH NO FILTERING
	[CHAR:=CHIN(SRCDEV); CHOUT(LSTDEV,CHAR)];


	procedure GETNAME;
	\READ A FILENAME
	integer EXTFLG, I,K;
	char DEFEXT;
	begin
	DEFEXT:=".XPL";
	EXTFLG:=false;

	\EAT LEADING SPACES AND CONTROL CHARS
	while CHAR<=$20 do [if CHAR=EOF then ERROR(61); GETC];

	\COPY FILE NAME INTO 'NAME'
	K:=0;
	loop	begin
		case CHAR of
		  ^.:	EXTFLG:=true;
		  EOL:	return false;
		  ^;:	quit
		other;

		NAME(K):=CHAR;
		K:=K+1;
		if K>=NAMMAX  then return false;
		GETC;
		end;

	\DEAL WITH EMPTY FILENAME
	if K=0 then return false;

	\DEAL WITH DEFAULT EXTENSIONS
	if EXTFLG then NAME(K-1):=NAME(K-1) ! $80
	else
		begin
		if (K+4)>=NAMMAX then return false;
		for I:=0,3 do NAME(K+I):=DEFEXT(I);
		end;
	return true;
	end;


begin	\INCLUDE
NAME:=RESERVE(NAMMAX);
if HANPTR>=HANMAX then
	[ERROR(69); while CHAR#^; & CHAR#EOF do GETC; return];
if not GETNAME then
	[ERROR(70); while CHAR#^; & CHAR#EOF do GETC; return];


\OPEN FILE
TRAP($FFFB);
NEWHAND:=FOPEN(NAME,0);
TRAP($FFFF);
if GETERR=3 then [ERROR(71); return];

\SAVE OLD FILE HANDLE ON STACK
OLDHAN(HANPTR):=INHAND;
HANPTR:=HANPTR+1;
INHAND:=NEWHAND;

\INCLUDE FILES ALWAYS USE SMALL BUFFERS
FSET(INHAND,^i);

TEXT(0,"INCLUDING: ");
for I:=2,HANPTR do TEXT(0,"   ");
TEXT(0,NAME);CRLF(0);
end;	\INCLUDE

\----------------------------------------------------------------------

fproc	CONEXPRESS;


proc	RATOM;		\READ AN ATOM
\OUTPUTS:  ATOM, ATYPE, IDENT, HASH, IATOM, CHAR, RLATOM.
\ (THIS PROCEDURE IS OPTIMIZED FOR SPEED.)
int	LEN,NEG,EXP,I,INTOVF;
real	FRACT,DENOM;

	proc	RFRACT;	\READ THE FRACTIONAL PART OF A REAL NO.
	begin
	ATYPE:=REALCON; ATOM:=0;
	GETCH_;
	FRACT:=FLOAT(0); DENOM:=FLOAT(10);	\(10.0 IS NOT SO PORTABLE)
	while CHAR>=^0 & CHAR<=^9 do
		[FRACT:=FRACT +FLOAT(CHAR-^0) /DENOM;
		DENOM:=DENOM*FLOAT(10);
		GETCH_];
	RLATOM:=RLATOM +FRACT;
	end;	\RFRACT


	proc	REXP;	\READ AN EXPONENT IF ANY
	if CHAR=^E ! CHAR=^e then
		begin
		ATYPE:=REALCON;
		GETCH_;
		if CHAR=^- then [NEG:=true; GETCH_]
			else NEG:=false;
		if CHAR=^+ then GETCH_;
		EXP:=0;
		if CHAR<^0 ! CHAR>^9 then ERROR(31);
		while CHAR>=^0 & CHAR<=^9 do
			[EXP:=EXP *10 +CHAR-^0; GETCH_];
		if NEG then EXP:= -EXP;
		while EXP>0 do
			[RLATOM:=RLATOM *FLOAT(10); EXP:=EXP-1];
		while EXP<0 do
			[RLATOM:=RLATOM /FLOAT(10); EXP:=EXP+1];
		end;	\REXP

begin	\RATOM
while CHAR<=$20\SPACE\ do
	begin	\SKIP SPACES, TABS, RETURNS, LF'S, & FF'S, ETC.
		\DON'T GO PAST EOF
	case CHAR of
	 EOF: if HANPTR>0 then FALLBACK else \IF HANPTR=0 THEN IT'S A HARD EOF
		[ATYPE:=SPECIAL; ATOM:=EOF; return];
	 EOL: if DEBFLG then [TEXT(LSTDEV,"<$"); HEXOUT(LSTDEV,PC);
				TEXT(LSTDEV,"> - ")]
	other;
	GETCH;
	end;
if CHAR>=^a then if CHAR<=^z then			\RESERVED WORD
	[ATYPE:= SPECIAL;
	ATOM:= CHAR; GETCH;
	ATOM:= ATOM<<5|CHAR; GETCH;
	if CHAR>=^a & CHAR<=^z then [ATOM:= ATOM<<5|CHAR; GETCH];
	while CHAR>=^a & CHAR<=^z do GETCH;
	case ATOM of
	  TRUSYM: [ATYPE:=INTCON; ATOM:=0; IATOM:=true];
	  FALSYM: [ATYPE:=INTCON; ATOM:=0; IATOM:=false];
	  CONSYM: begin
		  RATOM;
		  CONEXPRESS;
		  if FACTYP=INTEGER then CONDITIONAL:= IATOM else ERROR(47);
		  while ATOM=^; do RATOM;		\EAT SEMI, IF ANY
		  loop	begin				\EAT ATOMS UNTIL COND=TRUE
			if CONDITIONAL \#0\ then quit;
			if ATYPE=SPECIAL then
			  if ATOM=EOF then quit
			  else if ATOM=^" then	\Ignore 'con' in strings
			    begin
			    loop begin
				 CHAR:=CHIN(SRCDEV); CHOUT(LSTDEV,CHAR);
				 if CHAR=EOF then [ERROR(63); exit 1];
				 if CHAR=^^ then
					[CHAR:=CHIN(SRCDEV); CHOUT(LSTDEV,CHAR)]
				 else	if CHAR=^" then quit;
				 end;
			    GETCH;
			    end;
			RATOM;
			end;
		  end;
	  INCSYM: [INCLUDE; GETCH; RATOM]
	other;
	return];
if CHAR>=^A then if CHAR<=^Z ! CHAR=^_ then		\IDENTIFIER
	begin
	ATYPE:=IDENTIFIER; ATOM:=0;
	IDENT(0):=CHAR; HASH:=CHAR; GETCH;
	LEN:=1;
	loop	begin
		if CHAR>=^a & CHAR<=^z then CHAR:= CHAR & $DF;	\UPPERCASE
		case of
		CHAR>=^A & CHAR<=^Z,  CHAR>=^0 & CHAR<=^9,  CHAR=^_ :
			begin
			if LEN <SIGCHAR then
				[IDENT(LEN):=CHAR;
				HASH:=HASH+CHAR;
				LEN:=LEN+1];
			GETCH;
			end
		other quit;
		end;
	for LEN:=LEN,SIGCHAR-1 do
		[IDENT(LEN):=^ ; HASH:=HASH+^ ];
	HASH:=HASH & HASHMSK;
	return;
	end;
if CHAR>=^0 then if CHAR<=^9 then			\UNSIGNED INTEGER
	begin
	ATYPE:=INTCON;		\ASSUME INTEGER UNTIL SHOWN OTHERWISE
	ATOM:=0;
	INTOVF:=false;
	IATOM:=CHAR-^0;
	GETCH_;
	loop	begin
		I:=IATOM;
		if CHAR<^0 ! CHAR>^9 then quit;
		I:=IATOM*10+CHAR-^0;
		if IATOM>3276 ! IATOM=3276 & CHAR>^7 then	\"I" OVERFLOWED
			[INTOVF:=true; quit];			\OK IF IT'S REAL
		IATOM:=I;
		GETCH_;
		end;
	RLATOM:=FLOAT(IATOM);
	IATOM:=I;	\GET POSSIBLE LEGAL VALUE OF 32768 (AS -32768)
	while CHAR>=^0 & CHAR<=^9 do	\MORE DIGITS MUST BE REAL
		[RLATOM:=RLATOM*FLOAT(10) + FLOAT(CHAR-^0);
		GETCH_];
	if CHAR=^. then RFRACT;				\UNSIGNED REAL
	REXP;
	if ATYPE=INTCON & INTOVF & IATOM#$8000 then
		if CONDITIONAL then ERROR(6);
	return;
	end;
case CHAR of
^.:	[RLATOM:=FLOAT(0);				\UNSIGNED REAL
	RFRACT;
	REXP;
	return];
^$:	begin						\UNSIGNED HEX INTEGER
	ATYPE:=INTCON; ATOM:=0;
	GETCH_;
	case of
	  CHAR>=^0 & CHAR<=^9: IATOM:=CHAR-^0;
	  CHAR>=^A & CHAR<=^F: IATOM:=CHAR-$37;
	  CHAR>=^a & CHAR<=^f: IATOM:=CHAR-$57
	other [\DIGIT EXPECTED\ ERROR(31); return];
	loop	[GETCH_;
		case of
		  CHAR>=^0 & CHAR<=^9: I:=CHAR-^0;
		  CHAR>=^A & CHAR<=^F: I:=CHAR-$37;
		  CHAR>=^a & CHAR<=^f: I:=CHAR-$57
		other return;
		if IATOM>$FFF then
			if CONDITIONAL then ERROR(6);
		IATOM:=IATOM*16+I];
	end;
^%:	begin						\UNSIGNED BINARY INTEGER
	ATYPE:=INTCON; ATOM:=0;
	GETCH_;
	if CHAR>=^0 & CHAR<=^1 then IATOM:=CHAR-^0
	else [\DIGIT EXPECTED\ ERROR(31); return];
	loop	[GETCH_;
		if CHAR>=^0 & CHAR<=^1 then I:=CHAR-^0
		else return;
		if IATOM<0 then		\(if IATOM > $7FFF ... unsigned)
			if CONDITIONAL then ERROR(6);
		IATOM:=IATOM*2+I];
	end;
^^:	[ATYPE:=INTCON;	\META CHARACTER = INTEGER CONSTANT
	ATOM:=0;
	CHAR:=CHIN(SRCDEV); CHOUT(LSTDEV,CHAR);
	if CHAR <$20 ! CHAR=$7F then WARNING(3);
	IATOM:=CHAR;
	GETCH;
	return];
^":	[ATYPE:=SPECIAL;				\SPECIAL CHARACTER
	ATOM:=CHAR;\(' AND BACKSLASH HAVE NO EFFECT IN STRINGS)
	CHAR:=CHIN(SRCDEV); CHOUT(LSTDEV,CHAR);
	return]
other;
ATYPE:=SPECIAL;						\SPECIAL CHARACTER
ATOM:=CHAR;
GETCH;
case CHAR of
  ^=:	case ATOM of
	^::	[GETCH; ATOM:=GETSYM];
	^>:	[GETCH; ATOM:=GESYM];
	^<:	[GETCH; ATOM:=LESYM]
	other;
  ^<:	[if ATOM = ^< then [GETCH; ATOM:= LSLSYM]];
  ^>:	begin
	if ATOM = ^> then [GETCH; ATOM:= LSRSYM]
	else if ATOM = ^- then
		[GETCH;
		if CHAR#^> then ERROR(38);
		GETCH;
		ATOM:= ASRSYM];
	end
other	[];
end;	\RATOM



proc	SKIPIT;
\SKIP THE REST OF A STATEMENT FOR ERROR RECOVERY
while ATOM#EOF & ATOM#^; & ATOM#ENDSYM & ATOM#^] &
	ATOM#BEGSYM & ATOM#^[ do RATOM;



proc	HEXB; int I;	\OUTPUT HEX BYTE (OPTIMIZED FOR SPEED)
begin
CHOUT(BINDEV,HEXDIGIT( (I&$FF)/16 ));
CHOUT(BINDEV,HEXDIGIT(REM(0)));
end;	\HEXB



proc	SYMOUT; int SYM;
\OUTPUT SYMBOL NAME AT 'SYM'
int K,I,C;
begin
K:=SYM;
for I:=0,SIGCHAR-1 do
	begin
	C:=SYMBOL(K);
	if C=$20 then [CRLF(BINDEV); return];
	CHOUT(BINDEV,C);
	K:=K+SYMAX;
	end;
CRLF(BINDEV);
end;	\SYMOUT



proc	GEN; int OP,LEV,VAL,CL;	\GENERATE OP CODE
int	I;
char	A;
begin
\THE ENCODING OF THE CLASS, CL, IS AN 8-BIT BINARY CODE.
\0 = OPCODE ONLY, 1 BYTE
\2 = OPCODE WITH ONE BYTE VALUE
\3 = OPCODE WITH VALUE, 3 BYTES
\7 = OPCODE WITH ADDRESS (TO BE RELOCATED BY LOADER), 3 BYTES
\10 = OPCODE WITH LEVEL AND ONE BYTE OFFSET (IN VAL)
\15 = OPCODE WITH LEVEL AND ADDRESS, 4 BYTES
\16 = IMMF OPCODE WITH "RLSIZE" BYTES OF VALUE
\32 = CONSTANT REAL ARRAY POINTER
\64 = OPCODE WITH BASE RELATIVE ADDRESS, 3 BYTES
if PC#OLDPC then [CRLF(BINDEV); CHOUT(BINDEV,^;); HEXOUT(BINDEV,PC)];

if OP=1 & LEV=0 & VAL>=0 & VAL<$80 then  \SHORT GLOBAL LOAD (MAGIC OPCODE)
	[HEXB(VAL!$80); PC:=PC+1]
else	begin
	HEXB(OP); PC:=PC+1;
	if CL&8 then [HEXB(LEV); PC:=PC+1];
	if CL&4 then [CHOUT(BINDEV,^*); HEXOUT(BINDEV,VAL); PC:=PC+2]
	else	begin
		if CL=10 then [HEXB(VAL);HEXB(SWAP(VAL)); PC:=PC+2] 
		else if CL&2 then [HEXB(VAL); PC:=PC+1];
		if CL&1 then [HEXB(SWAP(VAL)); PC:=PC+1];
		end;
	end;
if CL=16 then		\IMMF--LOAD IMMEDIATE REAL NO. (RLATOM)
	[A:=addr RLATOM;  \TO ACCESS INDIVIDUAL BYTES IN RLATOM
	for I:=0,RLSIZE-1 do HEXB(A(I));
	PC:=PC+RLSIZE];
if CL&32 then	\OUTPUT DUMMY BYTES FOR CONSTANT REAL ARRAY POINTERS
	for I:=3,RLSIZE do [HEXB(0); PC:=PC+1];
if CL&64 then [CHOUT(BINDEV,^#); SYMOUT(VAL); PC:=PC+2];
OLDPC:=PC;
end;	\GEN


proc	GENIMM; int VAL;	\GENERATE IMM OP CODE
if ABS(VAL)<128 & VAL#$8000 then
	GEN(\IMS\36,0,VAL,2)
else	GEN(\IMM\11,0,VAL,3);


proc	FIX; int I;	\FIX FORWARD REFERENCES
begin
CRLF(BINDEV);
if PC#OLDPC then
	[CHOUT(BINDEV,^;); HEXOUT(BINDEV,PC);
	OLDPC:=PC;
	CRLF(BINDEV)];
CHOUT(BINDEV,^^); HEXOUT(BINDEV,I+1);
end;	\FIX



proc	LOOKUP;		\LOOKUP IDENTIFIER IN SYMBOL TABLE
\INPUTS: IDENT, HASH
\OUTPUTS: IDTYPE, VAL, LEV, SYMNUM.
\IF TWO IDENTIFIERS OF THE SAME NAME ARE IN THE SYMBOL TABLE
\ THEN THE MOST RECENT ENTRY IS USED.
int	I,K,PNTR;
begin
PNTR:=BOX(HASH);
loop	begin
	if PNTR=EMTPTR then [IDTYPE:=UNDEF; quit];
	I:=0; K:=PNTR;
	while IDENT(I)=SYMBOL(K) & I<SIGCHAR do
		[I:=I+1; K:=K+SYMAX];
	if I=SIGCHAR then	\FOUND
		[IDTYPE:=SYMTYP(PNTR);
		VAL:=SYMVAL(PNTR);
		LEV:=SYMLEV(PNTR);
		SYMNUM:=PNTR;		\(FOR FORWARD PROC)
		quit];
	PNTR:=SYMPNT(PNTR);
	end;
end;	\LOOKUP



proc	INSERT; int STYP,SLEV,SVAL;
\INSERT THE CURRENT IDENTIFIER INTO THE SYMBOL TABLE
\INPUTS:  STYP, SLEV, SVAL, IDENT, HASH, NOSYM, SYMBOL, & BOX.
int	I,K;
begin
LOOKUP;
if IDTYPE#UNDEF then if LEV=LEVEL then \COLLISION\ ERROR(11)
			else WARNING(1);
if NOSYM>=SYMAX then \TABLE FULL\ [ERROR(3); NOSYM:=SYMAX-1];
K:=NOSYM;
for I:=0,SIGCHAR-1 do [SYMBOL(K):=IDENT(I); K:=K+SYMAX];
SYMTYP(NOSYM):=STYP;
SYMLEV(NOSYM):=SLEV;
SYMVAL(NOSYM):=SVAL;
SYMTAG(NOSYM):=0;
SYMPNT(NOSYM):=BOX(HASH);		\LINK BACK
BOX(HASH):=NOSYM;
NOSYM:=NOSYM+1;
end;	\INSERT



proc	GETCON;	\GET A CONSTANT--EITHER BY VALUE OR BY NAME
int	NEG;
begin
if ATOM=^+ then RATOM;
if ATOM=^- then [NEG:=true; RATOM] else NEG:=false;
case ATYPE of
INTCON:	[if NEG then IATOM:=-IATOM; FACTYP:=INTEGER];
REALCON:[if NEG then RLATOM:=-RLATOM; FACTYP:=REAL];
IDENTIFIER:
	begin
	LOOKUP;
	if IDTYPE#UNDEF then SYMTAG(SYMNUM):=SYMTAG(SYMNUM)!$01;
	case IDTYPE of
	INCON:	[IATOM:=if NEG then -VAL else VAL;
		FACTYP:=INTEGER];
	RLCON:	[RLATOM:=if NEG then-RLTBL(VAL)else RLTBL(VAL);
		FACTYP:=REAL]
	other	ERROR(42);
	end
other	ERROR(42);
end;	\GETCON



proc	CONEXPRESS;	\EVALUATE CONSTANT EXPRESSIONS
\OUTPUTS FACTYP, IATOM, RLATOM
int	SFACTYP,ITEMP,IFVAR;
real	RTEMP;


	proc INTTEST;		\TEST FOR INTEGER ERRORS
	if FACTYP # INTEGER then ERROR(47);


	proc MIXTEST(TYPE);	\TEST FOR MIXED MODE ERRORS
	int TYPE;
	if TYPE#FACTYP then ERROR(46);


	proc	CFACTOR;
	begin
	if ATOM=^( then
		begin
		RATOM;
		CONEXPRESS;
		if ATOM#^) then ERROR(44);		
		end
	else GETCON;
	RATOM;
	end;	\CFACTOR


	proc	CSHIFTEXP;
	int	ITEMP;
	begin
	CFACTOR;
	ITEMP:=IATOM;
	case ATOM of
	LSLSYM:	begin
		INTTEST;
		RATOM;
		CFACTOR;
		INTTEST;
		IATOM:=ITEMP << IATOM;
		end;	
	LSRSYM:	begin
		INTTEST;
		RATOM;
		CFACTOR;
		INTTEST;
		IATOM:=ITEMP >> IATOM;
		end;
	ASRSYM:	begin
		INTTEST;
		RATOM;
		CFACTOR;
		INTTEST;
		IATOM:=ITEMP ->> IATOM;
		end
	other;
	end;	\CSHIFTEXP


	proc	CTERM;
	int	SFACTYP;
	int	ITEMP;
	real	RTEMP;
	begin
	CSHIFTEXP;
	SFACTYP:=FACTYP;
	loop	begin
		ITEMP:=IATOM;RTEMP:=RLATOM;
		case ATOM of
		  ^*:	begin
			RATOM;
			CSHIFTEXP;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:=ITEMP * IATOM
				else RLATOM:=RTEMP * RLATOM;
			end;
		  ^/:	begin
			RATOM;
			CSHIFTEXP;
			MIXTEST(SFACTYP);
			if IATOM=0 ! RLATOM=0.0 then ERROR(73) \Divide by zero
			else if FACTYP=INTEGER then IATOM:=ITEMP / IATOM
				else RLATOM:=RTEMP / RLATOM;
			end
		other	quit;
		end;
	end;	\CTERM


	proc	CALGEXP;	\ALGEBRIAC EXPRESSION
	int	SFACTYP;
	int	ITEMP;
	real	RTEMP;
	begin
	CTERM;
	SFACTYP:=FACTYP;
	loop	begin
		ITEMP:=IATOM;RTEMP:=RLATOM;
		case ATOM of
		  ^+:	begin
			RATOM;
			CTERM;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:=ITEMP + IATOM
			else RLATOM:=RTEMP + RLATOM;
			end;
		  ^-:	begin
			RATOM;
			CTERM;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:=ITEMP - IATOM
				else RLATOM:=RTEMP - RLATOM;
			end
		other	quit;
		end;
	end;	\CALGEXP


	proc	CLOGEXP;	\'NOT' AND COMPARISONS
	int	SFACTYP;
	int	ITEMP;
	real	RTEMP;
	begin
	if ATOM=NOTSYM ! ATOM=^~ then
		begin
		RATOM;
		CLOGEXP;
		INTTEST;
		IATOM:= ~IATOM;
		end
	else	begin
		CALGEXP;
		SFACTYP:=FACTYP;
		ITEMP:=IATOM; RTEMP:=RLATOM;
		case ATOM of
		 ^=:	[RATOM;
			CALGEXP;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:= ITEMP = IATOM
			else [IATOM:= RTEMP = RLATOM; WARNING(2)];
			FACTYP:=INTEGER];
		 ^#:	[RATOM;
			CALGEXP;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:= ITEMP # IATOM
			else [IATOM:= RTEMP # RLATOM; WARNING(2)];
			FACTYP:=INTEGER];
		 ^>:	[RATOM;
			CALGEXP;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:= ITEMP > IATOM
			else IATOM:= RTEMP > RLATOM;
			FACTYP:=INTEGER];
		 ^<:	[RATOM;
			CALGEXP;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:= ITEMP < IATOM
			else IATOM:= RTEMP < RLATOM;
			FACTYP:=INTEGER];
		 GESYM:	[RATOM;
			CALGEXP;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:= ITEMP >= IATOM
			else IATOM:= RTEMP >= RLATOM;
			FACTYP:=INTEGER];
		 LESYM:	[RATOM;
			CALGEXP;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:= ITEMP <= IATOM
			else IATOM:= RTEMP <= RLATOM;
			FACTYP:=INTEGER]
		other	[];
		end;
	end;	\CLOGEXP


	proc	CBOOLTERM;	\BOOLEAN "&" EXPRESSIONS
	int	ITEMP;
	begin
	CLOGEXP;
	loop	begin
		ITEMP:=IATOM;
		if ATOM=^& then
			begin
			INTTEST;
			RATOM;
			CLOGEXP;
			INTTEST;
			IATOM:=ITEMP & IATOM;
			end
		else quit;
		INTTEST;
		end;
	end;	\CBOOLTERM


begin	\CONEXPRESS
TRAP(false);
if ATOM=IFSYM then		\'IF' EXPRESSION
	begin
	RATOM;
	CONEXPRESS;
	INTTEST;
	IFVAR:=IATOM;
	if ATOM#THENYM then ERROR(22);
	RATOM;
	CONEXPRESS;
	SFACTYP:=FACTYP;
	ITEMP:=IATOM; RTEMP:=RLATOM;
	if ATOM#ELSEYM then ERROR(30);
	RATOM;
	CONEXPRESS;
	MIXTEST(SFACTYP);
	if IFVAR then 
		if FACTYP=INTEGER then IATOM:=ITEMP
		else RLATOM:=RTEMP;
	end
else	begin
	CBOOLTERM;
	loop	begin
		ITEMP:=IATOM;
		case ATOM of
		  ^!:	begin
			INTTEST;
			RATOM;
			CBOOLTERM;
			INTTEST;
			IATOM:=ITEMP ! IATOM;
			end;
		  ^|:	begin
			INTTEST;
			RATOM;
			CBOOLTERM;
			INTTEST;
			IATOM:=ITEMP | IATOM;
			end
		other quit;
		end;
	end;
TRAP(true);
if GETERR#0 then ERROR(74);	\GENERAL MATH ERROR
end;	\CONEXPRESS


fproc	BOOLEXP;


proc	PROCAL;
int	SVAL,SLEV,ARGCNT,SID,CURSYM;
begin
SVAL:=VAL; SLEV:=LEV; SID:=IDTYPE; CURSYM:=SYMNUM;
RATOM;
ARGCNT:=0;
if ATOM=^( then
	begin
	repeat	[RATOM; 
		BOOLEXP;
		ARGCNT:=ARGCNT +(if FACTYP=INTEGER then
			2 else RLSIZE)]
	until ATOM#^,;
	if ATOM#^) then ERROR(44) else RATOM;
	end;
case of
SID>=INPROC & SID<=RLFPROC:	\NORMAL PROCEDURE CALL
	[if ARGCNT>0 then GEN(\ARG\10,0,ARGCNT-1,2);
	GEN(\CAL\5,SLEV+2,SVAL,15)]

other case SID of
ININT,RLINT: GEN(\CML\12,0,SVAL,2);	\INTRINSIC PROCEDURE CALL
INOPT,RLOPT:				\OPTIMIZED PROCEDURE CALL
	[if ARGCNT>0 then ERROR(51); \NO ARGS DECLARED
	GEN(\JSR\38,0,SVAL,7)];
INEXT,RLEXT: GEN(\ECL\41,0,CURSYM,64);	\EXTERNAL ASSEMBLY PROCEDURE CALL
INEPRO,RLEPRO:				\EXTERNAL I2L PROCEDURE CALL
	[if ARGCNT>0 then GEN(\ARG\10,0,ARGCNT-1,2);
	GEN(\CAL\5,SLEV+2,CURSYM,72)]
other;
end;	\PROCAL



proc	BOOLEXP;	\BOOLEAN EXPRESSION
\OUTPUTS FACTOR TYPE (FACTYP)
int	P1,P2,SFACTYP;



proc	FACTOR;


func	STRCON;		\STRING CONSTANT FUNCTION
int	SPC,SCHAR;
begin
SPC:=PC;
CRLF(BINDEV); CHOUT(BINDEV,^;); HEXOUT(BINDEV,PC);
while CHAR#^" do
	begin			\(GETCH--OPTIMIZED FOR SPEED)
	case CHAR of
	  ^^:	begin
	  	CHAR:=CHIN(SRCDEV); CHOUT(LSTDEV,CHAR);
		if CHAR <$20 ! CHAR=$7F then
			if CHAR#$0D\CR\ & CHAR#$0A\LF\ & CHAR#$09\TAB\ then
				WARNING(3);
		if CHAR>=^@ & CHAR<=^_ & CHAR#^^ then CHAR:=CHAR-^@;
		if CHAR>=^` & CHAR<=^~ then CHAR:=CHAR-^`;
		end;
	  EOF:	[ERROR(63); exit 1]
	other	[];
	HEXB(CHAR); PC:=PC+1;
	SCHAR:=CHAR;
	CHAR:=CHIN(SRCDEV); CHOUT(LSTDEV,CHAR);
	if CHAR <$20 ! CHAR=$7F then
		if CHAR#$0D\CR\ & CHAR#$0A\LF\ & CHAR#$09\TAB\ then WARNING(3);
	end;
CRLF(BINDEV); CHOUT(BINDEV,^;); HEXOUT(BINDEV,PC-1);
HEXB(SCHAR!$80);
GETCH;
FACTYP:=INTEGER;
return SPC;	\RETURN STARTING ADDRESS OF STRING
end;	\STRCON



func	ARRAYCON;	\CONSTANT ARRAYS
int	THISEL,NEXTEL,PNTR,SPC,I,INDIRECT,SFACTYP;
def	NULL=$FFFF;
char	ENTRY,R;

	proc ARRAYX;	\(THIS MUST BE AN OPTIMIZED PROCEDURE
	begin		\ FOR THE RESERVE TO WORK PROPERLY.)
	RATOM;
	INDIRECT:=true;
	case ATOM of
	  ^[:	[ENTRY:=ARRAYCON; RATOM];
	  ^":	[ENTRY:=STRCON; RATOM]
	other	begin
		INDIRECT:=false;
		CONEXPRESS;
		if FACTYP=INTEGER then ENTRY:=IATOM
		else	[ENTRY:=RESERVE(RLSIZE);  \FACTYP=REAL
			R:=addr RLATOM;
			for I:=0,RLSIZE-1 do ENTRY(I):=R(I)];
		end;
	NEXTEL:=RESERVE(6);
	THISEL(1):=ENTRY;
	THISEL(2):=INDIRECT;
	THISEL(0):=NEXTEL;
	NEXTEL(0):=NULL;
	THISEL:=NEXTEL;
	end;

begin	\ARRAYCON
PNTR:=RESERVE(6);
THISEL:=PNTR;
THISEL(0):=NULL;
ARRAYX;
while ATOM=^, do
	[SFACTYP:=FACTYP;
	ARRAYX;
	if FACTYP#SFACTYP then \MIXED MODE\ ERROR(46)];
if ATOM#^] then ERROR(50);
SPC:=PC;
CRLF(BINDEV); CHOUT(BINDEV,^;); HEXOUT(BINDEV,PC);
while PNTR(0)#NULL do		\DUMP LIST
	begin
	ENTRY:=PNTR(1);
	if FACTYP=INTEGER then
		begin
		if PNTR(2) \INDIRECT\ then
			[CHOUT(BINDEV,^*); HEXOUT(BINDEV,ENTRY)]
		else	[HEXB(ENTRY); HEXB(SWAP(ENTRY))];
		PC:=PC+2;
		end
	else	begin	\(FACTYP=REAL)
		if PNTR(2) \INDIRECT\ then
			[CHOUT(BINDEV,^*); HEXOUT(BINDEV,ENTRY);
			for I:=1,RLSIZE-2 do HEXB(0)]
		else for I:=0,RLSIZE-1 do HEXB(ENTRY(I));
		PC:=PC+RLSIZE;
		end;
	PNTR:=PNTR(0);
	end;
return SPC;	\RETURN STARTING ADDRESS OF ARRAY
end;	\ARRAYCON



proc	SPECFAC;	\SPECIAL CHARACTER FACTOR
int	SVAL, SPC, R, SID;
begin
case ATOM of
  ^(:	[RATOM;				\PARENTHESIZED EXPRESSION
	BOOLEXP;			\(FACTOR TYPE IS UNCHANGED)
	if ATOM#^) then ERROR(44);
	RATOM];
  ^":	[SPC:=PC;		\STRING CONSTANT
	GEN(\JMP\7,0,0,7);
	SVAL:=STRCON;
	FIX(SPC);
	GEN(\IMM\11,0,SVAL,7);
	RATOM];
  ^[:	[SPC:=PC;		\CONSTANT ARRAY
	GEN(\JMP\7,0,0,7);
	SVAL:=ARRAYCON;
	FIX(SPC);
	if FACTYP=INTEGER then GEN(\IMM\11,0,SVAL,7)
	else	\FACTYP=REAL
		[R:=addr RLATOM;	\CONVERT AN INTEGER
		R(0):=SVAL;		\ POINTER INTO A REAL
		GEN(\IMMF\$2C,0,SVAL,36)];\ POINTER IN RLATOM
	RATOM];
  ADRSYM:
	begin				\GET ABSOLUTE HEAP ADDRESS
	RATOM;
	if ATYPE#IDENTIFIER then ERROR(45);
	LOOKUP;
	if IDTYPE#UNDEF then
		[SYMTAG(SYMNUM):=SYMTAG(SYMNUM)!$02;
		if (SYMTAG(SYMNUM)&$06) = $06 then WARNING(9)];
	case IDTYPE of
	  INVAR, RLVAR, ADDRVAR:
		begin
		SID:= IDTYPE;
		RATOM;
		if ATOM=^( then			\INDEXED
			begin
			GEN(\LOD\1,LEV,VAL,10);	\(EVEN FOR REALS)
			RATOM;
			BOOLEXP;		\1ST INDEX
			if FACTYP#INTEGER then ERROR(47);
			while ATOM=^, do	\MULTIPLE INDEXING
				begin
				case SID of
				  INVAR, ADDRVAR: GEN(\DBX\$20,0,0,0);
				  RLVAR: GEN(\TRX\$39,0,0,0)
				other [];
				RATOM;
				BOOLEXP;
				if FACTYP#INTEGER then ERROR(47);
				end;
			case SID of
			  INVAR: GEN(\DBA\$1E,0,0,0);
			  RLVAR: GEN(\TRA\$38,0,0,0);
			  ADDRVAR: GEN(\ADD\$0D,0,0,0)
			other [];
			if ATOM#^) then ERROR(44) else RATOM;
			end
		else	GEN(\ADR\$21,LEV,VAL,10);
		end;

	  UNDEF:	ERROR(10)	\(UNDECLARED NAME)
	other		ERROR(43);	\(VARIABLE EXPECTED)
	FACTYP:= INTEGER;
	end;
  PORTYM:
	begin				\READ BYTE FROM PORT
	RATOM;
	if ATOM#^( then ERROR(39) else RATOM;
	BOOLEXP;
	if FACTYP#INTEGER then ERROR(47);
	GEN(\PIN\$4E,0,0,0);
	if ATOM#^) then ERROR(44) else RATOM;
	end
other	\ILLEGAL FACTOR\ ERROR(26);
end;	\SPECFAC



proc	IDFAC;		\IDENTIFIER FACTOR
int	SLEV,SVAL,SID,SINDX;
begin	\IDFAC
LOOKUP;
if IDTYPE#UNDEF then SYMTAG(SYMNUM):=SYMTAG(SYMNUM)!$01;
SID:=IDTYPE;

case IDTYPE of
UNDEF:	ERROR(10);

INVAR, RLVAR, ADDRVAR:		\VARIABLE
	begin
	GEN(if SID=RLVAR then \LODF\$2A else \LOD\$01,LEV,VAL,10);
	RATOM;
	if ATOM=^( then				\IT IS INDEXED
		begin
		loop	begin
			RATOM;
			BOOLEXP;
			if FACTYP#INTEGER then ERROR(47);
			if ATOM#^, then quit;
			GEN(if SID=RLVAR then \TRI\$3A else \DBX\$20,0,0,0)
			end;
		if ATOM#^) then ERROR(44) else RATOM;
		case SID of
		 INVAR:   GEN(\DBX\$20,0,0,0);
		 RLVAR:   GEN(\TRI\$3A,0,0,0);
		 ADDRVAR: GEN(\LDX\$02,0,0,0)
		other	[];
		end;
	end;

INSEG, RLSEG, ADSEG, SHSEG:	\SEGMENT VARIABLE
	begin
	SINDX:=0;			\WATCH INDEX LEVEL
	GEN(\LOD\1,LEV,VAL,10);
	RATOM;
	if ATOM=^( then		\HANDLE FIRST INDEX
		begin
		RATOM;
		BOOLEXP;
		if FACTYP#INTEGER then ERROR(47);
		GEN(\DBX\32,0,0,0);
		if ATOM=^, then	\HANDLE SECOND INDEX
			begin
			SINDX:=2;	\FLAG TWO INDEXES
			RATOM;
			BOOLEXP;
			if FACTYP#INTEGER then ERROR(47);
			case SID of
			  INSEG: GEN(\LDSI\$40,0,0,0);
			  ADSEG: GEN(\LDSB\$41,0,0,0);
			  RLSEG: GEN(\LDSR\$42,0,0,0);
			  SHSEG: GEN(\LSHORT\$46,0,0,0)				
			other;
			end;
		if ATOM#^) then ERROR(44) else RATOM;
		end;
	\FORCE REAL TO BE INTEGER WHEN THERE ARE LESS THAN 2 INDEXES
	case SID of RLSEG,SHSEG: [if SINDX<2 then SID:=INSEG] other;
	end;

INCON:	begin	\INTEGER CONSTANT IDENTIFIER
	GENIMM(VAL);
	RATOM;
	end;

RLCON:	begin	\REAL CONSTANT IDENTIFIER
	RLATOM:=RLTBL(VAL); GEN(\IMMF\$2C,0,0,16);
	RATOM;
	end

other	begin	\PROCEDURES USED AS FUNCTIONS (BY DEFAULT)
	PROCAL;
	if SID<ININT then
		GEN(if SID&1 then\LOD\1 else\LODF\$2A,0,0,10);
	end;

FACTYP:=if SID & 1 then INTEGER else REAL; \ODD IDS ARE INTEGER
end;	\IDFAC


begin	\FACTOR
while ATOM=^+ do [RATOM; if ATOM=^+ then WARNING(7)];	\IGNORE UNARY "+"
if ATOM=^- then				\UNARY "-"
	[RATOM;
	if ATOM=^- then WARNING(7);
	FACTOR;
	GEN(if FACTYP=INTEGER then \NEG\17
		else \NEGF\$31,0,0,0)]
else	case ATYPE of
	SPECIAL:SPECFAC;
	INTCON:	[FACTYP:=INTEGER;	\INTEGER CONSTANT
		GENIMM(IATOM);
		RATOM];
	REALCON:[FACTYP:=REAL;		\REAL CONSTANT
		GEN(\IMMF\$2C,0,0,16);
		RATOM]
	other	IDFAC;	\ATYPE = IDENTIFIER (BY DEFAULT)
end;	\FACTOR


proc	SHIFTEXP;

	proc SHIFTX; int INOP;
	[if FACTYP # INTEGER then \INTEGER EXPECTED\ ERROR(47);
	RATOM; FACTOR;
	if FACTYP # INTEGER then ERROR(47);
	GEN(INOP, 0, 0, 0)];

begin	\SHIFTEXP
FACTOR;
case ATOM of
  LSLSYM: SHIFTX(\LSL\$3E);	\<<
  LSRSYM: SHIFTX(\LSR\$3F);	\>>
  ASRSYM: SHIFTX(\ASR\$3D)	\->>
other;
end;	\SHIFTEXP



proc	TERM;
int	SFACTYP;

	proc TERMX; int INOP,RLOP;
	[RATOM; SHIFTEXP;
	if SFACTYP#FACTYP then \MIXED MODE\ ERROR(46);
	GEN(if FACTYP=INTEGER then INOP else RLOP,0,0,0)];

begin	\TERM
SHIFTEXP;
SFACTYP:=FACTYP;
loop	case ATOM of
	  ^*:	TERMX(\MUL\15,\MULF\$2F);
	  ^/:	TERMX(\DIV\16,\DIVF\$30)
	other	quit;
end;	\TERM


proc	ALGEXP;		\ALGEBRIAC EXPRESSION
int	SFACTYP;

	proc ALGX; int INOP,RLOP;
	[RATOM; TERM;
	if SFACTYP#FACTYP then \MIXED MODE\ ERROR(46);
	GEN(if FACTYP=INTEGER then INOP else RLOP,0,0,0)];

begin	\ALGEXP
TERM;
SFACTYP:=FACTYP;
loop	case ATOM of
	  ^+:	ALGX(\ADD\13,\ADDF\$2D);
	  ^-:	ALGX(\SUB\14,\SUBF\$2E)
	other	quit;
end;	\ALGEXP


proc	LOGEXP;		\LOGICAL EXPRESSION
int	SFACTYP;

	proc	LOGX; int INOP,RLOP;
	[RATOM; ALGEXP;
	if SFACTYP#FACTYP then \MIXED MODE\ ERROR(46);
	GEN(if FACTYP=INTEGER then INOP else RLOP,0,0,0);
	FACTYP:=INTEGER];

begin	\LOGEXP
if ATOM=NOTSYM ! ATOM=^~ then		\UNARY 'NOT' OPERATOR
	[RATOM;
	if ATOM=NOTSYM ! ATOM=^~ then WARNING(7);
	LOGEXP;
	if FACTYP#INTEGER then ERROR(47);
	GEN(\NOT\28,0,0,0)]
else	[ALGEXP;
	SFACTYP:=FACTYP;
	case ATOM of
	 ^=:	[LOGX(\EQ\18,\EQF\$32); if FACTYP=REAL then WARNING(2)];
	 ^#:	[LOGX(\NE\19,\NEF\$33); if FACTYP=REAL then WARNING(2)];
	 ^>:	LOGX(\GT\21,\GTF\$35);
	 ^<:	LOGX(\LT\23,\LTF\$37);
	 GESYM:	LOGX(\GE\20,\GEF\$34);
	 LESYM:	LOGX(\LE\22,\LEF\$36)
	other;	];
end;	\LOGEXP


proc	BOOLTERM;	\BOOLEAN "&" EXPRESSIONS
begin
LOGEXP;
loop	[if ATOM=^& then [RATOM; LOGEXP; GEN(\AND\27,0,0,0)]
		else quit;
	if FACTYP#INTEGER then ERROR(47)];
end;


proc BEXPX; int INOP;
begin
if FACTYP # INTEGER then \INTEGER EXPECTED\ ERROR(47);
RATOM; BOOLTERM;
if FACTYP # INTEGER then ERROR(47);
GEN(INOP, 0, 0, 0);
end;	\BEXPX



begin	\BOOLEXP
if ATOM=IFSYM then			\'IF' EXPRESSION
	[RATOM; BOOLEXP;
	P1:=PC; GEN(\JPC\8,0,0,7);
	if ATOM#THENYM then ERROR(22);
	RATOM; BOOLEXP; SFACTYP:=FACTYP;
	if ATOM#ELSEYM then ERROR(30);
	P2:=PC; GEN(\JMP\7,0,0,7); FIX(P1);
	RATOM; BOOLEXP;
	if SFACTYP#FACTYP then \MIXED MODE\ ERROR(46);
	FIX(P2)]
else	begin			\BOOLEAN "!" (OR) AND "|" (XOR) EXPRESSIONS
	BOOLTERM;
	loop	case ATOM of
		  ^!:	BEXPX(\OR\$1A);
		  ^|:	BEXPX(\EOR\$1D)
		other quit;
	end;
end;	\BOOLEXP


proc	SSTATEMENT; int SSTK;	\(FOR 'QUIT'S IN 'CASE' STMNTS)


proc	STATEMENT;
int	P2,P3,SFIXS,SLEV,SVAL,SFACTYP,I,DOWNTO;


proc	ASSIGN;		\ASSIGNMENT STATEMENT
int	SID;
\ (ALSO INCLUDES PROCEDURE CALLS)

	proc	ASSX;
	[if ATOM#GETSYM then ERROR(21);
	RATOM;
	BOOLEXP];	\RIGHT-HAND SIDE OF ASSIGNMENT

begin	\ASSIGN
if ATOM=PORTYM then	\port($123):= boolexp
	begin
	RATOM;
	if ATOM#^( then ERROR(39) else RATOM;
	BOOLEXP;
	if FACTYP#INTEGER then ERROR(47);
	if ATOM#^) then ERROR(44) else RATOM;
	ASSX;
	GEN(\POUT\$4F,0,0,0);
	if FACTYP#INTEGER then ERROR(47);
	return;
	end;
if ATYPE#IDENTIFIER then [ERROR(20); SKIPIT; return];	\BAD START OF A STATEMENT\ 
LOOKUP;
if IDTYPE=UNDEF then [ERROR(10); SKIPIT; return];
SLEV:=LEV; SVAL:=VAL;	\SAVE THESE FOR "GEN." AN INTERIM
SID:=IDTYPE;		\ BOOLEXP MAY CHANGE LEV & VAL

case of
IDTYPE>=INPROC & IDTYPE<=RLEXT: [SYMTAG(SYMNUM):=SYMTAG(SYMNUM)!$01; PROCAL];

IDTYPE=INVAR ! IDTYPE=RLVAR ! IDTYPE=ADDRVAR:
	begin
	SFACTYP:=if IDTYPE=RLVAR then REAL else INTEGER;
	RATOM;
	if ATOM=^( then			\INDEXED
		begin
		SYMTAG(SYMNUM):=SYMTAG(SYMNUM)!$01;
		GEN(\LOD\1,SLEV,SVAL,10);
		RATOM;
		BOOLEXP;		\1ST INDEX
		if FACTYP#INTEGER then ERROR(47);

		while ATOM=^, do	\MULTIPLE INDEXING
			begin
			GEN(if SFACTYP=INTEGER then \DBX\$20
				else \TRX\$39,0,0,0);
			RATOM;
			BOOLEXP;
			if FACTYP#INTEGER then ERROR(47);
			end;
		if ATOM#^) then ERROR(44) else RATOM;
		case SID of
		 INVAR:   GEN(\DBA\$1E,0,0,0);
		 RLVAR:   GEN(\TRA\$38,0,0,0);
		 ADDRVAR: GEN(\ADD\$0D,0,0,0)
		other	[];

		ASSX;			\TOS NOW POINTS TO ARRAY ELEMENT
		case SID of
		 INVAR:   GEN(\STD\$1F,0,0,0);
		 RLVAR:   GEN(\STT\$3B,0,0,0);
		 ADDRVAR: GEN(\STX\$04,0,0,0)
		other	[];
		end

	else	[ASSX;
		GEN(if SFACTYP=INTEGER then \STO\$03
			else \STOF\$2B,SLEV,SVAL,10)];
	if FACTYP#SFACTYP then \MIXED MODE\ ERROR(46);
	end;

IDTYPE=INSEG ! IDTYPE=RLSEG !
IDTYPE=ADSEG ! IDTYPE=SHSEG:	\SEGMENT VARIABLES
	begin
	SFACTYP:=INTEGER;
	RATOM;
	if ATOM#^( then	[ASSX;GEN(\STO\3,SLEV,SVAL,10)]
	else	begin			\1ST INDEX
		SYMTAG(SYMNUM):=SYMTAG(SYMNUM)!$01;
		GEN(\LOD\1,SLEV,SVAL,10);
		RATOM;
		BOOLEXP;
		if FACTYP#INTEGER then ERROR(47);
		if ATOM=^, then		\2ND INDEX
			begin
			GEN(\DBX\32,0,0,0);
			RATOM;BOOLEXP;
			if FACTYP#INTEGER then ERROR(47);
			if ATOM#^) then ERROR(44) else RATOM;
			ASSX;	\GET RIGHT SIDE OF ASSIGNMENT
			case SID of
			  INSEG:GEN(\STSI\$43,0,0,0);
			  RLSEG:[GEN(\STSR\$45,0,0,0); SFACTYP:=REAL];
			  ADSEG:GEN(\STSA\$44,0,0,0);
			  SHSEG:[GEN(\SSHORT\$47,0,0,0); SFACTYP:=REAL]
			other;
			end
		else	begin
			GEN(\DBA\30,0,0,0);
			if ATOM#^) then ERROR(44) else RATOM;
			ASSX;	\GET RIGHT SIDE OF ASSIGNMENT
			GEN(\STD\31,0,0,0);
			end;
		end;
	if FACTYP#SFACTYP then \MIXED MODE\ ERROR(46);
	end

other \STATEMENT STARTING WITH A CONSTANT\ [ERROR(27); SKIPIT];
end;	\ASSIGN


proc	CASER; int TYPE;
int	SPC1,SPC2,SPC3;


proc	CASER2;
begin
RATOM;
BOOLEXP;
if FACTYP#INTEGER then ERROR(47);
SPC1:=PC;
GEN(TYPE,0,0,7);
if ATOM=^, then				\MULTIPLE LABELS
	[SPC3:=PC;
	repeat	RATOM;	\FOR MORE THAN 2 LABELS
		GEN(\JMP\7,0,SPC3,7);	\2 JUMPS TO STATEMENT
		FIX(SPC1);
		BOOLEXP;
		if FACTYP#INTEGER then ERROR(47);
		SPC1:=PC;
		GEN(TYPE,0,0,7);
	until ATOM#^,;
	FIX(SPC3)];
if ATOM#^: then [ERROR(49); SKIPIT; return];
RATOM;
STATEMENT;
end;	\CASER2


begin	\CASER
CASER2;
SPC2:=PC;
GEN(\JMP\7,0,0,7);		\JUMP OUT OF CASE STATEMENT
FIX(SPC1);
while ATOM=^; do
	[CASER2;
	GEN(\JMP\7,0,SPC2,7);	\2 JUMP EXIT (BACK THEN OUT)
	FIX(SPC1)];
if ATOM#ELSEYM & ATOM#OTHSYM then ERROR(29);
if ATOM=ELSEYM then WARNING(4);
RATOM;
STATEMENT;
FIX(SPC2);
end;	\CASER


begin	\STATEMENT
case ATOM of
BEGSYM,^[:
	begin
	RATOM;
	loop	begin
		if ATOM=ELSEYM then [ERROR(52); RATOM];
		if ATOM=OTHSYM then [ERROR(53); RATOM];
		STATEMENT;
		case ATOM of
		 ^;:	RATOM;
		 ENDSYM:quit;
		 ^]:	quit;
		 EOF:	[ERROR(62); exit 1]
		other	\SEMI EXPECTED\ ERROR(41);
		end;
	RATOM;		\READ PAST THE 'END'
	end;
CASEYM:	begin				\CASE STATEMENT
	RATOM;
	if ATOM=OFSYM then CASER(\JPC\8)
	else	begin
		BOOLEXP;
		if FACTYP#INTEGER then ERROR(47);
		if ATOM#OFSYM then [ERROR(48); SKIPIT; return];
		STKLOD:=STKLOD+1;
		CASER(\CJP\37);
		GEN(\DRP\40,0,0,0);
		STKLOD:=STKLOD-1;
		end;
	end;
QUITYM:	begin
	for I:=SSTK,STKLOD-1 do GEN(\DRP\40,0,0,0);
	if FIXCNT>=QUITMAX then [ERROR(4); FIXCNT:=QUITMAX-1];
	FIXES(FIXCNT):=PC;		\QUIT STATEMENT
	FIXCNT:=FIXCNT+1;
	GEN(\JMP\7,0,0,7);   \(WILL BE "FIXED" AT END OF 'LOOP')
	RATOM;
	end;
IFSYM:	begin				\IF STATEMENT
	RATOM;
	BOOLEXP;
	P3:=PC;
	GEN(\JPC\8,0,0,7);
	if ATOM#THENYM then [ERROR(22); SKIPIT; return];
	RATOM;
	STATEMENT;
	if ATOM=ELSEYM then
		[P2:=PC;
		GEN(\JMP\7,0,0,7);
		FIX(P3);
		P3:=P2;
		RATOM;
		STATEMENT];
	FIX(P3);
	end;
REPSYM:	[P2:=PC;			\REPEAT STATEMENT
	repeat RATOM; STATEMENT until ATOM#^;;
	if ATOM#UNTSYM then [ERROR(28); SKIPIT; return];
	RATOM;
	BOOLEXP;
	GEN(\JPC\8,0,P2,7)];
WHILYM:	[RATOM;				\WHILE STATEMENT
	P2:=PC;
	BOOLEXP;
	P3:=PC;
	GEN(\JPC\8,0,0,7);
	if ATOM#DOSYM then [ERROR(23); SKIPIT; return];
	RATOM;
	STATEMENT;
	GEN(\JMP\7,0,P2,7);
	FIX(P3)];
RETSYM:	begin				\RETURN STATEMENT
	RATOM;
	for I:=0,STKLOD-1 do GEN(\DRP\40,0,0,0);
	if ATOM#ELSEYM & ATOM#OTHSYM & ATOM#^; & ATOM#^] &
	    ATOM#ENDSYM & ATOM#UNTSYM then	\STORE THE RETURNED
		[BOOLEXP;		\ VALUE IN GLOBAL #0
		if FACTYP=INTEGER then GEN(\STO\3,0,0,10)
			else GEN(\STOF\$2B,0,0,10)];
	GEN(if OPTPROC then \RTS\39 else \RET\6,0,0,0);
	end;
LOOPYM:	begin				\LOOP STATEMENT
	SFIXS:=FIXCNT;
	RATOM;
	P2:=PC;
	SSTATEMENT(STKLOD);
	GEN(\JMP\7,0,P2,7);
	while FIXCNT>SFIXS do	\FIX THE JUMPS FOR THE 'QUIT'S
		[FIXCNT:=FIXCNT-1; FIX(FIXES(FIXCNT))];
	end;
FORSYM:	begin				\FOR STATEMENT
	RATOM;
	if ATYPE#IDENTIFIER then [ERROR(33); SKIPIT; return];
	LOOKUP;
	if IDTYPE=UNDEF then ERROR(10)
	else	[if IDTYPE#INVAR & IDTYPE#ADDRVAR then ERROR(33);
		SYMTAG(SYMNUM):=SYMTAG(SYMNUM)!$04;
		if (SYMTAG(SYMNUM)&$06) = $06 then WARNING(9)];
	SLEV:=LEV; SVAL:=VAL;
	RATOM;
	if ATOM#GETSYM then [ERROR(21); SKIPIT; return];
	RATOM;
	BOOLEXP;
	if FACTYP#INTEGER then ERROR(47);
	GEN(\STO\3,SLEV,SVAL,10);

	DOWNTO:= false;
	if ATOM=TOSYM ! ATOM=^, then []
	else if ATOM=DOWNYM then DOWNTO:= true
	else [ERROR(24); SKIPIT; return];

	RATOM;
	BOOLEXP;
	if FACTYP#INTEGER then ERROR(47);
	if ATOM#DOSYM then [ERROR(23); SKIPIT; return];
	GEN(\LOD\1,SLEV,SVAL,10);
	P2:=PC;
	GEN(if DOWNTO then \FORD\$49 else \FOR\24, 0, 0, 7);
	RATOM;
	STKLOD:=STKLOD+1;
	STATEMENT;
	STKLOD:=STKLOD-1;
	GEN(if DOWNTO then \DEC\$4A else \INC\25, SLEV, SVAL, 10);
	GEN(\JMP\7,0,P2,7);
	FIX(P2);
	\NOTE: THE INTERPRETER SPEEDS UP THINGS BY ASSUMING THAT "INC" OR "DEC"
	\ WILL ALWAYS BE FOLLOWED BY A "JMP" GOING BACK TO THE "FOR"
	end;
EXITYM:	[RATOM;				\EXIT STATEMENT
	if ATOM#ELSEYM & ATOM#OTHSYM & ATOM#^; & ATOM#^] &
	    ATOM#ENDSYM & ATOM#UNTSYM then	\STORE THE RETURNED
		[BOOLEXP;			\ VALUE IN GLOBAL #0
		if FACTYP=INTEGER then GEN(\STO\3,0,0,10)
			else GEN(\STOF\$2B,0,0,10)];
	GEN(\EXT\0,0,0,0)];
ELSEYM:	[];				\NULL STATEMENT
OTHSYM:	[];
^;:	[];
^]:	[];
ENDSYM:	[];
UNTSYM:	[];
EOF:	[]		\(THIS IS MOSTLY AN ACADEMIC POINT)
other	ASSIGN;
end;	\STATEMENT


begin	\SSTATEMENT
\TRICK TO ADJUST STACK (WITH DRP'S) WHEN A 'QUIT' IS IN
\ A 'CASE' STATEMENT.
STATEMENT;
end;


proc	PROCEDURE; int SSNOX;	\"SSNO" FROM "PROCDEC" FOR OPTIMIZED PROCS
int	SLEVEL,		\SAVE LEVEL (COMPLICATED BY OPTIMIZED PROCEDURES)
	P1,DX,		\HEAP SPACE REQUIREMENT COUNTER, unsigned
	DXOFF,		\VARIABLE'S OFFSET FROM BASE, unsigned
	FPBASE,		\PC AT END OF DECLARATIONS
	FPROCNT;	\COUNT OF PENDING FORWARD PROCEDURES


proc	EATARGS;	\SKIP ARGUMENTS IN PARENTHESIS
begin
if ATOM=^( then
	begin
	loop	[if CHAR=^) then quit;
		if CHAR=$0D\CR\ then [ERROR(44); quit];
		GETCH];
	GETCH; RATOM;
	end;
end;	\EATARGS


proc	CODDEC;		\DECLARE INTRINSIC NAMES
int	SID;
begin
SID:=ININT;		\DEFAULT IS INTEGER INTRINSIC
RATOM;
if ATOM=REALYM then [SID:=RLINT; RATOM]
	else if ATOM=INTSYM then RATOM;
if ATYPE#IDENTIFIER then ERROR(45);
while ATYPE=IDENTIFIER do
	[RATOM;
	EATARGS;
	if ATOM#^= then ERROR(40);
	RATOM;
	GETCON; if FACTYP#INTEGER then ERROR(47);
	if IATOM<0 ! IATOM>127 then ERROR(7);
	INSERT(SID,LEVEL,IATOM);
	RATOM;
	if ATOM=^, then RATOM];
if ATOM#^; then ERROR(41) else RATOM;
end;	\CODDEC


proc	CONDEC;		\DECLARE CONSTANT NAMES
int	CNTR,SSNO,F1,F2;
begin
F1:=false; F2:=false;
RATOM;
CNTR:=0;
if ATYPE#IDENTIFIER then ERROR(45);
while ATYPE=IDENTIFIER do
	begin
	RATOM;
	if ATOM#^= then [INSERT(INCON,LEVEL,CNTR); CNTR:=CNTR+1; F1:=true]
	else	begin
		SSNO:=NOSYM;
		INSERT(INCON,LEVEL,NORLSY);	\INSERT ID NOW
		RATOM;				\ FIX UP PARMS LATER
		CONEXPRESS;
		if FACTYP=INTEGER then SYMVAL(SSNO):=IATOM
		else	\FACTYP=REAL
			[SYMTYP(SSNO):=RLCON;
			if NORLSY>=RLMAX then
				[ERROR(2); NORLSY:=RLMAX-1];
			RLTBL(NORLSY):=RLATOM;
			NORLSY:=NORLSY+1];
		F2:=true;
		end;
	if ATOM=^, then RATOM else if ATOM#^; then WARNING(5);
	end;
if ATOM#^; then ERROR(41) else RATOM;
if F1 & F2 then WARNING(6);
end;	\CONDEC



proc	VARDEC; int TYPE;  \DECLARE VARIABLES--INT, REAL & ADDR
int	SDX,DIMS,T,ST;
begin
RATOM;
if ATYPE#IDENTIFIER then ERROR(45);
OPTPROC:=false;
while ATYPE=IDENTIFIER do
	begin
	INSERT(TYPE,LEVEL,DXOFF);
	SDX:=DXOFF;
	DXOFF:=DXOFF +(if TYPE=RLVAR then RLSIZE else 2);
	DX:=DX +(if TYPE=RLVAR then RLSIZE else 2);
	T:=if TYPE=RLVAR then RLSIZE else 2;
	ST:= T;
	if TYPE=ADDRVAR then ST:=1;
	RATOM;
	if ATOM=^( then		\GET DIMENSIONS OF AN ARRAY
		begin
		if DX#0 then [GEN(\HPI\9,0,DX,3); DX:=0];
		DIMS:= 0;
		loop	begin
			RATOM;
			CONEXPRESS;
			if FACTYP#INTEGER then ERROR(47);
			\PUSH SIZES OF EACH DIMENSION ON STACK
			GENIMM(IATOM);
			DIMS:= DIMS +1;
			if ATOM # ^, then	\last dimension of char array is
				begin		\ only a single byte per entry
				if ST=1 then T:=T>>1;
				T:=T*IATOM;
				DXOFF:=DXOFF+T;
				quit;
				end;
			T:=T*IATOM;    \ACCUMULATE BYTE COUNT FOR EACH DIMENSION
			DXOFF:=DXOFF+T;	\OFFSET FROM BASE
			end;
		if ATOM#^) then ERROR(44) else RATOM;
		\GEN CODE TO SET UP ARRAY AT RUN TIME
		\GEN CALL MakeArray([3, 5, 7, 10], 4, 2, addr ArrayName);
		GENIMM(DIMS);		\NUMBER OF DIMENSIONS
		GENIMM(ST);		\NUMBER OF BYTES IN EACH ELEMENT
		GEN(\ADR\33,LEVEL,SDX,10); \ADDRESS OF POINTER TO ARRAY
		GEN(\ARY\$48,0,0,0);
		end;
	if ATOM=^, then RATOM;
	end;
if ATOM#^; then ERROR(41) else RATOM;
end;	\VARDEC



procedure SEGDEC;	\DECLARE SEGMENT VARIABLES
begin
RATOM;
case ATOM of
  SHTSYM: VARDEC(SHSEG);
  INTSYM: VARDEC(INSEG);
  REALYM: VARDEC(RLSEG);
  ADRSYM,CHARYM: VARDEC(ADSEG)
other ERROR(72);
end;


proc	EXTDEC; int I2L;\DECLARE EXTERNAL PROCEDURES
int	SID;
begin
\HANDLE I2L VS. ASSEMBLY TYPE EXTERNAL
\ THE DEFAULT IS INTEGER EXTERNAL
SID:=if I2L then INEPRO else INEXT;

\HANDLE REAL VS INTEGER PROCEDURE
RATOM;
if ATOM=REALYM then [SID:=if I2L then RLEPRO else RLEXT; RATOM]
	else if ATOM=INTSYM then RATOM;
if ATYPE#IDENTIFIER then ERROR(45);
while ATYPE=IDENTIFIER do
	[INSERT(SID,LEVEL,IATOM);
	RATOM;
	EATARGS;
	if ATOM=^, then RATOM];
if ATOM#^; then ERROR(41) else RATOM;
end;	\EXTDEC


proc	FPRDEC; int OPTYPE;	\DECLARE FORWARD REFERENCED PROCEDURES
int	SID;
begin
SID:=INFPROC;		\DEFAULT IS INTEGER FORWARD PROCEDURE
RATOM;
if ATOM=REALYM then [SID:=RLFPROC; RATOM]
	else if ATOM=INTSYM then RATOM;
if ATYPE#IDENTIFIER then ERROR(45);
while ATYPE=IDENTIFIER do
	[RATOM;
	INSERT(SID,LEVEL,PC);
	GEN(\JMP\7,0,PC,OPTYPE);
	FPROCNT:=FPROCNT+1;
	EATARGS;
	if ATOM=^, then RATOM];
if ATOM#^; then ERROR(41) else RATOM;
end;	\FPRDEC


proc	PROCDEC; int CANOPT,PUBLIC;		\DECLARE PROCEDURE NAMES
int	SNOSYM,HASH,I,K,SID,SSNO,SNORL;
begin
SID:=INPROC;			\TYPED PROCEDURE (FOR FUNCTIONS)
RATOM;
if ATOM=REALYM then [SID:=RLPROC; RATOM]
else if ATOM=INTSYM then RATOM;
if ATYPE#IDENTIFIER then ERROR(45) else LOOKUP;
if IDTYPE=INFPROC ! IDTYPE=RLFPROC then
	\PROCEDURE HAS BEEN PREVIOUSLY DECLARED BY A 'FPROC' OR 'FFUNCT'
	[if LEVEL#LEV then ERROR(65);
	FIX(VAL);	\('FPROC' & 'PROC' MUST BE SAME SCOPE)
	SYMVAL(SYMNUM):=PC;
	SYMTYP(SYMNUM):=if IDTYPE=INFPROC then INPROC
		else RLPROC;
	if SID#SYMTYP(SYMNUM) then \MIXED MODE\ ERROR(46);
	if VAL>=FPBASE then FPROCNT:=FPROCNT-1;
	OPTPROC:=false]
else [SSNO:=NOSYM; INSERT(SID,LEVEL,PC); OPTPROC:=CANOPT];

\HANDLE PUBLIC PROCEDURES
if PUBLIC then [CHOUT(BINDEV,^%); SYMOUT(NOSYM-1)];

\ASSUME FOR NOW THAT PROCEDURE IS NOT OPTIMIZED AND MOVE DOWN A LEVEL
SLEVEL:=LEVEL;
LEVEL:=LEVEL+2; if LEVEL>14 then ERROR(5);
					\EAT THE ARGUMENT LIST AS A COMMENT
while CHAR#^; & CHAR#\CR\$0D do GETCH;	\SPECIAL COMMENT STOPS ON CR
if CHAR#^; then ERROR(41);

GETCH; RATOM;

SNOSYM:=NOSYM; SNORL:=NORLSY;
PROCEDURE(SSNO);	\PASS LOCATION OF PROC NAME IN CASE IT'S OPTIMIZED
CHKUSE(SNOSYM);
if ATOM#^; then ERROR(41) else RATOM;

while NOSYM>SNOSYM do	\RESTORE SYMBOL TABLE TO PREVIOUS LEVEL
\I.E. REMOVE THE IDENTIFIERS WHICH WERE LOCAL TO THIS PROCEDURE
	begin
	NOSYM:=NOSYM-1;
	HASH:=0;
	K:=NOSYM;
	for I:=0,SIGCHAR-1 do
		[HASH:=HASH+SYMBOL(K); K:=K+SYMAX];
	BOX(HASH&HASHMSK):=SYMPNT(NOSYM);
	end;
NORLSY:=SNORL;
LEVEL:=SLEVEL;
end;	\PROCDEC


begin	\PROCEDURE
DXOFF:= if LEVEL=0 then RLSIZE else 0; \SAVE HEAP SPACE FOR RETURN
DX:= DXOFF;

repeat
   loop	case ATOM of
	INTSYM:	VARDEC(INVAR);
	ADRSYM:	VARDEC(ADDRVAR);
	CHARYM:	VARDEC(ADDRVAR);
	REALYM:	VARDEC(RLVAR);
	CODSYM:	CODDEC;
	EXTNYM:	EXTDEC(false);
	DEFSYM:	CONDEC;
	SEGSYM: SEGDEC;
	EPRSYM, EFUNYM:	if LEVEL=0 then EXTDEC(true)
			else [ERROR(68); SKIPIT]
	other	quit;

   P1:=PC;
   GEN(\JMP\7,0,0,7);

   FPROCNT:=0;
   FPBASE:=PC;
   loop	case ATOM of
	PUBSYM: [if LEVEL#0 then ERROR(68);
		RATOM;
		case ATOM of PROCYM,FUNSYM:PROCDEC(false,true)
		else ERROR(67)];
	PROCYM,FUNSYM:	PROCDEC(true,false);
	FPRSYM,FFUNYM:	FPRDEC(7)
	other	quit;

   \IF THERE IS NOTHING TO JUMP OVER THEN ELIMINATE THE JUMP
   if PC=P1+3 then PC:=P1 else FIX(P1);

until	ATOM#INTSYM & ATOM#ADRSYM & ATOM#CHARYM & ATOM#REALYM & ATOM#CODSYM &
	ATOM#EXTNYM & ATOM#DEFSYM & ATOM#SEGSYM & ATOM#EPRSYM & ATOM#EFUNYM;

\RESERVE SPACE FOR LOCAL VARIABLES
if DXOFF#0 then		\note that a dimensioned array can make DX # DXOFF
	[OPTPROC:=false;
	if DX#0 then GEN(\HPI\9,0,DX,3)];
if OPTPROC then
	[SYMTYP(SSNOX):= if SYMTYP(SSNOX)=INPROC then INOPT else RLOPT;
	LEVEL:=LEVEL-2];	\SAME LEVEL AS NESTING PROCEDURE (TRICKY!)

SSTATEMENT(STKLOD);	\(STKLOD WILL ALWAYS BE ZERO HERE)

GEN(if OPTPROC then \RTS\39 else \RET\6,0,0,0);

if FIXCNT#0 then \SOME 'QUIT'S NOT IN A 'LOOP'\ ERROR(60);
if FPROCNT#0 then \UNRESOLVED FWD REFERENCES\ ERROR(66);
end;	\PROCEDURE

\------------------------ ROUTINES TO OPEN DOS FILES ---------------------------

proc	DOSOPEN;
int	CPUREG, PSPSEG, DATASEG, P, T;
char	CMDTAIL;

	func	GETSWT;		\FIND, REMOVE AND RETURN A SWITCH
	int	P, T;
	begin
	for P:= 1, CMDTAIL(0) do
	    if CMDTAIL(P)=^/ then
		begin
		CMDTAIL(P):= $20;
		if P < CMDTAIL(0) then
			begin
			T:= CMDTAIL(P+1);
			if T>=^a & T<=^z then T:= T-$20; \MAKE UPPERCASE
			CMDTAIL(P+1):= $20;
			return T;
			end;
		end;
	return 0;
	end;	\GETSWT


	proc	PARSE;		\PARSE COMMAND TAIL AND SET I/O HANDLES
	char	EXTIN, EXTOUT;
	int	P, EXTFLG, I;
	begin
	EXTIN:= ".XPL";   EXTOUT:= ".I2L";
	P:= 1;
	EXTFLG:= false;
	loop	begin			\PARSE COMMAND TAIL FOR EXTENSION
		if CMDTAIL(P) = ^. then
			begin
			EXTFLG:= true;
			quit;
			end;
		if CMDTAIL(P) = ^; then quit; \IGNORE SEMICOLON
		P:= P +1;
		if P > CMDTAIL(0) then quit;
		end;

	if not EXTFLG then			\SET EXTENSION AND INPUT HANDLE
		for I:= 0, 3 do CMDTAIL(P+I):= EXTIN(I);
	INHAND:= FOPEN(CMDTAIL+1, 0);

	for I:= 0, 3 do CMDTAIL(P+I):= EXTOUT(I); \SET EXTENSION & OUTPUT HANDLE
	OUTHAND:= FOPEN(CMDTAIL+1, 1);
	end;	\PARSE


begin	\DOSOPEN
CMDTAIL:= RESERVE($80+4);	\GET COMMAND TAIL FROM PSP
CPUREG:= GETREG;
PSPSEG:= CPUREG(11);
DATASEG:= CPUREG(12);
BLIT(PSPSEG, $80, DATASEG, CMDTAIL, $80);

loop	begin				\HANDLE SWITCHES
	T:= GETSWT;
	case T of
	  ^L:  DEVICE(1):=0;
	  ^D:  [DEVICE(1):=0; DEBFLG:=true];
	  ^W:  WARNFLAG:=true;
	   0:	quit			\NO MORE SWITCHES ON COMMAND LINE
	other	[TEXT(TV,"UNRECOGNIZED SWITCH: /"); CHOUT(TV, T); CRLF(TV); exit 1];
	end;
PARSE;					\PARSE COMMAND LINE AND SET HANDLES
FSET(INHAND, ^I);
FSET(OUTHAND, ^O);
end;	\DOSOPEN

\-------------------------------------------------------------------------------

begin	\MAIN
IDENT:=RESERVE(SIGCHAR);
FIXES:=RESERVE(2*QUITMAX);
SYMBOL:=RESERVE(SIGCHAR*SYMAX);	\SYMBOL TABLE
SYMTYP:=RESERVE(SYMAX);
SYMLEV:=RESERVE(SYMAX);
SYMVAL:=RESERVE(SYMAX*2);
SYMTAG:=RESERVE(SYMAX);
SYMPNT:=RESERVE(SYMAX*2);
BOX:=RESERVE(BOXNUM*2);		\HASH TABLE
RLTBL:=RLRES(RLMAX);
HEXDIGIT:="0123456789ABCDEF ";

\FOR INCLUDE FILES
OLDHAN:=RESERVE(HANMAX*2);
HANPTR:=0;

TEXT(TV,"
-- XPL0 INTERPRETED COMPILER, VER I2.7 --
       COPYRIGHT 2010 P.J.R. BOYLE

XPL0 comes with ABSOLUTELY NO WARRANTY.
This is free software. You are welcome and encouraged to redistribute
it under certain conditions. For details see LICENSE.TXT.
");

DEVICE:=[3,8,3];	\SET DEFAULT CHANNELS

DEBFLG:=false;		\OPEN DOS FILES
WARNFLAG:=false;
DOSOPEN;

BINDEV:=DEVICE(0); LSTDEV:=DEVICE(1); SRCDEV:=DEVICE(2);
OPENO(BINDEV); OPENO(LSTDEV); OPENI(SRCDEV);
CRLF(TV);
PC:=0; LEVEL:=0;			\INITIALIZE SOME STUFF
OLDPC:=$FFFF; STKLOD:=0; NOSYM:=0; NORLSY:=0; FIXCNT:=0;
for II:=0,BOXNUM-1 do BOX(II):=EMTPTR;	\ZERO THE SYMBOL TABLE
ERRCNT:=0;
CONDITIONAL:= true;

GETCH; RATOM;
OPTPROC:=false;		\(FOR 2 REASONS)
PROCEDURE(0);		\COMPILE MAIN PROCEDURE, I.E. THE PROGRAM
CHKUSE(0);
while ATOM=^; do RATOM;
if ATOM#EOF then \MORE CODE AFTER END\ [ERROR(61); PROCEDURE(0)];
CHOUT(BINDEV,^$);

TEXT(LSTDEV,"
PROGRAM LENGTH:  "); INTOUT(LSTDEV,PC+1); TEXT(LSTDEV,"
ERRORS DETECTED: "); INTOUT(LSTDEV,ERRCNT); CRLF(LSTDEV);
CRLF(TV);

CHOUT(BINDEV,EOF);
CLOSE(BINDEV);
CHOUT(LSTDEV,EOF);
CLOSE(LSTDEV);

FCLOSE(OUTHAND);	\CLOSE DOS FILES
FCLOSE(INHAND);
return if ERRCNT#0 then 1 else 0;
end;	\MAIN
