	PAGE

;FLOATING POINT OPCODES USING SOFTWARE EMULATION

;TOS:=NOS + TOS

FADDDO	PROC	FAR
	CALL	FLTSET		;SET UP ARGUMENTS
	CALL	FADDE
	JMP SHORT FLTEXT	;CLEAN UP AND EXIT
FADDDO	ENDP


;TOS:=NOS - TOS

FSUBDO	PROC	FAR
	CALL	FLTSET		;SET UP ARGUMENTS
	CALL	FSUBE
	JMP SHORT FLTEXT	;CLEAN UP AND EXIT
FSUBDO	ENDP
	PAGE


;TOS:=NOS * TOS

FMULDO	PROC	FAR
	CALL	FLTSET		;SET UP ARGUMENTS
	CALL	FMULE
	JMP SHORT FLTEXT	;CLEAN UP AND EXIT
FMULDO	ENDP


;TOS:=NOS / TOS

FDIVDO	PROC	FAR
	CALL	FLTSET		;SET UP ARGUMENTS
	CALL	FDIVE
	JMP SHORT FLTEXT	;CLEAN UP AND EXIT
FDIVDO	ENDP
	PAGE

;SETUP FOR FLOATING POINT OPCODE

FLTSET:	MOV	SISAVE,SI	;SAVE CRITICAL REGISTERS
	MOV	DISAVE,DI
	MOV	DI,DS		;SET UP ES FOR STRING OPS
	MOV	ES,DI

	MOV BYTE PTR  FSTAT,0	;FLAG NO ERRORS
	MOV	SI,SP		;POINT TO TOS
	ADD	SI,TOSOFF+2	;SKIP TWO RETURN ADDRESSES

	MOV DI,OFFSET FACT2	;POINT TO FACT2
	CALL	FLOAD		;LOAD IT

	MOV	SI,SP		;POINT TO NOS
	ADD	SI,RLNOS+2	;(SKIP TWO RETURN ADDRESSES)
	MOV DI,OFFSET FACT1	;POINT TO FACT1
	CALL	FLOAD		;LOAD IT

	JMP	SETFAG		;MAKE FACT1/FACT2 ARGUMENTS

;FLOATING INTRINSIC EXIT FOR SINGLE ARGUMENT OPERATIONS

FLTXTA:	MOV	DI,SP		;GET STACK POINTER
	ADD	DI,TOSOFF	;POINT TO TOS (REAL)
	MOV SI,OFFSET FACT1	;POINT TO FACT1
	CALL	FSTORE		;STORE RESULT
	CALL	FLTERR		;HANDLE ANY ERRORS

	XOR	DI,DI		;RESTORE ES = 0
	MOV	ES,DI
	MOV	DI,DISAVE	;RESTORE CRITICAL REGISTERS
	MOV	SI,SISAVE
	RETF

;FLOATING OPCODE EXIT FOR DOUBLE ARGUMENT OPERATIONS

FLTEXT:	MOV	DI,SP		;GET STACK POINTER
	ADD	DI,RLNOS	;POINT TO NOS (REAL)
	MOV SI,OFFSET FACT1	;POINT TO FACT1
	CALL	FSTORE		;STORE RESULT
	CALL	FLTERR		;HANDLE ANY ERRORS

	XOR	DI,DI		;RESTORE ES = 0
	MOV	ES,DI
	MOV	DI,DISAVE	;RESTORE CRITICAL REGISTERS
	MOV	SI,SISAVE
	RETF	8		;DROP TOS

;HANDLE FLOATING POINT ERRORS

FLTERR:	CMP	ERRNUM,0	;ALREADY HAVE AN ERROR?
	JNZ	FLEEXT		;THEN EXIT
	TEST BYTE PTR FSTAT,1CH	;ANY ERRORS WE CARE ABOUT?
	JZ	FLEEXT		;SKIP IF NOT

	TEST BYTE PTR FSTAT,04H	;DIVIDE BY ZERO?
	JZ	FLEXT1		;SKIP IF NOT
	MOV	AL,DIVZER	;FLAG IT
	JMP SHORT FLEXT3

FLEXT1:	TEST BYTE PTR FSTAT,08H	;OVERFLOW?
	JZ	FLEXT2		;SKIP IF NOT
	MOV	AL,FOVFL	;FLAG IT
	JMP SHORT FLEXT3

FLEXT2:	MOV	AL,FUNFL	;MUST BE UNDERFLOW
FLEXT3:	CALL	ERROR		;HANDLE THE ERROR
FLEEXT:	RET


	PAGE

;TOS:= NOS = TOS

FEQDO	PROC	FAR
	CALL	CMPSET
	JE	TRUEF
	JMP SHORT FLASEF
FEQDO	ENDP


;TOS:= NOS # TOS

FNEDO	PROC	FAR
	CALL	CMPSET
	JNE	TRUEF
	JMP SHORT FLASEF
FNEDO	ENDP


;TOS:= NOS >= TOS

FGEDO	PROC	FAR
	CALL	CMPSET
	JAE	TRUEF
	JMP SHORT FLASEF
FGEDO	ENDP


;TOS:= NOS > TOS

FGTDO	PROC	FAR
	CALL	CMPSET
	JA	TRUEF
	JMP SHORT FLASEF
FGTDO	ENDP
	PAGE


;TOS:= NOS <= TOS

FLEDO	PROC	FAR
	CALL	CMPSET
	JBE	TRUEF
	JMP SHORT FLASEF
FLEDO	ENDP


;TOS:= NOS < TOS

FLTDO	PROC	FAR
	CALL	CMPSET
	JB	TRUEF
	JMP SHORT FLASEF
FLTDO	ENDP


;HANDLE TRUE RESULT
;PUT TRUE VALUE UNDER EVERYTHING

TRUEF:	MOV	BP,SP
	MOV [BP]+LSTWRD,WORD PTR TRUVAL
	RETF	14

;HANDLE FALSE RESULT
;PUT FALSE VALUE UNDER EVERYTHING

FLASEF:	MOV	BP,SP
	MOV [BP]+LSTWRD,WORD PTR FALVAL
	RETF	14


;SETUP AND COMPARE TOS AND NOS, RETURNS STATUS

CMPSET:	MOV	SISAVE,SI	;SAVE CRITICAL REGISTERS
	MOV	DISAVE,DI
	MOV	DI,DS		;SET UP ES FOR STRING OPS
	MOV	ES,DI

	MOV	DI,SP		;POINT TOS
	ADD	DI,TOSOFF+2	;SKIP RETURN TWO ADDRESSES
	MOV	SI,DI		;POINT TO NOS
	ADD	SI,RELSIZ
	CALL	FCMP		;DO THE COMPARE

;DON'T ALTER STATUS
	MOV	DI,0		;RESTORE ES = 0
	MOV	ES,DI
	MOV	DI,DISAVE	;RESTORE CRITICAL REGISTERS
	MOV	SI,SISAVE
	RET
	PAGE

;INTRINSIC ROUTINES USING SOFTWARE EMULATION

;49
;REAL:=FLOAT(INTEGER)
;CONVERT THE INTEGER ON TOS TO A FLOATING POINT NUMBER
;(NOTE: THIS IS COMPILED AS AN REAL INTRINSIC
; WITH TOS ON STACK)

INTR49	LABEL	FAR
FLTFUN	PROC	FAR
	POP WORD PTR RETTMP	;SAVE RETURN
	POP WORD PTR RETTMP+2
	POP	BX		;GET THE NUMBER
	CALL	FLOAT		;FLOAT IT
	PUSH	AX		;PUSH SIGN, EXP, MANTISSA
	PUSH	BX		;PUSH MANTISSA
	XOR	CX,CX		;GET A ZERO
	PUSH	CX		;REST OF MANTISSA IS ZERO
	PUSH	CX
	JMP	RETTMP		;RETURN
FLTFUN	ENDP


;50
;INTEGER:=FIX(REAL)
;CONVERT REAL ON TOS TO NEAREST INTEGER
;(NOTE: THIS IS COMPILED AS AN INTEGER INTRINSIC
; WITH TOS IN AX)

INTR50	LABEL	FAR
FIXFUN	PROC	FAR
	MOV	BP,SP			;GET STACK FRAME
	MOV	BX,[BP]+TOSOFF+2	;GET M2
	MOV	AX,[BP]+TOSOFF+4	;GET SIGN, EXP, MANTISSA
	CALL	FIX
	JNC	FIXFN1		;SKIP IF NO ERROR
	MOV	AL,INOVFL	;GET ERROR NUMBER
	CALL	ERROR		;HANDLE ERROR
	MOV	BX,7FFFH	;MAKE BIG INTEGER
FIXFN1:	MOV	AX,BX		;PUT RESULT IN TOS
	RET	6		;DROP ARGS
FIXFUN	ENDP
	PAGE

;*********************************************
;****** TRANSCENDENTAL INTRINSICS ************
;*********************************************

;53
;TOS:=SQRT(TOS)

INTR53	LABEL	FAR
FLSQRT	PROC	FAR
	CALL	STFONE		;DO SET UP
	CALL	FSQRTE		;DO SQUARE ROOT
	JMP	FLTXTA		;CLEAN UP AND EXIT
FLSQRT	ENDP

;54
;TOS:=LN(TOS)

INTR54	LABEL	FAR
FLLN	PROC	FAR
	CALL	STFONE		;DO SET UP
	CALL	LOGN		;DO NATURAL LOG
	JMP	FLTXTA		;CLEAN UP AND EXIT
FLLN	ENDP

;55
;TOS:=EXP(TOS)

INTR55	LABEL	FAR
FLEXP	PROC	FAR
	CALL	STFONE		;DO SET UP
	CALL	FEXP		;DO EXP
	JMP	FLTXTA		;CLEAN UP AND EXIT
FLEXP	ENDP

;56
;TOS:=SIN(TOS)

INTR56	LABEL	FAR
FLSIN	PROC	FAR
	CALL	STFONE		;DO SET UP
	CALL	FSINE		;DO SINE
	JMP	FLTXTA		;CLEAN UP AND EXIT
FLSIN	ENDP

;57
;TOS:=ATAN(NOS/TOS)

INTR57	LABEL	FAR
FLAT2	PROC	FAR
	CALL	FLTSET		;SET UP ARGUMENTS
	CALL	ATAN2		;DO ARC TAN
	JMP	FLTEXT		;CLEAN UP AND EXIT
FLAT2	ENDP
	PAGE

;58
;TOS:=NOS MOD TOS

INTR58	LABEL	FAR
FLMOD	PROC	FAR
	CALL	FLTSET		;SET UP ARGUMENTS
	CALL	FMOD		;DO MODULO
	JMP	FLTEXT		;CLEAN UP AND EXIT
FLMOD	ENDP


;59
;TOS:=LOG(TOS)

INTR59	LABEL	FAR
FLLOG	PROC	FAR
	CALL	STFONE		;DO SET UP
	CALL	LOGTEN		;DO LOG
	JMP	FLTXTA		;CLEAN UP AND EXIT
FLLOG	ENDP


;60
;TOS:=COS(TOS)

INTR60	LABEL	FAR
FLCOS	PROC	FAR
	CALL	STFONE		;DO SET UP
	CALL	FCOSE		;DO COSINE
	JMP	FLTXTA		;CLEAN UP AND EXIT
FLCOS	ENDP


;61
;TOS:=TAN(TOS)

INTR61	LABEL	FAR
FLTAN	PROC	FAR
	CALL	STFONE		;DO SET UP
	CALL	FTAN		;DO TAN
	JMP	FLTXTA		;CLEAN UP AND EXIT
FLTAN	ENDP


;62
;TOS:=ASIN(TOS)

INTR62	LABEL	FAR
FLASIN	PROC	FAR
	CALL	STFONE		;DO SET UP
	CALL	ASIN		;DO ASIN
	JMP	FLTXTA		;CLEAN UP AND EXIT
FLASIN	ENDP
	PAGE

;63
;TOS:=ACOS(TOS)

INTR63	LABEL	FAR
FLACOS	PROC	FAR
	CALL	STFONE		;DO SET UP
	CALL	ACOS		;DO ACOS
	JMP	FLTXTA		;CLEAN UP AND EXIT
FLACOS	ENDP


;ROUTINE TO SETUP FOR A SINGLE ARGUMENT FUNCTION

STFONE:	MOV	SISAVE,SI	;SAVE CRITICAL REGISTERS
	MOV	DISAVE,DI
	MOV	DI,DS		;SET UP ES FOR STRING OPS
	MOV	ES,DI

	MOV	SI,SP		;POINT TOS
	ADD	SI,TOSOFF+2	;SKIP OVER TWO RETURN ADDRESSES
	MOV	DI,OFFSET FACT1	;POINT FACT1
	JMP	FLOAD		;LOAD IT
