\XPLPX.XPL	20-Feb-2010
\Optimized 32-Bit XPL0 Compiler
\Copyright 1984, 2010 P.J.R. Boyle
\IBM-PC native language version by Larry Fish
\32-bit protected mode and floating point by Loren Blaney
\
\This program is free software; you can redistribute it and/or modify it under
\ the terms of the GNU General Public License version 2 as published by the
\ Free Software Foundation.
\This program is distributed in the hope that it will be useful, but WITHOUT
\ ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
\ FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
\ details.
\You should have received a copy of the GNU General Public License along with
\ this program (in the file LICENSE.TXT); if not, write to the Free Software
\ Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\
\You can reach the authors at: loren.blaney@idcomm.com
\
\REVISIONS:
\May-91, 32-bit version for 80386+80387 (or better)
\Sep-23-93, Lowercase names
\Feb-16-94, Display include files indented according to level. Add constant
\ calculations. Fix problem with more than 64K of eprocs.
\V2.2 Feb-28-95, 16 sig chars in a name; '_' in front of public & external
\ names; comments in parenthesis allowed after all external procedure
\ declarations; 'addr' operator handles arrays; 'exit' statement can return
\ a value; etc.
\V2.2._ Jun-21-95, External assembly routines do not get underline prefix.
\V2.2.3 Nov-14-96, Consolidated versions.
\V3.0 Jul-20-99, Protected mode version. Allow lowercase 'e' in reals.
\V3.0.1 10-Feb-2001, 1600 symbol names, 160 'quit's and real constants.
\ Ignore ";" on command line. Fix /A & /L switches.
\V3.0.2 29-Jun-2001, Compensate for new way Windows handles pathnames.
\V3.1 11-Jan-2005, Merged XPLX 2.4.4 with XPLP 3.0.2. Allow 'public' forward
\ procedures. EDI register is the heap pointer (HP); ESI is devoted to local
\ variables. Short-circuit booleans. Fixed "~" in constant calculations. /2 &
\ /4 aligns procedures. Inline abs, rem, swap, ext and port functions. Allow
\ pathnames in input files. Fix bugs caused by aligning arrays on word
\ boundaries and declaring arrays totalling more than 32K. Fix abs($80000000)
\ infinite loop. Reduced number of CR,LF pairs from 26 to 20 because MASM 6.11
\ can't handle it. Truncate reserved word atom to 16 bits. Fix bug involving
\ 'for' loop control variable at intermediate level. Inline fix, float & sqrt.
\ Fix global declared arrays in a split heap. Numerous little speed ups. Paint
\ intrinsic (81). Fix bug: char A; A(0):= $1FF. IMUL with two operands does not
\ bomb EDX. Added 'string' directive to enable null-terminated strings. Fix bug
\ in local declared char arrays.
\V3.2 12-Mar-2005, Fix bug: "if T>0.0 & T<1.0 then" accepts T=-19.0 as true.
\V3.2.1 29-Mar-2005, Fix tiny bug where DO_IMM_STK called OPSTRING without all
\ the proper arguments, but it didn't cause a compile error.
\V3.3 31-Dec-2005, Inline assembly code ('asm').
\V3.3.1 27-May-2006, Fix bug in GENFIX. E.G: "CT(3):= fix(60.0-Am) + 5".
\V3.3.2 16-Jul-2006, Optimize code generated for arrays. Accept "^Z" in strings
\ (but not an actual ^Z). Flag integer-expected error for Real & Int.
\V3.3.3 8-Sep-2006, Fix bug revealed by optimizing arrays in V3.3.2 GENLDX.
\ S(I-1) is generated as S(I) when S is type char. Also I+1, I*2, -I, ~I,
\ abs I, etc.
\V3.3.4 23-Apr-2007, Inline sqrt works for both reals and integers. /R switch
\ enables SAR instead of SHR. Fix bug when dividing by a 'for' loop control
\ variable. Don't flag EOF error for null strings ("") when conditional compile
\ is false.
\V3.3.5 17-Mar-2008, Added binary notation (e.g: $1e = %11110); underlines are
\ allowed in numbers (123_456.78); variables can be declared after procedures;
\ add GetTime and Backup intrinsics; optimize multiplication by powers of 2.
\ The functions abs, sq, sqrt, swap, fix, and float can be used in defines. Add
\ square function sq.
\V3.3.7 13-Jan-2010, Allow 'to' to replace ',' in 'for' loops; implement'downto'
\Command line switch /c makes identifer names case-sensitive (/i now outputs I2L
\ comments). Added arithmetic shift right operator "->>". Optimize some zero
\  results, etc. Option /w displays warning messages.
\V3.3.8 20-Feb-2010, Fix bug caused by optimizing zero results. Abort on internal
\ errors. Add command words 'and', 'or', 'xor'.

\WARNINGS:
\ESI and EDI must not be altered by an external assembly language subroutine.
\If this program is compiled by a 16-bit version of XPL (for some strange
\ reason) then the order of the bytes in the reals must be changed (see
\ GENFIMM and ARRAYCON). (Of course there is going to be a problem
\ attempting to compile 32-bit constants.)

code	ABS=0,		REM=2,		RESERVE=3,	SWAP=4,
	EXTEND=5,	CHIN=7,		CHOUT=8,	CRLF=9,
	INTIN=10,	INTOUT=11,	TEXT=12,	OPENI=13,
	OPENO=14,	CLOSE=15,	TRAP=17,	GETERR=22,
	FSET=24,	HEXOUT=27,	FOPEN=29,	FCLOSE=32,
	GETREG=35,	BLIT=36,	FIX=50;
code real		FLOAT=49,	RLRES=46,	SQRT=53;

def	INTSIZE=4,	\number of bytes in an integer
	SYMAX=1600,	\maximum number of symbols in symbol table
	SIGCHAR=16,	\no. of significant chars in an identifer
	HASHMASK=$FF,	\bit mask for hash codes
	EMPTYPTR=-1,	\empty symbol pointer for hash linked lists
	BOXNUM=256,	\number of hash boxes (= maximum no. of list headers)
	RLMAX=160,	\size of real-constant symbol table
	RLSIZE=8,	\no. of bytes in a real number
	QUITMAX=160,	\maximum no. of 'quit's in a 'loop'
	HANMAX=8,	\maximum nesting depth of include flles (file handles)
	STKMAX=100,	\maximum items on pseudo stack
	LEVELMAX=8;	\maximum number of static levels (0 thru levelmax-1)

def	TV=0, KB=0, NULDEV=7;			\I/O devices
def	BEL=$07, EOL=$0A, EOF=$1A;		\control characters

int	OPTIMIZE;	\type of alignment (see DOALIGN)
def	\OPTIMIZE\	OPT88,		\byte
			OPT286,		\word
			OPT386;		\dword

int	EAXIMM,		\flag: EAX register contains immediate value in EAXVAL
	EAXVAL,		\immediate value currently in EAX (if EAXIMM is true)
	EAXHI0,		\flag: high 24 bits of EAX register are all zeros
	EAXLEV,		\the EAX register contains the value of a variable at
	EAXOFF,		\ this level & offset
	SEAXIMM,	\saved EAXIMM & EAXLEV; used to restore EAXIMM & EAXLEV
	SEAXLEV,	\ after an optimized compare
	SEAXHI0,
	EDXLEV,		\EDX register shadows the variable at this level and
	EDXOFF,		\ offset (only used by 'for' loop control variable)
	EDXPEND,	\EDXLEV pending loop; even reading the 'for' loop
			\ control variable inside a nested loop bombs EDX
	HAVENEST,	\flag: the current procedure has a proc nested in it
	HAVESTAT,	\flag: processor status flags are valid for TOS
	STXFLAG,	\flag to optimize GENSTX procedure
	POSTGENTYPE,	\which MOV [EBX],postgenval must be generated (0=none)
	POSTGENVAL,	\MOV BYTE PTR [EBX]+POSTGENOFF,POSTGENVAL
	POSTGENOFF;

int	PSTKPTR,	\stack pointer for the following stacks (push=sto,inc)
	PSTKTYP,	\pseudo stack: holds stack argument type
	PSTKLEV,	\pseudo stack: holds level of addr argument or imm value
	PSTKOFF;	\pseudo stack: holds offset of addr argument or ^C or ^L
def	\types of pseudo-stack arguments:
	REGTYP,		\TOS in register EAX
	STKTYP,		\TOS is on h/w stack
	ADRTYP,		\TOS is in address (level, offset)
	IMMTYP,		\TOS is immediate value (^C=normal constant; ^L=label)
	REALTYP;	\TOS is a real on the FPU stack

int	CaseSensitive,	\switch (/c) case-sensitive identifer names
	I2LCOMFLAG,	\switch (/i): put I2L comments in output .asm file
	DEBUG,		\switch (/d): put XPL source code in output .asm file
	SHORTBOOL,	\switch (/b): use short-circuit boolean evaluation
	WARNFLAG,	\switch (/w): display warning messages (like errors)

	CODCTR,		\count of generated opcodes
	OLDCODCTR,	\used to insert crlf into debug listing
	HASMAIN,	\flag: there is a statement in the main procedure
	CONDITIONAL,	\flag: conditional compile
	STRTERM,	\flag: string termination (0=null, nonzero=MSB)
	LOCAL,		\counts and creates unique local labels (for jumps)
	OLDLEV,		\old static level (for determining when to load EBP reg)
	INHAND,		\input .xpl file handle
	OUTHAND;	\output .asm file handle

int	ERRCTR,		\count of compile errors detected
	LSTDEV,		\listing output device number
	SRCDEV,		\source input device number
	BINDEV,		\binary output device number
	CHAR,		\the current character.  most of the time this contains
			\ the terminator of the current atom
	ATOM,		\present atom descriptor
			\contains reserved word hash or the ASCII for a special
			\ character; = 0 if the atom is a constant or identifier
	ATYPE;		\present atom type descriptor
def	\ATYPE\ SPECIAL, IDENTIFIER, INTCON, REALCON;
char	IDENT;		\array: current identifier name
int	HASH,		\current identifier hash code
	LABCTR,		\label counter (Lxx:)
	IATOM;		\value of current integer constant (from proc RATOM)
real	RLATOM;		\value of current real constant (from proc RATOM)

int	IDTYPE;		\present identifier type descriptor
def	UNDEF=0,	\undefined ID
	ADDRVAR=1,	\address variable ID (type = integer)
	INVAR=3,	\integer variable ID (odd values=integer; even=real)
	RLVAR=4,	\real variable ID
	INCON=5,	\integer constant ID
	RLCON=6,	\real constant ID
	INPROC=7,	\integer procedure ID
	RLPROC=8,	\real procedure ID
	INFPROC=9,	\integer forward procedure ID
	RLFPROC=10,	\real forward procedure ID
	INOPT=11,	\integer optimized procedure ID
	RLOPT=12,	\real optimized procedure ID
	INEPRO=13,	\integer xpl external procedure
	RLEPRO=14,	\real xpl external procedure
	ININT=15,	\integer intrinsic ID
	RLINT=16,	\real intrinsic ID
	INEXT=17,	\integer asm external procedure ID
	RLEXT=18;	\real asm external procedure ID

int	LEV,		\static level of current identifier
	VAL,		\value or address of current identifier
	SYMNUM,		\position in SYMTBL of current identifer
	FACTYP;		\factor (or operand) type (REAL or INTEGER)
def	\FACTYP\ REAL, INTEGER;
int	PROCRETS,	\array: code labels for procedure returns for each level
	FIXES,		\array: 'quit' fixes still outstanding
	LEVEL,		\static level of current procedure (counts by 2's)
	NOSYM,		\current number of symbols in symbol table
	FIXCTR,		\count of the number of outstanding 'quit's
	STKLOD,		\number of integers left on stack by 'for' or 'case'
	OPTPROC,	\boolean: generate an optimized procedure call
	NORLSY,		\current number of real constants in RLTBL
	LASTOP,		\previous opcode
	II;		\scratch for Main
char	HEXDIGIT;	\array of hex digits (0..F)

\Symbol table arrays:
char	SYMBOL,		\identifier names (IDENT)
	SYMTYP,		\type descriptors (IDTYPE)
	SYMLEV,		\level (LEV)
	SYMTAG;		\tag used for warnings (/w) (0=name unused, 1=name used)
int	SYMVAL,		\value or address (VAL)
	SYMPTR,		\list linkage pointers
	BOX;		\hash boxes (symbol linked-list headers)
real	RLTBL;		\real constant table

int	HANPTR,		\pointer to old include handles
	OLDHAN;		\array of old include handles

\Reserved word hashes:
def	ADRSYM=$88E4,	BEGSYM=$84C7,	CASEYM=$8053,	CODSYM=$8184,
	DEFSYM=$9CC6,	DOSYM=$0CEF,	ELSEYM=$99F3,	ENDSYM=$99A4,
	EXITYM=$9B69,	EXTNYM=$9B74,	FALSYM=$944C,	FFUNYM=$94B5,
	FORSYM=$9592,	FPRSYM=$9672,	FUNSYM=$96CE,	GESYM=$0C85,
	GETSYM=$90D4,	IFSYM=$0D46,	INTSYM=$A9B4,	LESYM=$0DE5,
	LOOPYM=$BD8F,	NOTSYM=$B594,	OFSYM=$0D86,	PROCYM=$CE2F,
	QUITYM=$CAC9,	REALYM=$C4C1,	REPSYM=$C4D0,	RETSYM=$C4D4,
	THENYM=$DD65,	TRUSYM=$DE35,	UNTSYM=$D9B4,	WHILYM=$D169,
	CHARYM=$8161,	EPRSYM=$9A72,	EFUNYM=$98B5,	PUBSYM=$CEC2,
	OTHSYM=$B2E8,	INCSYM=$A9A3,	LSLSYM=$BE0C,	LSRSYM=$BE92,
	CONSYM=$818E,	ABSSYM=$8833,	REMSYM=$C4CD,	SWAPYM=$C281,
	EXTSYM=$9B74,	PORTYM=$CD92,	FIXSYM=$9558,	FLOSYM=$95EF,
	SQRTYM=$C252,	STRSYM=$C2F2,	ASMSYM=$8A0D,	SQSYM=$0E11,
	TOSYM=$0EEF,	DOWNYM=$9D97,	ASRSYM=$8A12,	ANDSYM=$89A4,
	ORSYM=$0D92,	XORSYM=$ED92;



func	GETBC;		\Read a char from device 8. Return EOF if end of program
int	C, D;		\(get buffered character)
begin
for D:= 1, HANMAX do
	[C:= CHIN(8); if C#EOF then return C];
return C;
end;	\GETBC



proc	ERROR(N);	\Display error message N
int	N;
int	ERR, CH, I;
char	STRING;
def	MAXERR=75;	\maximum error number
begin
ERR:= RESERVE((MAXERR+1)*INTSIZE);
for I:= 0, MAXERR do ERR(I):= "? ";	\unused error numbers ="?"

ERR(0):= "INTERNAL ERROR ";
ERR(1):= "TOO MANY VARIABLES ";
ERR(2):= "TOO MANY REAL CONSTANT NAMES ";
ERR(3):= "TOO MANY NAMES ";
ERR(4):= "TOO MANY 'QUITS' ";
ERR(5):= "TOO MANY STATIC LEVELS ";
ERR(6):= "NUMBER OUT OF RANGE ";
ERR(7):= ERR(6);			\for intrinsic declarations
ERR(10):= "UNDECLARED NAME ";
ERR(11):= "NAME ALREADY DECLARED ";
ERR(20):= "ILLEGAL START OF A STATEMENT ";	\in ASSIGN
ERR(21):= "^":=^"* ";
ERR(22):= "'THEN'* ";
ERR(23):= "'DO'* ";
ERR(24):= "'TO' OR 'DOWNTO'* ";
ERR(26):= "ILLEGAL FACTOR ";		\unrecognizable special factor
ERR(27):= "STATEMENT STARTING WITH A CONSTANT "; \in ASSIGN
ERR(28):= "'UNTIL'* ";
ERR(29):= "'OTHER'* ";
ERR(30):= "'ELSE'* ";
ERR(31):= "DIGIT* ";
ERR(33):= "INTEGER VARIABLE* ";		\in a 'for' statement
ERR(37):= "REAL VALUE* ";
ERR(38):= "^">^"* ";		\ASR ->>
ERR(39):= "^"(^"* ";
ERR(40):= "^"=^"* ";
ERR(41):= "^";^"* ";
ERR(42):= "CONSTANT* ";			\in GETCON
ERR(43):= "VARIABLE* ";			\for an 'addr' operator
ERR(44):= "^")^"* ";
ERR(45):= "NAME* ";
ERR(46):= "MIXED MODE ";
ERR(47):= "INTEGER* ";
ERR(48):= "'OF'* ";
ERR(49):= "^":^"* ";
ERR(50):= "^"]^"* ";
ERR(51):= "NO ARGUMENTS DECLARED ";
ERR(52):= "STATEMENT STARTING WITH 'ELSE' ";
ERR(53):= "STATEMENT STARTING WITH 'OTHER' ";
ERR(60):= "'QUIT' NOT IN A 'LOOP' ";
ERR(61):= "EOF* ";
ERR(62):= "EOF INSIDE A BLOCK ";
ERR(63):= "EOF INSIDE A STRING ";
ERR(65):= "'FPROC' & ITS 'PROC' NOT AT SAME LEVEL ";
ERR(66):= "'FPROC' REFERENCE NOT FOUND ";
ERR(67):= "'PROC' OR 'FUNC'* ";
ERR(68):= "'EPROC'S AND 'PUBLIC'S MUST BE GLOBAL ";
ERR(69):= "'INCLUDE'S NESTED TOO DEEP ";
ERR(70):= "BAD FILE SPEC ";
ERR(71):= "FILE NOT FOUND ";
ERR(72):= "'INT', 'REAL', 'CHAR' or 'ADDR'* ";
ERR(73):= "DIVIDE BY ZERO IN A CONSTANT EXPRESSION ";
ERR(74):= "MATH ERROR IN A CONSTANT EXPRESSION ";
ERR(75):= "EXPRESSION MUST BE ENCLOSED IN PARENTHESES ";

if LSTDEV = 8 then
	begin
	OPENI(8);
	loop	begin
		CH:= GETBC;
		if CH=EOF then quit;
		CHOUT(TV, CH);
		end;
	CRLF(TV);
	end;

CHOUT(TV, BEL); CHOUT(TV, $0A);		\(damn linefeeds!)
CRLF(TV);
TEXT(TV, "***** ERROR NO. "); INTOUT(TV, N); TEXT(TV, " *****");
CRLF(TV);
STRING:= ERR(N);
I:= 0;
loop	begin
	CH:= STRING(I);			\output message
	if CH>=$80 then quit;
	if CH=^* then TEXT(TV, " EXPECTED BUT NOT FOUND")
	else CHOUT(TV, CH);
	I:= I+1;
	end;
CRLF(TV);
TEXT(TV, "ATTEMPT TO CONTINUE (Y/N)? ");
OPENI(KB);
case CHIN(KB) of ^N, ^n: [CLOSE(LSTDEV); exit 1] other;
BINDEV:= NULDEV;			\kill the output file
ERRCTR:= ERRCTR+1;
end;	\ERROR



proc	WARNING(N);	\Display warning message N
int	N;
int	WARN, CH, I;
char	STRING;
def	MAXWARN=8;	\maximum warning number
begin
if ~WARNFLAG then return;
WARN:= RESERVE((MAXWARN+1)*INTSIZE);
for I:= 0, MAXWARN do WARN(I):= "? ";	\unused warning numbers = "?"

WARN(1):= "LOCAL NAME SAME AS MORE-GLOBAL NAME ";
WARN(2):= "ROUNDING ERRORS MAKE EQUALITY UNLIKELY ";
WARN(3):= "CONTROL CHARACTER ";
WARN(4):= "USE 'OTHER' INSTEAD OF 'ELSE' ";
WARN(5):= "COMMAS MISSING IN 'DEFINE' ";
WARN(6):= "'DEFINE' MIXES ENUMERATIONS WITH '=' ";
WARN(7):= "DOUBLED UNARY OPERATOR: ++, --, OR ~~ ";
WARN(8):= "DEFINED BUT NOT USED ";

if LSTDEV = 8 then
	begin
	OPENI(8);
	loop	begin
		CH:= GETBC;
		if CH=EOF then quit;
		CHOUT(TV, CH);
		end;
	CRLF(TV);
	end;

\CHOUT(TV, BEL);\  CHOUT(TV, $0A);	\(damn linefeeds!)
TEXT(TV,"
***** WARNING NO. "); INTOUT(TV,N); TEXT(TV," *****
");
STRING:= WARN(N);
I:= 0;
loop	begin
	CH:= STRING(I);
	if CH>=$80 then quit;
	if CH=^* then TEXT(TV, " EXPECTED BUT NOT FOUND")
		else CHOUT(TV, CH);
	I:= I+1;
	end;
CRLF(TV);
TEXT(TV, "CONTINUE (Y/N)? ");
OPENI(KB);
case CHIN(KB) of ^N,^n: [CLOSE(LSTDEV); exit 1] other;
end;	\WARNING



proc	CHKUSE(LIM);	\Display unused identifier (symbol) names
int	LIM;
int	F, I, K, N, C;
begin
if not WARNFLAG then return;
F:= false;
N:= NOSYM;
C:= 0;
while N>LIM do
	begin
	N:= N-1;
	if SYMTAG(N)=0 then	\UNUSED
		begin
		if ~F then
			begin
			CRLF(TV);
			for I:= 0, 78 do CHOUT(TV, ^*);
			CRLF(TV);
			F:= true;
			end;
		K:= N;
		for I:= 0, SIGCHAR-1 do
			[CHOUT(TV, SYMBOL(K));  K:= K+SYMAX];
		TEXT(TV, "  ");
		C:= C+1;
		if (C&3)=3 then CRLF(TV);
		end;
	end;
if F then
	begin
	if (C&3)#3 then CRLF(TV);
	for I:= 0, 78 do CHOUT(TV, ^*);
	CRLF(TV);
	WARNING(8);
	end;
end;	\CHKUSE



proc	DEBDUMP;	\Dump XPL source to assembly file for debugging (/d)
int	CH;


	func	DUMPLINE;	\Dump a line of source code
	begin
	CH:= GETBC;
	if CH=EOF then return false;
	TEXT(BINDEV, "; ");
	loop	begin
		if CH=EOF then return false;
		CHOUT(BINDEV, CH);
		if CH=EOL then return true;
		CH:= GETBC;
		end;
	end;	\DUMPLINE


begin	\DEBDUMP
if LSTDEV=8 then
	begin
	OPENI(8);
	while DUMPLINE do;
	OPENO(8);
	end;
if OLDCODCTR # CODCTR then CRLF(BINDEV);
OLDCODCTR:= CODCTR;
end;	\DEBDUMP



proc	GETCH;		\Get a character from the source device
begin
CHAR:= CHIN(SRCDEV); CHOUT(LSTDEV, CHAR);
if DEBUG then
	if CHAR=EOL then DEBDUMP;
while CHAR=^\ do			\FILTER OUT COMMENTS
	begin
	loop	begin
		CHAR:= CHIN(SRCDEV); CHOUT(LSTDEV, CHAR);
		case CHAR of
		  $0D:	return;		\CR
		  EOL:	[if DEBUG then DEBDUMP; return];
		  ^\:	[CHAR:= ^ ; return];
		  EOF:	return
		other	[];
		end;
	end;
end;	\GETCH



proc	GETCH_;		\Get a non-underline character from the source device
repeat GETCH until CHAR#^_;

\------------------------- ROUTINES TO HANDLE INCLUDES -------------------------

proc	FALLBACK;	\Terminate an include and fall back to previous handle
begin
HANPTR:= HANPTR-1;
FCLOSE(INHAND);
INHAND:= OLDHAN(HANPTR);
FSET(INHAND, if HANPTR=0 then ^I else ^i); \only main file gets the big buffer
end;	\FALLBACK



proc	INCLUDE;	\Set up an include file
char	NAME;
def	NAMMAX=80;
int	NEWHAND, I;


	proc	GETC;		\Get character with no filtering
	begin
	CHAR:= CHIN(SRCDEV);
	CHOUT(LSTDEV, CHAR);
	end;	\GETC


	func	GETNAME;	\Read file specification
	int	EXTFLG, I, K;
	char	DEFEXT;
	begin
	DEFEXT:= ".XPL";
	EXTFLG:= false;

	while CHAR<=$20 do		\eat leading spaces and control chars
		[if CHAR=EOF then ERROR(61); GETC];

	K:= 0;				\copy file name into NAME
	loop	begin
		case CHAR of
		  ^.:	EXTFLG:= true;
		  EOL:	return false;
		  ^;:	quit
		other;

		NAME(K):= CHAR;
		K:= K+1;
		if K>=NAMMAX  then return false;
		GETC;
		end;

	if K=0 then return false;	\deal with empty filename

	if EXTFLG then			\deal with default extensions
		NAME(K-1):= NAME(K-1) ! $80
	else	begin
		if (K+4) >= NAMMAX then return false;
		for I:= 0, 3 do NAME(K+I):= DEFEXT(I);
		end;
	return true;
	end;	\GETNAME


begin	\INCLUDE
NAME:= RESERVE(NAMMAX);
if HANPTR >= HANMAX then
	[ERROR(69); while CHAR#^; & CHAR#EOF do GETC; return];
if not GETNAME then
	[ERROR(70); while CHAR#^; & CHAR#EOF do GETC; return];

TRAP($FFFB);				\open file
NEWHAND:= FOPEN(NAME, 0);
TRAP($FFFF);
if GETERR = 3 then [ERROR(71); return];

OLDHAN(HANPTR):= INHAND;		\save old file handle on stack
HANPTR:= HANPTR+1;
INHAND:= NEWHAND;

FSET(INHAND, ^i);			\include files always use small buffers

TEXT(TV, "INCLUDING: ");
for I:= 2, HANPTR do TEXT(TV, "   ");
TEXT(TV, NAME); CRLF(TV);
end;	\INCLUDE

\-------------------------------------------------------------------------------

fproc	CONEXPRESS;
fproc	LOOKUP, TTXT, POSTGEN;	\FOR 'ASM'


proc	RATOM;		\Read an atom
\Outputs:  ATOM, ATYPE, IDENT, HASH, IATOM, CHAR, RLATOM.
int	LEN, NEG, EXP, I, INTOVF;
real	FRACT, DENOM;


	proc	RFRACT;		\Read the fractional part of a real number
	begin
	ATYPE:= REALCON; ATOM:= 0;
	GETCH_;
	FRACT:= FLOAT(0); DENOM:= FLOAT(10);	\("10.0" is not as portable)
	while CHAR>=^0 & CHAR<=^9 do
		begin
		FRACT:= FRACT +FLOAT(CHAR-^0) /DENOM;
		DENOM:= DENOM*FLOAT(10);
		GETCH_;
		end;
	RLATOM:= RLATOM +FRACT;
	end;	\RFRACT


	proc	REXP;		\Read an exponent, if any
	if CHAR=^E ! CHAR=^e then
		begin
		ATYPE:= REALCON;
		GETCH_;
		if CHAR=^- then [NEG:= true; GETCH_]
		else NEG:= false;
		if CHAR=^+ then GETCH_;
		EXP:= 0;
		if CHAR<^0 ! CHAR>^9 then ERROR(31);
		while CHAR>=^0 & CHAR<=^9 do
			[EXP:= EXP *10 +CHAR-^0; GETCH_];
		if NEG then EXP:= -EXP;
		while EXP>0 do
			[RLATOM:= RLATOM *FLOAT(10); EXP:= EXP-1];
		while EXP<0 do
			[RLATOM:= RLATOM /FLOAT(10); EXP:= EXP+1];
		end;	\REXP


	proc	DoAsmLine;	\Output a line of assembly code
	int	HaveComment;
	begin
	HaveComment:= false;
	while CHAR#$0D\CR\ & CHAR#^} do
		begin
		if CHAR=^; then HaveComment:= true;
		if not HaveComment then CHOUT(BINDEV,CHAR);
		GETCH;
		if CHAR>=^A & CHAR<=^Z & not HaveComment then
			begin
			RATOM;			\(ATYPE=IDENTIFIER)
			LOOKUP;
			case IDTYPE of
			  ADDRVAR, INVAR, RLVAR:
				[if IDTYPE=RLVAR then TTXT("qwp ");
				if LEV=0 then TTXT("heaplo+")
				else if LEV=LEVEL then TTXT("[esi]+")
				else TTXT("[ebp]+");
				INTOUT(BINDEV,VAL)];
			  INCON:
				INTOUT(BINDEV,VAL);
			  UNDEF:
				ERROR(10)
			other	ERROR(26);
			end;
		if CHAR=EOF then [ERROR(62); exit 1];
		end;
	if CHAR=$0D\CR\ then [CRLF(BINDEV); GETCH];
	if CHAR=$0A\LF\ then GETCH;
	end;	\DoAsmLine


begin	\RATOM
while CHAR<=$20 do	\skip spaces, tabs, cr's, lf's, & ff's, etc.
	begin		\ but don't go past eof
			\if HANPTR=0 then it's a hard eof
	if CHAR=EOF then if HANPTR>0 then FALLBACK
		    else [ATYPE:= SPECIAL; ATOM:= EOF; return];
	GETCH;
	end;
if CHAR>=^a then if CHAR<=^z then				\RESERVED WORD
	begin
	ATYPE:= SPECIAL;
	ATOM:= CHAR; GETCH;
	ATOM:= ATOM<<5|CHAR; GETCH;
	if CHAR>=^a & CHAR<=^z then [ATOM:= ATOM<<5|CHAR; GETCH];
	ATOM:= ATOM & $0000FFFF;		\truncate to 16 bits
	while CHAR>=^a & CHAR<=^z do GETCH;
	case ATOM of
	  TRUSYM: [ATYPE:= INTCON; ATOM:= 0; IATOM:= true];
	  FALSYM: [ATYPE:= INTCON; ATOM:= 0; IATOM:= false];
	  CONSYM: begin
		  RATOM;
		  CONEXPRESS;
		  if FACTYP=INTEGER then CONDITIONAL:= IATOM else ERROR(47);
		  while ATOM=^; do RATOM;	\eat semicolon, if any
		  loop	begin			\eat atoms until cond=true
			if CONDITIONAL \#0\ then quit;
			if ATYPE=SPECIAL then
			  if ATOM=EOF then quit
			  else if ATOM=^" then	\ignore "con" inside strings
			    begin
			    if CHAR#^" then	\null string ("")
			      loop begin
				 CHAR:=CHIN(SRCDEV); CHOUT(LSTDEV,CHAR);
				 if CHAR=EOF then [ERROR(63); exit 1];
				 if CHAR=^^ then
					[CHAR:=CHIN(SRCDEV); CHOUT(LSTDEV,CHAR)]
				 else	if CHAR=^" then quit;
				 end;
			    GETCH;
			    end;
			RATOM;
			end;
		  end;
	  STRSYM: begin
		  RATOM;
		  CONEXPRESS;
		  if FACTYP=INTEGER then STRTERM:= IATOM else ERROR(47);
		  while ATOM=^; do RATOM;	\eat semicolon, if any
		  end;
	  ASMSYM:
	    if CONDITIONAL then
	  	begin				\INSERT IN-LINE ASSEMBLY CODE
	  	LASTOP:= -1;			\instead of call to COMMENT
	  	CODCTR:= CODCTR +1;		\Main proc might be pure asm
	  	if POSTGENTYPE\#0\ then POSTGEN;\deal with pending BX, if any
		while CHAR=$20\SPACE\ ! CHAR=$09\TAB\ do
			[CHOUT(BINDEV,CHAR); GETCH]; \don't skip EOL
		if CHAR=^{ then
			begin
			GETCH;		\eat {
			repeat DoAsmLine until CHAR=^};
			GETCH;		\eat }
			CRLF(BINDEV);
			end
		else	DoAsmLine;
		OLDLEV:= -1;	\assume EAX, EDX & EBP registers are destroyed
		EDXLEV:= -1;
		EAXLEV:= -1;
		EAXIMM:= false;
		EAXHI0:= false;
		RATOM;		\return atom following 'asm' line(s)
		end;
	  INCSYM: [INCLUDE; GETCH; RATOM]
	other;
	return;
	end;
if CHAR>=^A then if CHAR<=^Z ! CHAR=^_ then			\IDENTIFIER
	begin
	ATYPE:= IDENTIFIER; ATOM:= 0;
	IDENT(0):= CHAR; HASH:= CHAR; GETCH;
	LEN:= 1;
	loop	begin
		if not CaseSensitive then	\shift to uppercase
			if CHAR>=^a & CHAR<=^z then CHAR:= CHAR & $DF;
		case of
		  CHAR>=^A & CHAR<=^Z,  CHAR>=^a & CHAR<=^z, CHAR>=^0 &
		  CHAR<=^9,  CHAR=^_ :
			begin
			if LEN <SIGCHAR then
				begin
				IDENT(LEN):= CHAR;
				HASH:= HASH+CHAR;
				LEN:= LEN+1;
				end;
			GETCH;
			end
		other	quit;
		end;
	for LEN:= LEN, SIGCHAR-1 do
		[IDENT(LEN):= ^ ; HASH:= HASH+^ ];
	HASH:= HASH & HASHMASK;
	return;
	end;
if CHAR>=^0 then if CHAR<=^9 then			       \UNSIGNED INTEGER
	begin
	ATYPE:= INTCON;		\assume integer until shown otherwise
	ATOM:= 0;
	INTOVF:= false;
	IATOM:= CHAR-^0; GETCH_;
	loop	begin
		I:= IATOM;
		if CHAR<^0 ! CHAR>^9 then quit;
		I:= IATOM*10+CHAR-^0;
		if IATOM>214748364 ! IATOM=214748364 & CHAR>^7 then
			[INTOVF:=true; quit];	\overflowed, but ok if it's real
		IATOM:= I;
		GETCH_;
		end;
	RLATOM:= FLOAT(IATOM);
	IATOM:= I;			\(can't float(2147483648))
	while CHAR>=^0 & CHAR<=^9 do	\if more digits then it must be a real
		[RLATOM:= RLATOM*FLOAT(10) + FLOAT(CHAR-^0); GETCH_];
	if CHAR=^. then RFRACT;					\UNSIGNED REAL
	REXP;
	if ATYPE=INTCON & INTOVF & IATOM#$80000000 then
		if CONDITIONAL then ERROR(6);
	return;
	end;
case CHAR of
  ^.:	begin
	RLATOM:= FLOAT(0);					\UNSIGNED REAL
	RFRACT;
	REXP;
	return;
	end;
  ^$:	begin						   \UNSIGNED HEX INTEGER
	ATYPE:= INTCON; ATOM:= 0;
	GETCH_;
	case of
	  CHAR>=^0 & CHAR<=^9:	IATOM:= CHAR-^0;
	  CHAR>=^A & CHAR<=^F:	IATOM:= CHAR-$37;
	  CHAR>=^a & CHAR<=^f:	IATOM:=CHAR-$57
	other	[\DIGIT EXPECTED\ ERROR(31); return];
	loop	begin
		GETCH_;
		case of
		  CHAR>=^0 & CHAR<=^9:	I:= CHAR-^0;
		  CHAR>=^A & CHAR<=^F:	I:= CHAR-$37;
		  CHAR>=^a & CHAR<=^f:	I:=CHAR-$57
		other return;
		if IATOM>$FFFFFFF then
			if CONDITIONAL then ERROR(6);
		IATOM:= IATOM*16+I;
		end;
	end;
  ^%:	begin						\UNSIGNED BINARY INTEGER
	ATYPE:= INTCON; ATOM:= 0;
	GETCH_;
	if CHAR>=^0 & CHAR<=^1 then IATOM:= CHAR-^0
	else [\DIGIT EXPECTED\ ERROR(31); return];
	loop	begin
		GETCH_;
		if CHAR>=^0 & CHAR<=^1 then I:= CHAR-^0
		else return;
		if IATOM<0 then		\(if IATOM > $7FFF_FFFF ... unsigned)
			if CONDITIONAL then ERROR(6);
		IATOM:= IATOM*2+I;
		end;
	end;
  ^^:	begin
	ATYPE:= INTCON;						\META CHARACTER
	ATOM:= 0;				\=integer constant
	CHAR:= CHIN(SRCDEV); CHOUT(LSTDEV, CHAR);
	if CHAR <$20 ! CHAR=$7F then WARNING(3);
	IATOM:= CHAR;
	GETCH;
	return;
	end;
  ^":	begin
	ATYPE:= SPECIAL;				      \SPECIAL CHARACTER
	ATOM:= CHAR;		\(' and backslash have no effect inside strings)
	CHAR:= CHIN(SRCDEV); CHOUT(LSTDEV, CHAR);
	return;
	end
other;
ATYPE:= SPECIAL;					      \SPECIAL CHARACTER
ATOM:= CHAR;
GETCH;
case CHAR of
  ^=:	case ATOM of
	^::	[GETCH; ATOM:= GETSYM];
	^>:	[GETCH; ATOM:= GESYM];
	^<:	[GETCH; ATOM:= LESYM]
	other;
  ^<:	[if ATOM = ^< then [GETCH; ATOM:= LSLSYM]];
  ^>:	begin
	if ATOM = ^> then [GETCH; ATOM:= LSRSYM]
	else if ATOM = ^- then
		[GETCH;
		if CHAR#^> then ERROR(38);
		GETCH;
		ATOM:= ASRSYM];
	end
other	[];
end;	\RATOM



proc	SKIPIT;		\Skip the rest of a statement (for error recovery)
begin
while ATOM#EOF & ATOM#^; & ATOM#ENDSYM & ATOM#^] & ATOM#BEGSYM & ATOM#^[ do
	RATOM;
end;	\SKIPIT



proc	HEXB(I);	\Output a hex byte
int	I;
begin
CHOUT(BINDEV, HEXDIGIT( (I&$FF)/16 ));
CHOUT(BINDEV, HEXDIGIT(REM(0)));
end;	\HEXB



proc	SYMOUT(SYM);	\Output symbol name at SYM
int	SYM;
int	I, C;
begin
for I:= 0, SIGCHAR-1 do
	begin
	C:= SYMBOL(SYM);
	if C=$20 then return;
	CHOUT(BINDEV, C);
	SYM:= SYM +SYMAX;
	end;
end;	\SYMOUT

\=============================== CODE GENERATOR ================================

proc	TTXT(STR);	\Output opcode string
char	STR;
int	I, CH;
begin
for I:= 0, 32000 do
	begin
	CH:= STR(I);
	if CH >= $80 then 
		[CH:= CH & $7F;   I:= 32000];
	if CH=^| then CRLF(BINDEV) else CHOUT(BINDEV, CH);
	end
end;	\TTXT



proc	DOALIGN;	\Output alignment statement, if enabled
begin
case OPTIMIZE of
  OPT286: TTXT("	EVEN|");
  OPT386: TTXT("	ALIGN 4|")
other;
end;	\DOALIGN



proc	OPTNEWLEVEL(L);	\Set ESI for current level for an optimized procedure.
\Note that an optimized procedure can be called from a procedure at a deeper
\ level, thus ESI must be set to make sure it is at the current level.
int	L;
begin
if L > 0 then
	begin
	TTXT("	PUSH	ESI|	MOV	ESI,BASE");
	INTOUT(BINDEV, L/2); CRLF(BINDEV);
	end;
OLDLEV:= -1;		\EBP is undefined
end;	\OPTNEWLEVEL



proc	NEWLEVEL(L);  \Set up EBP to access intermediate variables, if necessary
int	L;
begin
if L#0 & L#OLDLEV & L#LEVEL then
	begin
	TTXT("	MOV	EBP,BASE");
	INTOUT(BINDEV, L/2); CRLF(BINDEV);
	OLDLEV:= L;
	end;
end;	\NEWLEVEL



proc	SHOWSTK;	\Debugging routine to show the pseudo stack
int	P;
begin
if not I2LCOMFLAG then return;
TEXT(BINDEV, "
; ==============================
");

for P:= 0, PSTKPTR-1 do
	begin
	TEXT(BINDEV, "; ");
	case P of
	  PSTKPTR-1:	TEXT(BINDEV, "TOS> ");
	  PSTKPTR-2:	TEXT(BINDEV, "NOS> ")
	other TEXT(BINDEV, "     ");

	case PSTKTYP(P) of
	  REGTYP:	TEXT(BINDEV, "REG");
	  STKTYP:	TEXT(BINDEV, "STK");
	  ADRTYP:	TEXT(BINDEV, "ADD");
	  IMMTYP:	TEXT(BINDEV, "IMM");
	  REALTYP:	TEXT(BINDEV, "FLT")
	other;

	TEXT(BINDEV, " - ");
	INTOUT(BINDEV, PSTKLEV(P)); TEXT(BINDEV, " - ");
	INTOUT(BINDEV, PSTKOFF(P));
	CRLF(BINDEV);
	end;
TEXT(BINDEV, "; ==============================
");
end;	\SHOWSTK

\------------ ROUTINES TO HANDLE INTERNAL OPTIMIZING (PSEUDO) STACK ------------

proc	BUGMSG(S);	\Display message for internal compiler error (i.e: bug)
int	S;
begin
TEXT(TV, "INTERNAL ERROR - "); TEXT(TV, S); CRLF(TV);
TTXT(";INTERNAL ERROR - "); TTXT(S); CRLF(BINDEV);
ERROR(0);
end;	\BUGMSG


	
proc	PPUSH(TYP, LEV, OFF);	\Push an item onto pseudo stack
int	TYP, LEV, OFF;
begin
if PSTKPTR < STKMAX then
	begin
	PSTKTYP(PSTKPTR):= TYP;
	PSTKLEV(PSTKPTR):= LEV;
	PSTKOFF(PSTKPTR):= OFF;
	PSTKPTR:= PSTKPTR+1;
	end
else BUGMSG("PPUSH OVERFLOW");
end;	\PPUSH



proc	PDROP(N);	\Drop (pop) N items from pseudo stack
int	N;
begin
PSTKPTR:= PSTKPTR-N;
if PSTKPTR < 0 then [PSTKPTR:= 0; BUGMSG("PDROP PSTKPTR<0")];
end;	\PDROP



proc	PSWAP;		\Swap top two items on the pseudo stack
int	T;
begin
T:= PSTKTYP(PSTKPTR-2);
PSTKTYP(PSTKPTR-2):= PSTKTYP(PSTKPTR-1);
PSTKTYP(PSTKPTR-1):= T;

T:= PSTKLEV(PSTKPTR-2);
PSTKLEV(PSTKPTR-2):= PSTKLEV(PSTKPTR-1);
PSTKLEV(PSTKPTR-1):= T;

T:= PSTKOFF(PSTKPTR-2);
PSTKOFF(PSTKPTR-2):= PSTKOFF(PSTKPTR-1);
PSTKOFF(PSTKPTR-1):= T;
end;	\PSWAP



proc	GENEAX(L, O);	\Generate code to put an immediate value into EAX
int	L,	\the value to generate
	O;	\^L or ^C (label or constant)
begin
CHOUT(BINDEV,^	);
case of
  O = ^L:		[TTXT("MOV	EAX,OFFSET L"); INTOUT(BINDEV, L)];

\0-byte solution:
  L=EAXVAL & EAXIMM:	[];		\value is already in EAX

\1-byte solutions:
  L=EAXVAL+1 & EAXIMM:	TTXT("INC	EAX");
  L=EAXVAL-1 & EAXIMM:	TTXT("DEC	EAX");

\2-byte solutions:
  L=0:			TTXT("XOR	EAX,EAX");
  L=(L&$000000FF ! EAXVAL&$FFFFFF00) & EAXIMM:
			[TTXT("MOV	AL,"); INTOUT(BINDEV, L&$000000FF)];
  L>>8=0 & EAXHI0:	[TTXT("MOV	AL,"); INTOUT(BINDEV, L)];
  L=(L&$0000FF00 ! EAXVAL&$FFFF00FF) & EAXIMM:
			[TTXT("MOV	AH,"); INTOUT(BINDEV, (L>>8)&$FF)];
  L=-EAXVAL & EAXIMM:	TTXT("NEG	EAX");		\(beware of $80000000)
  L=(~EAXVAL) & EAXIMM:	TTXT("NOT	EAX");
  L=EAXVAL+EAXVAL & EAXIMM:TTXT("ADD	EAX,EAX")

\5-byte solution:
other			[TTXT("MOV	EAX,"); INTOUT(BINDEV, L)];
CRLF(BINDEV);

EAXIMM:= O # ^L;			\don't use label for immediate value
if EAXIMM then EAXVAL:= L;
EAXHI0:= if EAXIMM then EAXVAL>>8=0 else false;
EAXLEV:= -1;
end;	\GENEAX



func	ISZERO(COMM);	\Eliminate operations that result in zero
			\Returns 'true' if operation equals 0
int	COMM;		\operation is commutative
begin
if PSTKTYP(PSTKPTR-2)=IMMTYP & PSTKLEV(PSTKPTR-2)=0 & PSTKOFF(PSTKPTR-2)=^C then
	[PDROP(1); return true];	\e.g: 0/A
if COMM then				\e.g: 0*A = A*0
	begin
	if PSTKTYP(PSTKPTR-1)=IMMTYP & PSTKLEV(PSTKPTR-1)=0 &
	   PSTKOFF(PSTKPTR-1)=^C then
		begin			\e.g: A*0
		PSTKTYP(PSTKPTR-2):= IMMTYP;
		PSTKLEV(PSTKPTR-2):= 0;
		PSTKOFF(PSTKPTR-2):= ^C;
		PDROP(1);
		return true;
		end;
	end;
return false;
end;	\ISZERO



func	IDENTITY(N,COMM);\Eliminate identity operations such as A+0 and A*1
int	N,		\returns 'true' if it was an identity operation
	COMM;		\operation is commutative
begin
if PSTKTYP(PSTKPTR-1)=IMMTYP & PSTKLEV(PSTKPTR-1)=N & PSTKOFF(PSTKPTR-1)=^C then
	[PDROP(1); return true];

if COMM then
	begin
	if PSTKTYP(PSTKPTR-2)=IMMTYP & PSTKLEV(PSTKPTR-2)=N &
	    PSTKOFF(PSTKPTR-2)=^C then
		begin			\eliminate identity operator
		PSTKTYP(PSTKPTR-2):= PSTKTYP(PSTKPTR-1);
		PSTKLEV(PSTKPTR-2):= PSTKLEV(PSTKPTR-1);
		PSTKOFF(PSTKPTR-2):= PSTKOFF(PSTKPTR-1);
		PDROP(1);
		return true;
		end;
	end;
return false;
end;	\IDENTITY



proc	OPSTRING(STR, TYP, LEV, OFF, REG);
\Output opcode string with embedded operands or registers.
\ Special string symbols: |=crlf, &=operand, #=register.
\*** WARNING***: Be sure to bomb EDX (EDXLEV:= -1) and EAX before using this
\ procedure to store into any memory variable (otherwise it will store into the
\ shadowing register instead).
char	STR;	\string
int	TYP,	\type of operand (&: ^R, ^A or ^I)
	LEV,	\level for address (A), value for immediate (I), or string for
		\ reg (R)
	OFF,	\offset for address, or ^L for labels
	REG;	\register (#: ^A, ^B, ^C, ^D, ^S, ^I, or ^P)
int	I, CH;
begin
if TYP=^A then 
	begin	\if address operand, make sure EBP is properly set if necessary
	case of
	  LEV=EDXLEV & OFF=EDXOFF:  \even reading EDX in a 'while' loop bombs it
		if EDXPEND then [EDXLEV:= -1; EDXPEND:=false; NEWLEVEL(LEV)];
	  LEV=EAXLEV & OFF=EAXOFF:
		[]
	other NEWLEVEL(LEV);
	end;
for I:= 0, 32000 do
	begin
	CH:= STR(I) & $7F;
	case CH of
	  ^&:	case TYP of
		  ^R:	TEXT(BINDEV, LEV);			\REGISTER (EAX)
		  ^A:	begin					\ADDRESS
			if LEV=EDXLEV & OFF=EDXOFF then		\REGISTER VAR
				TTXT("EDX")
			else if LEV=EAXLEV & OFF=EAXOFF then	\REGISTER VAR
				TTXT("EAX")
			else	begin
				TTXT("DWP ");			\DWORD PTR
				case LEV of
				  0:	TTXT(if LEVEL#0 ! OPTPROC ! ABS(OFF)>127
				  		then "HEAPLO+" else "[ESI]+");
				  LEVEL:TTXT("[ESI]+")
				other	TTXT("[EBP]+");
				INTOUT(BINDEV, OFF);
				end;
			end;
		  ^I:	begin
			if OFF=^L then				\IMMEDIATE
				[TTXT("OFFSET L"); INTOUT(BINDEV, LEV)]
			else if EAXIMM & EAXVAL=LEV then TTXT("EAX")
			else INTOUT(BINDEV, LEV);
			end
		other;
	  ^#:	case REG of
		  ^A:	[TEXT(BINDEV, "EAX");
			EAXLEV:= -1;   EAXIMM:= false;   EAXHI0:= false];
		  ^B:	TEXT(BINDEV, "EBX");
		  ^C:	TEXT(BINDEV, "ECX");
		  ^D:	[TEXT(BINDEV, "EDX");  EDXLEV:= -1];
		  ^S:	TEXT(BINDEV, "ESI");
		  ^I:	TEXT(BINDEV, "EDI");	\WARNING: reserved for heap ptr
		  ^P:	TEXT(BINDEV, "EBP")
		other	BUGMSG("OPSTRING");
	  ^|:	CRLF(BINDEV)
	other	CHOUT(BINDEV, CH);
	if STR(I) >= $80 then return;
	end
end;	\OPSTRING



proc	TOS2REG(R);	\Copy TOS into register specified by 'R'
int	R;		\ (unless it's a real)
begin
case PSTKTYP(PSTKPTR-1) of
  REGTYP: if R#^A then OPSTRING("	MOV	#,EAX|", 0, 0, 0, R);
  STKTYP: begin
	  OPSTRING("	POP	#|", 0, 0, 0, R);
	  if R = ^A then [EAXLEV:= -1; EAXIMM:= false; EAXHI0:= false];
	  end;
  ADRTYP: begin
	  OPSTRING("	MOV	#,&|", ^A, PSTKLEV(PSTKPTR-1),
	  		PSTKOFF(PSTKPTR-1), R);
	  if R = ^A then
		[EAXLEV:= PSTKLEV(PSTKPTR-1); EAXOFF:= PSTKOFF(PSTKPTR-1);
		EAXIMM:= false; EAXHI0:= false];
	  end;
  IMMTYP: if R=^A then GENEAX(PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1))
	  else	if PSTKLEV(PSTKPTR-1)=0 \& #^L\ then
			OPSTRING("	XOR	#,#|", 0, 0, 0, R)
	  	else	OPSTRING("	MOV	#,&|", ^I, PSTKLEV(PSTKPTR-1),
				PSTKOFF(PSTKPTR-1), R)\;
\ REALTYP: []
other	BUGMSG("TOS2REG");
end;	\TOS2REG



proc	ADDTOS2EBX;	\Add TOS to EBX (for indexing operation)
begin
case PSTKTYP(PSTKPTR-1) of
  REGTYP: TTXT("	ADD	EBX,EAX|");
  STKTYP: TTXT("	POP	ECX|	ADD	EBX,ECX|");
  ADRTYP: OPSTRING("	ADD	EBX,&|", ^A, PSTKLEV(PSTKPTR-1),
			PSTKOFF(PSTKPTR-1), 0);
  IMMTYP: if PSTKLEV(PSTKPTR-1)#0 \& #^L\ then
		OPSTRING("	ADD	EBX,&|", ^I, PSTKLEV(PSTKPTR-1),
				PSTKOFF(PSTKPTR-1), 0)\;
					\(this is usually optimized elsewhere)
\  REALTYP: []
other	BUGMSG("ADDTOS2EBX");
end;	\ADDTOS2EBX



proc	CLEANREG(LEV);	\Push any EAX below LEV on pseudo stack onto h/w stack
int	LEV;	\i.e: clean EAX off pseudo stack because we are about to use EAX
int	I;
begin
for I:= 0, PSTKPTR-(LEV+1) do	\from the bottom of the stack toward the top...
	if PSTKTYP(I) = REGTYP then
		[TTXT("	PUSH	EAX|");
		PSTKTYP(I):= STKTYP];
end;	\CLEANREG



proc	TOS2HARD;  \Make sure TOS is a hard value, either in EAX or on h/w stack
begin
if PSTKPTR < 1 then [BUGMSG("TOS2HARD"); return];
case PSTKTYP(PSTKPTR-1) of
  REGTYP, STKTYP, REALTYP: return;
  ADRTYP:
	begin
	CLEANREG(1);	\EAX on TOS is ok, but stack it if it's below TOS
	OPSTRING("	MOV	EAX,&|", ^A, PSTKLEV(PSTKPTR-1),
			PSTKOFF(PSTKPTR-1), 0);
	EAXLEV:= PSTKLEV(PSTKPTR-1); EAXOFF:= PSTKOFF(PSTKPTR-1);
	EAXIMM:= false; EAXHI0:= false;
	end;
  IMMTYP:
	begin
	CLEANREG(1);
	GENEAX(PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1));
	end
other	BUGMSG("TOS2HARD");
PSTKTYP(PSTKPTR-1):= REGTYP;
end;	\TOS2HARD



proc	TOS2STACK;	\Make sure TOS is in the top of the hardware stack
begin
if PSTKPTR < 1 then [BUGMSG("TOS2STACK"); return];
CLEANREG(1);
case PSTKTYP(PSTKPTR-1) of
  REGTYP: TTXT("	PUSH	EAX|");
  STKTYP: [];
  ADRTYP: OPSTRING("	PUSH	&|", ^A, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1),
			0);
  IMMTYP: begin
	  GENEAX(PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1));
	  TTXT("	PUSH	EAX|");
	  end;
  REALTYP:return	\it is already on the FPU stack
other	BUGMSG("TOS2STACK");
PSTKTYP(PSTKPTR-1):= STKTYP;
end;	\TOS2STACK



proc	TOS2EAX;	\Make sure TOS is in EAX
begin
CLEANREG(1);
TOS2REG(^A);
PSTKTYP(PSTKPTR-1):= REGTYP;
end;	\TOS2EAX

\-------------------------------------------------------------------------------

proc	GENOP2(OPSTR, REV, NOIMM, OP);	\Output an opcode for two-argument ops
char	OPSTR;	\opcode string
int	REV,	\flag: reverse order of operands (cuz they're not commutative)
	NOIMM;	\flag: cannot be done using immediate operand (like IDIV)
char	OP;	\string containing operator, i.e: ">="
int	TOS, NOS;



\Format used in the following procedure names is DO_NOS_TOS
proc	DO_REG_REG;							\0
begin					\(this can occur because of optimizing)
OPSTRING(OPSTR, ^R, "EAX", 0, 0);
PDROP(2);
PPUSH(REGTYP, 0, 0);
end;	\DO_REG_REG



proc	DO_STK_REG;							\1
begin
TTXT("	POP	ECX|");
if REV then
	[TTXT("	XCHG	EAX,ECX|");
	EAXLEV:= -1; EAXIMM:= false; EAXHI0:= false];
OPSTRING(OPSTR, ^R, "ECX", 0, 0);
PDROP(2);
PPUSH(REGTYP, 0, 0);
end;	\DO_STK_REG



proc	DO_ADD_REG;							\2
begin
if REV then
	begin
	OPSTRING("	MOV	ECX,EAX|	MOV	EAX,&|",
			^A, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
	EAXLEV:= PSTKLEV(PSTKPTR-2); EAXOFF:= PSTKOFF(PSTKPTR-2);
	EAXIMM:= false; EAXHI0:= false;
	OPSTRING(OPSTR, ^R, "ECX", 0, 0);
	end
else	OPSTRING(OPSTR, ^A, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
PDROP(2);
PPUSH(REGTYP, 0, 0);
end;	\DO_ADD_REG



proc	DO_IMM_REG;							\3
begin
if REV then
	begin
	TTXT("	MOV	ECX,EAX|");
	GENEAX(PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2));
	OPSTRING(OPSTR, ^R, "ECX", 0, 0);
	end
else	begin
	if NOIMM then
		begin
		OPSTRING("	MOV	ECX,&|",
				^I, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
		OPSTRING(OPSTR, ^R, "ECX", 0, 0);
		end
	else OPSTRING(OPSTR, ^I, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
	end;
PDROP(2);
PPUSH(REGTYP, 0, 0);
end;	\DO_IMM_REG



proc	DO_STK_STK;							\4
begin
TTXT("	POP	ECX|	POP	EAX|");
EAXLEV:= -1; EAXIMM:= false; EAXHI0:= false;
OPSTRING(OPSTR, ^R, "ECX", 0, 0);
PDROP(2);
PPUSH(REGTYP, 0, 0);
end;	\DO_STK_STK



proc	DO_ADD_STK;							\5
begin
if REV then
	begin
	OPSTRING("	POP	ECX|	MOV	EAX,&|",
			^A, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
	EAXLEV:= PSTKLEV(PSTKPTR-2); EAXOFF:= PSTKOFF(PSTKPTR-2);
	EAXIMM:= false; EAXHI0:= false;
	OPSTRING(OPSTR, ^R, "ECX", 0, 0);
	end
else	begin
	TTXT("	POP	EAX|");
	EAXLEV:= -1; EAXIMM:= false; EAXHI0:= false;
	OPSTRING(OPSTR, ^A, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
	end;
PDROP(2);
PPUSH(REGTYP, 0, 0);
end;	\DO_ADD_STK



proc	DO_IMM_STK;							\6
begin
if REV then
	begin
	OPSTRING("	POP	ECX|", 0, 0, 0, 0);
	GENEAX(PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2));
	OPSTRING(OPSTR, ^R, "ECX", 0, 0);
	end
else	begin
	TTXT("	POP	EAX|");
	EAXLEV:= -1; EAXIMM:= false; EAXHI0:= false;
	if NOIMM then
		begin
		OPSTRING("	MOV	ECX,&|",
				^I, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
		OPSTRING(OPSTR, ^R, "ECX", 0, 0);
		end
	else	OPSTRING(OPSTR, ^I, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2),
				0);
	end;
PDROP(2);
PPUSH(REGTYP, 0, 0);
end;	\DO_IMM_STK



proc	DO_REG_ADD;							\7
begin
OPSTRING(OPSTR, ^A, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
PDROP(2);
PPUSH(REGTYP, 0, 0);
end;	\DO_REG_ADD



proc	DO_STK_ADD;							\8
begin
TTXT("	POP	EAX|");
EAXLEV:= -1; EAXIMM:= false; EAXHI0:= false;
OPSTRING(OPSTR, ^A, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
PDROP(2);
PPUSH(REGTYP, 0, 0);
end;	\DO_STK_ADD



proc	DO_ADD_ADD;							\9
begin
\If NOS is a register variable then it's better to reverse the operation
if ~REV & PSTKLEV(PSTKPTR-2)=EDXLEV & PSTKOFF(PSTKPTR-2)=EDXOFF then PSWAP;
OPSTRING("	MOV	EAX,&|", ^A, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
EAXLEV:= PSTKLEV(PSTKPTR-2); EAXOFF:= PSTKOFF(PSTKPTR-2);
EAXIMM:= false; EAXHI0:= false;

if PSTKLEV(PSTKPTR-1) = PSTKLEV(PSTKPTR-2) &
   PSTKOFF(PSTKPTR-1) = PSTKOFF(PSTKPTR-2) then
	OPSTRING(OPSTR, ^R, "EAX", 0, 0)	\don't fetch same value twice
else	OPSTRING(OPSTR, ^A, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
PDROP(2);
PPUSH(REGTYP, 0, 0);
end;	\DO_ADD_ADD



proc	DO_IMM_ADD;							\10
begin
if REV ! NOIMM then
	begin
	GENEAX(PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2));
	OPSTRING(OPSTR, ^A, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
	end
else	begin
	OPSTRING("	MOV	EAX,&|",
			^A, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
	EAXLEV:= PSTKLEV(PSTKPTR-1); EAXOFF:= PSTKOFF(PSTKPTR-1);
	EAXIMM:= false; EAXHI0:= false;
	OPSTRING(OPSTR, ^I, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
	end;
PDROP(2);
PPUSH(REGTYP, 0, 0);
end;	\DO_IMM_ADD



proc	DO_REG_IMM;							\11
begin
if NOIMM then
	begin
	TTXT("	MOV	ECX,");
	INTOUT(BINDEV, PSTKLEV(PSTKPTR-1)); CRLF(BINDEV);
	OPSTRING(OPSTR, ^R, "ECX", 0, 0);
	end
else	OPSTRING(OPSTR, ^I, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
PDROP(2);
PPUSH(REGTYP, 0, 0);
end;	\DO_REG_IMM



proc	DO_STK_IMM;							\12
begin
TTXT("	POP	EAX|");
EAXLEV:= -1; EAXIMM:= false; EAXHI0:= false;
if NOIMM then
	begin
	TTXT("	MOV	ECX,");
	INTOUT(BINDEV, PSTKLEV(PSTKPTR-1)); CRLF(BINDEV);
	OPSTRING(OPSTR, ^R, "ECX", 0, 0);
	end
else	OPSTRING(OPSTR, ^I, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
PDROP(2);
PPUSH(REGTYP, 0, 0);
end;	\DO_STK_IMM



proc	DO_ADD_IMM;							\13
begin
if REV then
	begin
	OPSTRING("	MOV	EAX,&|",
			^A, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
	EAXLEV:= PSTKLEV(PSTKPTR-2); EAXOFF:= PSTKOFF(PSTKPTR-2);
	EAXIMM:= false; EAXHI0:= false;
	if NOIMM then
		begin
		OPSTRING("	MOV	ECX,&|",
				^I, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
		OPSTRING(OPSTR, ^R, "ECX", 0, 0);
		end
	else	OPSTRING(OPSTR, ^I, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
	end
else	begin
	if NOIMM then
		begin
		GENEAX(PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1));
		OPSTRING(OPSTR, ^A, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
		end
	else	begin
		OPSTRING("	MOV	EAX,&|",
				^A, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
		EAXLEV:= PSTKLEV(PSTKPTR-2); EAXOFF:= PSTKOFF(PSTKPTR-2);
		EAXIMM:= false; EAXHI0:= false;
		OPSTRING(OPSTR, ^I, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
		end;
	end;
PDROP(2);
PPUSH(REGTYP, 0, 0);
end;	\DO_ADD_IMM



proc	DO_IMM_IMM;							\14
\WARNING: this must not affect EAX (not "clean")
int	TOSVAL, NOSVAL, C1, C2, REMAIN;
begin
if PSTKOFF(PSTKPTR-1)#^C ! PSTKOFF(PSTKPTR-2)#^C then
	BUGMSG("DO_IMM_IMM LABELS");

TOSVAL:= PSTKLEV(PSTKPTR-1);
NOSVAL:= PSTKLEV(PSTKPTR-2);
C1:= OP(0); C2:= OP(1);			\get operator symbol from string
C2:= if C1>=$80 then 0 else C2 & $7F;
C1:= C1 & $7F;
case C1 of
  ^=:	TOSVAL:= NOSVAL=TOSVAL;
  ^#:	TOSVAL:= NOSVAL#TOSVAL;
  ^>:	TOSVAL:= if C2=^= then NOSVAL>=TOSVAL else NOSVAL>TOSVAL;
  ^<:	TOSVAL:= if C2=^= then NOSVAL<=TOSVAL else NOSVAL<TOSVAL;
  ^!:	TOSVAL:= NOSVAL!TOSVAL;
  ^&:	TOSVAL:= NOSVAL&TOSVAL;
  ^|:	TOSVAL:= NOSVAL|TOSVAL;
  ^+:	TOSVAL:= NOSVAL+TOSVAL;
  ^-:	TOSVAL:= NOSVAL-TOSVAL;
  ^*:	TOSVAL:= NOSVAL*TOSVAL;
  ^/:	begin
	if TOSVAL=0 then [ERROR(73); TOSVAL:= $7FFFFFFF; REMAIN:= 0]
	else [TOSVAL:= NOSVAL/TOSVAL; REMAIN:= REM(0)];
	OPSTRING("	MOV	REMAIN,&|", ^I, REMAIN, ^C, 0);
	end
other	BUGMSG("DO_IMM_IMM");
PDROP(2);
PPUSH(IMMTYP, TOSVAL, ^C);
HAVESTAT:= false;
end;	\DO_IMM_IMM



begin	\GENOP2
if PSTKPTR < 2 then BUGMSG("GENOP2");

if PSTKTYP(PSTKPTR-1)=IMMTYP & PSTKOFF(PSTKPTR-1)#^C !	\handle "NAME"+2, etc.
   PSTKTYP(PSTKPTR-2)=IMMTYP & PSTKOFF(PSTKPTR-2)#^C then
	[TOS2HARD; EAXLEV:= -1; EAXIMM:= false; EAXHI0:= false];

TOS:= PSTKTYP(PSTKPTR-1);
NOS:= PSTKTYP(PSTKPTR-2);
if TOS#IMMTYP ! NOS#IMMTYP then CLEANREG(2);	\if they're not both immediates
HAVESTAT:= true;	\OPSTR sets status flags except for DO_IMM_IMM

\Generate opcode based on NOS and TOS
case of
  NOS=REGTYP & TOS=REGTYP: DO_REG_REG;		\0
  NOS=STKTYP & TOS=REGTYP: DO_STK_REG;		\1
  NOS=ADRTYP & TOS=REGTYP: DO_ADD_REG;		\2
  NOS=IMMTYP & TOS=REGTYP: DO_IMM_REG;		\3

  NOS=STKTYP & TOS=STKTYP: DO_STK_STK;		\4
  NOS=ADRTYP & TOS=STKTYP: DO_ADD_STK;		\5
  NOS=IMMTYP & TOS=STKTYP: DO_IMM_STK;		\6

  NOS=REGTYP & TOS=ADRTYP: DO_REG_ADD;		\7
  NOS=STKTYP & TOS=ADRTYP: DO_STK_ADD;		\8
  NOS=ADRTYP & TOS=ADRTYP: DO_ADD_ADD;		\9
  NOS=IMMTYP & TOS=ADRTYP: DO_IMM_ADD;		\10

  NOS=REGTYP & TOS=IMMTYP: DO_REG_IMM;		\11
  NOS=STKTYP & TOS=IMMTYP: DO_STK_IMM;		\12
  NOS=ADRTYP & TOS=IMMTYP: DO_ADD_IMM;		\13
  NOS=IMMTYP & TOS=IMMTYP: DO_IMM_IMM		\14
other	BUGMSG("GENOP2");
end;	\GENOP2

\------------------------ ROUTINES TO GENERATE OPCODES -------------------------

proc	POSTGEN;
\Postponing the use of an index register after it is loaded can save 2
\ cycles on a 486 and even more on a Pentium. These hidden cycles are
\ caused by Address Generation Interlock (AGI).
begin
\Note that the MOV instruction does not affect status. GENFOR takes advantage
\ of this. (Don't use OPSTRING because EAX cannot be used to substitute for an
\ immediate value when storing bytes.)
case POSTGENTYPE of
  1:	[TTXT("	MOV	BYTE PTR [EBX]+"); INTOUT(BINDEV,POSTGENOFF);
	CHOUT(BINDEV, ^,); INTOUT(BINDEV,POSTGENVAL&$FF); CRLF(BINDEV)];
  2:	OPSTRING("	MOV	DWP [EBX],&|", ^I, POSTGENVAL, ^C, 0)
other	BUGMSG("POSTGEN");
POSTGENTYPE:= 0;
end;	\POSTGEN



proc	GENSTART;
begin
TTXT("	PAGE	240,132
	.386P
	.387
CSEG	SEGMENT PARA PUBLIC USE32 'CODE'
	ASSUME CS:CSEG
	EXTRN INTR0:NEAR, INTR1:NEAR, INTR2:NEAR, INTR3:NEAR
	EXTRN INTR4:NEAR, INTR5:NEAR, INTR6:NEAR, INTR7:NEAR
	EXTRN INTR8:NEAR, INTR9:NEAR, INTR10:NEAR, INTR11:NEAR
	EXTRN INTR12:NEAR, INTR13:NEAR, INTR14:NEAR, INTR15:NEAR
	EXTRN INTR16:NEAR, INTR17:NEAR, INTR18:NEAR, INTR19:NEAR
	EXTRN INTR20:NEAR, INTR21:NEAR, INTR22:NEAR, INTR23:NEAR
	EXTRN INTR24:NEAR, INTR25:NEAR, INTR26:NEAR, INTR27:NEAR
	EXTRN INTR28:NEAR, INTR29:NEAR, INTR30:NEAR, INTR31:NEAR
	EXTRN INTR32:NEAR, INTR33:NEAR, INTR34:NEAR, INTR35:NEAR
	EXTRN INTR36:NEAR, INTR37:NEAR, INTR38:NEAR, INTR39:NEAR
	EXTRN INTR40:NEAR, INTR41:NEAR, INTR42:NEAR, INTR43:NEAR
	EXTRN INTR44:NEAR, INTR45:NEAR, INTR46:NEAR, INTR47:NEAR
	EXTRN INTR48:NEAR, INTR49:NEAR, INTR50:NEAR, INTR51:NEAR
	EXTRN INTR52:NEAR, INTR53:NEAR, INTR54:NEAR, INTR55:NEAR
	EXTRN INTR56:NEAR, INTR57:NEAR, INTR58:NEAR, INTR59:NEAR
	EXTRN INTR60:NEAR, INTR61:NEAR, INTR62:NEAR, INTR63:NEAR
	EXTRN INTR64:NEAR, INTR65:NEAR, INTR66:NEAR, INTR67:NEAR
	EXTRN INTR68:NEAR, INTR69:NEAR, INTR70:NEAR, INTR71:NEAR
	EXTRN INTR72:NEAR, INTR73:NEAR, INTR74:NEAR, INTR75:NEAR
	EXTRN INTR76:NEAR, INTR77:NEAR, INTR78:NEAR, INTR79:NEAR
	EXTRN INTR80:NEAR, INTR81:NEAR, INTR82:NEAR, INTR83:NEAR
	EXTRN INTR12A:NEAR
	EXTRN MKARRAY:NEAR
CSEG	ENDS

DSEG	SEGMENT PARA PUBLIC USE32 'DATA'
	ASSUME DS:DSEG
	EXTRN STKPTR:DWORD, REMAIN:DWORD, HEAPLO:DWORD
	EXTRN BASE0:DWORD, BASE1:DWORD, BASE2:DWORD, BASE3:DWORD
	EXTRN BASE4:DWORD, BASE5:DWORD, BASE6:DWORD, BASE7:DWORD
DSEG	ENDS

DWP	EQU	< DWORD PTR >
QWP	EQU	< QWORD PTR >

CSEG	SEGMENT PARA PUBLIC USE32 'CODE'
PROGRM:
");
end;	\GENSTART



proc	DSTART;		\Start a DSEG data segment
begin
if POSTGENTYPE\#0\ then POSTGEN;		\(for neatness)
TTXT("|DSEG	SEGMENT PARA PUBLIC 'DATA'|");
end;	\DSTART



proc	DEND;		\End the DSEG data segment
begin
TTXT("DSEG	ENDS||");
end;	\DEND



proc	DLABEL(N);	\Make a data label
int	N;
begin
TTXT("|L");	\"|" is necessary because there might already be a label here
INTOUT(BINDEV, N);
end;	\DLABEL



proc	FLABEL(N);	\Make a near code label
int	N;
begin
DLABEL(N);
TTXT("	LABEL	");
TTXT("NEAR|");
LASTOP:= -1;		\we might not be coming from the previous opcode, so
OLDLEV:= -1;		\ we don't know what's in these registers
EDXLEV:= -1;
EAXLEV:= -1;
EAXIMM:= false;
EAXHI0:= false;
end;	\FLABEL



proc	CLABEL(N);	\Make a code label
int	N;
begin
if POSTGENTYPE\#0\ then POSTGEN;
DLABEL(N); CHOUT(BINDEV, ^:);
if DEBUG then CRLF(BINDEV);
LASTOP:= -1;		\We might not be coming from the previous opcode, so
OLDLEV:= -1;		\ we don't know what's in these registers.
EAXLEV:= -1;		\However the EDX register gets special consideration.
EAXIMM:= false;		\Do not bomb EDX.
EAXHI0:= false;
end;	\CLABEL



func	NEWLAB;		\Generate a new label number
begin
LABCTR:= LABCTR+1;
return LABCTR;
end;	\NEWLAB



proc	COMMENT(OPC);  \All opcode routines call this before generating any code
int	OPC;
int	COMTB1, COMTB2;
begin
LASTOP:= OPC;
CODCTR:= CODCTR +1;

\The opcodes listed below are guaranteed to never use EBX, thus the call to
\ POSTGEN can be postponed. Opcodes (such as LDX) that are optimized by a
\ following opcode that uses LASTOP (such as STX) are not in the list so that
\ a POSTGEN does not occur between these opcodes and interfere with their
\ optimization.
if POSTGENTYPE\#0\ then
	begin
	case OPC of
	  $01\LOD\, $03\STO\, $0A\ARG\, $0B\IMM\, $0D\ADD\, $0E\SUB\, $0F\MUL\,
	  $10\DIV\, $11\NEG\, $18\FOR\, $19\INP\, $1A\OR\, $1B\AND\, $1D\EOR\,
	  $21\ADR\, $28\DRP\, $3C\MARK\, $3D\ASR\, $3E\LSL\, $3F\LSR\: []
	other POSTGEN;
	end;

if not I2LCOMFLAG then return;

COMTB1:=
 ["EXIT","LOD","LDX","STO","STX","CAL","RET","JMP","JPC","HPI","ARG","IMM",
 "CML","ADD","SUB","MUL","DIV","NEG","EQ","NE","GE","GT","LE","LT","FOR",
 "INP","OR","AND","NOT","EOR","DBA","STD","DBX","ADR","LDI","LDA","IMS",
 "CJP","JSR","RTS","DRP","CEXT","FLOD","FSTO","FIMM","FADD","FSUB","FMUL",
 "FDIV","FNEG","FEQ","FNE","FGE","FGT","FLE","FLT","TRA","TRX","TRI","STT",
 "MARK","ASR","LSL","LSR","LDSI","LDSB","LDSR","STSI","STSB","STSR","LSHORT",
 "SSHORT","MKARRAY","ABS","FABS","REM","SWAP","EXT","PIN","POUT","FIX",
 "FLOAT","FSQRT","SQRT","FSQ","SQ"];
\LDSI..SSHORT are obsolete and have been removed from the rest of the code. They
\ are kept in this list as place holders to preserve the original opcode numbers

COMTB2:= ["TXT","FLT","INT","END","NUL"];

SHOWSTK;
CRLF(BINDEV);
TEXT(BINDEV, "; $"); HEXB(OPC); TEXT(BINDEV, " - ");
TEXT(BINDEV, if OPC >= $FB then COMTB2(OPC-$FB) else COMTB1(OPC));
CRLF(BINDEV);
end;	\COMMENT



proc	GENEXIT;	\$00
begin
COMMENT($00);
TTXT("	MOV	ESP,STKPTR|	RET|");
DOALIGN;
end;	\GENEXIT



proc	GENLOD(L, O);	\$01 TOS <- @(Level + Offset)
int	L, O;
begin
COMMENT($01);
if L=EAXLEV & O=EAXOFF then		\value of the variable is already in EAX
	PPUSH(REGTYP, 0, 0)
else	PPUSH(ADRTYP, L, O);
end;	\GENLOD



proc	GENLDX;		\$02 TOS <- @((NOS) + TOS)
int	C;		\e.g: A(3); A=NOS, 3=TOS
begin
COMMENT($02);
CLEANREG(2);
if PSTKTYP(PSTKPTR-1)=IMMTYP then
	begin				\the index is a constant (C)
	C:= PSTKLEV(PSTKPTR-1);
	PDROP(1);
	if PSTKTYP(PSTKPTR-1)=REGTYP then
		TTXT("	MOV	AL,[EAX]+")
	else	[TOS2REG(^B);
		TTXT("	MOV	AL,[EBX]+")];
	INTOUT(BINDEV,C);
	end
else	begin
	\if TOS is in EDX then it's better to reverse the operation
	if PSTKLEV(PSTKPTR-1)=EDXLEV & PSTKOFF(PSTKPTR-1)=EDXOFF !
	   PSTKTYP(PSTKPTR-1)=REGTYP then PSWAP;

	if PSTKLEV(PSTKPTR-2)=EDXLEV & PSTKOFF(PSTKPTR-2)=EDXOFF then
		begin		\NOS is in EDX
		TOS2REG(^A); PDROP(1);
		TTXT("	MOV	AL,[EAX+EDX]");
		end
	else if PSTKTYP(PSTKPTR-2)=REGTYP then
		begin		\NOS is in EAX
		TOS2REG(^B); PDROP(1);
		TTXT("	MOV	AL,[EAX+EBX]");
		end
	else	begin
		TOS2REG(^B); PDROP(1);
		ADDTOS2EBX;
		TTXT("	MOV	AL,[EBX]");
		end;
	end;
PDROP(1);
TTXT("|");

if EAXHI0 then LASTOP:= -1
else TTXT("	MOVZX	EAX,AL|");
\optimized GENSTX, GENJPC, SHIFT and GENPOUT depends on this MOVZX instruction

PPUSH(REGTYP, 0, 0);
EAXLEV:= -1; EAXIMM:= false; EAXHI0:= true;
end;	\GENLDX



proc	GENSTO(L, O);	\$03 @(Level + Offset) <- TOS
int	L, O;
begin
COMMENT($03);
if L=EAXLEV & O=EAXOFF then EAXLEV:= -1; \Must bomb reg variable before using
if L=EDXLEV & O=EDXOFF then EDXLEV:= -1; \ OPSTRING to store into any variable
case PSTKTYP(PSTKPTR-1) of
  REGTYP: [OPSTRING("	MOV	&,EAX|",	^A, L, O, 0);
	   EAXLEV:= L; EAXOFF:= O];
  STKTYP: OPSTRING("	POP	&|",	^A, L, O, 0);
  ADRTYP: if L#PSTKLEV(PSTKPTR-1) ! O#PSTKOFF(PSTKPTR-1) then	\don't gen A:= A
	    [OPSTRING("	MOV	EAX,&|",	^A, PSTKLEV(PSTKPTR-1),
	    		PSTKOFF(PSTKPTR-1), 0);
	     OPSTRING("	MOV	&,EAX|",	^A, L, O, 0);
	     EAXLEV:= L; EAXOFF:= O; EAXIMM:= false; EAXHI0:= false];
  IMMTYP:
	begin	\if immediate value is 0, it's better to use 2 instructions
	if PSTKLEV(PSTKPTR-1) = 0 then
		[GENEAX(PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1));
		OPSTRING("	MOV	&,EAX|",	^A, L, O, 0);
		EAXLEV:= L; EAXOFF:= O]
	else	[OPSTRING("	MOV	&,",	^A, L, O, 0);
		OPSTRING("&|",		^I, PSTKLEV(PSTKPTR-1),
				PSTKOFF(PSTKPTR-1), 0)];
	end
other	BUGMSG("GENSTO");
PDROP(1);
end;	\GENSTO



proc	GENSTX;		\$04 @(NOS) <- TOS
int	LEV, OFF, TOS, NOS, LOP;
begin
LOP:= LASTOP;
COMMENT($04);
if LOP=\LDX\$02 ! LOP=\PIN\$4E then
	[TTXT("	ORG	$-3|"); EAXHI0:= false];	\eliminate MOVZX EAX,AL

TOS:= PSTKTYP(PSTKPTR-1);
NOS:= PSTKTYP(PSTKPTR-2);

if TOS=IMMTYP then
	begin
	LEV:= PSTKLEV(PSTKPTR-1);
	OFF:= PSTKOFF(PSTKPTR-1);
	PDROP(1);
	TOS2REG(^B);
	OPSTRING("	MOV	BYTE PTR [EBX],&|", ^I, LEV&$FF, OFF, 0);
	PDROP(1);
	end
else	begin
	if NOS=REGTYP then
		begin
		TOS2REG(^B); PDROP(1);
		PDROP(1);
		TTXT("	MOV	[EAX],BL|");
		end
	else	begin
		TOS2REG(^A); PDROP(1);
		TOS2REG(^B); PDROP(1);
		TTXT("	MOV	[EBX],AL|");
		end;
	end;
end;	\GENSTX



proc	GENSTX2;	\$04 @(NOS2+NOS) <- TOS
int	LOP;
begin
LOP:= LASTOP;
COMMENT($04);
if LOP=\LDX\$02 ! LOP=\PIN\$4E then
	[TTXT("	ORG	$-3|"); EAXHI0:= false];	\eliminate MOVZX EAX,AL

OPSTRING("	MOV	EBX,&|", ^A, PSTKLEV(PSTKPTR-3), PSTKOFF(PSTKPTR-3), 0);

POSTGENOFF:= 0;
case PSTKTYP(PSTKPTR-2) of
  REGTYP: OPSTRING("	ADD	EBX,&|", ^R, "EAX", 0, 0);
  STKTYP: OPSTRING("	POP	ECX|	ADD	EBX,&|", ^R, "ECX", 0, 0);
  ADRTYP: OPSTRING("	ADD	EBX,&|", ^A, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
  IMMTYP: POSTGENOFF:= PSTKLEV(PSTKPTR-2)
other BUGMSG("GENSTX2");

if PSTKTYP(PSTKPTR-1)=IMMTYP & PSTKOFF(PSTKPTR-1)=^C then
	[POSTGENVAL:= PSTKLEV(PSTKPTR-1); POSTGENTYPE:= 1]
else	begin
	TOS2REG(^A);
	TTXT("	MOV	[EBX]+"); INTOUT(BINDEV,POSTGENOFF); TTXT(",AL|");
	end;
PDROP(3);
end;	\GENSTX2



proc	GENCAL(LABEL, EXT);	\$05 procedure call
int	LABEL,
	EXT;	\flag: external procedure (eproc or efunc)
begin
COMMENT($05);
TTXT("	CALL	");
if EXT then [CHOUT(BINDEV, ^_); SYMOUT(LABEL)]
else [TTXT("L"); INTOUT(BINDEV, LABEL)];
CRLF(BINDEV);
OLDLEV:= -1;		\subroutine might have destroyed registers
EDXLEV:= -1;
EAXLEV:= -1;
EAXIMM:= false;
EAXHI0:= false;
end;	\GENCAL



proc	DOJUMP(L);	\Generate JMP instruction (as part of an opcode)
int	L;
begin
TTXT("	JMP	L"); INTOUT(BINDEV, L);
CRLF(BINDEV);
DOALIGN;
end;	\DOJUMP



proc	GENRET(L);	\$06
int	L;
int	P;
begin
if LASTOP=$00\EXIT\ ! LASTOP=$06\RET\ ! LASTOP=$07\JMP\ then return;
COMMENT($06);
if L = 0 then TTXT("	RET|")
else	begin	    \(don't mess up EAX because a value might be returned in it)
	L:= L >> 1;
	if PROCRETS(L)\#0\ & HAVENEST then
		DOJUMP(PROCRETS(L))	\jump to existing procedure return code
	else	begin
		if HAVENEST then
			begin		\make label for this procedure return
			P:= NEWLAB;
			PROCRETS(L):= P;
			CLABEL(P);
			end;

		\ 1	POP	EDI	   ;get value originally in BASEn
		\(6	XCHG	EDI,BASEn) ;restore BASEn and EDI
		\ 1	POP	ESI	   ;restore ESI
		\ 1	RET

		TTXT("	POP	EDI|");
		if HAVENEST then
			[TTXT("	XCHG	EDI,BASE"); INTOUT(BINDEV, L); TTXT("|")];
		TTXT("	POP	ESI|	RET");
		CRLF(BINDEV);
		DOALIGN;
		end;
	end;
end;	\GENRET



proc	GENJSR(L);	\$26 optimized procedure call
int	L;
begin
COMMENT($26);
TTXT("	CALL	L"); INTOUT(BINDEV, L); CRLF(BINDEV);
OLDLEV:= -1;		\procedure might have destroyed registers
EDXLEV:= -1;
EAXLEV:= -1;
EAXIMM:= false;
EAXHI0:= false;
end;	\GENJSR



proc	GENRTS(L);	\$27 optimized procedure return
int	L;
begin
if LASTOP=$00\EXIT\ ! LASTOP=$07\JMP\ ! LASTOP=$27\RTS\ then return;
COMMENT($27);
\don't mess up EAX because a value might be returned in it
if L > 0 then TTXT("	POP	ESI|");
TTXT("	RET");
CRLF(BINDEV);
DOALIGN;
end;	\GENRTS



proc	GENCML(LABEL, LAST, TYPE, FUNC, ARGS);	\$0C intrinsic call
int	LABEL, LAST, TYPE, FUNC, ARGS;
begin
COMMENT($0C);
if ARGS > 0 then
	begin		\handle all combinations of arguments
	if TYPE=ININT then
		[if LAST=INTEGER then TOS2EAX else TTXT("	POP	EAX|")]
	else	TOS2STACK;
	end;

TTXT("	CALL	INTR"); INTOUT(BINDEV, LABEL);
if LABEL=12 & STRTERM=0 then CHOUT(BINDEV, ^A);	\use alternate Text intrinsic
CRLF(BINDEV);

PDROP(ARGS);
OLDLEV:= -1;		\intrinsic call might have destroyed registers
EDXLEV:= -1;
EAXLEV:= -1;
EAXIMM:= false;
EAXHI0:= false;
if FUNC then
	case TYPE of
	  ININT: PPUSH(REGTYP, 0, 0);
	  RLINT: PPUSH(REALTYP, 0, 0)
	other;
end;	\GENCML



proc	GENCEXT(LABEL, LAST, TYPE, FUNC, ARGS);	\$29 external assembly routine
int	LABEL, LAST, TYPE, FUNC, ARGS;
begin
COMMENT($29);
if ARGS>0 & LAST=INTEGER then TOS2STACK;
\WARNING: ESI and EDI must not be altered by the assembly language subroutine
TTXT("	CALL	"); SYMOUT(LABEL); CRLF(BINDEV);

PDROP(ARGS);
OLDLEV:= -1;		\subroutine call might have destroyed registers
EDXLEV:= -1;
EAXLEV:= -1;
EAXIMM:= false;
EAXHI0:= false;
if FUNC then
	case TYPE of
	  INEXT: PPUSH(STKTYP, 0, 0);
	  RLEXT: PPUSH(REALTYP, 0, 0)
	other;
end;	\GENCEXT



proc	GENJMP(L);	\$07
int	L;
begin
if LASTOP=$00\EXIT\ ! LASTOP=$06\RET\ ! LASTOP=$07\JMP\ !
	LASTOP=$27\RTS\ then return;
COMMENT($07);
DOJUMP(L);
end;	\GENJMP



proc	GENFJMP(L);	\Generate jump for 'fproc's
int	L;
begin
COMMENT($07);
TTXT("	JMP	");
CHOUT(BINDEV,^L); INTOUT(BINDEV, L); CRLF(BINDEV);
end;	\GENFJMP



proc	GENJPC(L, SENSE);	\$08 Jump if TOS=false (or true)
int	L, SENSE;	\normally sense = false, for jump on false
int	LOP;

	proc	GENJ(S);
	char	S;
	begin
	TTXT("	J");
	S:= S +1;			\Skip the "J"
	if SENSE then			\reverse meaning
		[if S(0) = ^N then S:= S +1
		else TTXT("N")];
	TTXT(S);
	TTXT("	L"); INTOUT(BINDEV, L); CRLF(BINDEV);
	end;	\GENJ

begin	\GENJPC
LOP:= LASTOP;
COMMENT($08);
\if immediate = SENSE (usually false) then unconditionaly jump
\if immediate = SENSE (usually true) then gen no instruction
if PSTKTYP(PSTKPTR-1)=IMMTYP then
	[if (PSTKLEV(PSTKPTR-1)#0) = SENSE then [CRLF(BINDEV); DOJUMP(L)]]
else	begin
	if LOP>=$12 & LOP<=$17 then		\optimize comparison
		begin
		TTXT("	ORG	$-8|");		\back over MOV, Jcc, INC
		EAXIMM:= SEAXIMM;		\previous CMP didn't destroy EAX
		EAXLEV:= SEAXLEV;
		EAXHI0:= SEAXHI0;
		case LOP of
		  $12:	GENJ("JNE");
		  $13:	GENJ("JE");
		  $14:	GENJ("JL");
		  $15:	GENJ("JLE");
		  $16:	GENJ("JG");
		  $17:	GENJ("JGE")
		other;
		end
	else if LOP=\LDX\$02 ! LOP=\PIN\$4E then
		begin
		TTXT("	ORG	$-3|	TEST	AL,AL|");     \kill MOVZX EAX,AL
		EAXHI0:= false;
		GENJ("JE");
		end
	else if HAVESTAT & (LOP=\OR\$1A ! LOP=\AND\$1B) then
		GENJ("JE")
	else if LOP=\NOT\$1C & PSTKTYP(PSTKPTR-1)=REGTYP then
		begin
		TTXT("	ORG	$-2|	XOR	EAX,-1|");  \eliminate NOT EAX
		EAXHI0:= false; EAXLEV:= -1;	\EAXVAL and EAXIMM are unchanged
		GENJ("JE")
		\BEWARE: replacing NOT JE with JNE does not work if EAX = 1, etc
		end
	else if PSTKTYP(PSTKPTR-1)=ADRTYP then
		begin		\replace MOV EAX,mem TEST EAX,EAX with CMP mem,0
		OPSTRING("	CMP	&,0|", ^A, PSTKLEV(PSTKPTR-1),
			PSTKOFF(PSTKPTR-1), 0);
		GENJ("JE");
		end
	else	begin					\normal JPC
		CLEANREG(1);
		TOS2REG(^A);
		if LOP<$32\FEQ\ ! LOP>$37 \FLT\ then	\optimize comparison
			TTXT("	TEST	EAX,EAX|");
		GENJ("JE");
		if SENSE \=true i.e. JNE\ then
			[EAXIMM:= true; EAXVAL:= 0; EAXHI0:= true];
		end;
	end;
PDROP(1);
end;	\GENJPC



proc	GENHPI(V);	\$09
int	V;
begin
COMMENT($09);
if V # 0 then
	begin
	TTXT("	ADD	EDI,"); INTOUT(BINDEV, V);
	CRLF(BINDEV);
	end;
end;	\GENHPI



proc	GENBASE(L,V);	\$09.5  Generate start of procedure
int	L, V;
begin
COMMENT($09);
OLDLEV:= L;
if L = 0 then return;		\(split heap)

\This isn't necessary at level 0 because RET does an EXIT and BASE0 is not used.
\ 1	PUSH	ESI		;preserve ESI across procedure call
\ 2	MOV	ESI,EDI		;set ESI to base of procedure's variables
\(6	XCHG	BASEn,EDI)	;set BASE and get its old value
\ 1	PUSH	EDI		;save old value of BASE (in case of recursion)
\ 3	LEA	EDI,[ESI]+V	;restore EDI and add space for local variables

EAXLEV:= -1; EAXIMM:= false; EAXHI0:= false;
TTXT("	PUSH	ESI|	MOV	ESI,EDI|");
if HAVENEST then
	[TTXT("	XCHG	BASE"); INTOUT(BINDEV, L/2); TTXT(",EDI|")];
TTXT("	PUSH	EDI|	LEA	EDI,[ESI]+"); INTOUT(BINDEV,V); TTXT("|");
end;	\GENBASE



\OLD - required because of reals
proc	GENARG0(BYTES);	\$0A Move procedure arguments from pseudo stack to heap
int	BYTES;
int	P, I, L;

	proc	HEAPOP(S, A);	\Produce heap argument operand
	int	S, A;
	begin
	TTXT(S); TTXT("DWP [EDI]+"); INTOUT(BINDEV, A);
	end;	\HEAPOP

begin	\GENARG0
COMMENT($0A);
for P:= 1, BYTES/INTSIZE do		\P = number of dwords
	begin
	case PSTKTYP(PSTKPTR-1) of
	REGTYP: [HEAPOP("	MOV	", BYTES-(INTSIZE*P)); TTXT(",EAX|")];
	IMMTYP: begin
		HEAPOP("	MOV	", BYTES-(INTSIZE*P));
		OPSTRING(",&|", ^I, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
		end;
	ADRTYP: begin
		OPSTRING("	MOV	ECX,&|",
				^A, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
		HEAPOP("	MOV	", BYTES-(INTSIZE*P)); TTXT(",ECX|");
		end;
	STKTYP: [HEAPOP("	POP	", BYTES-(INTSIZE*P)); CRLF(BINDEV)];
	REALTYP:[TTXT("	FSTP	QWP [EDI]+");
		INTOUT(BINDEV, BYTES-(INTSIZE*P)-4);
		CRLF(BINDEV);
		P:= P+1]		\skip 2nd half of real
	other BUGMSG("GENARG");
	PDROP(1);
	end;
end;	\GENARG0



\NEW
proc	GENARG1(BYTES);	\$0A Move procedure arguments from pseudo stack to heap
int	BYTES;
int	P, Q,	\dwords of arguments
	DUP;	\flag: have duplicate args

	proc	HEAPOP(S, I);	\Produce heap argument operand
	int	S, I;
	begin
	TTXT(S);   TTXT("DWP [EDI]+");   INTOUT(BINDEV, BYTES-(INTSIZE*I));
	PSTKTYP(PSTKPTR-I):= -1;	\mark it off
	end;	\HEAPOP

begin	\GENARG1
COMMENT($0A);
for P:= 1, BYTES/INTSIZE do
	begin
	case PSTKTYP(PSTKPTR-P) of
	REGTYP: [HEAPOP("	MOV	", P);   TTXT(",EAX|")];
	STKTYP: [HEAPOP("	POP	", P);   CRLF(BINDEV)]
	other;
	end;
for P:= 1, BYTES/INTSIZE do
	begin
	if PSTKTYP(PSTKPTR-P) = IMMTYP then
	    begin
	    DUP:= false;
	    for Q:= P+1, BYTES/INTSIZE do		\scan for duplicates
		begin
		if PSTKTYP(PSTKPTR-Q) = IMMTYP then
		   if PSTKLEV(PSTKPTR-Q) = PSTKLEV(PSTKPTR-P) &
		      PSTKOFF(PSTKPTR-Q) = PSTKOFF(PSTKPTR-P) then
			begin				\duplicate found
			if ~DUP then
			    [DUP:= true;
			    GENEAX(PSTKLEV(PSTKPTR-P), PSTKOFF(PSTKPTR-P));
			    HEAPOP("	MOV	", P);   TTXT(",EAX|")];
			HEAPOP("	MOV	", Q);   TTXT(",EAX|");
			end;
		end;
	    if ~DUP then
		begin	\"AND [EDI]+n,0" is a byte shorter than "MOV [EDI]+n,0"
		if PSTKLEV(PSTKPTR-P)=0 & PSTKOFF(PSTKPTR-P)=^C &
			~(EAXVAL=0 & EAXIMM) \not already in EAX\ then
		  [HEAPOP("	AND	", P);   TTXT(",0|")]
		else if PSTKLEV(PSTKPTR-P)=-1 & PSTKOFF(PSTKPTR-P)=^C &
			~(EAXVAL=-1 & EAXIMM) \not already in EAX\ then
		  [HEAPOP("	OR	", P);   TTXT(",-1|")]
		else
		  [HEAPOP("	MOV	", P);
		  OPSTRING(",&|", ^I, PSTKLEV(PSTKPTR-P), PSTKOFF(PSTKPTR-P),
		  		0)];
		end;
	    end;
	end;
for P:= 1, BYTES/INTSIZE do
	begin
	if PSTKTYP(PSTKPTR-P) = ADRTYP then
	    begin
	    DUP:= false;
	    for Q:= P+1, BYTES/INTSIZE do		\scan for duplicates
		begin
		if PSTKTYP(PSTKPTR-Q) = ADRTYP &
		   PSTKLEV(PSTKPTR-Q) = PSTKLEV(PSTKPTR-P) &
		   PSTKOFF(PSTKPTR-Q) = PSTKOFF(PSTKPTR-P) then
			begin				\duplicate found
			if ~DUP then
			    [DUP:= true;
			    OPSTRING("	MOV	EAX,&|", ^A, PSTKLEV(PSTKPTR-P),
				PSTKOFF(PSTKPTR-P), 0);
			    EAXLEV:= PSTKLEV(PSTKPTR-P);
			    EAXOFF:= PSTKOFF(PSTKPTR-P);
			    EAXIMM:= false; EAXHI0:= false;
			    HEAPOP("	MOV	", P);   TTXT(",EAX|")];
			HEAPOP("	MOV	", Q);   TTXT(",EAX|");
			end;
		end;
	    if ~DUP then
		[OPSTRING("	MOV	EAX,&|", ^A, PSTKLEV(PSTKPTR-P),
			PSTKOFF(PSTKPTR-P), 0);
		EAXLEV:= PSTKLEV(PSTKPTR-P); EAXOFF:= PSTKOFF(PSTKPTR-P);
		EAXIMM:= false; EAXHI0:= false;
		HEAPOP("	MOV	", P);   TTXT(",EAX|")];
	    end;
	end;
for P:= 1, BYTES/INTSIZE do PDROP(1);
end;	\GENARG1



proc	GENARG(BYTES);	\$0A Move procedure arguments from pseudo stack to heap
int	BYTES;
int	P;
begin
\If there is a real argument then handle the old way, else there is a
\ one-to-one correspondance between arguments and dwords passed.
for P:= 1, BYTES/INTSIZE do
	if PSTKTYP(PSTKPTR-P)=REALTYP then P:= 30000;
if P>=30000 then GENARG0(BYTES)
else GENARG1(BYTES);
end;	\GENARG



proc	GENIMM(K, V);	\$0B & $24
int	K,	\kind:	^L=label	^C=constant
	V;	\value:	label no.	immediate
begin
COMMENT($0B);
PPUSH(IMMTYP, V, K);
end;	\GENIMM



proc	GENADD;		\$0D
int	TOSTYP, NOSTYP;
begin
COMMENT($0D);
if ~IDENTITY(0,true) then
	begin
	TOSTYP:= PSTKTYP(PSTKPTR-1);
	NOSTYP:= PSTKTYP(PSTKPTR-2);
	if TOSTYP=IMMTYP & PSTKLEV(PSTKPTR-1)=1 & PSTKOFF(PSTKPTR-1)=^C &
	    NOSTYP#IMMTYP then
		begin				\optimize A+1
		PDROP(1);
		CLEANREG(1);
		TOS2REG(^A);
		TTXT("	INC	EAX|");
		EAXLEV:= -1; EAXVAL:= EAXVAL+1; EAXHI0:= false;
		PDROP(1); PPUSH(REGTYP, 0, 0);
		end
	else if NOSTYP=IMMTYP & PSTKLEV(PSTKPTR-2)=1 & PSTKOFF(PSTKPTR-2)=^C &
	    TOSTYP#IMMTYP then
		begin				\optimize 1+A
		PSTKTYP(PSTKPTR-2):= PSTKTYP(PSTKPTR-1);
		PSTKLEV(PSTKPTR-2):= PSTKLEV(PSTKPTR-1);
		PSTKOFF(PSTKPTR-2):= PSTKOFF(PSTKPTR-1);
		PDROP(1);
		CLEANREG(1);
		TOS2REG(^A);
		TTXT("	INC	EAX|");
		EAXLEV:= -1; EAXVAL:= EAXVAL+1; EAXHI0:= false;
		PDROP(1); PPUSH(REGTYP, 0, 0);
		end
	else	begin
		GENOP2("	ADD	EAX,&|", false, false, "+");
		if TOSTYP#IMMTYP ! NOSTYP#IMMTYP then
			[EAXLEV:= -1; EAXIMM:= false; EAXHI0:= false];
		end;
	end;
end;	\GENADD



proc	GENSTXADD;	\Optimized STX operation
begin
STXFLAG:= false;
if PSTKTYP(PSTKPTR-2)=ADRTYP then STXFLAG:= true else GENADD;
end;	\GENSTXADD



proc	GENSUB;		\$0E
int	TOSTYP, NOSTYP;
begin
COMMENT($0E);
if ~IDENTITY(0,false) then
	begin
	TOSTYP:= PSTKTYP(PSTKPTR-1);
	NOSTYP:= PSTKTYP(PSTKPTR-2);
	if TOSTYP=IMMTYP & PSTKLEV(PSTKPTR-1)=1 & PSTKOFF(PSTKPTR-1)=^C &
	    NOSTYP#IMMTYP then
		begin				\optimize A-1
		PDROP(1);
		CLEANREG(1);
		TOS2REG(^A);
		TTXT("	DEC	EAX|");
		EAXLEV:= -1; EAXVAL:= EAXVAL-1; EAXHI0:= false;
		PDROP(1); PPUSH(REGTYP, 0, 0);
		end
	else	begin
		GENOP2("	SUB	EAX,&|", true, false, "-");
		if TOSTYP#IMMTYP ! NOSTYP#IMMTYP then
			[EAXLEV:= -1; EAXIMM:= false; EAXHI0:= false];
		end;
	end;
end;	\GENSUB



func	Power2(N);	\Return N's power of 2 if it's exact and positive.
int	N;		\ e.g. if N=8 then return 3; if N=9 return 0
int	P;
begin
if N<0 then return 0;
P:= 30;
while N do
	begin
	N:= N<<1;
	if N<0 then
		return if N<<1 then 0 else P;
	P:= P-1;
	end;
end;	\Power2



proc	GENMUL;		\$0F
int	TOSTYP, NOSTYP, N;
begin
COMMENT($0F);
if not IDENTITY(1,true) then
    if not ISZERO(true) then
	begin
	TOSTYP:= PSTKTYP(PSTKPTR-1);
	NOSTYP:= PSTKTYP(PSTKPTR-2);
	if TOSTYP=IMMTYP & Power2(PSTKLEV(PSTKPTR-1))#0 & PSTKOFF(PSTKPTR-1)=^C &
	    NOSTYP#IMMTYP then
		begin				\optimize A*PowerOf2
		N:= Power2(PSTKLEV(PSTKPTR-1));
		PDROP(1);
		CLEANREG(1);
		TOS2REG(^A);
		TTXT("	SHL	EAX,");
		INTOUT(BINDEV, N);
		CRLF(BINDEV);
		EAXLEV:= -1; EAXVAL:= EAXVAL+EAXVAL; EAXHI0:= false;
		PDROP(1); PPUSH(REGTYP, 0, 0);
		end
	else if NOSTYP=IMMTYP & Power2(PSTKLEV(PSTKPTR-2))#0 & PSTKOFF(PSTKPTR-2)=^C &
	    TOSTYP#IMMTYP then
		begin				\optimize PowerOf2*A
		N:= Power2(PSTKLEV(PSTKPTR-2));
		PSTKTYP(PSTKPTR-2):= PSTKTYP(PSTKPTR-1);
		PSTKLEV(PSTKPTR-2):= PSTKLEV(PSTKPTR-1);
		PSTKOFF(PSTKPTR-2):= PSTKOFF(PSTKPTR-1);
		PDROP(1);
		CLEANREG(1);
		TOS2REG(^A);
		TTXT("	SHL	EAX,");
		INTOUT(BINDEV, N);
		CRLF(BINDEV);
		EAXLEV:= -1; EAXVAL:= EAXVAL+EAXVAL; EAXHI0:= false;
		PDROP(1); PPUSH(REGTYP, 0, 0);
		end
	else	begin
		GENOP2("	IMUL	EAX,&|", false, false, "*");
		if TOSTYP#IMMTYP ! NOSTYP#IMMTYP then
		     [EAXLEV:= -1; EAXIMM:= false; EAXHI0:= false];
		end;
	end;
end;	\GENMUL



proc	GENDIV;		\$10
int	TOSTYP, NOSTYP;
begin
COMMENT($10);
\Do not call both IDENTITY and ISZERO because they can alter PSTK.
if IDENTITY(1,false) then
	begin					\A/1=A; rem=0
	TTXT("	MOV	REMAIN,");
	TTXT(if EAXIMM & EAXVAL=0 then "EAX|" else "0|");
	end
else if ISZERO(false) then
	begin					\0/A=0; rem=0
	TTXT("	MOV	REMAIN,");
	TTXT(if EAXIMM & EAXVAL=0 then "EAX|" else "0|");
	end
else	begin
	\WARNING: If this code is changed then DVZHAN in Nativepx.asm may need
	\ to be changed too else divide-by-zero won't be trapped properly.
	TOSTYP:= PSTKTYP(PSTKPTR-1);
	NOSTYP:= PSTKTYP(PSTKPTR-2);
	EDXLEV:= -1;	\CDQ destroys EDX register
	GENOP2("	CDQ|	IDIV	&|	MOV	REMAIN,EDX|",
		true, true, "/");
	if TOSTYP#IMMTYP ! NOSTYP#IMMTYP then
		[EDXLEV:= -1; EAXLEV:= -1; EAXIMM:= false; EAXHI0:= false];
	end;
end;	\GENDIV



proc	GENNEG;		\$11
begin
COMMENT($11);
if PSTKTYP(PSTKPTR-1)=IMMTYP then
	PSTKLEV(PSTKPTR-1):= -PSTKLEV(PSTKPTR-1)
else	begin
	CLEANREG(1);
	TOS2REG(^A);
	TTXT("	NEG	EAX|");
	EAXLEV:= -1; EAXVAL:= -EAXVAL; EAXHI0:= false;
	PDROP(1); PPUSH(REGTYP, 0, 0);
	end;
end;	\GENNEG



proc	FCMP(T);	\$32-$37
int	T;
int	CMPT;
begin
CMPT:= ["SHL	AH,2|",					\EQ
	"SHL	AH,2|	CMC|",				\NE
	"AND	AH,41H|	LAHF|	SHL	AH,2|	CMC|",	\GE
	"SAHF|",					\GT
	"SAHF|	CMC|",					\LE
	"AND	AH,41H|	LAHF|	SHL	AH,2|"];	\LT
CLEANREG(0);
TTXT("	FCOMPP|	FNSTSW	AX|	");
TTXT(CMPT(T-$32));
TTXT("	SBB	EAX,EAX|");	\GENJPC depends on this setting the status

EAXLEV:= -1;
EAXIMM:= false;
EAXHI0:= false;

PDROP(2);
PPUSH(REGTYP, 0, 0);
end;	\FCMP



proc	ICMP(OPCODE);	\$12-$17 Integer compares:  TOS := NOS > TOS
int	OPCODE;
int	TOS, NOS, CMPSTR;


	proc	COMPLEFT(OP);	\Optimize compares where operand can be on left
	int	OP;	\string containing operator, i.e. ">="
	begin
	case of
        NOS=STKTYP&TOS=REGTYP: GENOP2("	CMP	&,EAX|", false, true, OP);
	NOS=ADRTYP&TOS=REGTYP: GENOP2("	CMP	&,EAX|", false, true, OP);
	NOS=IMMTYP&TOS=REGTYP: GENOP2("	CMP	&,EAX|", false, true, OP);
	NOS=ADRTYP&TOS=STKTYP: GENOP2("	CMP	&,EAX|", false, true, OP);

	NOS=ADRTYP & TOS=IMMTYP:
		begin
		CLEANREG(2);
		if ABS(PSTKLEV(PSTKPTR-1))>127 & PSTKLEV(PSTKPTR-2)=0 then
		  begin			\4-byte immediate value and level 0
		  OPSTRING("	MOV	EAX,&|",
				^A, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
		  EAXLEV:= PSTKLEV(PSTKPTR-2); EAXOFF:= PSTKOFF(PSTKPTR-2);
		  EAXIMM:= false; EAXHI0:= false;
		  OPSTRING("	CMP	EAX,&|",
				^I, PSTKLEV(PSTKPTR-1), PSTKOFF(PSTKPTR-1), 0);
		  end
		else
		  begin
		  OPSTRING("	CMP	&,",
				^A, PSTKLEV(PSTKPTR-2), PSTKOFF(PSTKPTR-2), 0);
		  OPSTRING("&|",	^I, PSTKLEV(PSTKPTR-1),
		  		PSTKOFF(PSTKPTR-1), 0);
		  end;
		PDROP(2);
		PPUSH(REGTYP, 0, 0);
		end;

	NOS=REGTYP & TOS=IMMTYP & EAXHI0 & PSTKLEV(PSTKPTR-1)>>8=0 &
	    (OPCODE=$12\=\ ! OPCODE=$13\#\):
		begin		\Must use UNsigned compares for other opcodes
		CLEANREG(2);
		TTXT("	CMP	AL,"); INTOUT(BINDEV, PSTKLEV(PSTKPTR-1));
		CRLF(BINDEV);
		PDROP(2);
		PPUSH(REGTYP, 0, 0);
		end

	other GENOP2("	CMP	EAX,&|", true, false, OP);
	end;	\COMPLEFT


begin	\ICMP
CMPSTR:= [
	"	JE	$+3|",
	"	JNE	$+3|",
	"	JGE	$+3|",
	"	JG	$+3|",
	"	JLE	$+3|",
	"	JL	$+3|" ];

if PSTKPTR<2 then BUGMSG("ICMP");
TOS:= PSTKTYP(PSTKPTR-1);
NOS:= PSTKTYP(PSTKPTR-2);

if TOS=IMMTYP & PSTKLEV(PSTKPTR-1)=0 & NOS=REGTYP then
	begin				\optimize register comparison to 0
	PDROP(1);
	TTXT("	TEST	EAX,EAX|");
	end
else	begin
	case OPCODE of
	  $12:	COMPLEFT("=");
	  $13:	COMPLEFT("#");
	  $14:	COMPLEFT(">=");
	  $15:	COMPLEFT(">");
	  $16:	COMPLEFT("<=");
	  $17:	COMPLEFT("<")
	other;
	end;

if TOS=IMMTYP & NOS=IMMTYP then		\if they're both immediates then
	LASTOP:= -1			\ don't optimize next JPC
else	begin
	SEAXIMM:= EAXIMM;		\save EAX info for GENJPC optimization
	SEAXLEV:= EAXLEV;
	SEAXHI0:= EAXHI0;
	TTXT("	MOV	EAX,-1|");	\(does not affect status)
	TTXT(CMPSTR(OPCODE-$12));	\GENJPC optimization depends on these
	TTXT("	INC	EAX|");		\ three instructions taking 8 bytes
	EAXLEV:= -1; EAXIMM:= false; EAXHI0:= false;
	end;
end;	\ICMP



proc	GENCMP(T);	\Select integer or real comparison
int	T;
begin
COMMENT(T);
if T>$17 then FCMP(T) else ICMP(T);
end;	\GENCMP



proc	GENFOR(LEV, OFF, LAB, TYP, IVAL, DOWNTO);\$18,$49 Compare for 'for' loop
int	LEV, OFF, LAB, TYP, IVAL, DOWNTO;
begin
COMMENT(if DOWNTO then $49 else $18);
if TYP=IMMTYP then
	begin
	if IVAL # 0 then
		[TTXT("	CMP	EDX,"); INTOUT(BINDEV, IVAL); CRLF(BINDEV)];
	\Zero case assumes status is set by GENINP or TEST EDX,EDX @ top of loop
	end
else	[TTXT("	CMP	EDX,[ESP]|")];			\(SS = DS)

if POSTGENTYPE\#0\ then POSTGEN;
TTXT(if DOWNTO then "	JGE	L" else "	JLE	L");
INTOUT(BINDEV, LAB); CRLF(BINDEV);
if TYP#IMMTYP then TTXT("	POP	ECX|");		\discard TOS

\Make sure that the control variable in memory is correct when exiting the loop
if LEV=EDXLEV & OFF=EDXOFF then
	[EDXLEV:= -1;					\prevent MOV EDX,EDX
	if LEV=EAXLEV & OFF=EAXOFF then EAXLEV:= -1;	\avoid MOV EAX,EDX
	OPSTRING("	MOV	&,EDX|", ^A, LEV, OFF, 0)];
PDROP(1);
CRLF(BINDEV);
EDXLEV:= -1;		\Do not be tempted to say EDX is valid at this point.
\The way labels are handled depends on this. A register must be considered
\ bombed at the end of its 'for' loop since the overall effect of the 'for'
\ loop is a store into the control variable. (There might be a surrounding
\ 'for' loop.) The EAX register is different; it is not bombed.
end;	\GENFOR



proc	GENINP(L, O, DOWNTO);	\$19,$4A Increment/Decrement for 'for' loop
int	L, O, DOWNTO;
begin
if DOWNTO then
   begin
   COMMENT($4A);
   if L#EDXLEV ! O#EDXOFF then
	begin
	if L=EAXLEV & O=EAXOFF then EAXLEV:= -1;		\avoid DEC EAX
	OPSTRING("	DEC	&|", ^A, L, O, 0);
	OPSTRING("	MOV	EDX,&|", ^A, L, O, 0);
	end
   else	TTXT("	DEC	EDX|");
   end
else begin
   COMMENT($19);
   if L#EDXLEV ! O#EDXOFF then
	begin
	if L=EAXLEV & O=EAXOFF then EAXLEV:= -1;		\avoid INC EAX
	OPSTRING("	INC	&|", ^A, L, O, 0);
	OPSTRING("	MOV	EDX,&|", ^A, L, O, 0);
	end
   else	TTXT("	INC	EDX|");
   end;
\GENFOR assumes status is set correctly for EDX (for case when upper limit = 0)
end;	\GENINP



proc	GENOR;		\$1A
int	TOSTYP, TOSVAL, NOSTYP;
begin
COMMENT($1A);
HAVESTAT:= false;
if ~IDENTITY(0,true) then
	begin
	TOSTYP:= PSTKTYP(PSTKPTR-1);
	TOSVAL:= PSTKLEV(PSTKPTR-1);
	NOSTYP:= PSTKTYP(PSTKPTR-2);
	if TOSTYP=IMMTYP & (TOSVAL&$FFFFFF00)=0 & NOSTYP#IMMTYP then
		begin			\AL := NOS ! TOS
		CLEANREG(2);
		PDROP(1);
		TOS2EAX;		\NOS into EAX
		PDROP(1);
		TTXT("	OR	AL,"); INTOUT(BINDEV,TOSVAL); TTXT("|");
		PPUSH(REGTYP, 0, 0);
		end
	else	GENOP2("	OR	EAX,&|", false, false, "!");
		\optimized JPC depends on GENOP2 setting status
	EAXLEV:= -1; EAXIMM:= false; EAXHI0:= false;
	end;
end;	\GENOR



proc	GENAND;		\$1B
int	TOSTYP, TOSVAL, NOSTYP;
begin
COMMENT($1B);
HAVESTAT:= false;
if not IDENTITY($FFFFFFFF,true) then
    if not ISZERO(true) then
	begin
	TOSTYP:= PSTKTYP(PSTKPTR-1);
	TOSVAL:= PSTKLEV(PSTKPTR-1);
	NOSTYP:= PSTKTYP(PSTKPTR-2);
	if TOSTYP=IMMTYP & TOSVAL>>8=$FFFFFF & NOSTYP#IMMTYP then
		begin			\AL := NOS & TOS
		CLEANREG(2);
		PDROP(1);
		TOS2EAX;		\NOS into EAX
		PDROP(1);
		TTXT("	AND	AL,"); INTOUT(BINDEV,TOSVAL&$FF); TTXT("|");
		PPUSH(REGTYP, 0, 0);
		end
	else if TOSTYP=IMMTYP & NOSTYP=REGTYP & EAXHI0 then
		begin			\AL := NOS & TOS
		CLEANREG(2);
		PDROP(2);
		if (TOSVAL&$FF) # $FF then	\AND AL,0FFh would do nothing
			begin
			TTXT("	AND	AL,"); INTOUT(BINDEV,TOSVAL&$FF);
			TTXT("|");
			end;
		PPUSH(REGTYP, 0, 0);
		end
	else if TOSTYP=IMMTYP & TOSVAL=$000000FF & NOSTYP#IMMTYP then
		begin
		CLEANREG(2);
		PDROP(1);
		TOS2EAX;		\NOS into EAX
		PDROP(1);
		TTXT("	MOVZX	EAX,AL|");
		PPUSH(REGTYP, 0, 0);
		end
	else	GENOP2("	AND	EAX,&|", false, false, "&");
		\optimized JPC depends on GENOP2 setting status
	EAXLEV:= -1;
	EAXIMM:= false;
	\EAXHI0 is not set false (because masking only clears bits)
	if TOSTYP=IMMTYP & TOSVAL>>8=0 then EAXHI0:= true;
	end;
end;	\GENAND



proc	GENNOT;		\$1C
begin
COMMENT($1C);
if PSTKTYP(PSTKPTR-1)=IMMTYP then
	PSTKLEV(PSTKPTR-1):= ~ PSTKLEV(PSTKPTR-1)
else	begin
	CLEANREG(1);
	TOS2REG(^A);
	TTXT("	NOT	EAX|");
	\optimized JPC depends on this
	EAXLEV:= -1; EAXVAL:= ~EAXVAL; EAXHI0:= false;
	PDROP(1); PPUSH(REGTYP, 0, 0);
	end;
end;	\GENNOT



proc	GENEOR;		\$1D
begin
COMMENT($1D);
if ~IDENTITY(0,true) then
	[GENOP2("	XOR	EAX,&|", false, false, "|");
	EAXLEV:= -1; EAXIMM:= false; EAXHI0:= false];
end;	\GENEOR



proc	DOINDEX2(PWR);	\Generate index for DBA and TRA. TOS <- TOS*2^PWR + NOS
int	PWR;	\power of two
int	TOS, NOS, C;
begin
CLEANREG(2);
TOS:= PSTKTYP(PSTKPTR-1);
NOS:= PSTKTYP(PSTKPTR-2);
if NOS=REGTYP & TOS=ADRTYP then
	begin
	TOS2REG(^B); PDROP(1);
	if PWR > 0 then
		[TTXT("	SHL	EBX,"); INTOUT(BINDEV, PWR); CRLF(BINDEV)];
	TTXT("	ADD	EAX,EBX|");
	EAXLEV:= -1; EAXIMM:= false; EAXHI0:= false;
	PDROP(1);
	PPUSH(REGTYP, 0, 0);
	end
else if TOS=IMMTYP then
	begin
	if ~IDENTITY(0,false) then
		begin
		PSTKLEV(PSTKPTR-1):= PSTKLEV(PSTKPTR-1) << PWR;
		GENOP2("	ADD	EAX,&|", false, false, "+");
		EAXLEV:= -1; EAXIMM:= false; EAXHI0:= false;
		end;
	end
else	begin
	TOS2REG(^A);
	if PWR > 0 then
		[TTXT("	SHL	EAX,"); INTOUT(BINDEV, PWR); CRLF(BINDEV)];
	EAXLEV:= -1; EAXIMM:= false; EAXHI0:= false;
	PSTKTYP(PSTKPTR-1):= REGTYP;
	GENOP2("	ADD	EAX,&|", false, false, "+");
	EAXLEV:= -1; EAXIMM:= false; EAXHI0:= false;
	end;
end;	\DOINDEX2



proc	GENDBA;		\$1E TOS <- TOS*INTSIZE + NOS
begin
COMMENT($1E);
DOINDEX2(2);		\2^2 = 4 = INTSIZE
end;	\GENDBA



proc	GENSTD;		\$1F @(NOS) <- TOS
int	LEV, OFF, TOS, NOS;
begin
COMMENT($1F);
TOS:= PSTKTYP(PSTKPTR-1);
OFF:= PSTKOFF(PSTKPTR-1);
NOS:= PSTKTYP(PSTKPTR-2);
LEV:= PSTKLEV(PSTKPTR-1);

if TOS=IMMTYP & OFF=^C then
	begin
	PDROP(1);
	TOS2REG(^B);
	POSTGENOFF:= 0; POSTGENVAL:= LEV; POSTGENTYPE:= 2;
	PDROP(1);
	end
else	begin
	if NOS=REGTYP then
		begin
		TTXT("	MOV	EBX,EAX|");
		TOS2REG(^A); PDROP(2);
		end
	else	begin
		TOS2REG(^A); PDROP(1);
		TOS2REG(^B); PDROP(1);
		end;
	TTXT("	MOV	[EBX],EAX|");
	end;
end;	\GENSTD



proc	DOINDEX1(PWR);	\Handle index generated for DBX and TRX
			\TOS <- @(TOS*2^PWR + NOS)
int	PWR;	\power of two
int	C;
begin
CLEANREG(2);
if PSTKTYP(PSTKPTR-1)=IMMTYP then
	begin
	C:= PSTKLEV(PSTKPTR-1);
	PDROP(1);
	if PSTKTYP(PSTKPTR-1)=REGTYP then
		TTXT("	MOV	EAX,[EAX]+")
	else	[TOS2REG(^B);
		TTXT("	MOV	EAX,[EBX]+")];
	INTOUT(BINDEV,C<<PWR); CRLF(BINDEV);
	PDROP(1);
	EAXLEV:= -1; EAXIMM:= false; EAXHI0:= false;
	end
else if PSTKTYP(PSTKPTR-1)=REGTYP then
	begin
	PDROP(1);
	TOS2REG(^B);
	TTXT("	MOV	EAX,[EBX+EAX");
	if PWR \#0\ then
		[CHOUT(BINDEV,^*); INTOUT(BINDEV,1<<PWR)];
	TTXT("]|");
	PDROP(1);
	EAXLEV:= -1; EAXIMM:= false; EAXHI0:= false;
	end
else	begin
	TOS2REG(^B);
	PDROP(1);
	TOS2REG(^A);
	TTXT("	MOV	EAX,[EAX+EBX");
	if PWR \#0\ then
		[CHOUT(BINDEV,^*); INTOUT(BINDEV,1<<PWR)];
	TTXT("]|");
	PDROP(1);
	EAXLEV:= -1; EAXIMM:= false; EAXHI0:= false;
	end;
PPUSH(REGTYP, 0, 0);
end;	\DOINDEX1



proc	GENDBX;		\$20 TOS <- @(TOS*INTSIZE + NOS)
begin
COMMENT($20);
DOINDEX1(2);		\2^2 = 4 = INTSIZE
end;	\GENDBX



proc	GENADR(L, O);	\$21
int	L, O;
begin
COMMENT($21);
CLEANREG(0);
\Must bomb any register variables before using OPSTRING to prevent
\ generating LEA EAX, with a register operand, which is an illegal opcode.
if L=EAXLEV & O=EAXOFF then EAXLEV:= -1;
if L=EDXLEV & O=EDXOFF then EDXLEV:= -1;
OPSTRING("	LEA	EAX,&|", ^A, L, O, 0);
EAXLEV:= -1; EAXIMM:= false; EAXHI0:= false;
PPUSH(REGTYP, 0, 0);
end;	\GENADR



proc	GENCJP(L,SENSE);	\$25 Case jump
int	L,SENSE;
int	TOSTYP, TOSVAL, TOSOFF, NOSTYP;
begin
COMMENT($25);
\NOS is normally in EAX and it equals the value of the expression between the
\ words 'case' & 'of'. TOS equals the "label" value, the value ahead of the ":".
TOSTYP:= PSTKTYP(PSTKPTR-1);
TOSVAL:= PSTKLEV(PSTKPTR-1);
TOSOFF:= PSTKOFF(PSTKPTR-1);
NOSTYP:= PSTKTYP(PSTKPTR-2);

case TOSTYP of
  REGTYP,STKTYP:
	  begin
	  TOS2REG(^C); PDROP(1);
	  TOS2EAX;
	  TTXT("	CMP	EAX,ECX|");
	  end;
  ADRTYP: [OPSTRING("	CMP	EAX,&|", ^A, TOSVAL, TOSOFF, 0);
	  PDROP(1)];
  IMMTYP:
	begin
	if (TOSVAL&$FFFFFF00)=0 & NOSTYP=REGTYP & EAXHI0 then
		begin			\CMP NOS,TOS
		CLEANREG(2);
		PDROP(2);
		TTXT("	CMP	AL,"); INTOUT(BINDEV,TOSVAL); TTXT("|");
		PPUSH(REGTYP, 0, 0);
		end
	else	[OPSTRING("	CMP	EAX,&|", ^I, TOSVAL, TOSOFF, 0);
		PDROP(1)];
	end
other	  BUGMSG("GENCJP");

if SENSE then TTXT("	JE	L")
	 else TTXT("	JNE	L");
INTOUT(BINDEV, L); CRLF(BINDEV);
end;	\GENCJP



proc	GENDRP(N);	\$28 Drop N values from hardware stack
int	N;
int	I;
begin
COMMENT($28);
for I:= 1, N do
    if PSTKTYP(PSTKPTR-I)=STKTYP then
	TTXT("	POP	ECX|");
end;	\GENDRP



proc	GENFLOD(L, O);	\$2A
int	L, O;
begin
COMMENT($2A);
NEWLEVEL(L);
TTXT("	FLD	QWP ");
case L of
  0:	TTXT(if LEVEL#0 ! OPTPROC ! ABS(O)>127 then "HEAPLO+" else "[ESI]+");
  LEVEL:TTXT("[ESI]+")
other	TTXT("[EBP]+");
INTOUT(BINDEV,O);
CRLF(BINDEV);
PPUSH(REALTYP, 0, 0);
end;	\GENFLOD



proc	GENFSTO(L, O);	\$2B
int	L, O;
begin
COMMENT($2B);

NEWLEVEL(L);
TTXT("	FSTP	QWP ");
case L of
  0:	TTXT(if LEVEL#0 ! OPTPROC ! ABS(O)>127 then "HEAPLO+" else "[ESI]+");
  LEVEL:TTXT("[ESI]+")
other	TTXT("[EBP]+");
INTOUT(BINDEV,O);
CRLF(BINDEV);

PDROP(1);
end;	\GENFSTO



proc	GENFIMM(T, V);	\$2C
int	T, V;
int	L, I;
addr	P;
begin
COMMENT($2C);
if T=^C then				\Type = Constant
	begin
	if RLATOM=0.0 then TTXT("	FLDZ|")
	else if RLATOM=1.0 then TTXT("	FLD1|")
	else	begin
		DSTART;
		TTXT("	ALIGN	8|");
		L:= NEWLAB;
		DLABEL(L);
		TTXT("	DQ	0");
		P:= addr RLATOM;
		for I:= -7, 0 do HEXB(P(-I));
		TTXT("H|");
		DEND;
\HEXOUT is not used because 8 (not just 4) bytes are needed. RLOUT is not used
\ because it might not output all the places after the decimal point. Also it
\ requires that the assembler be IEEE-754 compliant (which it probably is).
		TTXT("	FLD	QWP L"); INTOUT(BINDEV, L);
		CRLF(BINDEV);
		end;
	end
else if T=^L then			\Type = Label (for constant array)
	begin
	DSTART;
	TTXT("	ALIGN	8|");
	L:= NEWLAB;
	DLABEL(L);
	\Place address into low end of 1.0 and load it into FPU
	TTXT("	DD	L"); INTOUT(BINDEV,V);
	TTXT(", 3FF00000H|");
	DEND;
	TTXT("	FLD	QWP L"); INTOUT(BINDEV, L);
	CRLF(BINDEV);
	end
else	BUGMSG("GENFIMM");
PPUSH(REALTYP, 0, 0);
end;	\GENFIMM



proc	FMATH(T);	\$2D-$30
int	T;
int	OSTR;
begin
OSTR:= ["ADD|", "SUB|", "MUL|", "DIV|"];
COMMENT(T);
TTXT("	F");
TTXT(OSTR(T-$2D));
PDROP(1);
end;	\FMATH



proc	GENMTH(T);	\Select real or integer math opcodes
int	T;
begin
if T > $10 then FMATH(T) else
	case T of
	  $0D:	GENADD;
	  $0E:	GENSUB;
	  $0F:	GENMUL;
	  $10:	GENDIV
	other;
end;	\GENMTH



proc	GENFNEG;	\$31
begin
COMMENT($31);
TTXT("	FCHS|");
end;	\GENFNEG



proc	GENTRA;		\$38 TOS <- TOS*8 + NOS
begin
COMMENT($38);
DOINDEX2(3);
end;	\GENTRA



proc	GENTRX;		\$39 TOS <- @(TOS*8 + NOS)
begin
COMMENT($39);
DOINDEX1(3);
end;	\GENTRX



proc	GENTRI;		\$3A Real TOS <- @(TOS*8 + NOS)
int	C;		\e.g: A(3); A=NOS, 3=TOS
begin
COMMENT($3A);
if PSTKTYP(PSTKPTR-1)=IMMTYP then
	begin
	C:= PSTKLEV(PSTKPTR-1);		\TOS*8=24
	PDROP(1);
	TOS2REG(^C);			\MOV ECX,[ESI]+8
	PDROP(1);
	TTXT("	FLD	QWP [ECX]+"); INTOUT(BINDEV,C*8); CRLF(BINDEV);
	end
else	begin		\A(N); A=NOS, N=TOS
	TOS2EAX;	\MOV	EAX,N
	PDROP(1);
	TOS2REG(^C);	\MOV	ECX,[ESI]+8	;A
	PDROP(1);
	TTXT("	FLD	QWP [ECX+EAX*8]|");	\N*8
	EAXLEV:= -1;
	EAXIMM:= false;
	EAXHI0:= false;
	end;
PPUSH(REALTYP, 0, 0);
end;	\GENTRI



proc	GENSTT;		\$3B @(NOS) <- real TOS
begin
COMMENT($3B);
PDROP(1);		\drop the real
TOS2REG(^A);		\EAX:= NOS
TTXT("	FSTP	QWP [EAX]|");
PDROP(1);
end;	\GENSTT



proc	GENMARK;	\$3C (for procedure arguments)
begin
COMMENT($3C);
end;	\GENMARK



func	Sar(N, C);	\Shift N arithmetic right C bits
int	N, C;
begin
C:= C & $1F;		\only the low 5 bits of the shift count are used
return if N >= 0 then N>>C else ~((~N)>>C);
end;	\Sar



proc	SHIFT(LEFT, LOP);
int	LEFT, LOP;
int	TOSTYP, NOSTYP, TOSVAL, NOSVAL;
\(GENOP2 won't work here because CL must be used.
\ also note DIV can use any register for divisor)
begin
if not IDENTITY(0,false) then
    if not ISZERO(false) then
	begin
	TOSTYP:= PSTKTYP(PSTKPTR-1);
	NOSTYP:= PSTKTYP(PSTKPTR-2);
	TOSVAL:= PSTKLEV(PSTKPTR-1) & $000000FF;	\shift count into CL
	NOSVAL:= PSTKLEV(PSTKPTR-2);
	if TOSTYP=IMMTYP & NOSTYP=IMMTYP then
		begin
		TOSVAL:= if LEFT then NOSVAL<<TOSVAL else NOSVAL>>TOSVAL;
		PDROP(2);
		PPUSH(IMMTYP, TOSVAL, ^C);
		end
	else if TOSTYP=IMMTYP then		\TOS = amount to shift
		begin
		if LEFT & (TOSVAL&$1F)>=24 &	\shift count only uses 5 bits
		    (LOP=\LDX\$02 ! LOP=\PIN\$4E) then	\eliminate MOVZX EAX,AL
			[TTXT("	ORG	$-3|"); EAXHI0:= false];
		CLEANREG(2);
		PDROP(1);
		TOS2EAX;			\NOS into EAX
		PDROP(1);
		if LEFT & TOSVAL=1 then TTXT("	ADD	EAX,EAX|") \3x faster
		else	begin
			TTXT(if LEFT then "	SHL	EAX,"
				     else "	SHR	EAX,");
			INTOUT(BINDEV, TOSVAL); CRLF(BINDEV);
			end;
		PPUSH(REGTYP, 0, 0);
		EAXLEV:= -1;
		EAXIMM:= false; \(BEWARE: only 5 bits are used in shift count
		if LEFT then EAXHI0:= false
		else \right\ if (TOSVAL&$1F)>=24 then EAXHI0:= true;
		end
	else	begin
		CLEANREG(2);
		TOS2REG(^C); PDROP(1);
		TOS2REG(^A); PDROP(1);
		TTXT(if LEFT then "	SHL" else "	SHR");

		TTXT("	EAX,CL|");
		PPUSH(REGTYP, 0, 0);
		EAXLEV:= -1; EAXIMM:= false;
		if LEFT then EAXHI0:= false;
		end;
	end;
end;	\SHIFT



proc	GENASR;		\$3D   NOS ->> TOS
begin
COMMENT($3D);
CLEANREG(2);
TOS2REG(^C); PDROP(1);
TOS2REG(^A); PDROP(1);
TTXT("	SAR");
TTXT("	EAX,CL|");
PPUSH(REGTYP, 0, 0);
EAXLEV:= -1; EAXIMM:= false;
end;	\GENASR



proc	GENLSL;		\$3E   NOS << TOS
int	LOP;
begin
LOP:= LASTOP;
COMMENT($3E);
SHIFT(true,LOP);
end;	\GENLSL



proc	GENLSR;		\$3F   NOS >> TOS
int	LOP;
begin
LOP:= LASTOP;
COMMENT($3F);
SHIFT(false,LOP);
end;	\GENLSR



proc	GENARY;		\$48, Array declaration
begin
COMMENT($48);
TTXT("	CALL	"); TTXT("MKARRAY|");
OLDLEV:= -1;		\subroutine might have destroyed registers
EDXLEV:= -1;
EAXLEV:= -1;
EAXIMM:= false;
EAXHI0:= false;
end;	\GENARY



proc	GENABS;		\$49, Absolute value function
begin
COMMENT($49);
if PSTKTYP(PSTKPTR-1)=IMMTYP then
	PSTKLEV(PSTKPTR-1):= ABS(PSTKLEV(PSTKPTR-1))
else	begin
	CLEANREG(1);
	TOS2REG(^A);
	TTXT("	NEG	EAX|	JL	$-2|");	\beware of JS and $80000000
	EAXLEV:= -1; EAXVAL:= ABS(EAXVAL); EAXHI0:= false;	\ (thanks! Ruud)
	PDROP(1); PPUSH(REGTYP, 0, 0);
	end;
end;	\GENABS



proc	GENFABS;	\$4A, Absolute value function of a real
begin
COMMENT($4A);
TTXT("	FABS|");
end;	\GENFABS



proc	GENREM;		\$4B, Remainder of last divide
begin
COMMENT($4B);
PDROP(1);		\discard TOS
CLEANREG(0);
TTXT("	MOV	EAX,REMAIN|");
EAXLEV:= -1; EAXIMM:= false; EAXHI0:= false;
PPUSH(REGTYP, 0, 0);
end;	\GENREM



proc	GENSWAP;	\$4C, Swap-bytes function
begin
COMMENT($4C);
if PSTKTYP(PSTKPTR-1)=IMMTYP then
	PSTKLEV(PSTKPTR-1):= SWAP(PSTKLEV(PSTKPTR-1))
else	begin
	CLEANREG(1);
	TOS2REG(^A);
	TTXT("	XCHG	AH,AL|");
	EAXLEV:= -1; EAXVAL:= SWAP(EAXVAL); EAXHI0:= false;
	PDROP(1); PPUSH(REGTYP, 0, 0);
	end;
end;	\GENSWAP



proc	GENEXT;		\$4D, Sign-extend function
begin
COMMENT($4D);
if PSTKTYP(PSTKPTR-1)=IMMTYP then
	PSTKLEV(PSTKPTR-1):= EXTEND(PSTKLEV(PSTKPTR-1))
else	begin
	CLEANREG(1);
	TOS2REG(^A);
	TTXT("	MOVSX	EAX,AL|");		\EAX:= EXTEND(AL)
	EAXLEV:= -1; EAXVAL:= EXTEND(EAXVAL); EAXHI0:= false;
	PDROP(1); PPUSH(REGTYP, 0, 0);
	end;
end;	\GENEXT



proc	GENPIN;		\$4E, Function to read a byte from a port
begin			\TOS:= port(TOS);
COMMENT($4E);
CLEANREG(1);
\if TOS is an immediate value <= $FF then: IN AL,imm
if PSTKTYP(PSTKPTR-1)=IMMTYP & (PSTKLEV(PSTKPTR-1)&$FFFFFF00)=0 then
	begin
	TTXT("	IN	AL,");
	INTOUT(BINDEV, PSTKLEV(PSTKPTR-1));
	TTXT("|");
	end
else	begin
	TOS2REG(^D);
	TTXT("	IN	AL,DX|");	\(not EDX, even in 32-bit mode)
	EDXLEV:= -1;
	end;
if EAXHI0 then LASTOP:= -1 else TTXT("	MOVZX	EAX,AL|");
\optimized GENSTX, GENJPC, SHIFT and GENPOUT depends on this MOVZX instruction
EAXLEV:= -1;
EAXIMM:= false;
EAXHI0:= true;
PDROP(1); PPUSH(REGTYP, 0, 0);
end;	\GENPIN



proc	GENPOUT;	\$4F, Function to write a byte to a port
int	LOP;		\port(NOS):= TOS;
begin
LOP:= LASTOP;
COMMENT($4F);
if LOP=\LDX\$02 ! LOP=\PIN\$4E then
	[TTXT("	ORG	$-3|"); EAXHI0:= false];	\eliminate MOVZX EAX,AL
CLEANREG(1);
\if NOS is an immediate value <= $FF then: OUT imm,AL
if PSTKTYP(PSTKPTR-2)=IMMTYP & (PSTKLEV(PSTKPTR-2)&$FFFFFF00)=0 then
	begin
	TOS2REG(^A);
	TTXT("	OUT	");
	INTOUT(BINDEV, PSTKLEV(PSTKPTR-2));
	TTXT(",AL|");
	PDROP(2);
	end
else if PSTKTYP(PSTKPTR-2) = REGTYP then
	begin
	TTXT("	XCHG	EDX,EAX|");	\MOV EDX,EAX
	EAXLEV:= -1; EAXIMM:= false; EAXHI0:= false;
	TOS2REG(^A);
	PDROP(2);
	TTXT("	OUT	DX,AL|");
	EDXLEV:= -1;
	end
else	begin
	TOS2REG(^A); PDROP(1);
	TOS2REG(^D); PDROP(1);
	TTXT("	OUT	DX,AL|");
	EDXLEV:= -1;
	end;
end;	\GENPOUT



proc	GENFIX;		\$50, Fix function
begin			\INTEGER:= FIX(REAL);
COMMENT($50);
CLEANREG(0);		\push any EAX onto h/w stack
PDROP(1);		\drop real from pseudo stack
\make space on h/w stack, convert real to integer, and store it in stack space
TTXT("	PUSH	EAX|	FISTP	DWP [ESP]|");
PPUSH(STKTYP, 0, 0);	\make pseudo stack reflect value on h/w stack
end;	\GENFIX



proc	GENFLOAT;	\$51, Float function
int	L, O;
begin			\REAL:= FLOAT(INTEGER);
COMMENT($51);
L:= PSTKLEV(PSTKPTR-1);
O:= PSTKOFF(PSTKPTR-1);
case PSTKTYP(PSTKPTR-1) of
  REGTYP: TTXT("	PUSH	EAX|	FILD	DWP [ESP]|	POP	EAX|");
  STKTYP: TTXT("	FILD	DWP [ESP]|	POP	ECX|");	\(never occurs)
  ADRTYP: begin
	  \must bomb any register variables before using OPSTRING to prevent
	  \ generating FILD with a register operand, which is an illegal opcode
	  if L=EAXLEV & O=EAXOFF then EAXLEV:= -1;
	  if L=EDXLEV & O=EDXOFF then EDXLEV:= -1;
	  OPSTRING("	FILD	&|", ^A, L, O, 0);
	  end;
  IMMTYP: begin
	  OPSTRING("	PUSH	&|", ^I, L, O, 0);
	  TTXT("	FILD	DWP [ESP]|	POP	ECX|");
	  end
other	BUGMSG("GENFLOAT");
PDROP(1);		\drop integer from pseudo stack
PPUSH(REALTYP, 0, 0);	\make pseudo stack reflect value on FPU stack
end;	\GENFLOAT



proc	GENFSQRT;	\$52, Sqrt function of a real
begin
COMMENT($52);
TTXT("	FSQRT|");
end;	\GENFSQRT



proc	GENSQRT;	\$53, Sqrt function of an integer
int	L, O;
begin
COMMENT($53);
L:= PSTKLEV(PSTKPTR-1);
O:= PSTKOFF(PSTKPTR-1);
if PSTKTYP(PSTKPTR-1)=IMMTYP then
	PSTKLEV(PSTKPTR-1):= FIX(SQRT(FLOAT(L)))
else	begin
	case PSTKTYP(PSTKPTR-1) of			\FLOAT
	  REGTYP: TTXT("	PUSH	EAX|	FILD	DWP [ESP]|");
	  STKTYP: TTXT("	FILD	DWP [ESP]|");	\(never occurs)
	  ADRTYP: begin
	  \must bomb any register variables before using OPSTRING to prevent
	  \ generating FILD with a register operand, which is an illegal opcode
		  if L=EAXLEV & O=EAXOFF then EAXLEV:= -1;
		  if L=EDXLEV & O=EDXOFF then EDXLEV:= -1;
		  OPSTRING("	FILD	&|", ^A, L, O, 0);
		  TTXT("	PUSH	ECX|");		\make a space on stack
		  end
	other	BUGMSG("GENSQRT");

	TTXT("	FSQRT|");				\SQRT

	TTXT("	FISTP	DWP [ESP]|");			\FIX
	PDROP(1); PPUSH(STKTYP, 0, 0);	\make pseudo stack reflect h/w stack
	end;
end;	\GENSQRT



proc	GENFSQ;		\$54, Square a real
begin
COMMENT($54);
TTXT("	FLD	ST|	FMUL|");
end;	\GENFSQ



proc	GENSQ;		\$55, Square an integer
begin
COMMENT($55);
if PSTKTYP(PSTKPTR-1)=IMMTYP then
	PSTKLEV(PSTKPTR-1):= PSTKLEV(PSTKPTR-1) * PSTKLEV(PSTKPTR-1)
else	begin
	CLEANREG(1);
	TOS2REG(^A);
	TTXT("	IMUL	EAX,EAX|");		\EAX:= EAX*EAX
	EAXLEV:= -1; EAXVAL:= EAXVAL*EAXVAL; EAXHI0:= false;
	PDROP(1); PPUSH(REGTYP, 0, 0);
	end;
end;	\GENSQ



proc	GENEND;		\$FE
begin
COMMENT($FE);
TTXT("CSEG	ENDS|	END|");
end;	\GENEND

\===============================================================================

proc	LOOKUP;		\Lookup identifier in symbol table
\Inputs: IDENT, HASH
\Outputs: IDTYPE, VAL, LEV, SYMNUM.
\If two identifiers of the same name are in the symbol table then the most
\ recent entry is used.
int	I, K, PTR;
begin
PTR:= BOX(HASH);
loop	begin
	if PTR=EMPTYPTR then [IDTYPE:= UNDEF; quit];
	I:= 0; K:= PTR;
	while IDENT(I)=SYMBOL(K) & I<SIGCHAR do
		[I:= I+1; K:= K+SYMAX];
	if I=SIGCHAR then			\found
		[IDTYPE:= SYMTYP(PTR);
		VAL:= SYMVAL(PTR);
		LEV:= SYMLEV(PTR);
		SYMNUM:= PTR;			\(for forward proc)
		quit];
	PTR:= SYMPTR(PTR);
	end;
end;	\LOOKUP



proc	INSERT(STYP, SLEV, SVAL);
\Insert the current identifier into the symbol table
\Inputs:  STYP, SLEV, SVAL, IDENT, HASH, NOSYM, SYMBOL, & BOX.
int	STYP, SLEV, SVAL;
int	I, K;
begin
LOOKUP;
if IDTYPE # UNDEF then if LEV=LEVEL then \collision\ ERROR(11)
				    else WARNING(1);
if NOSYM >= SYMAX then \table full\ [ERROR(3); NOSYM:= SYMAX-1];
K:= NOSYM;
for I:= 0, SIGCHAR-1 do [SYMBOL(K):= IDENT(I); K:= K+SYMAX];
SYMTYP(NOSYM):= STYP;
SYMLEV(NOSYM):= SLEV;
SYMVAL(NOSYM):= SVAL;
SYMTAG(NOSYM):= 0;
SYMPTR(NOSYM):= BOX(HASH);			\link back
BOX(HASH):= NOSYM;
NOSYM:= NOSYM+1;
end;	\INSERT



proc	GETCON;		\Get a constant--either by value or by name
int	NEG;
begin
if ATOM=^+ then RATOM;
if ATOM=^- then [NEG:= true; RATOM] else NEG:= false;
case ATYPE of
  INTCON:
	[if NEG then IATOM:= -IATOM;
	FACTYP:= INTEGER];
  REALCON:
	[if NEG then RLATOM:= -RLATOM;
	FACTYP:= REAL];
  IDENTIFIER:
	begin
	LOOKUP;
	if IDTYPE#UNDEF then SYMTAG(SYMNUM):= SYMTAG(SYMNUM)!$01;
	case IDTYPE of
	 INCON:	[IATOM:= if NEG then -VAL else VAL;
		FACTYP:= INTEGER];
	 RLCON:	[RLATOM:= if NEG then-RLTBL(VAL) else RLTBL(VAL);
		FACTYP:= REAL]
	other	ERROR(42);
	end
other	ERROR(42);
end;	\GETCON

\-------------------------------------------------------------------------------

proc	CONEXPRESS;	\Evaluate constant expressions
\Outputs: FACTYP, IATOM, RLATOM
int	SFACTYP, ITEMP, IFVAR;
real	RTEMP;


	proc INTTEST;		\Test for integer errors
	if FACTYP # INTEGER then ERROR(47);


	proc MIXTEST(TYPE);	\Test for mixed mode errors
	int TYPE;
	if TYPE#FACTYP then ERROR(46);


	proc	CFACTOR;
	begin
	if ATOM=^( then
		begin
		RATOM;
		CONEXPRESS;
		if ATOM#^) then ERROR(44);		
		end
	else if ATOM=ABSSYM then
		begin					\absolute value function
		RATOM;
		if ATOM#^( then ERROR(39) else RATOM;
		CONEXPRESS;
		if FACTYP=INTEGER then IATOM:= abs(IATOM) else RLATOM:= abs(RLATOM);
		if ATOM#^) then ERROR(44);
		end
	else if ATOM=SQRTYM then
		begin					\square-root function
		RATOM;
		if ATOM#^( then ERROR(39) else RATOM;
		CONEXPRESS;
		if FACTYP=INTEGER then IATOM:= sqrt(IATOM) else RLATOM:= sqrt(RLATOM);
		if ATOM#^) then ERROR(44);
		end
	else if ATOM=SQSYM then
		begin					\square function
		RATOM;
		if ATOM#^( then ERROR(39) else RATOM;
		CONEXPRESS;
		if FACTYP=INTEGER then IATOM:= sq(IATOM) else RLATOM:= sq(RLATOM);
		if ATOM#^) then ERROR(44);
		end
	else if ATOM=SWAPYM then
		begin					\swap bytes function
		RATOM;
		if ATOM#^( then ERROR(39) else RATOM;
		CONEXPRESS;
		if FACTYP#INTEGER then ERROR(47);
		IATOM:= swap(IATOM);
		if ATOM#^) then ERROR(44);
		end
	else if ATOM=FIXSYM then
		begin					\fix function
		RATOM;
		if ATOM#^( then ERROR(39) else RATOM;
		CONEXPRESS;
		if FACTYP#REAL then ERROR(37);
		IATOM:= fix(RLATOM);
		FACTYP:= INTEGER;
		if ATOM#^) then ERROR(44);
		end
	else if ATOM=FLOSYM then
		begin					\float function
		RATOM;
		if ATOM#^( then ERROR(39) else RATOM;
		CONEXPRESS;
		if FACTYP#INTEGER then ERROR(47);
		RLATOM:= float(IATOM);
		FACTYP:= REAL;
		if ATOM#^) then ERROR(44);
		end
	else	GETCON;
	RATOM;
	end;	\CFACTOR


	proc	CSHIFTEXP;
	int	ITEMP;
	begin
	CFACTOR;
	ITEMP:=IATOM;
	case ATOM of
	LSLSYM:	begin
		INTTEST;
		RATOM;
		CFACTOR;
		INTTEST;
		IATOM:=ITEMP << IATOM;
		end;	
	LSRSYM:	begin
		INTTEST;
		RATOM;
		CFACTOR;
		INTTEST;
		IATOM:=ITEMP >> IATOM;
		end;
	ASRSYM:	begin
		INTTEST;
		RATOM;
		CFACTOR;
		INTTEST;
		IATOM:=ITEMP ->> IATOM;
		end
	other;
	end;	\CSHIFTEXP


	proc	CTERM;
	int	SFACTYP;
	int	ITEMP;
	real	RTEMP;
	begin
	CSHIFTEXP;
	SFACTYP:=FACTYP;
	loop	begin
		ITEMP:=IATOM;RTEMP:=RLATOM;
		case ATOM of
		  ^*:	begin
			RATOM;
			CSHIFTEXP;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:=ITEMP * IATOM
				else RLATOM:=RTEMP * RLATOM;
			end;
		  ^/:	begin
			RATOM;
			CSHIFTEXP;
			MIXTEST(SFACTYP);
			if IATOM=0 ! RLATOM=0.0 then ERROR(73) \divide by zero
			else if FACTYP=INTEGER then IATOM:=ITEMP / IATOM
				else RLATOM:=RTEMP / RLATOM;
			end
		other	quit;
		end;
	end;	\CTERM


	proc	CALGEXP;	\Algebriac expression
	int	SFACTYP;
	int	ITEMP;
	real	RTEMP;
	begin
	CTERM;
	SFACTYP:=FACTYP;
	loop	begin
		ITEMP:=IATOM;RTEMP:=RLATOM;
		case ATOM of
		  ^+:	begin
			RATOM;
			CTERM;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:=ITEMP + IATOM
			else RLATOM:=RTEMP + RLATOM;
			end;
		  ^-:	begin
			RATOM;
			CTERM;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:=ITEMP - IATOM
				else RLATOM:=RTEMP - RLATOM;
			end
		other	quit;
		end;
	end;	\CALGEXP


	proc	CLOGEXP;	\'not' and comparisons
	int	SFACTYP;
	int	ITEMP;
	real	RTEMP;
	begin
	if ATOM=NOTSYM ! ATOM=^~ then		\unary 'not' operator
		begin
		RATOM;
		CLOGEXP;
		INTTEST;
		IATOM:= ~IATOM;
		end
	else	begin
		CALGEXP;
		SFACTYP:=FACTYP;
		ITEMP:=IATOM; RTEMP:=RLATOM;
		case ATOM of
		 ^=:	[RATOM;
			CALGEXP;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:= ITEMP = IATOM
			else [IATOM:= RTEMP = RLATOM;  WARNING(2)];
			FACTYP:=INTEGER];
		 ^#:	[RATOM;
			CALGEXP;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:= ITEMP # IATOM
			else [IATOM:= RTEMP # RLATOM;  WARNING(2)];
			FACTYP:=INTEGER];
		 ^>:	[RATOM;
			CALGEXP;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:= ITEMP > IATOM
			else IATOM:= RTEMP > RLATOM;
			FACTYP:=INTEGER];
		 ^<:	[RATOM;
			CALGEXP;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:= ITEMP < IATOM
			else IATOM:= RTEMP < RLATOM;
			FACTYP:=INTEGER];
		 GESYM:	[RATOM;
			CALGEXP;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:= ITEMP >= IATOM
			else IATOM:= RTEMP >= RLATOM;
			FACTYP:=INTEGER];
		 LESYM:	[RATOM;
			CALGEXP;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:= ITEMP <= IATOM
			else IATOM:= RTEMP <= RLATOM;
			FACTYP:=INTEGER]
		other	[];
		end;
	end;	\CLOGEXP


	proc	CBOOLTERM;	\Boolean "&" expressions
	int	ITEMP;
	begin
	CLOGEXP;
	loop	begin
		ITEMP:=IATOM;
		if ATOM=^& ! ATOM=ANDSYM then
			begin
			INTTEST;
			RATOM;
			CLOGEXP;
			INTTEST;
			IATOM:=ITEMP & IATOM;
			end
		else quit;
		INTTEST;
		end;
	end;	\CBOOLTERM


begin	\CONEXPRESS
TRAP(false);
if ATOM=IFSYM then				\'if' expression
	begin
	RATOM;
	CONEXPRESS;
	INTTEST;
	IFVAR:=IATOM;
	if ATOM#THENYM then ERROR(22);
	RATOM;
	CONEXPRESS;
	SFACTYP:=FACTYP;
	ITEMP:=IATOM; RTEMP:=RLATOM;
	if ATOM#ELSEYM then ERROR(30);
	RATOM;
	CONEXPRESS;
	MIXTEST(SFACTYP);
	if IFVAR then 
		if FACTYP=INTEGER then IATOM:=ITEMP
		else RLATOM:=RTEMP;
	end
else	begin
	CBOOLTERM;
	loop	begin
		ITEMP:=IATOM;
		case ATOM of
		  ^!, ORSYM:
			begin
			INTTEST;
			RATOM;
			CBOOLTERM;
			INTTEST;
			IATOM:=ITEMP ! IATOM;
			end;
		  ^|, XORSYM:
			begin
			INTTEST;
			RATOM;
			CBOOLTERM;
			INTTEST;
			IATOM:=ITEMP | IATOM;
			end
		other quit;
		end;
	end;
TRAP(true);
if GETERR#0 then ERROR(74);			\general math error
end;	\CONEXPRESS

\-------------------------------------------------------------------------------

fproc	BOOLEXP;



proc	PROCAL(FUNC);
int	FUNC;	\true if function vs. procedure
int	SVAL, ARGCTR, BYTES, SID, CURSYM;
begin
SVAL:= VAL; SID:= IDTYPE; CURSYM:= SYMNUM;
RATOM;
ARGCTR:= 0;
BYTES:= 0;
CLEANREG(0);
if ATOM=^( then
	begin
	\mark the start of argument generation
	if SID>=INPROC & SID<=RLFPROC then GENMARK;
	loop	begin
		RATOM;
		BOOLEXP;
		ARGCTR:= ARGCTR+1;
		BYTES:= BYTES + (if FACTYP=INTEGER then INTSIZE else RLSIZE);
		if ATOM # ^, then quit;
		if SID>=INPROC & SID<=RLFPROC then []	\pseudo stack for procs
		else if FACTYP=INTEGER then TOS2STACK;	\h/w stack for others
		end;
	if ATOM#^) then ERROR(44) else RATOM;
	end;
case of
  SID>=INPROC & SID<=RLFPROC:				\normal procedure call
	[if ARGCTR>0 then GENARG(BYTES);
	GENCAL(SVAL, false)]

other	case SID of
	  ININT, RLINT:	GENCML(SVAL,FACTYP,SID,FUNC,ARGCTR); \intrinsic call
	  INOPT, RLOPT:					\optimized proc call
		[if ARGCTR>0 then ERROR(51);		\no arg declared
		GENJSR(SVAL)];
	  INEXT, RLEXT:	GENCEXT(CURSYM,FACTYP,SID,FUNC,ARGCTR);	\ext asm call
	  INEPRO, RLEPRO:					\ext xpl call
		[if ARGCTR>0 then GENARG(BYTES);
		GENCAL(CURSYM, true)]
	other;
end;	\PROCAL



proc	FACTOR;



func	STRCON;	\Generate code for a string constant and return its address
int	SPC,	\label number of starting address of string
	ASC,	\flag: last output was in ASCII format (vs. BINARY)
	CTR,	\count of characters on current line of output
	NCHAR,	\next character (one character look ahead)
	DONE;	\flag: terminating quote mark has been read in


	proc	GETNEXTCH;	\Get next chararacter
	begin
	CHAR:= NCHAR; NCHAR:= CHIN(SRCDEV);
	if NCHAR=EOF then [ERROR(63); exit 1];
	CHOUT(LSTDEV, NCHAR);
	if NCHAR <$20 ! NCHAR=$7F then
		if NCHAR#$0D\CR\ & NCHAR#$0A\LF\ & NCHAR#$09\TAB\ then
			WARNING(3);
	if NCHAR=^^ then
		begin		\convert to control characters, except ^ and Del
		NCHAR:=CHIN(SRCDEV);
		if NCHAR=EOF then [ERROR(63); exit 1];
		CHOUT(LSTDEV,NCHAR);
		if NCHAR <$20 ! NCHAR=$7F then
			if NCHAR#$0D\CR\ & NCHAR#$0A\LF\ & NCHAR#$09\TAB\ then
				WARNING(3);
		if NCHAR>=^@ & NCHAR<=^_ & NCHAR#^^ then NCHAR:=NCHAR-^@;
		if NCHAR>=^` & NCHAR<=^~ then NCHAR:=NCHAR-^`;
		end
	else if NCHAR=^" then	\terminating quote mark
		begin
		if STRTERM \#0\ then CHAR:= CHAR!$80;	\terminate with MSB set
		DONE:= true;
		end;
	end;	\GETNEXTCH


	proc	BINMODE;	\Output character as a decimal (binary) value
	begin
	if CTR#0 & ASC then CHOUT(BINDEV, ^");	\terminate ASCII string, if any
	if CTR#0 then CHOUT(BINDEV, ^,);	\output separator, if necessary
	INTOUT(BINDEV, CHAR);
	ASC:= false;		\no longer in ASCII mode
	end;	\BINMODE


	proc	ASCMODE;	\Output character as an ASCII value
	begin
	if CTR=0 then CHOUT(BINDEV, ^")		\begin ASCII string else
	else if not ASC then TEXT(BINDEV, ",^""); \separate binary part first
	CHOUT(BINDEV, CHAR);
	ASC:= true;		\now in ASCII mode
	end;	\ASCMODE


begin	\STRCON		Enter with CHAR = first character in string (or close ")
COMMENT($FB);
SPC:= NEWLAB;		\make a label at the starting address of the string
DLABEL(SPC);

if CHAR#^" then		\in case of null string (i.e: ""; must be 0 terminated)
	begin
	if CHAR=^^ then
		begin		\convert to control characters, except ^ and Del
		CHAR:=CHIN(SRCDEV);
		if CHAR=EOF then [ERROR(63); exit 1];
		CHOUT(LSTDEV,CHAR);
		if CHAR <$20 ! CHAR=$7F then
			if CHAR#$0D\CR\ & CHAR#$0A\LF\ & CHAR#$09\TAB\ then
				WARNING(3);
		if CHAR>=^@ & CHAR<=^_ & CHAR#^^ then CHAR:=CHAR-^@;
		if CHAR>=^` & CHAR<=^~ then CHAR:=CHAR-^`;
		end;
	NCHAR:= CHAR;			\so GETNEXTCH restores CHAR
	ASC:= false;
	DONE:= false;
	CTR:= 0;
	loop	begin
		GETNEXTCH;
		if CTR=0 then TEXT(BINDEV, "	DB	");	\new output line

		case of
		  CHAR=^', CHAR=^":	\assembler uses these for delimiters
				BINMODE;
		  CHAR>=$20:	ASCMODE;\non-control characters
		  CHAR=$09:	ASCMODE	\accept tab in ASCII, for readability
		other	BINMODE;
		CTR:= CTR+1;

		if DONE then [if ASC then CHOUT(BINDEV, ^"); quit];

		if CTR >= 40 then
			begin
			if ASC then CHOUT(BINDEV, ^");
			CRLF(BINDEV);
			CTR:= 0;
			end;
		end;	\loop
	CRLF(BINDEV);
	end;

if STRTERM = 0 then TTXT("	DB	0|");	\terminate with null

GETCH;
FACTYP:= INTEGER;
return SPC;		\return label number for starting address of string
end;	\STRCON



func	ARRAYCON;	\Constant arrays
int	THISEL, NEXTEL, PTR, SPC, I, INDIRECT, SFACTYP;
def	NULL=$FFFFFFFF;
char	ENTRY, R;

	proc	ARRAYX;	\(WARNING: This must be an optimized procedure
	begin		\ for the Reserve to work properly - i.e. no locals.)
	RATOM;
	INDIRECT:= true;
	case ATOM of
	  ^[:	[ENTRY:= ARRAYCON; RATOM];
	  ^":	[ENTRY:= STRCON; RATOM]
	other	begin
		INDIRECT:= false;
		CONEXPRESS;
		if FACTYP=INTEGER then ENTRY:= IATOM
		else	[ENTRY:= RESERVE(RLSIZE);  	\FACTYP=REAL
			R:= addr RLATOM;
			for I:= 0, RLSIZE-1 do ENTRY(I):= R(I)];
		end;
	NEXTEL:= RESERVE(3*INTSIZE);
	THISEL(1):= ENTRY;
	THISEL(2):= INDIRECT;
	THISEL(0):= NEXTEL;
	NEXTEL(0):= NULL;
	THISEL:= NEXTEL;
	end;	\ARRAYX


begin	\ARRAYCON
PTR:= RESERVE(3*INTSIZE);
THISEL:= PTR;
THISEL(0):= NULL;
ARRAYX;
while ATOM=^, do
	[SFACTYP:= FACTYP;
	ARRAYX;
	if FACTYP#SFACTYP then \mixed mode\ ERROR(46)];
if ATOM#^] then ERROR(50);
COMMENT(if FACTYP=INTEGER then $FD else $FC);

SPC:= NEWLAB;
DLABEL(SPC);
while PTR(0)#NULL do				\dump list
	begin
	ENTRY:= PTR(1);
	if FACTYP=INTEGER then
		begin
		TTXT("	DD	");
		if PTR(2) \indirect\ then CHOUT(BINDEV, ^L);
		INTOUT(BINDEV, ENTRY);
		end
	else	begin				\(FACTYP=REAL)
		if PTR(2) \indirect\ then
			begin
			TTXT("	DD	L");
			INTOUT(BINDEV, ENTRY);
			TTXT(", 3FF00000H|");
			end
		else	begin
			TTXT("	DQ	");
			CHOUT(BINDEV, ^0);
			for I:= 0, RLSIZE-1 do HEXB(ENTRY(RLSIZE-I-1));
			CHOUT(BINDEV, ^H);
			end;
		end;
	PTR:= PTR(0);
	CRLF(BINDEV);
	end;
return SPC;	\return starting address of array
end;	\ARRAYCON



proc	SPECFAC;	\Special character factor
int	SVAL, SID;
begin
case ATOM of
  ^(:	[RATOM;					\parenthesized expression
	BOOLEXP;				\(factor type is unchanged)
	if ATOM#^) then ERROR(44);
	RATOM];
  ^":	[DSTART;				\string constant
	SVAL:= STRCON;
	DEND;
	GENIMM(^L, SVAL);
	RATOM];
  ^[:	[DSTART;				\constant array
	TTXT("	ALIGN	8|");
	SVAL:= ARRAYCON;
	DEND;
	if FACTYP=INTEGER then GENIMM(^L, SVAL)
	else GENFIMM(^L, SVAL);			\FACTYP=REAL
	RATOM];
  ADRSYM:
	begin					\get absolute heap address
	RATOM;
	if ATYPE#IDENTIFIER then ERROR(45);
	LOOKUP;
	if IDTYPE#UNDEF then SYMTAG(SYMNUM):= SYMTAG(SYMNUM)!$01;
	case IDTYPE of
	  INVAR, RLVAR, ADDRVAR:
		begin
		SID:= IDTYPE;
		RATOM;
		if ATOM=^( then			\indexed
			begin
			GENLOD(LEV, VAL);	\(even for reals)
			RATOM;
			BOOLEXP;		\1st index
			if FACTYP#INTEGER then ERROR(47);
			while ATOM=^, do	\multiple indexing
				begin
				case SID of
				  INVAR, ADDRVAR: GENDBX;
				  RLVAR: GENTRX
				other [];
				RATOM;
				BOOLEXP;
				if FACTYP#INTEGER then ERROR(47);
				end;
			case SID of
			  INVAR: GENDBA;
			  RLVAR: GENTRA;
			  ADDRVAR: GENADD
			other [];
			if ATOM#^) then ERROR(44) else RATOM;
			end
		else	GENADR(LEV, VAL);
		end;
	  UNDEF:	ERROR(10)		\(undeclared name)
	other		ERROR(43);		\(variable expected)
	FACTYP:= INTEGER;
	end;
  ABSSYM:
	begin					\absolute value function
	RATOM;
	if ATOM#^( then ERROR(39) else RATOM;
	BOOLEXP;
	if FACTYP=INTEGER then GENABS else GENFABS;
	if ATOM#^) then ERROR(44) else RATOM;
	end;
  REMSYM:
	begin					\remainder of last divide
	RATOM;
	if ATOM#^( then ERROR(39) else RATOM;
	BOOLEXP;
	if FACTYP#INTEGER then ERROR(47);
	GENREM;
	if ATOM#^) then ERROR(44) else RATOM;
	end;
  SWAPYM:
	begin					\swap bytes function
	RATOM;
	if ATOM#^( then ERROR(39) else RATOM;
	BOOLEXP;
	if FACTYP#INTEGER then ERROR(47);
	GENSWAP;
	if ATOM#^) then ERROR(44) else RATOM;
	end;
  EXTSYM:
	begin					\sign extend function
	RATOM;
	if ATOM#^( then ERROR(39) else RATOM;
	BOOLEXP;
	if FACTYP#INTEGER then ERROR(47);
	GENEXT;
	if ATOM#^) then ERROR(44) else RATOM;
	end;
  PORTYM:
	begin					\read byte from port
	RATOM;
	if ATOM#^( then ERROR(39) else RATOM;
	BOOLEXP;
	if FACTYP#INTEGER then ERROR(47);
	GENPIN;
	if ATOM#^) then ERROR(44) else RATOM;
	end;
  FIXSYM:
	begin					\fix function
	RATOM;
	if ATOM#^( then ERROR(39) else RATOM;
	BOOLEXP;
	if FACTYP#REAL then ERROR(37);
	GENFIX;
	FACTYP:= INTEGER;
	if ATOM#^) then ERROR(44) else RATOM;
	end;
  FLOSYM:
	begin					\float function
	RATOM;
	if ATOM#^( then ERROR(39) else RATOM;
	BOOLEXP;
	if FACTYP#INTEGER then ERROR(47);
	GENFLOAT;
	FACTYP:= REAL;
	if ATOM#^) then ERROR(44) else RATOM;
	end;
  SQRTYM:
	begin					\sqrt function
	RATOM;
	if ATOM#^( then ERROR(39) else RATOM;
	BOOLEXP;
	if FACTYP=INTEGER then GENSQRT else GENFSQRT;
	if ATOM#^) then ERROR(44) else RATOM;
	end;
  SQSYM:
	begin					\square function
	RATOM;
	if ATOM#^( then ERROR(39) else RATOM;
	BOOLEXP;
	if FACTYP=INTEGER then GENSQ else GENFSQ;
	if ATOM#^) then ERROR(44) else RATOM;
	end
other	\illegal factor\ ERROR(26);
end;	\SPECFAC



proc	IDFAC;		\Identifier factor
int	SID;
begin
LOOKUP;
if IDTYPE#UNDEF then SYMTAG(SYMNUM):= SYMTAG(SYMNUM)!$01;
SID:= IDTYPE;
case IDTYPE of
 UNDEF:	ERROR(10);

 INVAR, RLVAR, ADDRVAR:				\variable
	begin
	if SID#RLVAR then GENLOD(LEV,VAL);
	RATOM;
	if ATOM=^( then				\it is indexed
		begin
		if SID=RLVAR then GENLOD(LEV,VAL);   \use integer for real array
		loop	begin
			RATOM;
			BOOLEXP;
			if FACTYP#INTEGER then ERROR(47);
			if ATOM#^, then quit;
			if SID=RLVAR then GENTRX else GENDBX;
			end;
		if ATOM#^) then ERROR(44) else RATOM;
		case SID of
		 INVAR:   GENDBX;
		 RLVAR:   GENTRI;
		 ADDRVAR: GENLDX
		other	[];
		end
	else	if SID=RLVAR then GENFLOD(LEV,VAL); \not array so just load real
	end;

 INCON:	begin					\integer constant identifier
	GENIMM(^C, VAL);
	RATOM;
	end;

 RLCON:	begin					\real constant identifier
	RLATOM:= RLTBL(VAL); GENFIMM(^C, 0);
	RATOM;
	end

other	begin					\procedures used as functions
	PROCAL(true);
	if SID<ININT then	\integer functions return values in EAX
		if SID&1 then [PPUSH(REGTYP, 0, 0) \GENLOD(0, 0); TOS2HARD\]
		else GENFLOD(0, 0);
	end;

FACTYP:= if SID & 1 then INTEGER else REAL;	\odd IDs are integer
end;	\IDFAC



begin	\FACTOR
while ATOM=^+ do [RATOM; if ATOM=^+ then WARNING(7)];	\ignore unary "+"
if ATOM=^- then					\unary "-"
	begin
	RATOM;
	if ATOM=^- then WARNING(7);
	FACTOR;
	if FACTYP=INTEGER then GENNEG else GENFNEG;
	end
else	case ATYPE of
	  SPECIAL:	SPECFAC;
	  INTCON:	[FACTYP:= INTEGER;	\integer constant
			GENIMM(^C, IATOM);
			RATOM];
	  REALCON:	[FACTYP:= REAL;		\real constant
			GENFIMM(^C, 0);
			RATOM]
	other		IDFAC;			\ATYPE = IDENTIFIER (by default)
end;	\FACTOR



proc	SHIFTEXP;

	proc	SHIFTX;
	begin
	if FACTYP # INTEGER then \integer expected\ ERROR(47);
	RATOM; FACTOR;
	if FACTYP # INTEGER then ERROR(47);
	end;	\SHIFTX

begin	\SHIFTEXP
FACTOR;
case ATOM of
  LSLSYM: [SHIFTX; GENLSL];	\ <<
  LSRSYM: [SHIFTX; GENLSR];	\ >>
  ASRSYM: [SHIFTX; GENASR]	\->>
other;
end;	\SHIFTEXP



proc	TERM;
int	SFACTYP;

	proc	TERMX(INOP, RLOP);
	int	INOP, RLOP;
	begin
	RATOM; SHIFTEXP;
	if SFACTYP#FACTYP then \mixed mode\ ERROR(46);
	GENMTH(if FACTYP=INTEGER then INOP else RLOP);
	end;	\TERMX

begin	\TERM
SHIFTEXP;
SFACTYP:= FACTYP;
loop	case ATOM of
	  ^*:	TERMX(\MUL\$0F, \MULF\$2F);
	  ^/:	TERMX(\DIV\$10, \DIVF\$30)
	other	quit;
end;	\TERM



proc	ALGEXP;		\Algebraic expression
int	SFACTYP;

	proc	ALGX(INOP, RLOP);
	int	INOP, RLOP;
	begin
	RATOM; TERM;
	if SFACTYP#FACTYP then \mixed mode\ ERROR(46);
	GENMTH(if FACTYP=INTEGER then INOP else RLOP);
	end;

begin	\ALGEXP
TERM;
SFACTYP:= FACTYP;
loop	case ATOM of
	  ^+:	ALGX(\ADD\$0D, \ADDF\$2D);
	  ^-:	ALGX(\SUB\$0E, \SUBF\$2E)
	other	quit;
end;	\ALGEXP



proc	LOGEXP;		\Logical expression
int	SFACTYP;

	proc	LOGX(INOP, RLOP);
	int	INOP, RLOP;
	begin
	RATOM; ALGEXP;
	if SFACTYP#FACTYP then \mixed mode\ ERROR(46);
	GENCMP(if FACTYP=INTEGER then INOP else RLOP);
	FACTYP:= INTEGER;
	end;

begin	\LOGEXP
if ATOM=NOTSYM ! ATOM=^~ then			\unary 'not' operator
	begin
	RATOM;
	if ATOM=NOTSYM ! ATOM=^~ then WARNING(7);
	LOGEXP;
	if FACTYP#INTEGER then ERROR(47);
	GENNOT;
	end
else	begin
	ALGEXP;
	SFACTYP:= FACTYP;
	case ATOM of
	  ^=:	[LOGX(\EQ\$12, \EQF\$32);  if FACTYP=REAL then WARNING(2)];
	  ^#:	[LOGX(\NE\$13, \NEF\$33);  if FACTYP=REAL then WARNING(2)];
	  ^>:	LOGX(\GT\$15, \GTF\$35);
	  ^<:	LOGX(\LT\$17, \LTF\$37);
	  GESYM:LOGX(\GE\$14, \GEF\$34);
	  LESYM:LOGX(\LE\$16, \LEF\$36)
	other;
	end;
end;	\LOGEXP



proc	BOOLTERM;	\Boolean "&" expressions
begin
LOGEXP;
loop	begin
	if ATOM=^& ! ATOM=ANDSYM then
		[if FACTYP#INTEGER then ERROR(47);
		RATOM; LOGEXP; GENAND]
	else	quit;
	if FACTYP#INTEGER then ERROR(47);
	end;
end;	\BOOLTERM



func	SHORTER(LT, LF); \Short-circuit evaluate boolean expressions
int	LT, LF;	    \labels to jump to if boolean expression is true or false
int	LTUSED, LFUSED;	 \flags

\if LOGEXP then STATEMENT
\Labels:       ^LT       ^LF
\Example:
\if N=1  !  N=2  !  N=3 & N=4 & N=5  !  N=6  !  N=7 then ...
\
\		CMP	N,1
\		JE	LT
\		CMP	N,2
\		JE	LT
\
\		CMP	N,3
\		JNE	LF0
\		CMP	N,4
\		JNE	LF0
\		CMP	N,5
\		JE	LT
\	LF0:				;initial false label
\		CMP	N,6
\		JE	LT
\		CMP	N,7
\		JNE	LF1
\	LT:				;there is only one true label
\		CALL	STATEMENT
\	LF1:				;final false label is returned

begin
LTUSED:= false;
LFUSED:= false;
loop	begin
	RATOM;
	LOGEXP;
	loop	begin
		if ATOM=^& ! ATOM=ANDSYM then
			begin	\beware of masking, e.g: if F & 3 then ...
			if LASTOP>=$12 & LASTOP<=$17 then	\comparison
				begin
				GENJPC(LF,false);	\jump to false label
				LFUSED:= true;		\label is used
				RATOM; LOGEXP;
				end
			else	[RATOM; LOGEXP; GENAND]; \old way
			end
		else quit;
		end;
	case ATOM of
	  ^!, ORSYM:
		begin
		GENJPC(LT,true);	\conditionally jump to true label
		LTUSED:= true;		\indicate that true label was used
		if LFUSED then		\if there is a conditional jump using
			begin		\ this label then...
			CLABEL(LF);	\make label for false destination
			LF:= NEWLAB;	\make another false label
			LFUSED:= false;	\this one isn't used yet
			end;
		end;
	  ^|, XORSYM, IFSYM: \must use parentheses for xor and 'if' expressions
		ERROR(75)
	other	quit;
	end;
GENJPC(LF,false);
if LTUSED then CLABEL(LT);		\only make label if it is actually used
return LF;				\return (possibly new) false label
end;	\SHORTER



proc	BOOLEXP;	\Boolean expression. Outputs factor type (FACTYP).
int	P1, P2, P3, SFACTYP;


	proc	IFEXP;
	begin				\if BOOLEXP then BOOLEXP else BOOLEXP
	CLEANREG(0);
	if SHORTBOOL then		\Labels:      P1^     P2^          P3^
		begin
		P1:= NEWLAB;		\true label
		P2:= NEWLAB;		\false label
		P2:= SHORTER(P1, P2);	\returns false label (may be different)
		end
	else	begin
		RATOM;
		BOOLEXP;
		P2:= NEWLAB;		\false label
		GENJPC(P2,false);	\skip statement if BOOLEXP is false
		end;

	if ATOM # THENYM then ERROR(22);
	RATOM;
	BOOLEXP;
	SFACTYP:= FACTYP;
	if FACTYP = INTEGER then TOS2EAX;
	PDROP(1);			\a lie, but it gets corrected below
	if ATOM # ELSEYM then ERROR(30);
	P3:= NEWLAB;
	GENJMP(P3);
	CLABEL(P2);

	RATOM;
	BOOLEXP;
	if FACTYP=INTEGER then TOS2EAX;
			\pseudo stack must be in same state for each code path
	if SFACTYP#FACTYP then \mixed mode\ ERROR(46);
	CLABEL(P3);
	end;



	proc	BEXPX;
	begin
	if FACTYP # INTEGER then \integer expected\ ERROR(47);
	RATOM; BOOLTERM;
	if FACTYP # INTEGER then ERROR(47);
	end;	\BEXPX


begin
if ATOM=IFSYM then IFEXP			\'if' expression
else	begin					\boolean "!" (or) expressions
	BOOLTERM;
	loop	case ATOM of
		  ^!, ORSYM:	[BEXPX; GENOR];
		  ^|, XORSYM:	[BEXPX; GENEOR]
		other quit;
	end;
end;	\BOOLEXP

\-------------------------------------------------------------------------------

proc	SSTATEMENT(SSTK);	\(For 'quit's in 'case' statements)
int	SSTK;



proc	STATEMENT;
int	P1, P2, P3, SFIXS, SLEV, SVAL, SFACTYP, SEDXLEV,
	LOPARAMS, HIPARAMS, FLAG, DOWNTO;



proc	ASSIGN;		\Assignment statement (also includes procedure calls)
int	SID;

	proc	ASSX;
	begin
	if ATOM#GETSYM then ERROR(21);
	RATOM;
	BOOLEXP;	\right-hand side of assignment
	end;

begin	\ASSIGN
if ATOM=PORTYM then	\port($123):= BOOLEXP
	begin
	RATOM;
	if ATOM#^( then ERROR(39) else RATOM;
	BOOLEXP;
	if FACTYP#INTEGER then ERROR(47);
	if ATOM#^) then ERROR(44) else RATOM;
	ASSX;
	GENPOUT;
	if FACTYP#INTEGER then ERROR(47);
	return;
	end;

if ATYPE#IDENTIFIER then			\illegal start of a statement
	[ERROR(20); SKIPIT; return];
LOOKUP; if IDTYPE=UNDEF then [ERROR(10); SKIPIT; return];
SLEV:= LEV; SVAL:= VAL;			\save these for GEN. An interim
SID:= IDTYPE;				\ BOOLEXP in ASSX changes LEV & VAL

case of
  IDTYPE>=INPROC & IDTYPE<=RLEXT:
	[SYMTAG(SYMNUM):= SYMTAG(SYMNUM)!$01;  PROCAL(false)];

  IDTYPE=INVAR ! IDTYPE=RLVAR ! IDTYPE=ADDRVAR:
	begin
	SFACTYP:=if IDTYPE=RLVAR then REAL else INTEGER;
	RATOM;
	if ATOM=^( then				\indexed
		begin
		SYMTAG(SYMNUM):= SYMTAG(SYMNUM)!$01;
		GENLOD(SLEV, SVAL);		\(even for reals)
		RATOM;
		BOOLEXP;			\1st index
		if FACTYP#INTEGER then ERROR(47);

		while ATOM=^, do		\multiple indexing
			begin
			if SFACTYP=INTEGER then GENDBX else GENTRX;
			RATOM;
			BOOLEXP;
			if FACTYP#INTEGER then ERROR(47);
			end;
		if ATOM#^) then ERROR(44) else RATOM;
		case SID of
		 INVAR:   GENDBA;
		 RLVAR:   GENTRA;
		 ADDRVAR: GENSTXADD
		other	[];

		ASSX;				\TOS now points to array element
		case SID of
		 INVAR:   GENSTD;
		 RLVAR:   GENSTT;
		 ADDRVAR: if STXFLAG then GENSTX2 else GENSTX
		other	[];
		end

	else	[ASSX;
		if SFACTYP=INTEGER then GENSTO(SLEV, SVAL)
		else GENFSTO(SLEV, SVAL)];

	if FACTYP#SFACTYP then \mixed mode\ ERROR(46);
	end

other	\statement starting with a constant\ [ERROR(27); SKIPIT];
end;	\ASSIGN



proc	CASER(TYPE);
int	TYPE;
int	SPC1, SPC2, SPC3, MULTILABEL, SEAXHI0;
begin
if TYPE = $25\CJP\ then TOS2EAX;
SPC2:= NEWLAB;
repeat	MULTILABEL:= false;
	loop	begin
		RATOM;				\case label:
		BOOLEXP;
		if FACTYP#INTEGER then ERROR(47);
		if ATOM#^, then quit;
		if ~MULTILABEL then
			[SPC3:= NEWLAB;
			MULTILABEL:= true];
		if TYPE=$08 then GENJPC(SPC3,true) else GENCJP(SPC3,true);
		end;
	SPC1:= NEWLAB;
	if TYPE=$08 then GENJPC(SPC1,false) else GENCJP(SPC1,false);
	SEAXHI0:= EAXHI0;		\preserve EAXHI0 to enable "CMP AL,IMM"
	if MULTILABEL then CLABEL(SPC3);
	if ATOM#^: then [ERROR(49); SKIPIT; return];

	if TYPE = $25\CJP\ then PDROP(1);		\don't save EAX
	RATOM;
	STATEMENT;
	if TYPE = $25\CJP\ then PPUSH(REGTYP, 0, 0);	\EAX holds case value

	GENJMP(SPC2);				\jump out of case statement
	CLABEL(SPC1);
	EAXHI0:= SEAXHI0;
until ATOM#^;;

if ATOM#ELSEYM & ATOM#OTHSYM then ERROR(29);
if ATOM=ELSEYM then WARNING(4);
if TYPE = $25\CJP\ then PDROP(1);		\don't save EAX
RATOM;
STATEMENT;
if TYPE = $25\CJP\ then PPUSH(REGTYP, 0, 0);	\EAX holds case value
CLABEL(SPC2);
end;	\CASER



begin	\STATEMENT
case ATOM of
BEGSYM, ^[:
	begin
	RATOM;
	loop	begin
		if ATOM=ELSEYM then [ERROR(52); RATOM];
		if ATOM=OTHSYM then [ERROR(53); RATOM];
		STATEMENT;
		case ATOM of
		  ^;:	RATOM;
		  ENDSYM, ^]:
			quit;
		  EOF:	[ERROR(62); exit 1]
		other	\semi expected\ ERROR(41);
		end;
	RATOM;		\read past the 'end'
	end;

CASEYM:	begin					\case statement
	RATOM;
	if ATOM=OFSYM then CASER(\JPC\$08)
	else	begin
		BOOLEXP;
		if FACTYP#INTEGER then ERROR(47);
		if ATOM#OFSYM then [ERROR(48); SKIPIT; return];
		STKLOD:= STKLOD+1;
		CASER(\CJP\$25);
		GENDRP(1);
		PDROP(1);
		STKLOD:= STKLOD-1;
		end;
	end;

QUITYM:	begin
	GENDRP(STKLOD-SSTK);
	if FIXCTR>=QUITMAX then [ERROR(4); FIXCTR:= QUITMAX-1];
	FIXES(FIXCTR):= NEWLAB;		\'quit' statement
	GENJMP(FIXES(FIXCTR));   	\(will be "fixed" at end of 'loop')
	EDXLEV:= -1;			\may be jumping out of a 'for' loop and
	FIXCTR:= FIXCTR+1;		\ EDX is not = to its memory loc here
	RATOM;
	end;

IFSYM:	begin				\if BOOLEXP then STATEMENT
	if SHORTBOOL then		\Labels:      P1^       P2^
		begin
		P1:= NEWLAB;		\true label
		P2:= NEWLAB;		\false label
		P2:= SHORTER(P1, P2);	\returns false label (may be different)
		end
	else	begin
		RATOM;
		BOOLEXP;
		P2:= NEWLAB;		\false label
		GENJPC(P2,false);	\skip statement if BOOLEXP is false
		end;
	if ATOM # THENYM then [ERROR(22); SKIPIT; return];
	RATOM;
	STATEMENT;
	if ATOM = ELSEYM then
		begin		      \if BOOLEXP then STATEMENT else STATEMENT
		P3:= NEWLAB;	      \Labels:      P1^       P2^            P3^
		GENJMP(P3);
		CLABEL(P2);
		P2:= P3;		\change name of P2 exit label to be P3
		RATOM;
		STATEMENT;
		end;
	CLABEL(P2);
	end;

REPSYM:	begin
	DOALIGN;
	P2:= NEWLAB;			\repeat statement
	CLABEL(P2);
	SEDXLEV:= EDXLEV; EDXPEND:= true;	\mark register variable pending
	repeat RATOM; STATEMENT until ATOM#^;;
	if ATOM#UNTSYM then [ERROR(28); SKIPIT; return];
	RATOM;
	BOOLEXP;
	GENJPC(P2,false);
	if EDXPEND & EDXLEV>=0 then
	\Restore reg var (EDX) if it's still pending & nothing else bombed it
		[EDXLEV:= SEDXLEV; EDXPEND:= false];
	end;

WHILYM:	begin				\     while BOOLEXP do STATEMENT
	DOALIGN;			\Labels: P1^        P2^       P3^
	P1:= NEWLAB;
	CLABEL(P1);
	SEDXLEV:= EDXLEV; EDXPEND:= true;	\mark register variable pending
\The 'for' loop control variable is shadowed by the register EDX. When EDX is
\ "pending" because of the 'while' loop, the actual memory value that EDX
\ shadows must be fetched, rather than fetching EDX, because EDX could be bombed
\ later in the 'while' loop. But if the actual memory value is fetched, EDX must
\ be bombed, otherwise the actual memory value will not be incremented at end of
\ the 'for' loop. This complication is endured only because it shaves 10% off
\ the time for the Sieve benchmark; it is rarely encountered anywhere else. The
\ straightforward thing would be to simply say that EDX is bombed because of the
\ label at the top of the 'while' loop, i.e. say: EDXLEV:= -1 at this point.

	if SHORTBOOL then
		begin
		P2:= NEWLAB;		\true label
		P3:= NEWLAB;		\false label
		P3:= SHORTER(P2, P3);	\returns false label
		end
	else	begin
		RATOM;
		BOOLEXP;
		P3:= NEWLAB;
		GENJPC(P3,false);
		end;
	if ATOM # DOSYM then [ERROR(23); SKIPIT; return];
	RATOM;
	STATEMENT;
	GENJMP(P1);
	CLABEL(P3);
	if EDXPEND & EDXLEV>=0 then
	\Restore reg var (EDX) if it's still pending & nothing else bombed it
		[EDXLEV:= SEDXLEV; EDXPEND:= false];
	end;

RETSYM:	begin				\return statement
	RATOM;
	GENDRP(STKLOD);
	if ATOM#ELSEYM & ATOM#OTHSYM & ATOM#^; & ATOM#^] &
	    ATOM#ENDSYM & ATOM#UNTSYM then	\store the returned
		[BOOLEXP;			\ value in EAX or global 0
		if FACTYP=INTEGER then
			[if LEVEL=0 & ~OPTPROC then GENSTO(0, 0)
			else [TOS2EAX; PDROP(1)]]
		else GENFSTO(0, 0)];
	if OPTPROC then GENRTS(LEVEL)
	else GENRET(LEVEL);
	EDXLEV:= -1;			\may be jumping out of a 'for' loop and
	end;				\ EDX is not = to its memory loc here
					\ and it might be global
LOOPYM:	begin				\loop statement
	SFIXS:= FIXCTR;
	RATOM;
	DOALIGN;
	P2:= NEWLAB;
	CLABEL(P2);
	SEDXLEV:= EDXLEV; EDXPEND:= true; \mark register variable pending
	SSTATEMENT(STKLOD);
	GENJMP(P2);
	while FIXCTR>SFIXS do		\fix the jumps for the 'quit's
		[FIXCTR:= FIXCTR-1; CLABEL(FIXES(FIXCTR))];
	if EDXPEND & EDXLEV>=0 then	\quit bombs EDX: EDXLEV is not restored
	\Restore reg var (EDX) if it's still pending & nothing else bombed it
		[EDXLEV:= SEDXLEV; EDXPEND:= false];
	end;

FORSYM:	begin				\for statement
	LOPARAMS:= RESERVE(3*INTSIZE);	\optimize when limits are immediate
	HIPARAMS:= RESERVE(3*INTSIZE);
	RATOM;
	if ATYPE#IDENTIFIER then [ERROR(33); SKIPIT; return];
	LOOKUP;
	if IDTYPE=UNDEF then ERROR(10)
	else	[if IDTYPE#INVAR & IDTYPE#ADDRVAR then ERROR(33);
		SYMTAG(SYMNUM):= SYMTAG(SYMNUM)!$01];
	SLEV:= LEV; SVAL:= VAL;
	RATOM;
	if ATOM#GETSYM then [ERROR(21); SKIPIT; return];
	RATOM;
	BOOLEXP;
	LOPARAMS(0):= PSTKTYP(PSTKPTR-1);
	LOPARAMS(1):= PSTKLEV(PSTKPTR-1);
	LOPARAMS(2):= PSTKOFF(PSTKPTR-1);

	if FACTYP#INTEGER then ERROR(47);
	GENSTO(SLEV, SVAL);

	DOWNTO:= false;
	if ATOM=TOSYM ! ATOM=^, then []
	else if ATOM=DOWNYM then DOWNTO:= true
	else [ERROR(24); SKIPIT; return];

	RATOM;
	BOOLEXP;
	HIPARAMS(0):= PSTKTYP(PSTKPTR-1);
	HIPARAMS(1):= PSTKLEV(PSTKPTR-1);
	HIPARAMS(2):= PSTKOFF(PSTKPTR-1);

	if HIPARAMS(0)#IMMTYP then TOS2STACK;
	if FACTYP#INTEGER then ERROR(47);
	if ATOM#DOSYM then [ERROR(23); SKIPIT; return];

	\Put copy of control variable into EDX
	if SLEV=EAXLEV & SVAL=EAXOFF then
		[TTXT("	XCHG	EDX,EAX|");	\optimize - one byte
		EAXLEV:= -1; EAXIMM:= false; EAXHI0:= false] \(destroyed anyway)
	else	OPSTRING("	MOV	EDX,&|", ^A, SLEV, SVAL, 0);
	EDXLEV:= SLEV; EDXOFF:= SVAL; EDXPEND:= false;

	\We don't need to JMP to FOR op if loop limits are immediate values (and
	\ low limit <= hi limit) because the loop will be executed at least once
	FLAG:= LOPARAMS(0)=IMMTYP & HIPARAMS(0)=IMMTYP &
		(if DOWNTO then LOPARAMS(1)>=HIPARAMS(1)
		else LOPARAMS(1)<=HIPARAMS(1));
	if ~FLAG then				\optimize JMP
		begin
		if HIPARAMS(0)=IMMTYP & HIPARAMS(1)=0 then
			TTXT("	TEST	EDX,EDX|");	\CMP EDX,0 outside loop
		P2:= NEWLAB;
		GENJMP(P2);
		end;
	DOALIGN;
	P3:= NEWLAB;
	CLABEL(P3);

	RATOM;
	STKLOD:= STKLOD+1;
	STATEMENT;
	STKLOD:= STKLOD-1;
	GENINP(SLEV, SVAL, DOWNTO);
	if ~FLAG then CLABEL(P2);
	GENFOR(SLEV, SVAL, P3, HIPARAMS(0), HIPARAMS(1), DOWNTO);
	end;

EXITYM:	[RATOM;					\exit statement
	if ATOM#ELSEYM & ATOM#OTHSYM & ATOM#^; & ATOM#^] &
	    ATOM#ENDSYM & ATOM#UNTSYM then	\store the returned
		[BOOLEXP;			\ value in global 0
		if FACTYP=INTEGER then GENSTO(0, 0) else GENFSTO(0, 0)];
	GENEXIT];

ELSEYM, OTHSYM, ^;, ^], ENDSYM, UNTSYM:	[];

EOF:	[]					\(this is mostly academic)
other	ASSIGN;
end;	\STATEMENT



begin	\SSTATEMENT
\Trick to adjust stack (with DRP's) when a 'quit' is in a 'case' statement.
STATEMENT;
end;	\SSTATEMENT

\-------------------------------------------------------------------------------

proc	PROCEDURE; int SSNOX;	\SSNO from PROCDEC for optimized procedures
int	SLEVEL,		\save level (complicated by optimized procedures)
	P1,
	HEAPSP,		\heap space requirement counter (formerly called DX)
	HEAPSPOFF,	\variable's offset from base (=HEAPSP if no arrays or if
	HAVEGENBASE,	\flag: have generated base code for procedure
	HAVESTART,	\flag: have generated start-up code for program
	OLDCOD,		\OLDCODCTR to see if there is code in the Main procedure
	FPBASE,		\LABCTR at end of declarations
	FPROCTR;	\count of pending forward procedures



proc	EATARGS;	\Skip arguments in parentheses
begin
if ATOM=^( then
	begin
	loop	[if CHAR=^) then quit;
		if CHAR=$0D\CR\ then [ERROR(44); quit];
		GETCH];
	GETCH; RATOM;
	end;
end;	\EATARGS



proc	CODDEC;		\Declare intrinsic names
int	SID;
begin
SID:= ININT;		\default is integer intrinsic
RATOM;
if ATOM=REALYM then [SID:= RLINT; RATOM]
else if ATOM=INTSYM then RATOM;
if ATYPE#IDENTIFIER then ERROR(45);
while ATYPE=IDENTIFIER do
	[RATOM;
	EATARGS;
	if ATOM#^= then ERROR(40);
	RATOM;
	GETCON; if FACTYP#INTEGER then ERROR(47);
	if IATOM<0 ! IATOM>127 then ERROR(7);
	INSERT(SID, LEVEL, IATOM);
	RATOM;
	if ATOM=^, then RATOM];
if ATOM#^; then ERROR(41) else RATOM;
end;	\CODDEC



proc	CONDEC;		\Declare constant names
int	CTR, SSNO, F1, F2;
begin
F1:=false; F2:=false;
RATOM;
CTR:= 0;
if ATYPE#IDENTIFIER then ERROR(45);
while ATYPE=IDENTIFIER do
	begin
	RATOM;
	if ATOM#^= then [INSERT(INCON, LEVEL, CTR); CTR:= CTR+1; F1:= true]
	else	begin
		SSNO:= NOSYM;
		INSERT(INCON, LEVEL, NORLSY);	\insert ID now; fix up the rest
		RATOM;				\ of the parameters later
		CONEXPRESS;
		if FACTYP=INTEGER then SYMVAL(SSNO):= IATOM
		else	[SYMTYP(SSNO):= RLCON;	\FACTYP=REAL
			if NORLSY>=RLMAX then
				[ERROR(2); NORLSY:= RLMAX-1];
			RLTBL(NORLSY):= RLATOM;
			NORLSY:= NORLSY+1];
		F2:= true;
		end;
	if ATOM=^, then RATOM else if ATOM#^; then WARNING(5);
	end;
if ATOM#^; then ERROR(41) else RATOM;
if F1 & F2 then WARNING(6);
end;	\CONDEC



proc	CHECKBASE;	\Generate base init code for procedure, if not done
begin
if not HAVEGENBASE then
	begin
	if not HAVESTART then
		if LEVEL=0 then [GENSTART; HAVESTART:= true];
		\(beware of more than 64K of 'eproc's)
	HAVENEST:= true;		\assume worst case
	GENBASE(LEVEL,HEAPSP);
	HEAPSP:= 0;			\it's been reserved (don't do it again)
	OPTPROC:= false;
	HAVEGENBASE:= true;
	end;
end;	\CHECKBASE



proc	VARDEC(TYPE);	\Declare variables: int, real & char
int	TYPE;
int	DIMS,T,ST,SOFF;
begin
RATOM;
if ATYPE#IDENTIFIER then ERROR(45);
while ATYPE=IDENTIFIER do
	begin
	INSERT(TYPE,LEVEL,HEAPSPOFF);
	SOFF:= HEAPSPOFF;	\save address of possible array declaration
	HEAPSPOFF:=HEAPSPOFF + (if TYPE=RLVAR then RLSIZE else INTSIZE);
	T:= if TYPE=RLVAR then RLSIZE else INTSIZE;
	ST:= T;
	if TYPE=ADDRVAR then ST:=1;
	RATOM;
	if ATOM=^( then				\get dimension(s) of an array
		begin
		CHECKBASE;
		if HEAPSP#0 & LEVEL#0 then	\(split heap)
			[GENHPI(HEAPSP); HEAPSP:=0];
		DIMS:= 0;
		loop	begin
			RATOM;
			CONEXPRESS;
			if FACTYP#INTEGER then ERROR(47);
			\Push sizes of each dimension onto stack
			GENIMM(^C,IATOM);
			TOS2STACK; PDROP(1);
			DIMS:= DIMS +1;		\count number of dimensions
			if ATOM # ^, then	\last dimension of char array is
				begin		\ only a single byte per entry
				if ST=1 then T:=T/INTSIZE;
				T:=T*IATOM;
				if ST=1 then T:= T+3 & $FFFFFFFC;  \(INTSIZE=4)
						\keep aligned on dword boundary
				if LEVEL#0 then HEAPSPOFF:=HEAPSPOFF+T;
				quit;
				end;
			T:=T*IATOM;    \accumulate byte count for each dimension
			if LEVEL#0 then HEAPSPOFF:=HEAPSPOFF+T;\offset from base
			end;
		if ATOM#^) then ERROR(44) else RATOM;

		\Generate code to set up the array at run time, for example:
		\Generate CALL MakeArray( (3, 5, 7, 11), 4, INTSIZE);
		GENIMM(^C,DIMS);      \number of dimensions (4)
		TOS2STACK; PDROP(1);
		GENIMM(^C,ST);	      \number of bytes in each element (INTSIZE)
		TOS2EAX; PDROP(1);
		GENARY;
		if LEVEL=0 then
		\Store address of array (returned by MKARRAY) in array variable
			[PPUSH(REGTYP, 0, 0); GENSTO(0, SOFF)];
		end
	else	HEAPSP:= HEAPSP + (if TYPE=RLVAR then RLSIZE else INTSIZE);
	if ATOM=^, then RATOM;
	end;
if ATOM#^; then ERROR(41) else RATOM;
end;	\VARDEC



proc	EXTDEC(XPL);	\Declare external procedures (both eproc and ext)
int	XPL;		\flag: XPL-type external (eproc), not assembly (ext)
int	SID, D;
begin
SID:= if XPL then INEPRO else INEXT;	\default is integer external

RATOM;					\handle real vs. integer procedure
if ATOM=REALYM then [SID:= if XPL then RLEPRO else RLEXT; RATOM]
else if ATOM=INTSYM then RATOM;
if ATYPE#IDENTIFIER then ERROR(45);

D:= 0;
while ATYPE=IDENTIFIER do
	begin
	INSERT(SID, LEVEL, IATOM);
	RATOM;
	EATARGS;
	if ATOM=^, then RATOM;
	TTXT("	EXTRN	");
	if XPL then CHOUT(BINDEV, ^_); 
	SYMOUT(NOSYM-1); TTXT(":NEAR|");
	D:= D+1;
	end;
if ATOM#^; then ERROR(41) else RATOM;
end;	\EXTDEC



proc	FPRDEC;		\Declare forward-referenced procedures
int	SID, I;
begin
SID:= INFPROC;		\default type
RATOM;
if ATOM=REALYM then [SID:= RLFPROC; RATOM]
else if ATOM=INTSYM then RATOM;
if ATYPE#IDENTIFIER then ERROR(45);
while ATYPE=IDENTIFIER do
	begin
	RATOM;
	I:= NEWLAB;
	INSERT(SID, LEVEL, I);
	FLABEL(I);
	GENFJMP(NEWLAB);
	FPROCTR:= FPROCTR+1;
	EATARGS;
	if ATOM=^, then RATOM;
	end;
if ATOM#^; then ERROR(41) else RATOM;
end;	\FPRDEC



proc	PROCDEC(CANOPT, PUBLIC);	\Declare procedure names
int	CANOPT, PUBLIC;
int	SNOSYM, HASH, I, K, SID, SSNO, SNORL;
begin
SID:= INPROC;				\typed procedure (for functions)
RATOM;
if ATOM=REALYM then [SID:= RLPROC; RATOM]
else if ATOM=INTSYM then RATOM;
if ATYPE#IDENTIFIER then ERROR(45) else LOOKUP;

if IDTYPE=INFPROC ! IDTYPE=RLFPROC then
	\Procedure has been previously declared by a 'fproc' or 'ffunct'
	begin
	if LEVEL#LEV then ERROR(65);	\('fproc' & 'proc' must be same scope)
	if PUBLIC then			\handle public procedures
		begin
		TTXT("	PUBLIC	_");
		SYMOUT(SYMNUM);
		TTXT("|_");
		SYMOUT(SYMNUM);
		TTXT(":|");
		end;
	FLABEL(VAL+1);
	SYMVAL(SYMNUM):= VAL+1;
	SYMTYP(SYMNUM):= if IDTYPE=INFPROC then INPROC else RLPROC;
	if SID#SYMTYP(SYMNUM) then \mixed mode\ ERROR(46);
	if VAL>=FPBASE then FPROCTR:= FPROCTR-1;
	OPTPROC:= false;
	end
else	begin
	SSNO:= NOSYM;
	I:= NEWLAB;
	INSERT(SID, LEVEL, I);
	if PUBLIC then			\handle public procedures
		begin
		TTXT("	PUBLIC	_");
		SYMOUT(NOSYM-1);
		TTXT("|_");
		SYMOUT(NOSYM-1);
		TTXT(":|");
		end;
	FLABEL(I);
	OPTPROC:= CANOPT;
	end;

\Assume for now that procedure is not optimized and move down a static level
SLEVEL:=LEVEL;
LEVEL:= LEVEL+2; if LEVEL >= LEVELMAX*2 then ERROR(5);
\Eat the argument list as a comment. This special comment stops on carriage ret.
while CHAR#^; & CHAR#\CR\$0D do GETCH;
if CHAR#^; then ERROR(41);
GETCH; RATOM;

SNOSYM:= NOSYM; SNORL:= NORLSY;
PROCEDURE(SSNO);	\pass location of proc name in case it's optimized
CHKUSE(SNOSYM);
if ATOM#^; then ERROR(41) else RATOM;
while NOSYM>SNOSYM do	\restore symbol table to previous level
	begin		\i.e. remove identifiers which were local to this proc
	NOSYM:= NOSYM-1;
	HASH:= 0; K:= NOSYM;
	for I:= 0, SIGCHAR-1 do
		[HASH:= HASH+SYMBOL(K); K:= K+SYMAX];
	BOX(HASH&HASHMASK):= SYMPTR(NOSYM);
	end;
NORLSY:= SNORL;
LEVEL:= SLEVEL;
HAVENEST:= true;
end;	\PROCDEC



begin	\PROCEDURE
EDXLEV:= -1;		\we don't know what's in EDX
EAXLEV:= -1;
EAXIMM:= false;
EAXHI0:= false;
STXFLAG:= false;
POSTGENTYPE:= 0;
HAVENEST:= false;

HEAPSPOFF:= if LEVEL=0 then RLSIZE else 0;	\save heap space for return
HEAPSP:= HEAPSPOFF;
HAVEGENBASE:= false;
HAVESTART:= false;

FPROCTR:= 0;
FPBASE:= LABCTR;

repeat
  loop	begin
	case ATOM of
	  INTSYM: VARDEC(INVAR);
	  ADRSYM: VARDEC(ADDRVAR);
	  CHARYM: VARDEC(ADDRVAR);
	  REALYM: VARDEC(RLVAR);
	  CODSYM: CODDEC;
	  EXTNYM: EXTDEC(false);
	  DEFSYM: CONDEC;
	  EPRSYM, EFUNYM:
		  if LEVEL=0 then EXTDEC(true) else [ERROR(68); SKIPIT]
	other	quit;
	end;

  if not HAVESTART then
	if LEVEL=0 then [GENSTART; HAVESTART:= true];
		\(beware of more than 64K of eprocs)

  \Process lower level procedures...
  case ATOM of
    PUBSYM, PROCYM, FUNSYM, FPRSYM, FFUNYM:
	begin
	P1:= NEWLAB;
	GENJMP(P1);
	end
  other P1:= 0 \null\;

  loop	begin
	case ATOM of
	  PUBSYM:
		[if LEVEL#0 then ERROR(68);
		RATOM;
		case ATOM of PROCYM, FUNSYM: PROCDEC(false, true)
		other ERROR(67)];
	  PROCYM, FUNSYM:
		PROCDEC(true, false);
	  FPRSYM, FFUNYM:
		FPRDEC			\'fproc' cannot precede a 'def'
	other	quit;
	end;

  if P1#0 then CLABEL(P1);

until	ATOM#INTSYM & ATOM#ADRSYM & ATOM#CHARYM & ATOM#REALYM & ATOM#CODSYM &
	ATOM#EXTNYM & ATOM#DEFSYM & ATOM#EPRSYM & ATOM#EFUNYM;


if HEAPSPOFF#0 then OPTPROC:=false;
if OPTPROC then
	begin
	SYMTYP(SSNOX):= if SYMTYP(SSNOX)=INPROC then INOPT else RLOPT;
	LEVEL:=LEVEL-2;	\same level as nesting procedure (tricky!)
	OPTNEWLEVEL(LEVEL);
	end
else	begin		\reserve space for local variables (if not already done)
	if not HAVEGENBASE then GENBASE(LEVEL,HEAPSP)
	else if LEVEL#0 then GENHPI(HEAPSP);	\(split heap)
	end;

OLDCOD:= CODCTR;			\is there code in the Main procedure?
SSTATEMENT(STKLOD);			\(STKLOD will always be zero here)
HASMAIN:= CODCTR # OLDCOD;

if OPTPROC then GENRTS(LEVEL) else GENRET(LEVEL);

if FIXCTR#0 then \some 'quit's not in a 'loop'\ ERROR(60);
if FPROCTR#0 then \unresolved forward references\ ERROR(66);
end;	\PROCEDURE

\------------------------ ROUTINES TO OPEN DOS FILES ---------------------------

proc	DOSOPEN;
int	CPUREG, PSPSEG, DATASEG, T;
char	CMDTAIL;

	func	GETSWT;		\Find, remove and return a switch
	int	P, T;
	begin
	for P:= 1, CMDTAIL(0) do
	    if CMDTAIL(P)=^/ then
		begin
		CMDTAIL(P):= $20;
		if P < CMDTAIL(0) then
			begin
			T:= CMDTAIL(P+1);
			if T>=^a & T<=^z then T:= T-$20; \make uppercase
			CMDTAIL(P+1):= $20;
			return T;
			end;
		end;
	return 0;
	end;	\GETSWT


	proc	PARSE;		\Parse command tail and set I/O handles
	char	EXTIN, EXTOUT;
	int	P, EXTFLG, I;
	begin
	EXTIN:= ".XPL";   EXTOUT:= ".ASM";
	P:= 1;
	EXTFLG:= false;
	loop	begin		\parse command tail for extension
		if CMDTAIL(P) = ^. then
			begin
			EXTFLG:= true;
			quit;
			end;
		if CMDTAIL(P) = ^; then quit;	\ignore semicolon
		if P > CMDTAIL(0) then quit;	\if quit then P points to CR
		P:= P + 1;
		end;

	\Back up over any trailing spaces (caused by switches)
	repeat P:= P - 1 until CMDTAIL(P) # ^ ;
	P:= P + 1;
	if not EXTFLG then			\set up file extensions
		for I:= 0, 3 do CMDTAIL(P+I):= EXTIN(I);
	INHAND:= FOPEN(CMDTAIL+1, 0);

	for I:= 0, 3 do CMDTAIL(P+I):= EXTOUT(I);
	OUTHAND:= FOPEN(CMDTAIL+1, 1);
	end;	\PARSE


begin	\DOSOPEN
CMDTAIL:= RESERVE($80+4);		\get command tail from PSP
CPUREG:= GETREG;
PSPSEG:= CPUREG(11);
DATASEG:= CPUREG(12);
BLIT(PSPSEG, $80, DATASEG, CMDTAIL, $80);

loop	begin				\handle switches
	T:= GETSWT;
	case T of
	  ^A:	[BINDEV:= 0; LSTDEV:= 7];
	  ^B:	SHORTBOOL:= true;	\short-circuit boolean evaluation
	  ^C:	CaseSensitive:= true;
	  ^D:	DEBUG:= true;
	  ^I:	I2LCOMFLAG:= true;
	  ^L:	LSTDEV:= 0;
	  ^W:	WARNFLAG:= true;
	  ^2:	OPTIMIZE:= OPT286;
	  ^3,^4:OPTIMIZE:= OPT386;
	   0:	quit			\no more switches on command line
	other	begin
		TEXT(TV,"UNRECOGNIZED SWITCH: /"); CHOUT(TV, T); CRLF(TV);
		TEXT(0, "Usage: XPLXP [options] source
   /A: Display Assembly code
   /B: Short circuit Boolean evaluations
   /C: Make identifer names Case-sensitive
   /D: Include XPL source in output (Debug)
   /I: Include I2L comments in output
   /L: Display source code Listing
   /W: Display Warning messages
   /2: Align loops on word boundaries
   /4: Align loops on dword boundaries
");
		exit 1;
		end;

	end;
PARSE;					\parse command line and set file handles
FSET(INHAND, ^I);
FSET(OUTHAND, ^O);
end;	\DOSOPEN

\-------------------------------------------------------------------------------

begin	\Main
IDENT:= RESERVE(SIGCHAR);
PROCRETS:= RESERVE(LEVELMAX*INTSIZE);
FIXES:= RESERVE(QUITMAX*INTSIZE);
SYMBOL:= RESERVE(SIGCHAR*SYMAX);	\symbol table
SYMTYP:= RESERVE(SYMAX);
SYMVAL:= RESERVE(SYMAX*INTSIZE);
SYMLEV:= RESERVE(SYMAX);
SYMTAG:= RESERVE(SYMAX);
SYMPTR:= RESERVE(SYMAX*INTSIZE);
BOX:= RESERVE(BOXNUM*INTSIZE);		\hash table
RLTBL:= RLRES(RLMAX);
HEXDIGIT:= "0123456789ABCDEF ";

PSTKTYP:= RESERVE(STKMAX*INTSIZE);	\internal optimizing (pseudo) stack
PSTKLEV:= RESERVE(STKMAX*INTSIZE);
PSTKOFF:= RESERVE(STKMAX*INTSIZE);

OLDHAN:= RESERVE(HANMAX*INTSIZE);	\include arrays

TEXT(TV, "
-- XPL0 32-BIT OPTIMIZING PROTECTED MODE COMPILER, VER 3.3.8 --
                  COPYRIGHT 2010 P.J.R. BOYLE

XPL0 comes with ABSOLUTELY NO WARRANTY.
This is free software. You are welcome and encouraged to redistribute
it under certain conditions. For details see LICENSE.TXT.

");
OPTIMIZE:= OPT88;			\default is to align to byte boundaries
SHORTBOOL:= false;
DEBUG:= false;
I2LCOMFLAG:= false;
CaseSensitive:= false;
WARNFLAG:= false;
BINDEV:= 3; LSTDEV:= 8; SRCDEV:= 3;
DOSOPEN;
OPENO(BINDEV); OPENO(LSTDEV); OPENI(SRCDEV);

LABCTR:= 0; LEVEL:= 0;			\initialize some stuff
for II:= 0, LEVELMAX-1 do PROCRETS(II):= 0;
STKLOD:= 0; NOSYM:= 0; NORLSY:= 0; FIXCTR:= 0;
for II:= 0, BOXNUM do BOX(II):= EMPTYPTR; \zero the symbol table
ERRCTR:= 0;
LASTOP:= -1\NUL\;
HAVESTAT:= false;
PSTKPTR:= 0; HANPTR:= 0;
LOCAL:= 0;
OLDLEV:= -1;
CODCTR:= 0;
OLDCODCTR:= CODCTR;
CONDITIONAL:= true;
STRTERM:= -1;	\default to MSB string termination (nonzero)

TTXT("	PAGE	240,132|");		\minimize useless headers (TASM limit)
GETCH; RATOM;
OPTPROC:= false;			\(for two reasons)
PROCEDURE(0);				\compile main procedure (the program)
CHKUSE(0);
while ATOM=^; do RATOM;
if ATOM#EOF then \more code after end\ [ERROR(61); PROCEDURE(0)];

\If program has code in its main procedure (Main) then make it public
if HASMAIN then TTXT("	PUBLIC	PROGRM|");
GENEND;

CHOUT(BINDEV, EOF);
CLOSE(BINDEV);

CRLF(LSTDEV);
TEXT(LSTDEV, "ERRORS DETECTED: "); INTOUT(LSTDEV, ERRCTR); CRLF(LSTDEV);
CLOSE(LSTDEV);
CRLF(TV);

FCLOSE(OUTHAND);
FCLOSE(INHAND);
return if ERRCTR#0 then 1 else 0;
end;	\Main
