	PAGE

;** MAIN BODY OF INTERPRETER ***

;IMPLEMENTATION NOTE: For speed, the PC is assumed to be the DI register.
;All intrinsic and subroutines must restore DI to its original value.


;I2L ENTRY POINT

I2LENT	PROC	NEAR
	MOV	ENTSTK,SP		;SAVE ENTRY STACK POINTER
	MOV	CS:AXREG,AX		;SAVE ALL REGISTERS
	MOV	CS:BXREG,BX		;FOR PARAMETER PASSING
	MOV	CS:CXREG,CX
	MOV	CS:DXREG,DX
	MOV	CS:DIREG,DI
	MOV	CS:SIREG,SI
	MOV	CS:BPREG,BP
	MOV	CS:CSREG,CS
	MOV	CS:DSREG,DS
	MOV	CS:SSREG,SS
	MOV	CS:ESREG,ES
	PUSHF
	POP	AX
	MOV	CS:PSWREG,AX

	MOV	AX,CS			;FOR SAFETY IF NOT CALLED BY DOS
	MOV	DSGMNT,AX
	MOV	DS,AX
	MOV	ES,AX
	
	POP	DX			;SAVE RETURN ADDRESS
	CLI				;SET THE HARDWARE STACK
	MOV	SS,AX
	MOV	SP,OFFSET STACKHI
	STI
	PUSH	DX			;SET RETURN ADDRESS

	CALL	RESIZE			;SHRINK MEMORY TO 64K
	MOV	HEAPHI,USRTOP		;SET HEAP'S UPPER LIMIT
	MOV	ERRNUM,0		;NO ERRORS YET
	CALL	SETINT			;INITIALIZE INTRINSICS
	MOV	AX,HEAPLO
	MOV	HP,AX			;SET START OF HEAP

;Copy the remainder of the command line (the command tail) into pseudo device 8
	CALL	PSOPNO			;(IN CASE OF RESTART)
	CALL	PSOPNI
	MOV	SI,81H
	CLD
I2L10:	LODSB	ES: BYTE PTR 0		;AL:= ES:[SI++]
	CALL	PSOUT
	CMP	AL,0DH			;CR
	JNE	I2L10

	MOV	DI,PROGLO		;SET PROGRAM COUNTER
	CALL	INTERP			;CALL THE INTERPRETER
	CMP	ERRNUM,0		;AN ERROR?
	JZ	I2LEXT			;SKIP IF NOT
	CALL	ERREXT			;HANDLE EXIT ERRORS
I2LEXT:	CALL	RSTBRK			;REMOVE BREAK HANDLER

	MOV	AH,4CH			;TERMINATE PROCESS
	MOV	BX,HEAPLO		;RETURN LOW BYTE OF GLOBAL ZERO
	MOV	AL,BYTE PTR [BX]	; TO PARENT PROCESS
	INT	21H

I2LENT	ENDP
	PAGE

;ROUTINE TO DISPLAY ERROR MESSAGES UPON EXIT FROM THE PROGRAM

ERREXT:	CALL	I2LERR			;DISPLAY THE I2L ERROR MESSAG
	CALL	DISPPC			;DISPLAY PC VALUE ON EXIT
	RET


;DISPLAY THE APPROPRIATE I2L ERROR MESSAGE

I2LERR:	LEA	SI,EM0			;DISPLAY I2L ERROR MESSAGE
	CALL	TXTLOP			;E.G: "I2L ERROR 5: BAD INTRINSIC"
	MOV	AL,ERRNUM		;DISPLAY THE NUMBER
	MOV	AH,0
	CALL	PUTNMB

	MOV	BH,0
	MOV	BL,ERRNUM		;INDEX TO APPROPRIATE MESSAGE
	SAL	BX,1
	MOV	SI,ERRMSG[BX]-2
	RET


;DISPLAY PROGRAM COUNTER VALUE ON EXIT

DISPPC:	CALL	TXTLOP			;DISPLAY PC VALUE
	LEA	SI,EMADD
	CALL	TXTLOP

	MOV	AX,DI
	SUB	AX,PROGLO
	CALL	WRDOUT
	CALL	CRLF
	RET
	PAGE

;SHRINK PROGRAM TO 64K SO OTHER PROGRAMS CAN BE IN MEMORY

RESIZE:	MOV	AH,4AH		;MODIFY MEMORY ALLOCATION FUNCTION
	MOV	BX,4096		;TO 64K (4096 PARAGRAPHS)
	INT	21H		;CALL DOS FUNCTION
	RET

	PAGE

;ACTUAL INTERPRETER LOOP

INTERP	PROC	NEAR
	MOV	STKPTR,SP	;SAVE STACK POINTER
	MOV	ERRNUM,0	;NO ERRORS
	MOV	TRAPS,0FFFFH	;TRAP ALL ERRORS
	MOV	AX,HP		;PRESET LEVEL 0
	MOV	DISPLY,AX

;NOW WE FAKE A CALL TO THE USER PROGRAM AS A PROCEDURE
;(WHICH IT IS). THE RETURN ADDRESS FOR THIS PROCEDURE IS THE
;FIRST BYTE OF THE PROGRAM WHICH HAS BEEN PRESET TO BE AN
;EXIT OPCODE.

	MOV	BX,0		;PUSH ZERO LEVEL
	PUSH	BX
	PUSH	DISPLY[BX]	;PUSH DISPLAY VECTOR
	PUSH	DI		;SAVE PC
	INC	DI		;ADVANCE PC
	JMP	OPGO		;ENTER DISPATCH TO EXECUTE 1ST OPCODE
	PAGE

;MAGIC INSTRUCTION FOR FAST LOAD OF GLOBAL INTEGER WHICH IS THE
;MOST COMMON I2L INSTRUCTION. ONE-BYTE INSTRUCTION WITH HIGH BIT
;SET. THE OTHER 7 BITS ARE THE OFFSET. THE LEVEL IS ASSUMED TO BE
;0.

GLOB:	SHR	BL,1		;FIX OFFSET
	MOV	SI,DISPLY	;GET 0 LEVEL DISPLAY VECTOR
	PUSH	[BX+SI]		;LOAD AND PUSH VALUE


;MAIN DISPATCH LOOP

;IMPLEMENTATION NOTE: For speed, the PC is assumed to be the DI register.
;All intrinsic and subroutines must restore DI to it's original value.


;RETURN HERE IF BH NOT ZERO

CMLRET:	XOR	BH,BH		;ZERO BH

;RETURN HERE IF BH IS PRESERVED

OPGO:	MOV	BL,[DI]		;GET OPCODE
	INC	DI		;ADVANCE PROGRAM COUNTER
	ADD	BL,BL		;TIMES 2 FOR INDEXING
	JC	GLOB		;HIGH BIT SET IS GLOBAL LOAD
	JMP	OPTAB[BX]	;DISPATCH TO OPCODE


;OPCODE ERROR DETECTED

OPERR:	MOV	AL,4		;I2L ERROR # 4 (ILLEGAL OPCODE)
	CALL	ERROR		;REPORT ERROR, AND IF WE RETURN,
	JMP	CMLRET		; GIVE IT OUR BEST SHOT
INTERP	ENDP

	PAGE

;OPCODE JUMP TABLE
	EVEN
OPTAB	DW	EXITDO		;$00,1, EXIT INTERPRETER
	DW	LODDO		;$01,3, LOAD A VARIABLE
	DW	LDXDO		;$02,3, INDEXED LOAD A BYTE
	DW	STODO		;$03,3, STORE INTO A VARIABLE
	DW	STXDO		;$04,3, INDEXED STORE TO A BYTE
	DW	CALDO		;$05,4, CALL AN I2L PROCEDURE
	DW	RETDO		;$06,1, RETURN FROM I2L PROCEDURE
	DW	JMPDO		;$07,3, JUMP TO I2L CODE
	DW	JPCDO		;$08,3, JUMP IF FALSE
	DW	HPIDO		;$09,2, INCREMENT HEAP PTR BY ARG
	DW	ARGDO		;$0A,2, GET PROC ARGUMENTS
	DW	IMMDO		;$0B,3, IMMEDIATE LOAD OF ARG
	DW	CMLDO		;$0C,2, CALL AN INTRINSIC
	DW	ADDDO		;$0D,1, ADD
	DW	SUBDO		;$0E,1, SUBTRACT
	DW	MULDO		;$0F,1, MULTIPLY
	DW	DIVDO		;$10,1, DIVIDE
	DW	NEGDO		;$11,1, UNARY MINUS
	DW	EQDO		;$12,1, TEST FOR EQUAL
	DW	NEDO		;$13,1, TEST FOR NOT EQUAL
	DW	GEDO		;$14,1, TEST FOR >=
	DW	GTDO		;$15,1, TEST FOR >
	DW	LEDO		;$16,1, TEST FOR <=
	DW	LTDO		;$17,1, TEST FOR <
	DW	FORDO		;$18,3, 'FOR' LOOP CONTROL
	DW	INCDO		;$19,3, INCREMENT AND PUSH
	DW	ORDO		;$1A,1, OR
	DW	ANDDO		;$1B,1, AND
	DW	NOTDO		;$1C,1, 1'S COMPLEMENT
	DW	EORDO		;$1D,1, EOR
	DW	DOUBL		;$1E,1, NOS+TOS*2 (DBA)
	DW	DEFSAV		;$1F,1, INDIRECT SAVE (STD)
	DW	DEFER		;$20,1, INDIRECT GET (DBX)
	DW	ADDRDO		;$21,3, ADDRESS OF VARIABLE
	DW	LDIDO		;$22,1, INDIRECT GET
	DW	LDADO		;$23,3, ABSOLUTE GET
	DW	SIMMDO		;$24,2, SHORT IMMEDIATE
	DW	CAJMP		;$25,3, CASE JUMP
	DW	JSRDO		;$26,3, OPTIMIZED PROC CALL
	DW	RTSDO		;$27,1, OPTIMIZED RETURN
	DW	DRPDO		;$28,1, DROP TOS
	DW	EXTDO		;$29,3, CALL EXTERNAL SUBROUTINE
	PAGE

	DW	FLODDO		;$2A,3, FLOATING LOAD
	DW	FSTODO		;$2B,3, FLOATING STORE
	DW	FIMMDO		;$2C,6, FLOATING LOAD IMMED
	DW	FADDDO		;$2D,1, FLOATING ADDITION
	DW	FSUBDO		;$2E,1, FLOATING SUBTRACT
	DW	FMULDO		;$2F,1, FLOATING MULTIPLY
	DW	FDIVDO		;$30,1, FLOATING DIVIDE
	DW	FNEGDO		;$31,1, FLOATING NEGATE
	DW	FEQDO		;$32,1, TEST FLOATING FOR =
	DW	FNEDO		;$33,1, TEST FLOATING FOR #
	DW	FGEDO		;$34,1, TEST FLOATING FOR >=
	DW	FGTDO		;$35,1, TEST FLOATING FOR >
	DW	FLEDO		;$36,1, TEST FLOATING FOR <=
	DW	FLTDO		;$37,1, TEST FLOATING FOR <
	DW	TRADO		;$38,1, TOS:= 5*TOS +NOS
	DW	TRXDO		;$39,1, PUSH @(5*TOS+NOS)
	DW	TRIDO		;$3A,1, PUSH(5)@(TOS(2)+NOS(5))
	DW	STTDO		;$3B,1, PULL(5) @(NOS(2))
	DW	OPERR		;$3C,1, BAD OPCODE
	DW	ASRDO		;$3D,1, ARITHMETIC SHIFT RIGHT ->>
	DW	LSLDO		;$3E,1, SHIFT LEFT <<
	DW	LSRDO		;$3F,1, SHIFT RIGHT >>
	DW	LDSIDO		;$40,1, LOAD SEGMENT INTEGER
	DW	LDSBDO		;$41,1, LOAD SEGMENT BYTE
	DW	LDSRDO		;$42,1, LOAD SEGMENT REAL
	DW	STSIDO		;$43,1, STORE SEGMENT INTEGER
	DW	STSBDO		;$44,1, STORE SEGMENT BYTE
	DW	STSRDO		;$45,1, STORE SEGMENT REAL
	DW	LSHORT		;$46,1, LOAD SHORT SEGMENT REAL
	DW	SSHORT		;$47,1, STORE SHORT SEGMENT REAL

	DW	MKARRAY		;$48,1, RESERVE MULTIDIMENSIONAL ARRAY
	DW	FORDDO		;$49,3, 'FOR' DOWNTO LOOP CONTROL
	DW	DECDO		;$4A,3, DECREMENT AND PUSH
	DW	OPERR		;$4B,1, BAD OPCODE
	DW	OPERR		;$4C,1, BAD OPCODE
	DW	OPERR		;$4D,1, BAD OPCODE
	DW	PINDO		;$4E,1, INPUT FROM PORT
	DW	POUTDO		;$4F,1, OUTPUT TO PORT

	DW	80H-(($-OPTAB)/2) DUP(OPERR)	;FILL REST OF TABLE WITH ERRORS
