\VMouse.xpl	5-May-2007
\Demo of a mouse pointer for 24-bit VESA graphics
\Compile with 32-bit XPL0 (xpx.bat)
\
\REVISIONS:
\27-Apr-2007: Released
\ 5-May-2007: Eliminate flicker when mouse button is pressed

include	c:\cxpl\codes;		\intrinsic routine declarations
string 0;			\use null-terminated strings

def	VMode=$112,		\graphic video mode
	ScrW=640, ScrH=480;	\screen dimensions (pixels)
def	MW=12, MH=21;		\mouse pointer width and height (pixels)

int	CpuReg,			\address of CPU register array (from GetReg)
	MX, MY,			\mouse coordinates (pixels)
	MX0, MY0,		\old mouse coordinates
	RX0, RY0, RX1, RY1;	\rectangle corners
int	C0, C1, C2, C3;		\corner colors for gradient
int	MouseBg(2+MW*MH);	\sprite: mouse pointer's background image

def	SizeOfInt = 4;		\number of bytes in an integer
def	Black=$000000, BWhite=$FFFFFF;	\24-bit bright white



proc	Exit(Msg);		\Display (error) message and terminate program
char	Msg;
begin
SetVid($03);			\restore normal text mode
Text(0, Msg);
Crlf(0);
exit;
end;	\Exit



func	ExtendWord(N);		\Sign extend 16-bit word to 32-bit double word
int	N;
return if N & $8000 then N ! $FFFF0000 else N & $0000FFFF;



func	CallInt(Int, AX, BX, CX, DX, BP, DS, ES); \Call a software interrupt
int	Int, AX, BX, CX, DX, BP, DS, ES; \(unused arguments need not be passed)
begin
CpuReg(0):= AX;
CpuReg(1):= BX;
CpuReg(2):= CX;
CpuReg(3):= DX;
CpuReg(6):= BP;
CpuReg(9):= DS;
CpuReg(11):= ES;
SoftInt(Int);
return ExtendWord(CpuReg(0));	\return contents of AX register
end;	\CallInt

\=============================== MOUSE ROUTINES ================================

func	OpenMouse;		\Initializes mouse; returns 'false' if it fails
begin				\Pointer is set to center of screen but hidden
CallInt($21, $3533);		\Make sure mouse vector $33 points to something
if ((CpuReg(1) ! CpuReg(11)) & $FFFF) = 0 then return false;
return CallInt($33, $0000);	\reset mouse and return its status
end;	\OpenMouse



func	GetMousePosition(N); \Return position of specified mouse coordinate
int	N;	\0 = X coordinate; 1 = Y coordinate
begin
CallInt($33, $0003);
return (if N then CpuReg(3) else CpuReg(2)) & $FFFF;
end;	\GetMousePosition



func	GetMouseButton(N);	\Return 'true' if specified mouse button is down
int	N;	\button number: 0 = left; 1 = right (or middle)
begin
CallInt($33, $0003);
return if N then (CpuReg(1)&2)=2 else (CpuReg(1)&1)=1;
end;	\GetMouseButton



proc	SetMouseLimits(W, H);	\Set the horizontal and vertical travel limits
int	W, H;
begin
CallInt($33, $0007, 0, 0, W-1);
CallInt($33, $0008, 0, 0, H-1);
end;	\SetMouseLimits

\===============================================================================

proc	DrawSprite(X0, Y0, Sp, Trans);	\Draw a sprite
int	X0, Y0;	\coordinates of upper-left corner
int	Sp;	\address of sprite data
int	Trans;	\flag: make (0) background transparent (instead of opaque)
int	X, Y, C,
	W, H;	\width and height of sprite (pixels)
begin
W:= Sp(0);
H:= Sp(1);
Sp:= Sp + 2*SizeOfInt;
for Y:= Y0, Y0+H-1 do
    for X:= X0, X0+W-1 do
	begin
	C:= Sp(0);			\get pixel's color
	Sp:= Sp + SizeOfInt;
	if C ! ~Trans then Point(X, Y, C);
	end;
end;	\DrawSprite



proc	GetSprite(X0, Y0, W, H, Sp);	\Load sprite data array from Screen
int	X0, Y0,		\coordinates in Screen to get sprite from
	W, H;		\width and height of sprite (pixels)
int	Sp;		\address of array in which to load sprite data
int	X, Y;
begin
Sp(0):= W;
Sp(1):= H;
Sp:= Sp + 2*SizeOfInt;
for Y:= Y0, Y0+H-1 do
    for X:= X0, X0+W-1 do
	begin
	Sp(0):= ReadPix(X, Y);
	Sp:= Sp + SizeOfInt;
	end;
end;	\GetSprite



proc	DrawMousePtr(X, Y);	\Draw mouse pointer at screen coordinates X,Y
int	X, Y;			\the upper-left corner is the tip of the arrow
char	Ptr;
int	I, J;
begin
Ptr:=  ["#           ",
	"##          ",
	"#.#         ",
	"#..#        ",
	"#...#       ",
	"#....#      ",
	"#.....#     ",
	"#......#    ",
	"#.......#   ",
	"#........#  ",
	"#.........# ",
	"#......#####",
	"#...#..#    ",
	"#..##..#    ",
	"#.#  #..#   ",
	"##   #..#   ",
	"#     #..#  ",
	"      #..#  ",
	"       #..# ",
	"       #..# ",
	"        ##  "];

for J:= 0, MH-1 do		\for all the rows...
    for I:= 0, MW-1 do		\for all the pixels in the row...
	case Ptr(J,I) of
	  ^#:	Point(I+X, J+Y, Black);
	  ^.:	Point(I+X, J+Y, BWhite)
	other [];
end;	\DrawMousePtr



proc	ShowMouse(On);			\Turn mouse pointer on or off
int	On;	\flag: true = pointer on; false = pointer off
begin
if On then
	begin
	GetSprite(MX, MY, MW, MH, MouseBg);	\save background image
	MX0:= MX;   MY0:= MY;			\save background's coordinates
	DrawMousePtr(MX, MY);			\draw mouse pointer
	end
else	begin
	DrawSprite(MX, MY, MouseBg, false);	\restore background image
	end;
end;	\ShowMouse

\===============================================================================

proc	DrawGradientRectangle(X, Y, W, H);	\Draw a gradient rectangle
int	X, Y, W, H;	\upper left corner coordinates, width, height (pixels)
int	I, J, C, CX0, CX1;
begin
if W < 0 then [W:= -W;   X:= X-W];	\handle backward arguments
if H < 0 then [H:= -H;   Y:= Y-H];
for J:= Y, Y+H-1 do			\for each scan line...
	begin
	CX0:= (C1-C0)*J/(H*H);		\interpolate (sorta) colors from top to
	CX1:= (C3-C2)*J/(H*H);		\ bottom of rectangle
	for I:= X, X+W-1 do		\for each pixel...
		begin
		C:= (CX1-CX0)*I/(W*W);	\interpolate (sorta) from left to right
		Point(I, J, C);
		end;
	end;
end;	\DrawGradientRectangle



proc	MoveMouse;			\Move mouse pointer and draw rectangles
int	MButton,
	T;			\temporary scratch
begin
MX:= GetMousePosition(0);
MY:= GetMousePosition(1);

if MX#MX0 ! MY#MY0 then
	begin					\mouse moved
	DrawSprite(MX0, MY0, MouseBg, false);	\restore background image
	GetSprite(MX, MY, MW, MH, MouseBg);	\save background at new location
	DrawMousePtr(MX, MY);			\draw pointer at new location
	MX0:= MX;   MY0:= MY;			\record mouse's location
	end;

if GetMouseButton(0) then
	begin
	if ~MButton then
		begin				\mouse button just went down
		MButton:= true;
		RX0:= MX;   RY0:= MY;		\establish corner of rectangle
		C0:= Ran(256)<<16;		\ along with its colors
		C1:= Ran(256)<<8;
		C2:= Ran(256);
		C3:= 0;
		end;

	\Mouse button is still held down
	if MX#RX1 ! MY#RY1 then
		begin				\mouse moved
		RX1:= MX;   RY1:= MY;		\second corner of rectangle
		ShowMouse(false);
		DrawGradientRectangle(RX0, RY0, RX1-RX0, RY1-RY0);
		ShowMouse(true);
		end;
	end
else	MButton:= false;			\mouse button is released
end;	\MoveMouse

\===============================================================================

begin	\Main
CpuReg:= GetReg;
if not OpenMouse then Exit("This program requires a mouse.");

SetVid($12);					\initialize old mouse drivers
SetVid(VMode);					\set the actual graphics mode
SetMouseLimits(ScrW, ScrH);
Move((ScrW-18*8)/2, ScrH/2);
Text($106, "drag me beautiful");
ShowMouse(true);				\display mouse pointer

loop	begin
	MoveMouse;
	if ChkKey then quit;			\exit when any key is pressed
	end;

SetVid(3);					\restore normal text mode
end;	\Main
