\HANOID.XPL	JUL-01-95
\Towers of Hanoi puzzle solver
\
\               <-- Top(1)
\            ܺ                                                 
\           ܺ                                                
\          ܺ                                               
\         ܺ                      <-- Top(2)               <-- Top(3)
\    Center:  1                         2                         3

code	CHOUT=8, INTIN=10, TEXT=12, CURSOR=23, SOUND=39;

def	FF=$0C, SP=$20;
def	DISKCH= ^, NEEDLECH= ^;	\Symbols used to draw disks & needles
def	TVW=80, TVH=25;			\Screen dimensions in characters

int	DISKS,		\Number of disks
	RADIUS;		\Radius of disk (in characters)
char	TOP(4),		\Line number above tower of disks (TOP(0) is not used)
	CENTER(4);	\Column number of each of the three needles



proc	SHOW(CX, CY, CH);	\Draw (or erase) a disk
int	CX, CY, CH;
\Also inputs Radius


	proc	SHOWHALF;	\Show (or clear) half of a disk
	int	I;
	for I:= 1, RADIUS do CHOUT(0, CH);


begin
CURSOR(CENTER(CX)-RADIUS, TOP(CY));
SHOWHALF;
CHOUT(0, NEEDLECH);
SHOWHALF;
end;	\SHOW



proc	MOVETOWER(FROM, TO, USING);
int	FROM, TO, USING;
begin
RADIUS:= RADIUS -1;
if RADIUS >0 then
	begin
	MOVETOWER(FROM, USING, TO);	\Move subtower from FROM to USING
					\Subtower is tower above bottom disk
	TOP(FROM):= TOP(FROM) +1;	\Move bottom disk from FROM to TO
	SHOW(FROM, FROM, SP);		\Erase disk on FROM needle

	SHOW(TO, TO, DISKCH);		\Show disk on TO needle
	TOP(TO):= TOP(TO) -1;

	SOUND(1, 1, RADIUS*500);	\Make clink sound
	SOUND(0, 9, 1);			\Delay

	MOVETOWER(USING, TO, FROM);	\Move subtower from USING to TO
	end;
RADIUS:= RADIUS +1;
end;	\MOVETOWER



begin	\MAIN
CHOUT(0, FF);
loop	begin
	CURSOR(0, 0);   TEXT(0, "How many disks (0-12)? ");
	DISKS:= INTIN(0);
	if DISKS <= 0 then quit;

	CENTER(1):= TVW /6;
	CENTER(2):= 3 *TVW /6;
	CENTER(3):= 5 *TVW /6;

	CHOUT(0, FF);			\Set up the initial display
	for RADIUS:= 1, DISKS do
		begin
		TOP(3):= TVH -1 -DISKS +RADIUS;
		SHOW(1, 3, DISKCH);
		SHOW(2, 3, SP);
		SHOW(3, 3, SP);
		end;
	\RADIUS  =  DISKS +1;
	\TOP(3)  =  TVH -1 -DISKS +DISKS  =  TVH -1
	TOP(1):= TVH -1 -DISKS;		\Needle 1 initially has all the disks
	TOP(2):= TVH -1;		\Needles 2 and 3 are empty

	MOVETOWER(1, 3, 2);		\Move tower from needle 1 to 3 using 2
	end;
end;	\MAIN
