\CHAOS.XPL	JUL-01-95
\The Chaos Game by Shane Davis
\Modified by Loren Blaney

include C:\CXPL\CODESI;

def	WIDTH= 640, HEIGHT= 480;	\Screen dimensions
def	COLOR1=3,	\Color of plotted points
	COLOR2=4;	\Color of triangle
def	AX, BX, CX, DX;	\CPU registers

int	CPUREG,		\Address of array containing copy of CPU registers
	ITER,		\Iteration counter
	ITERX1000,	\Thousands of iterations
	MBUTTON,	\Boolean: A mouse button is pressed
	MOUSEX, MOUSEY,	\Mouse position
	PNT,		\Randomly selected corner point
	POINTS(3,2),	\3 points with 2 coordinates (X & Y)
	XPOS, YPOS;	\Position to plot point



proc	MPOINTER(ON);	\Turn on or off mouse pointer
int	ON;
begin
CPUREG(AX):= if ON then 1 else 2;
SOFTINT($33);		\Call BIOS routine
end;	\MPOINTER



proc	GETMINFO;	\Get mouse information. Outputs: MOUSEX, MOUSEY, MBUTTON
begin
CPUREG(AX):= $03;	\BIOS function to get mouse position and button status
SOFTINT($33);
MOUSEX:= CPUREG(CX);
MOUSEY:= CPUREG(DX);
MBUTTON:= (CPUREG(BX) & $07) # 0;
end;	\GETMINFO



proc	CLEANEXIT;	\Clean up and exit program
begin
SETVID($03);		\Restore video mode back to text
OPENI(0);		\Flush any keystrokes in keyboard buffer
exit;
end;	\CLEANEXIT

\----------------------------------------------------------------------

proc	GET3POINTS;	\Using the mouse, get 3 points to form triangle


	proc	GETP(I);	\Get a point using the mouse
	int	I;		\Index of point to get
	begin
	loop	begin
		GETMINFO;
		if MBUTTON then
			begin
			POINTS(I, 0):= MOUSEX;
			POINTS(I, 1):= MOUSEY;
			quit;
			end;
		if CHKKEY then CLEANEXIT;
		end;

	loop	begin		\Wait for mouse button to be released
		GETMINFO;
		if not MBUTTON then quit;
		if CHKKEY then CLEANEXIT;
		end;
	end;	\GETP


begin	\GET3POINTS
GETP(0);
MPOINTER(false);   POINT(POINTS(0,0), POINTS(0,1), COLOR2);   MPOINTER(true);
\Mouse pointer must be off to keep from interfering with point plotting

GETP(1);
MPOINTER(false);   LINE(POINTS(1,0), POINTS(1,1), COLOR2);   MPOINTER(true);

GETP(2);
MPOINTER(false);
LINE(POINTS(2,0), POINTS(2,1), COLOR2);
LINE(POINTS(0,0), POINTS(0,1), COLOR2);
MPOINTER(true);
end;	\GET3POINTS

\----------------------------------------------------------------------

begin	\MAIN
CPUREG:= GETREG;	\Get address of CPU register array for BIOS calls
XPOS:= RAN(WIDTH);   YPOS:= RAN(HEIGHT); \Randomly select starting point

loop	begin
	SETVID($12);		\Set 640x480x16 VGA mode and clear the screen

	MPOINTER(true);		\Show mouse pointer
				\Set limits for mouse pointer
	CPUREG(AX):= $07;  CPUREG(CX):= 0;  CPUREG(DX):= WIDTH-16;  SOFTINT($33);
	CPUREG(AX):= $08;  CPUREG(CX):= 16; CPUREG(DX):= HEIGHT-16; SOFTINT($33);

	CURSOR(0, 0);
	TEXT(0,
"THE CHAOS GAME          Hit any key to exit          Pick 3 points with mouse");
	GET3POINTS;

	CURSOR(24, 0);   TEXT(0, "Press mouse to stop");
	CURSOR(53, 0);   TEXT(0, "Iterations: 0            ");
	MPOINTER(false);	\Turn off mouse pointer while plotting

	ITER:= 0;   ITERX1000:= 0;
	loop	begin
		if ITER >= 1000 then
			begin
			ITER:= 0;
			ITERX1000:= ITERX1000 +1;
			CURSOR(65, 0);   INTOUT(0, ITERX1000);   TEXT(0, "000");
			end;

		PNT:= RAN(3);			\Randomly select a corner point
		XPOS:= (XPOS +POINTS(PNT,0)) /2;\Move halfway toward it
		YPOS:= (YPOS +POINTS(PNT,1)) /2;
		POINT(XPOS, YPOS, COLOR1);	\Show new location

		ITER:= ITER+1;			\Count it

		GETMINFO;
		if MBUTTON then
			begin			\Wait for button to be released
			repeat GETMINFO until not MBUTTON;
			quit;
			end;

		if CHKKEY then CLEANEXIT;
		end;
	end;
end;	\MAIN
