\Kalitor.XPL	16-Jan-2005	Loren Blaney	loren_blaney@idcomm.com
\Kaleidoscopic Torus in 16 Million Colors. Use arrow keys to adjust window size.

include	c:\cxpl\codes;		\intrinsic code definitions (including Paint)
def	TVW=640, TVH=480;	\screen dimensions (pixels)

int	II,			\scratch index for Main
	Key,			\keyboard character
	WinX, WinY, WinW, WinH,	\displayed window offset and dimensions (pixels)
	ImageOff;		\offset into Image for displayed window
real	Radius0, Radius1,	\major and minor radii of torus
	Mag,			\magnification factor
	Time;			\things vary with time
real	R0, G0, B0,		\3D vectors: initial direction of light sources
	R(3), G(3), B(3);	\3D vectors: current direction of colored lights
int	Image(TVW*TVH);		\screen image buffer

def	Root2 = 0.70711,	\1/sqrt(2)
	Root3 = 0.57735;	\1/sqrt(3)
def	UpArrow=$48, DnArrow=$50, LtArrow=$4B, RtArrow=$4D;	\key scan codes
def	IntSize = 4;		\number of bytes in an integer



proc	WaitVB;			\Wait for vertical blank
begin
while port($3DA) & $08 do;	\wait for vertical blank to go away
repeat until port($3DA) & $08;	\wait for vertical blank
end;	\WaitVB



func real DotProd(V0, V1);	\Dot product of 3D vectors
real	V0, V1;			\ = |V0| * |V1| * Cos(A)
return V0(0)*V1(0) + V0(1)*V1(1) + V0(2)*V1(2);



proc	DrawTorus(Rad0, Rad1);
real	Rad0, Rad1;
def	Brite = 3.0;	\brightness control
int	X, Y,		\coordinates within window (pixels)
	C,		\color to plot
	MR, MG, MB;	\magnitudes of red, green and blue colors
real	D, D1, D2,	\distances
	N(3),		\3D vector normal to surface of torus
	X0, Y0;		\point where line between X,Y and center intersects
			\ circle of radius0
begin
for Y:= -WinH/2, WinH/2-1 do	\for all of the points in the window...
    for X:= -WinW/2, WinW/2-1 do
	begin
	D:= sqrt(float(X*X + Y*Y));	\distance of X,Y from center
	if D >= Rad0-Rad1 then		\not inside hole in center of torus
		begin			\find intersection point at Rad0
		X0:= float(X)*Rad0/D;
		Y0:= float(Y)*Rad0/D;

		\find point on surface of torus
		D1:= D - Rad0;		\distance of X,Y from circle at Rad0
		D2:= Rad1*Rad1 - D1*D1;
		if D2 >= 0.0 then
			begin		\form vector normal to surface
			N(0):= float(X) - X0;
			N(1):= float(Y) - Y0;
			N(2):= -sqrt(D2);	\(-Z is toward viewer)

			\dot product of normal vector with light sources
			MR:= fix(DotProd(N, R) * Brite);
			MG:= fix(DotProd(N, G) * Brite);
			MB:= fix(DotProd(N, B) * Brite);
			\don't clip off negative values; they look great!
			C:= MR<<16 + MG<<8 + MB;
			Image(X+TVW/2 + (Y+TVH/2)*TVW):= C;
			end;
		end;
	end;
end;	\DrawTorus



begin	\Main
SetVid($112);				\640x480x24 graphics
for II:= 0, TVW*TVH-1 do Image(II):= 0;	\erase

Radius0:= 200.0;			\some attractive starting values
Radius1:= 100.0;
Time:= 150.0;
WinW:= TVW/2;				\half-size window

\	X	Y	Z
R0:= [-Root3, +Root3, -Root3];		\initial positions of colored lights
G0:= [+Root2,  0.0,   -Root2];
B0:= [-Root3, -Root3, -Root3];

loop	begin
	for II:= 0, 3-1 do
		begin				\vary light sources over time
		R(II):= R0(II) * Sin(Time+float(II));
		G(II):= G0(II) * Sin(Time+1.0+float(II));
		B(II):= B0(II) * Sin(Time+2.0+float(II));
		end;

	WinH:= 3*WinW/4;			\window height = 3/4 width
	WinX:= (TVW-WinW)/2;			\center window on screen
	WinY:= (TVH-WinH)/2;
	ImageOff:= (WinX + WinY*TVW)*Intsize;	\offset to displayed window

	Mag:= float(WinW) / float(TVW);	\magnification varies with window size
	DrawTorus(Radius0*Mag, Radius1*Mag);
	WaitVB;   WaitVB;		\limit speed to about 30 frames / sec.
	Paint(WinX, WinY, WinW, WinH, Image+ImageOff, TVW);   \display window

	Radius0:= 180.0*Sin(Time) + 180.0;	\vary torus radii over time
	Radius1:= Time + 27.0;
	Time:= Time * 1.001;			\geometrically increment time

	if ChkKey then
		begin
		Key:= Chin(1);
		if Key = 0 then Key:= -Chin(1);	\get scan code
		case Key of
		  -UpArrow, -RtArrow:
			begin
			WinW:= WinW + 32;		\increase window size
			if WinW > TVW then WinW:= TVW;	\up to size of screen
			end;
		  -DnArrow, -LtArrow:
			begin
			WinW:= WinW - 32;		\decrease window size
			if WinW < 160 then WinW:= 160;	\down to a limit
			end
		other	quit;
		end;
	end;
SetVid(3);		\restore normal text mode
end;	\Main
