/*      MISC.C - part of the FreeDAPI
        Copyright 1999 - Enrico Bartky

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include <dapi.h>
#include <conio.h>
#include <graphics.h>
#include <stdio.h>
#include <process.h>
#include <alloc.h>
#include <string.h>

HBUTTON ButtonInvert(HBUTTON button)
{
 if(!button.i)
 {
  HideMouse();
  setcolor(0);
  rectangle(button.x,button.y,button.x1,button.y1);
  rectangle(button.x+1,button.y+1,button.x1-1,button.y1-1);
  setfillstyle(1,7);
  bar(button.x+2,button.y+2,button.x1-2,button.y1-2);
  setcolor(0);
  line(button.x+2,button.y+2,button.x1-2,button.y+2);
  line(button.x+2,button.y+2,button.x+2,button.y1-2);
  setcolor(15);
  line(button.x1-2,button.y+2,button.x1-2,button.y1-2);
  line(button.x+2,button.y1-2,button.x1-2,button.y1-2);
  setcolor(0);
  outtextxy(button.x+4,button.y+4,button.txt);
  button.i=1;
  ShowMouse();
 }
 return button;
}

int ButtonClicked(HBUTTON but)
{
 if(MouseIn(but.x,but.y,but.x1,but.y1))
 {
  while(Mouse.leftdn)
  {
   ReadMouseDown();
   but=ButtonInvert(but);
  }
  HideMouse();
  DrawButton(but);
  but.i=0;
  ShowMouse();
  return 1;
 }
 return 0;
}

void Hide(HWND win)
{
 setfillstyle(1,0);
 HideMouse();
 bar(win->x,win->y,win->x1,win->y1);
 if(win->parent!=NULL)
 {
  win->parent->active=1;
  DrawWindow(win);
 }
 ShowMouse();
}

void OpenGraph()
{
 int gd=DETECT,gm;
 registerbgidriver(EGAVGA_driver);
 initgraph(&gd,&gm,"");
}

void *DAPIcalloc(int h,size_t bytes)
{
 void *rtn;
 rtn=calloc(h,bytes);
 if(rtn==NULL)
 {
  closegraph();
  printf("Not enough memory!\n");
  exit(1);
 }
 return rtn;
}

int DAPI_EMSalloc(unsigned long bytes)
{
 int rtn;
 if(EMSbaseaddress()==0)
 {
  closegraph();
  printf("Unable to find the EMS base address!\n");
  exit(1);
 }
 if ((bytes/16384)+1<EMSpages()&&rtn!=-1)
  rtn=EMSalloc((bytes/EMS_PAGE_SIZE)+1);
 else
  rtn=-1;
 if(rtn==-1)
 {
  closegraph();
  printf("Not enough memory!\n");
  exit(1);
 }
 return rtn;
}

char *CharToStr(char c)
{
 static char temp[1];
 temp[0]=c;
 return temp;
}

HENTER ProcessEnter(HENTER Enter)
{
 char c;
 char buffer[255];
 int i=0;
 while(1)
 {
/*  ReadMouseUp();
  if(Mouse.lefthit)
   if(!(MouseIn(Enter.x,Enter.y,Enter.x1,Enter.y1)))
    break;*/
  if(i==Enter.l)
   break;
  outtextxy(Enter.x+2+(TXTWIDTH*(i))-1,Enter.y+2,CharToStr('_'));
  c=getch();
  setcolor(15);
  outtextxy(Enter.x+2+(TXTWIDTH*(i))-1,Enter.y+2,CharToStr('_'));
  if(c==13)
   break;
  if(i==Enter.l)
   break;
  setcolor(0);
  outtextxy(Enter.x+2+(TXTWIDTH*i),Enter.y+2,CharToStr(c));
  buffer[i]=c;
  i++;
 };
 buffer[i]='\0';
 strcpy(Enter.buffer,buffer);
 return Enter;
}

int EnterClicked(HENTER Enter)
{
 if(MouseIn(Enter.x,Enter.y,Enter.x1,Enter.y1))
  return 1;
 return 0;
}