#include <unistd.h>
#include <limits.h>
#include <string.h>

#define OPT_POSIX   0x01
#define OPT_SHORT   0x02
#define OPT_PHELP   0x04

void writeerr( const char *s )
{
    _write( 2, s, strlen( s ) );
}

int main( int argc, char **argv )
{
    int c, flags = 0, len;

    opterr = 0;

    while( ( c = getopt( argc, argv, "ps" ) ) != -1 ) {
        switch( c ) {
            case 'p':
                flags |= OPT_POSIX;
                break;
            case 's':
                flags |= OPT_SHORT;
                break;
            case '?':
                flags |= OPT_PHELP;
                break;
        }
    }

    c = 0;

    if( flags & OPT_PHELP || argc < 1 ) {
        writeerr( "FreeDOS PATHCHK 1.0 - Check for a valid path name\n" );
        writeerr( "Syntax: PATHCHK <pathname>\n" );
        writeerr( "Options:\n" );
        writeerr( "  -p  Stricter (POSIX) checking\n" );
        writeerr( "  -s  Do not allow long filenames\n" );
        return( 1 );
    }

    len = strlen( argv[ optind ] );

    if( len > PATH_MAX ) c++;
    if( flags & OPT_POSIX && len > _POSIX_PATH_MAX ) c++;
    if( flags & OPT_SHORT && len > 80 ) c++;

    return( c );
}

