#include <io.h>
#include <libgen.h>
#include <dos.h>
#include <string.h>

void writeout( const char *s )
{
    _write( 1, s, strlen( s ) );
}

void writeerr( const char *s )
{
    _write( 2, s, strlen( s ) );
}

int main( int argc, char **argv )
{
    if( argc < 1 || argv[ 1 ][ 0 ] == _getswitch() || argv[ 1 ][ 0 ] == '-' ) {
        writeerr( "FreeDOS DIRNAME 1.0 - Get directory path of a pathname\n" );
        writeerr( "Syntax: DIRNAME <path>\n" );

        return( 1 );
    }

    writeout( dirname( argv[ 1 ] ) );
    writeout( "\n" );

    return( 0 );
}

