#include <unistd.h>
#include <dos.h>
#include <signal.h>
#include <time.h>

static clock_t __targettime = 0;
static void interrupt far ( *__prev4A )() = NULL;;

static unsigned char __targetsecs;
static unsigned char __targetmins;
static unsigned char __targethour;

void __getrtct( void );
#pragma aux __getrtct = \
    "mov ah, 0x02"      \
    "clc"               \
    "int 0x1A"          \
    "mov __targetsecs, dh"\
    "mov __targetmins, cl"\
    "mov __targethour, ch"\
    modify [ax cx dx];

void __setalrm( void );
#pragma aux __setalrm = \
    "mov ah, 0x06"      \
    "mov dh, __targetsecs"\
    "mov cl, __targetmins"\
    "mov dh, __targethour"\
    "int 0x1A"          \
    modify [ax cx dx];

void __clralrm( void );
#pragma aux __clralrm = \
    "mov ah, 0x07"      \
    "int 0x1A"          \
    modify [ax];

static void interrupt __catchalarm( void )
{
    if( clock() >= __targettime ) {
        setvect( 0x4A, __prev4A );
        __prev4A = NULL;
        __clralrm();
        raise( SIGALRM );
        __targettime = 0;
    }

    if( __prev4A != NULL ) __prev4A();
}

unsigned alarm( unsigned seconds )
{
    unsigned char temptime;

    if( __targettime ) return( ( __targettime - clock() ) / 18 );

    __getrtct();

    temptime = ( ( seconds / 60 ) / 60 );
    temptime += ( temptime / 2 );

    __targethour += temptime;
    seconds %= 60;
    temptime = ( seconds / 60 );
    temptime += ( temptime / 2 );
    __targetmins += temptime;
    seconds %= 60;
    temptime = ( seconds + ( seconds / 2 ) );
    __targetsecs += temptime;

    if( __prev4A == NULL ) __prev4A = getvect( 0x4A );
    /* Try not to use floating point :-) */
    __targettime = ( seconds * 18 ) + clock();
    setvect( 0x4A, __catchalarm );
    __setalrm();

    return( 0 );
}

