#include <sys/uio.h>
#include <io.h>
#include <limits.h>
#include <errno.h>

ssize_t writev( int handle, const struct iovec *iov, int iovcnt )
{
    register int retval;
    ssize_t nbytes = 0;

    if( iovcnt < 1 ) {
        errno = EINVAL;
        return( -1 );
    }

    for( ; iovcnt; iov++, iovcnt-- ) {
        retval = write( handle, iov->iov_base, iov->iov_len );
        if( retval == -1 ) return( -1 );

        if( ( long )nbytes + ( long )retval > SSIZE_MAX ) {
            errno = EINVAL;
            return( -1 );
        }
        nbytes += retval;
    }

    return( nbytes );
}
