#include <time.h>
#include <utime.h>
#include <dos.h>
#include <fcntl.h>

int utime( const char *path, const struct utimbuf *times )
{
    struct _date fdate;
    struct _time ftime;
    struct ftime sftd;
    int handle;

    if( ( handle = _open( path, O_RDONLY ) ) == -1 ) return( -1 );

    unixtodos( times->modtime, &fdate, &ftime );
    sftd.ft_tsec = ftime.ti_sec / 2;
    sftd.ft_min = ftime.ti_min;
    sftd.ft_hour = ftime.ti_hour;
    sftd.ft_day = fdate.da_day;
    sftd.ft_month = fdate.da_mon;
    sftd.ft_year = fdate.da_year - 1980;

    if( setftime( handle, &sftd ) == -1 ) {
        close( handle );
        return( -1 );
    }

    close( handle );
    
    return( 0 );
}

