#include <time.h>
#include "internal.h"

void __scalar_to_ymd( long scalar,
                      unsigned *pyr,
                      unsigned *pmo,
                      unsigned *pday )
{
    unsigned n;                /* compute inverse of years_to_days() */

    n = ( unsigned )( ( scalar * 400L ) / 146097L );
    while( __years_to_days( n ) < scalar ) {
        n++;
    }
    for( n = ( unsigned )( ( scalar * 400L ) / 146097L );
         __years_to_days( n ) < scalar; ) n++;
         /* 146097 == years_to_days(400) */
    *pyr = n;
    n = ( unsigned )( scalar - __years_to_days( n-1 ) );
    if( n > 59 ) {                       /* adjust if past February */
        n += 2;
        if( __isleap( *pyr ) ) n -= n > 62 ? 1 : 2;
    }
    *pmo = ( n * 100 + 3007 ) / 3057;  /* inverse of months_to_days() */
    *pday = n - __months_to_days( *pmo );
}

