#include <stdio.h>
#include <process.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

extern unsigned __errorlevel;

int main( int argc, char **argv )
{
    int failure = 0;
    char systemcmd[ _POSIX_ARG_MAX ];

    if( strcmp( argv[ 1 ], "Spawned" ) == 0 ) {
        if( getenv( "TESTVAL" ) == NULL ) {
            printf( "spawnv() - Failure\n" );
            return( 54 );
        }
        printf( "spawnv() - Success\n" );

        return( 55 );
    } else if( strcmp( argv[ 1 ], "Executed" ) == 0 ) {
        if( getenv( "TESTVAL" ) == NULL ) {
            printf( "execv() - Failure\n" );
            return( 43 );
        }
        printf( "execv() - Success\n" );

        return( 44 );
    } else if( strcmp( argv[ 1 ], "Systemed" ) == 0 ) {
        if( getenv( "TESTVAL" ) == NULL ) {
            printf( "system() - Failure\n" );
            return( 1 );
        }
        printf( "system() - Success\n" );

        return( 0 );
    }

    putenv( "TESTVAL=TESTING PROCESS.H" );

    strcpy( systemcmd, argv[ 0 ] );
    strcat( systemcmd, " Systemed" );

    if( system( systemcmd ) != 0 || __errorlevel == 1 ) {
        printf( "system() - Failure\n" );
        failure++;
    }

    if( ( __errorlevel = spawnl( P_WAIT, argv[ 0 ], argv[ 0 ],
                                 "Spawned", NULL ) ) != 55 ) {
        if( __errorlevel != 54 ) printf( "spawnv() - Failure\n" );
        failure++;
    }

    execl( argv[ 0 ], argv[ 0 ], "Executed", NULL );

    printf( "execv() - Failure\n" );
    failure++;

    return( failure );
}

