#include <string.h>
#include <sys/types.h>

size_t _fstrlcat( char far *dst, const char far *src, size_t size )
{
    size_t used, length, copy;

    used = _fstrlen( dst );
    length = _fstrlen( src );
    
    if( size > 0 && used < size - 1 ) {
        copy = ( length >= size - used ) ? size - used - 1 : length;
        _fmemcpy( dst + used, src, copy );
        dst[ used + copy ] = '\0';
    }
    
    return( used + length );
}

