#include <libgen.h>
#include <string.h>
#include <direct.h>
#include <stdlib.h>

void _splitpath( const char *path,
                       char *drive,
                       char *dir,
                       char *name,
                       char *ext )
{
    char *dname = dirname( path );
    char *bname = basename( path );
    char hasname = 0;

    if( dname != NULL && strcmp( dname, "." ) != 0 ) {
        if( dname[ 1 ] == ':' ) {
            if( drive ) strncpy( drive, dname, 2 );

            dname += 2;
        }
        if( *dname ) {
            if( dir ) strcpy( dir, dname );
        }
    }
    if( bname != NULL && strcmp( bname, "." ) != 0 ) {
        char *b = bname;

        hasname = 1;

        while( *b && *b != '.' ) b++;

        if( *b == '.' ) {
            if( ext ) strcpy( ext, b );

            *b = '\0';
        }
        if( *bname ) {
            if( name ) strcpy( name, bname );
        }
    }

    if( hasname ) strcat( dir, "\\" );
}

