#include <string.h>
#include <dos.h>
#include <dir.h>
#include <io.h>

extern char *getenv( const char *name );

char *_searchenv( const char *filename, const char *varname, char *fullpath )
{
    char *envptr = getenv( varname );

    if( access( filename, 0 ) == 0 ) return( strcpy( fullpath, filename ) );

    if( envptr == NULL ) return( ( fullpath = NULL ) );

    while( *envptr ) {
        char *tok = strchr( envptr, ';' );
        int toklen;

        if( *tok ) toklen = tok - envptr;
        else toklen = strlen( envptr );

        memcpy( fullpath, envptr, toklen );
        strcpy( fullpath + toklen, "\\" );
        strcpy( fullpath + toklen + 1, filename );

        if( access( fullpath, 0 ) == 0 ) return( fullpath );
        envptr = tok;
        if( envptr ) envptr++;
    }

    return( ( fullpath = NULL ) );
}

