#include <dir.h>
#include <dos.h>
#include <string.h>
#include <stddef.h>
#include <malloc.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>

int __dogetfn( const char *relpath, char *destpath );
#ifdef __CLIB_LFN__
#pragma aux __dogetfn = \
    "mov ax, 0x7160"    \
    "mov cx, 0x0002"    \
    "int 0x21"          \
    "jnc finish"        \
    "mov ah, 0x60"      \
    "int 0x21"          \
    "finish:"           \
    "sbb ax, ax"        \
    parm [si] [di]      \
    value [ax]          \
    modify [ax cx si di];
#else
#pragma aux __dogetfn = \
    "mov ah, 0x60"      \
    "int 0x21"          \
    "sbb ax, ax"        \
    parm [si] [di]      \
    value [ax]          \
    modify [ax si di];
#endif

char *realpath( const char *relpath, char *pathbuf )
{
    char *buf = pathbuf;
    register int retval;

    if( buf == NULL && ( buf = malloc( PATH_MAX ) ) == NULL ) {
        return( NULL );
    }

    if( readlink( relpath, buf, PATH_MAX ) != -1 ) 
         retval = __dogetfn( __retsfn( buf ), buf );
    else retval = __dogetfn( __retsfn( relpath ), buf );

    if( retval < 0 ) {
        errno = _doserrno = -retval;

        if( pathbuf == NULL ) free( buf );
        buf = NULL;
    } else pathbuf = buf;

    return( buf );
}

