#include <dos.h>

void ( *__userexit[ 32 ] )( void );
int __atexited = 0;

void far interrupt ( *__oldhandlers[ 5 ] ) = {
    NULL, NULL, NULL, NULL, NULL
};
void interrupt far ( *___prev28 )() = NULL;

void __dodexit( unsigned char status );
#pragma aux __dodexit = \
    "mov ah, 0x4C"      \
    "int 0x21"          \
    parm [al];

void __callatexit( void )
{
    int i = 31; /* 32 is the max atexit level */

    if( __atexited ) for( ; i >=0; i-- ) {
        if( __userexit[ i ] != NULL ) ( __userexit[ i ] )();
    }
}

void __cleanup( void )
{
    int i;

    for( i = 0; i < 5; i++ ) {
        if( __oldhandlers[ i ] != NULL ) 
            setvect( ( i == 0 ) ? 0x23 :
                     ( i == 1 ) ? 6 :
                     ( i == 2 ) ? 0 :
                     ( i == 3 ) ? 4 :
                     5, __oldhandlers[ i ] );
    }
    if( ___prev28 != NULL ) setvect( 0x28, ___prev28 );
}

void exit( int status )
{
    __callatexit();
    _exit( status );
}

void _exit( int status )
{
    __cleanup();
    __dodexit( status );
}

