#include <stdlib.h>

void *bsearch( const void *key, const void *base, size_t nmemb, size_t size,
               int( *compar )( const void *m1, const void *m2 ) )
{
    size_t try;
    int res;
    const void *ptr;

    while( nmemb > 0 ) {
        try = nmemb / 2;
        ptr = ( void * )( ( char * )base + try * size );
        res = compar( ptr, key );

        if( res == 0 ) return( ( void * )ptr );
        else if( res < 0 ) {
            nmemb = nmemb - try - 1;
            base = ( const void * )( ( const char * )ptr + size );
        } else nmemb = try;
    }

    return( NULL );
}
