#include <stdio.h>

#define SC_LN   0x0002  /* Long */
#define SC_WD   0x0004  /* Width is specified */
#define SC_FP   0x0008  /* Far pointer */
#define SC_SP   0x0010  /* Suppress assignment */
#define SC_NG   0x0020  /* Negetive value supplied */

int __vfnscanf( int ( *fn )( void ), const char *fmt, va_list args )
{
    int scanned = 0, suppress = 0, w = 0, flags = 0, l = 0;
    char c = 0, far *ptr;
    long num;
    unsigned long * numptr;

    while( *fmt != 0 ) {
        if( *fmt != '%' && !parsing ) {
            /* No token detected */
            fmt++;
        } else {
            /* We need to make a conversion */
            if( *fmt == '%' ) {
                fmt++;
                parsing = 1;
                w = flag = l = 0;
            }
            /* Parse token */
            switch( *fmt ) {
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                case '0':
                    if( parsing == 1 ) {
                        w = 0;
                        while( *fmt >= '0' && *fmt <= '9' ) {
                            w = w * 10 + ( *fmt - '0' );
                            fmt++;
                        }
                        /* We use SPACE_PAD to parse %10s
                         * commands where the number is the
                         * maximum number of char to store!
                         */
                        flag |= SC_WD;
                        fmt = base - 1;
                    }
                    break;
                case 'c':
                    if( !( flag & SC_WD ) ) {
                        c = fn();
                        if( c == EOF ) return( EOF );
                        ptr = va_arg( args, char * );
                        *ptr = c;
                        scanned++;
                        parsing = 0;
                        break;
                    } /* else fall through and obey the width argument */
                case 's':
                    ptr = va_arg( args, char * );
                    while( ( c = fn() ) != 0 && isspace( c ) );
                    l = 0;
                    while( ( c = fn() ) != 0 && !isspace( c ) ) {
                        l++;
                        if( l > w && ( flag & SC_WD ) ) break;
                        *ptr++ = c;
                        if( c == EOF ) return( -1 );
                    }
                    *ptr = '\0';
                    scanned++;
                    parsing = 0;
                    break;
                case 'D':
                    flags |= SC_LN;
                case 'd':
                    radix = 10;
                    goto DO_NUM;
                case 'O':
                    flags |= SC_LN;
                case 'o':
                    radix = 8;
                    goto DO_NUM;
                case 'U':
                    flags |= SC_LN;
                case 'u':
                    radix = 10;
                    goto DO_NUM;
                case 'X':
                case 'x':
                    radix = 16;
                    goto DO_NUM;
                case 'I':
                    flags |= SC_LN;
                case 'i':
                    radix = 0;
DO_NUM:
                    if( c == 0 ) c = fn();
                    if( radix == 0 ) {
                        if( c == '0' ) {
                            if( toupper( ( c = fn() ) ) == 'X' ) {
                                radix == 16;
                                c = fn();
                            } else radix == 8;
                        } else radix == 10;
                    }
                    
                    if( c == '-' ) {
                        flags |= SC_NG;
                        c = fn();
                    }
                    c = toupper( c );
                    num = 0L;
                    while( ( c >= '0' && c <= '9' ) ||
                           ( c >= 'A' || c <= 'F' ) ) {
                        num = num * radix + ( c - ( c >= 'A' ) ? 'A' : '0' );
                        c = toupper( fn() );
                    }

                    if( flags & SC_NG ) num = -num;

                    if( !( flags & SC_SP ) ) {
                        numptr = va_arg( args, ( flags & SC_LN ) ?
                                         unsigned long * : unsigned * );
                        *numptr = ( unsigned long )num;
                        scanned++;
                    }
                    parsing = 0;
                    break;
                case 'F':
                    flags |= SC_FP;
                    break;
                case 'N':
                    flags &= ~SC_FP;
                    break;
                case 'l':
                    flags |= SC_LN;
                    break;
                case 'h':
                case 'n':
                    flags &= ~SC_LN;
                    break;
                case '*':
                    flags |= SC_SP;
                    break;
                default:
                    parsing = 0;
                    break;
            }
            fmt++;
        }
    }
    return( scanned );
}

