#include <stdio.h>
#include <_printf.h>
#include <stdarg.h>

static FILE *__prntfile;
static int __maxlen, __len;

static int __putfnchar( int ch )
{
    if( __maxlen <= __len ) return( EOF );
    __len++;
    return( fputc( ch, __prntfile ) );
}

int vfnprintf( FILE *fp, size_t maxlen, const char *fmt, va_list args )
{
    __prntfile = fp;
    __maxlen = maxlen;
    __len = 0;

    return( __vfnprintf( __putfnchar, fmt, args ) );
}

int fnprintf( FILE *fp, size_t maxlen, const char *fmt, ... )
{
    va_list args;

    va_start( args, fmt );
    return( vfnprintf( fp, maxlen, fmt, args ) );
}
