#include <stdio.h>
#include <malloc.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <io.h>

FILE *freopen( const char * restrict filename, const char * restrict mode,
               FILE * restrict retval )
{
    int tmpmode = __getomode( mode ), i;

    if( retval == NULL ) return( NULL );

    close( retval->fd );

    if( retval->tempfnam ) {
        unlink( retval->tempfnam );
        free( retval->tempfnam );
    }

    if( tmpmode & O_BINARY ) retval->flags &= ~__FTEXT;
    else retval->flags |= __FTEXT;

    if( ( retval->fd = open( filename, tmpmode, S_IREAD | S_IWRITE ) ) == -1 ) {
        free( retval );

        return( NULL );
    }

    retval->tempfnam = NULL;
    retval->flags = retval->unget = 0;

    return( retval );
}

