#include <stdio.h>
#include <malloc.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <io.h>

extern FILE *__openstreams[];

FILE *fopen( const char *filename, const char *mode )
{
    int tmpmode = __getomode( mode ), i;
    FILE *retval = malloc( sizeof( FILE ) );

    if( retval == NULL ) return( NULL );

    if( tmpmode & O_BINARY ) retval->flags &= ~__FTEXT;
    else retval->flags |= __FTEXT;

    if( ( retval->fd = open( filename, tmpmode, S_IREAD | S_IWRITE ) ) == -1 ) {
        free( retval );

        return( NULL );
    }

    retval->tempfnam = NULL;
    retval->flags = retval->unget = 0;

    for( i = 0; __openstreams[ i ]; i++ );
    if( i > HANDLE_MAX ) {
        close( retval->fd );
        free( retval );

        return( NULL );
    }
    __openstreams[ i ] = retval;

    return( retval );
}

