#include <io.h>
#include <fcntl.h>
#include <errno.h>

int setmode( int handle, int amode )
{
    int prevmode = ioctl( handle, 0 );
    int dxarg;

    if( prevmode & _FLAG_DEVICE ) {
        if( amode & O_BINARY ) dxarg |= _FLAG_BINARY;
        else dxarg &= ~_FLAG_BINARY;

        if( ioctl( handle, 1, dxarg ) < 0 ) return( -1 );

        prevmode = ( prevmode & _FLAG_BINARY ) ? O_BINARY : O_TEXT;
    } else if( handle & O_TEXT ) prevmode = O_TEXT;

    return( prevmode == O_TEXT ? O_TEXT : O_BINARY );
}

