#include <io.h>
#include <dos.h>
#include <errno.h>

int __dorenam( const char *source, const char far *dest );
#ifdef __CLIB_LFN__
#pragma aux __dorenam = \
    "mov ax, 0x7156"    \
    "stc"               \
    "int 0x21"          \
    "jnc finish"        \
    "mov ah, 0x56"      \
    "int 0x21"          \
    "finish:"           \
    "jnc end"           \
    "mov errno, ax"     \
    "sbb ax, ax"        \
    "end:"              \
    parm [dx] [es di]   \
    value [ax]          \
    modify [ax dx di];
#else
#pragma aux __dorenam = \
    "mov ah, 0x56"      \
    "int 0x21"          \
    "jnc finish"        \
    "mov errno, ax"     \
    "sbb ax, ax"        \
    "finish:"           \
    parm [dx] [es di]   \
    value [ax]          \
    modify [ax dx di];
#endif

int rename( const char *source, const char *dest )
{
    int retval;

    if( access( dest, F_OK ) == 0 ) {
        errno = EACCES;
        return( -1 );
    }

    if( ( retval = __dorenam( source, dest ) ) < 0 ) return( -1 );

    return( 0 );
}

