#include <fcntl.h>
#include <io.h>
#include <dos.h>
#include <errno.h>
#include <stdarg.h>
#include <sys/stat.h>

unsigned __umask_perm = 0;
int _fmode = O_TEXT;

int open( const char *name, int oflags, ... )
{
    int omode = 0;
    int retval = -1;

    if( !( oflags & ( O_BINARY | O_TEXT ) ) ) omode = _fmode;
    else if( oflags & O_BINARY ) omode = O_BINARY;
    else omode = O_TEXT;

    if( oflags & O_APPEND ) omode |= O_APPEND;
    if( oflags & O_TRUNC ) omode |= O_TRUNC;

    /* These bits are not supported or are supported after initial open */
    oflags &= ~( O_TEXT | O_BINARY | O_APPEND | O_TRUNC | O_NOCTTY );

    if( ( oflags & O_EXCL && oflags & O_CREAT ) ) { 
    /* O_EXCL and O_CREAT fail if file exists */
        if( access( name, F_OK ) == 0 ) {
            errno = EEXIST;
            return( -1 );
        }
        oflags &= ~O_EXCL;
    }

    if( oflags & O_CREAT ) {
        va_list args;
        register int attrs = _A_NORMAL;

        va_start( args, oflags );

        if( !( va_arg( args, int ) & S_IWRITE ) &&
            !( __umask_perm & S_IWRITE ) ) attrs = _A_RDONLY;
        if( access( name, F_OK ) != 0 ) {
            retval = creatnew( name, attrs );

            if( ( oflags & 0xF0 ) ||
                ( oflags & O_RDWR ) ||
                ( oflags & O_RDONLY )) { /* failed shared, or non-wronly bits */
                _close( retval );
                retval = -1;
            }
        }
        oflags &= ~O_CREAT;
    }

    if( retval == -1 ) {
        retval = _open( name, oflags );

        if( retval == -1 ) return( -1 );
    }

    if( omode & O_TRUNC ) {
        if( _write( retval, NULL, 0 ) == -1 ) {
            _close( retval );

            return( -1 );
        }
    }

    if( omode & O_APPEND ) {
        if( lseek( retval, 0L, SEEK_END ) == -1 ) {
            _close( retval );

            return( -1 );
        }
    }

    setmode( retval, ( omode & O_TEXT ) ? O_TEXT : O_BINARY );
    retval |= ( omode & O_TEXT ) ? O_TEXT : O_BINARY;

    return( retval );
}

