#include <io.h>
#include <errno.h>

int eof( int handle )
{
    long curpos = lseek( handle, 0L, SEEK_CUR );

    if( curpos == -1L ) {
        errno = EBADF;
        return( -1 );
    }

    if( lseek( handle, 0L, SEEK_END ) == curpos ) {
        lseek( handle, curpos, SEEK_SET );
        return( 1 );
    }

    lseek( handle, curpos, SEEK_SET );
    return( 0 );
}
