#include <dos.h>
#include <errno.h>
#include <io.h>

int __dogtatr( const char *filename );
#pragma aux __dogtatr = \
    "mov ax, 0x4300"    \
    "int 0x21"          \
    "jnc end"           \
    "mov _doserrno, ax" \
    "mov cx, 0xFFFF"    \
    "end:"              \
    parm [dx]           \
    value [cx]          \
    modify [ax dx cx];

int access( const char *filename, int mode )
{
    register int retval = __dogtatr( __retsfn( filename ) );
    int failure = 0;

    if( retval == 0xFFFF ) {
        errno = ENOENT;

        return( -1 );
    }

    if( mode & W_OK && retval & _A_RDONLY ) failure++;
    if( mode & D_OK && !( retval & _A_SUBDIR ) ) failure++;
    if( mode & E_OK && retval & _A_SUBDIR ) failure++;

    if( failure ) {
        errno = EACCES;

        return( -1 );
    }

    return( 0 );
}

