#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <errno.h>

int __dlcreat( const char *path, int attr );
#pragma aux __dlcreat = \
    "mov ax, 0x716C"    \
    "mov dx, 0x12"      \
    "mov bx, 0x0001"    \
    "stc"               \
    "int 0x21"          \
    "jnc finish"        \
    "sbb ax, ax"        \
    "finish:"           \
    parm [si] [cx]      \
    value [ax]          \
    modify [ax bx cx dx si];

int __docreat( const char *path, int attr );
#pragma aux __docreat = \
    "mov ah, 0x3C"      \
    "int 0x21"          \
    "jnc finish"        \
    "mov errno, ax"     \
    "sbb ax, ax"        \
    "finish:"           \
    parm [dx] [cx]      \
    value [ax]          \
    modify [ax cx dx];

int _creat( const char *path, int attr )
{
#ifndef __CLIB_LFN__
    register int retval = __docreat( path, attr );

    if( retval < 0 ) {
        return( -1 );
    }
#else
    register int oldstderr = dup( 2 );
    register int retval = __dlcreat( path, attr );

    if( retval < 0 ) retval = __docreat( path, attr );
    if( retval < 0 ) {
        _close( oldstderr );
        return( -1 );
    }
#endif
#ifndef __CLIB_LFN__

    return( retval );
#else
    _close( 2 );
    dup2( oldstderr, 2 );
    _close( oldstderr );
    _close( retval );

    return( _open( path, O_WRONLY ) );
#endif
}

