#ifndef __UNISTD_H
#define __UNISTD_H

#include <_defs.h>
#include <limits.h>
#include <sys/types.h>
#include <process.h>
#include <dir.h>
#include <io.h>
#include <sys/locking.h>

struct option {
    char *name;                   /* the name of the long option */
    int has_arg;                  /* one of the above macros */
    int *flag;                    /*
                                   * determines if getopt_long() returns a
                                   * value for a long option; if it is
                                   * non-NULL, 0 is returned as a function
                                   * value and the value of val is stored in
                                   * the area pointed to by flag.  Otherwise,
                                   * val is returned.
                                   */
    int val;                      /*
                                   * determines the value to return if flag is
                                   * NULL.
                                   */
};

extern int      optopt,
                optind,
                opterr;
extern char *   optarg;

extern size_t   confstr( int name, char *buf, int len );
extern char *   crypt( char *pw, char *salt );
extern void     encrypt( char *block, ... );
extern char *   getlogin( void );
extern int      getopt( int argc, char **argv, char *opts );
extern int      getopt_long( int argc, char **argv, char *shortopts,
                             struct option * longopts, int *longind );
extern int      getopt_long_only( int argc, char **argv, char *shortopts,
                                  struct option * longopts, int *longind );
extern char *   getwd( char *wdbuf );
extern int      link( const char *path, const char *path2 );
extern int      pause( void );
extern ssize_t  pread( int fd, void *buf, size_t nbyte, off_t offset );
extern ssize_t  pwrite( int fd, const void *buf, size_t nbyte, off_t offset );
extern ssize_t  readlink( const char * restrict path,
                          char * restrict buf,
                          size_t bufl );
extern ssize_t  __readsinglelink( const char *path, char *buf, size_t bufl );
extern void     setkey( char *key );
extern void     swab( const void *b1, void *b2, ssize_t length );
extern int      symlink( const char *path1, const char *path2 );
extern int      truncate( const char *path, off_t len );
extern char *   ttyname( int fildes );
extern int      ttyname_r( int fildes, char *name, size_t namesize );
extern int      usleep( useconds_t useconds );

#define _POSIX_SPAWN                        200112L
#define _POSIX2_C_DEV                       200112L
#define _POSIX2_CHAR_TERM                   200112L
#define _XOPEN_LEGACY                       1
#define _XOPEN_UNIX                         1

#define _CS_PATH                            1
#define _CS_POSIX_V6_ILP32_OFF32_CFLAGS     0
#define _CS_POSIX_V6_ILP32_OFF32_LDFLAGS    0
#define _CS_POSIX_V6_ILP32_OFF32_LIBS       0
#define _CS_POSIX_V6_ILP32_OFFBIG_CFLAGS    0
#define _CS_POSIX_V6_ILP32_OFFBIG_LDFLAGS   0
#define _CS_POSIX_V6_ILP32_OFFBIG_LIBS      0
#define _CS_POSIX_V6_LP64_OFF64_CFLAGS      0
#define _CS_POSIX_V6_LP64_OFF64_LDFLAGS     0
#define _CS_POSIX_V6_LP64_OFF64_LIBS        0
#define _CS_POSIX_V6_LPBIG_OFFBIG_CFLAGS    0
#define _CS_POSIX_V6_LPBIG_OFFBIG_LDFLAGS   0
#define _CS_POSIX_V6_LPBIG_OFFBIG_LIBS      0
#define _CS_POSIX_V6_WIDTH_RESTRICTED_ENVS  0
#define _CS_XBS5_ILP32_OFF32_CFLAGS         0
#define _CS_XBS5_ILP32_OFF32_LDFLAGS        0
#define _CS_XBS5_ILP32_OFF32_LIBS           0
#define _CS_XBS5_ILP32_OFF32_LINTFLAGS      0
#define _CS_XBS5_ILP32_OFFBIG_CFLAGS        0
#define _CS_XBS5_ILP32_OFFBIG_LDFLAGS       0
#define _CS_XBS5_ILP32_OFFBIG_LIBS          0
#define _CS_XBS5_ILP32_OFFBIG_LINTFLAGS     0
#define _CS_XBS5_LP64_OFF64_CFLAGS          0
#define _CS_XBS5_LP64_OFF64_LDFLAGS         0
#define _CS_XBS5_LP64_OFF64_LIBS            0
#define _CS_XBS5_LP64_OFF64_LINTFLAGS       0
#define _CS_XBS5_LPBIG_OFFBIG_CFLAGS        0
#define _CS_XBS5_LPBIG_OFFBIG_LDFLAGS       0
#define _CS_XBS5_LPBIG_OFFBIG_LIBS          0
#define _CS_XBS5_LPBIG_OFFBIG_LINTFLAGS     0

#define _PC_FILESIZEBITS                    FILESIZEBITS
#define _PC_LINK_MAX                        LINK_MAX
#define _PC_MAX_CANON                       MAX_CANON
#define _PC_MAX_INPUT                       MAX_INPUT
#define _PC_NAME_MAX                        NAME_MAX
#define _PC_PATH_MAX                        PATH_MAX
#define _PC_PIPE_BUF                        PIPE_BUF
#define _PC_SYMLINK_MAX                     SYMLINK_MAX

#define _SC_ARG_MAX                         ARG_MAX
#define _SC_ATEXIT_MAX                      ATEXIT_MAX
#define _SC_BC_BASE_MAX                     BC_BASE_MAX
#define _SC_BC_DIM_MAX                      BC_DIM_MAX
#define _SC_BC_SCALE_MAX                    BC_SCALE_MAX
#define _SC_BC_STRING_MAX                   BC_STRING_MAX
#define _SC_CHILD_MAX                       CHILD_MAX
#define _SC_CLK_TCK                         CLOCKS_PER_SEC
#define _SC_COLL_WEIGHTS_MAX                COLL_WEIGHTS_MAX
#define _SC_EXPR_NEST_MAX                   EXPR_NEST_MAX
#define _SC_HOST_NAME_MAX                   HOST_NAME_MAX
#define _SC_IOV_MAX                         IOV_MAX
#define _SC_LINE_MAX                        LINE_MAX
#define _SC_LOGIN_NAME_MAX                  LOGIN_NAME_MAX
#define _SC_NGROUPS_MAX                     NGROUPS_MAX
#define _SC_GETGR_R_SIZE_MAX                128
#define _SC_GETPW_R_SIZE_MAX                128
#define _SC_OPEN_MAX                        OPEN_MAX
#define _SC_PAGE_SIZE                       PAGE_SIZE
#define _SC_PAGESIZE                        PAGESIZE
#define _SC_RE_DUP_MAX                      RE_DUP_MAX
#define _SC_STREAM_MAX                      STREAM_MAX
#define _SC_SYMLOOP_MAX                     SYMLOOP_MAX
#define _SC_TTY_NAME_MAX                    TTY_NAME_MAX
#define _SC_TZNAME_MAX                      TZNAME_MAX

#define fpathconf( x, y )                   ( ( long )( y ) )
#define ftruncate( x, y )                   ( chsize( x, y ) )
#define getegid( )                          ( 0 )
#define geteuid( )                          ( 0 )
#define getgid( )                           ( 0 )
#define getuid( )                           ( 0 )
#define nice( x )                           ( x )
#define setegid( x )                        ( 0 )
#define seteuid( x )                        ( 0 )
#define setgid( x )                         ( 0 )
#define setregid( x, y )                    ( 0 )
#define setreuid( x, y )                    ( 0 )
#define setuid( x )                         ( 0 )
#define sysconf( x )                        ( ( long )( x ) )

#endif

