#ifndef __TIME_H
#define __TIME_H

#include <sys/types.h>

struct tm {
    int tm_sec,                     /* Seconds */
        tm_min,                     /* Minutes */
        tm_hour,                    /* Hour */
        tm_mday,                    /* Day of month */
        tm_mon,                     /* Month */
        tm_year,                    /* Year */
        tm_wday,                    /* Day of week */
        tm_yday,                    /* Day of year */
        tm_isdst;                   /* Daylight-savings flag */
};

struct timespec {
    time_t  tv_sec;                 /* Seconds */
    long    tv_nsec;                /* Nanoseconds */
};

struct itimerspec {
    struct timespec it_interval,    /* Timer period */
                    it_value;       /* Timer expiration */
};

extern char *       tzname[2];
extern long         timezone;
extern int          daylight;

extern char *       asctime( const struct tm *timeptr );
extern clock_t      clock( void );
extern char *       ctime( const time_t *timer );
extern double       difftime( time_t time1, time_t time0 );
extern struct tm *  gmtime( const time_t *timer );
extern struct tm *  localtime( const time_t *timer );
extern struct tm *  localtime_r( const time_t *timer, struct tm *__tms );
extern time_t       mktime( struct tm *timeptr );
extern int          stime( time_t *timer );
extern char *       _strdate( char *buf );
extern size_t       strftime( char *s, size_t maxs, const char *f,
                              const struct tm *t );
extern char *       _strtime( char *buf );
extern time_t       time( time_t *timer );

#define CLOCK_PROCESS_CPUTIME_ID    0
#define CLOCK_THREAD_CPUTIME_ID     0
#define CLOCKS_PER_SEC              18.2
#define CLK_TCK                     18.2
#define CLOCK_REALTIME              0
#define TIMER_ABSTIME               0x01
#define CLOCK_MONOTONIC             0
#define difftime( x, y )            ( ( double )x - ( double )y )
#define tzset()

#endif

