#ifndef __SYS_STAT_H
#define __SYS_STAT_H

#include <_defs.h>
#include <sys/types.h>

struct stat {
    dev_t       st_dev;     /* Device ID of device containing the file */
    ino_t       st_ino;     /* Serial Number */
    mode_t      st_mode;    /* Mode of the file */
    nlink_t     st_nlink;   /* Number of hard links to the file */
    uid_t       st_uid;     /* User ID of the file */
    gid_t       st_gid;     /* Group ID of the file */
    dev_t       st_rdev;    /* If character or block device, dev ID of file */
    off_t       st_size;    /* Size of the file */
    time_t      st_atime;   /* Last access time */
    time_t      st_mtime;   /* Last modification time */
    time_t      st_ctime;   /* Creation time */
    blksize_t   st_blksize; /* File-system-preferred I/O block size */
    blkcnt_t    st_blocks;  /* Number of blocks allocated for object */
    mode_t      st_attr;    /* DOS attributes of the file */
};

int     chmod( const char *path, mode_t mode );
int     fstat( int fildes, struct stat *buf );
int     lstat( const char * restrict filename, struct stat * restrict buf );
int     mkdir( const char *path, ... );
int     stat( const char * restrict filename, struct stat * restrict buf );
mode_t  umask( mode_t cmask );

#define fchmod              ( -1 )
#define mkfifo              ( -1 )
#define mknod               ( -1 )

#define S_IFREG             0x0000
#define S_IFDIR             0x0010
#define S_IFBLK             0x0100
#define S_IFCHR             0x0200
#define S_IFIFO             0x0400
#define S_IFLNK             0x0800
#define S_IFSOCK            0x1000
#define S_IFMT              ( S_IFREG | S_IFDIR | S_IFBLK | \
                              S_IFCHR | S_IFIFO | S_IFLNK | S_IFSOCK )

#define S_IREAD             0x0001
#define S_IWRITE            0x0002
#define S_IEXEC             0x0004

#define S_IRWXU             ( S_IREAD | S_IWRITE | S_IEXEC )
#define S_IRUSR             S_IREAD
#define S_IWUSR             S_IWRITE
#define S_IXUSR             S_IEXEC

#define S_IRWXG             ( S_IREAD | S_IWRITE | S_IEXEC )
#define S_IRGRP             S_IREAD
#define S_IWGRP             S_IWRITE
#define S_IXGRP             S_IEXEC

#define S_IRWXO             ( S_IREAD | S_IWRITE | S_IEXEC )
#define S_IROTH             S_IREAD
#define S_IWOTH             S_IWRITE
#define S_IXOTH             S_IEXEC

#define S_ISUID             0x8000
#define S_ISGID             0x8000
#define S_ISVTX             0x8000

#define S_ISBLK( m )        ( m & S_IFBLK )
#define S_ISCHR( m )        ( m & S_IFCHR )
#define S_ISDIR( m )        ( m & S_IFDIR )
#define S_ISFIFO( m )       ( m & S_IFIFO )
#define S_ISLNK( m )        ( m & S_IFLNK )
#define S_ISSOCK( m )       ( m & S_IFSOCK )

#define S_TYPEISMQ( buf )   ( 0 )
#define S_TYPEISSEM( buf )  ( 0 )
#define S_TYPEISSHM( buf )  ( 0 )
#define S_TYPEISTMO( buf )  ( 0 )

#endif

