#ifndef __IO_H
#define __IO_H

#include <sys/types.h>
#include <_defs.h>

#ifdef __WATCOMC__
#pragma pack( __push, 1 )
#endif

struct ftime {
    unsigned ft_tsec  : 5;  /* Two seconds */
    unsigned ft_min   : 6;  /* Minutes */
    unsigned ft_hour  : 5;  /* Hours */
    unsigned ft_day   : 5;  /* Days */
    unsigned ft_month : 4;  /* Months */
    unsigned ft_year  : 7;  /* Year - 1980 */
};

#ifdef __WATCOMC__
#pragma pack( __pop )
#endif

extern unsigned __umask_perm;

extern int      access( const char *filename, int mode );
extern int      chmod( const char *filename, mode_t access );
extern int      _chmod( const char *filename, int func, ... );
extern int      chsize( int handle, long newlen );
extern int      close( int handle );
extern int      _close( int handle );
extern int      creat( const char *filename, int access );
extern int      _creat( const char *path, int attr );
extern int      creatnew( const char *path, int attr );
extern int      creattemp( char *pathbuf, int attrib );
extern int      dup( int handle );
extern int      dup2( int handle, int handle2 );
extern int      eof( int handle );
extern long     filelength( int handle );
extern int __cdecl getftime( int handle, void *ptr );
extern int      ioctl( int handle, int func, ... );
extern int      isatty( int handle );
extern int      lock( int handle, long offset, long length );
extern int      locking( int handle, int cmd, long length );
extern off_t    lseek( int handle, long offset, int fromwhere );
extern int      mkstemp( char *template );
extern char *   mktemp( char *temp );
extern int      open( const char *name, int oflags, ... );
extern int      _open( const char *path, int flags );
extern ssize_t  read( int handle, void *buf, unsigned len );
extern int      _read( int handle, void *buf, unsigned len );
extern int      remove( const char *filename );
extern int      rename( const char *source, const char *dest );
extern int      setftime( int handle, void *ptr );
extern int      setmode( int handle, int amode );
extern int      sopen( const char *name, int mode, int shflag, ... );
extern long     tell( int handle );
extern mode_t   umask( mode_t newmode );
extern int      unlink( const char *filename );
extern int      unlock( int handle, long offset, long length );
extern ssize_t  write( int handle, const void *buf, unsigned len );
extern int      _write( int handle, const void *buf, unsigned len );

#define __oshandle( x ) ( x & 0xFF )

/* IOCTL cmd 0 bits */
#define _FLAG_STDINP    0x0001  /* Handle refers to STDIN */
#define _FLAG_STDOUT    0x0002  /* Handle refers to STDOUT */
#define _FLAG_NULLDV    0x0004  /* Handle refers to NULL */
#define _FLAG_CLOCKD    0x0008  /* Handle refers to CLOCK */
#define _FLAG_INT029    0x0010  /* Device uses INT 29 */
#define _FLAG_BINARY    0x0020  /* Handle is in binary mode */
#define _FLAG_ALWEOF    0x0040  /* (Device) Always EOF on input */
#define _FLAG_FILEWR    0x0040  /* (File) File has not been written to */
#define _FLAG_DEVICE    0x0080  /* Handle refers to a device */
#define _FLAG_SBKEYB    0x0100  /* (Device) Flag set by KEYB */
#define _FLAG_INT024    0x0100  /* (File) Int 24 generated when no free space */
#define _FLAG_OPNCLS    0x0800  /* (Device) Supports OPEN/CLOSE calls */
#define _FLAG_NOREMV    0x0800  /* (File) Media is not removable */
#define _FLAG_CLOEXC    0x1000  /* Handle is not inherited by children */
#define _FLAG_OUTBUS    0x2000  /* Output until busy supported */
#define _FLAG_IOCTLS    0x4000  /* (Device) Supports IOCTL calls */
#define _FLAG_NOUFTM    0x4000  /* (File) Don't update time/date on close */
#define _FLAG_REMOTE    0x8000  /* File is remote */

#define F_OK            0x00    /* File/Directory exists */
#define X_OK            0x01    /* File/Directory is executable (always) */
#define W_OK            0x02    /* File/Directory is writeable */
#define R_OK            0x04    /* File/Directory is readable (always) */
#define D_OK            0x08    /* Directory (not File) exists */
#define E_OK            0x10    /* File (not Directory) exists */

#define HANDLE_MAX      20      /* Max number of open files */

#define SEEK_SET        0       /* From the beginning */
#define SEEK_CUR        1       /* From the current position */
#define SEEK_END        2       /* From the end */

#endif

