#ifndef __INTTYPES_H
#define __INTTYPES_H

#include <_defs.h>
#include <stdint.h>

#ifdef __HAVE_LONG_LONG__
typedef lldiv_t imaxdiv_t;
#endif

extern long long    llabs( long long num );
#define imaxabs( num )          llabs( num )
#ifdef __HAVE_LONG_LONG__
extern lldiv_t      lldiv( long long num, long long denom );
#define imaxdiv( num, denom )   lldiv( num, denom )
#endif
extern int64_t      strtoll( const char * restrict nptr, char ** restrict eptr,
                        int base );
#define strtoimax( x, y, z )    strtoll( x, y, z )
extern uint64_t     strtoull( const char * restrict nptr, char ** restrict eptr,
                        int base );
#define strtoumax( x, y, z )    strtoull( x, y, z )

#define PRId8   "hhd"
#define PRId16  "hd"
#define PRId32  "ld"
#define PRId64  "lld"
#define PRIi8   "hhi"
#define PRIi16  "hi"
#define PRIi32  "li"
#define PRIi64  "lli"
#define PRIo8   "hho"
#define PRIo16  "ho"
#define PRIo32  "lo"
#define PRIo64  "llo"
#define PRIu8   "hhu"
#define PRIu16  "hu"
#define PRIu32  "lu"
#define PRIu64  "llu"
#define PRIx8   "hhx"
#define PRIx16  "hx"
#define PRIx32  "lx"
#define PRIx64  "llx"
#define PRIX8   "hhX"
#define PRIX16  "hX"
#define PRIX32  "lX"
#define PRIX64  "llX"
#define SCNd8   "hhd"
#define SCNd16  "hd"
#define SCNd32  "ld"
#define SCNd64  "lld"
#define SCNi8   "hhi"
#define SCNi16  "hi"
#define SCNi32  "li"
#define SCNi64  "lli"
#define SCNo8   "hho"
#define SCNo16  "ho"
#define SCNo32  "lo"
#define SCNo64  "llo"
#define SCNu8   "hhu"
#define SCNu16  "hu"
#define SCNu32  "lu"
#define SCNu64  "llu"
#define SCNx8   "hhx"
#define SCNx16  "hx"
#define SCNx32  "lx"
#define SCNx64  "llx"
#define SCNX8   "hhX"
#define SCNX16  "hX"
#define SCNX32  "lX"
#define SCNX64  "llX"
#define PRIdLEAST8   "hhd"
#define PRIdLEAST16  "hd"
#define PRIdLEAST32  "ld"
#define PRIdLEAST64  "lld"
#define PRIiLEAST8   "hhi"
#define PRIiLEAST16  "hi"
#define PRIiLEAST32  "li"
#define PRIiLEAST64  "lli"
#define PRIoLEAST8   "hho"
#define PRIoLEAST16  "ho"
#define PRIoLEAST32  "lo"
#define PRIoLEAST64  "llo"
#define PRIuLEAST8   "hhu"
#define PRIuLEAST16  "hu"
#define PRIuLEAST32  "lu"
#define PRIuLEAST64  "llu"
#define PRIxLEAST8   "hhx"
#define PRIxLEAST16  "hx"
#define PRIxLEAST32  "lx"
#define PRIxLEAST64  "llx"
#define PRIXLEAST8   "hhX"
#define PRIXLEAST16  "hX"
#define PRIXLEAST32  "lX"
#define PRIXLEAST64  "llX"
#define SCNdLEAST8   "hhd"
#define SCNdLEAST16  "hd"
#define SCNdLEAST32  "ld"
#define SCNdLEAST64  "lld"
#define SCNiLEAST8   "hhi"
#define SCNiLEAST16  "hi"
#define SCNiLEAST32  "li"
#define SCNiLEAST64  "lli"
#define SCNoLEAST8   "hho"
#define SCNoLEAST16  "ho"
#define SCNoLEAST32  "lo"
#define SCNoLEAST64  "llo"
#define SCNuLEAST8   "hhu"
#define SCNuLEAST16  "hu"
#define SCNuLEAST32  "lu"
#define SCNuLEAST64  "llu"
#define SCNxLEAST8   "hhx"
#define SCNxLEAST16  "hx"
#define SCNxLEAST32  "lx"
#define SCNxLEAST64  "llx"
#define SCNXLEAST8   "hhX"
#define SCNXLEAST16  "hX"
#define SCNXLEAST32  "lX"
#define SCNXLEAST64  "llX"
#define PRIdFAST8   "d"
#define PRIdFAST16  "d"
#define PRIdFAST32  "ld"
#define PRIdFAST64  "lld"
#define PRIiFAST8   "i"
#define PRIiFAST16  "i"
#define PRIiFAST32  "li"
#define PRIiFAST64  "lli"
#define PRIoFAST8   "o"
#define PRIoFAST16  "o"
#define PRIoFAST32  "lo"
#define PRIoFAST64  "llo"
#define PRIuFAST8   "u"
#define PRIuFAST16  "u"
#define PRIuFAST32  "lu"
#define PRIuFAST64  "llu"
#define PRIxFAST8   "x"
#define PRIxFAST16  "x"
#define PRIxFAST32  "lx"
#define PRIxFAST64  "llx"
#define PRIXFAST8   "X"
#define PRIXFAST16  "X"
#define PRIXFAST32  "lX"
#define PRIXFAST64  "llX"
#define SCNdFAST8   "d"
#define SCNdFAST16  "d"
#define SCNdFAST32  "ld"
#define SCNdFAST64  "lld"
#define SCNiFAST8   "i"
#define SCNiFAST16  "i"
#define SCNiFAST32  "li"
#define SCNiFAST64  "lli"
#define SCNoFAST8   "o"
#define SCNoFAST16  "o"
#define SCNoFAST32  "lo"
#define SCNoFAST64  "llo"
#define SCNuFAST8   "u"
#define SCNuFAST16  "u"
#define SCNuFAST32  "lu"
#define SCNuFAST64  "llu"
#define SCNxFAST8   "x"
#define SCNxFAST16  "x"
#define SCNxFAST32  "lx"
#define SCNxFAST64  "llx"
#define SCNXFAST8   "X"
#define SCNXFAST16  "X"
#define SCNXFAST32  "lX"
#define SCNXFAST64  "llX"
#define PRIdMAX     "lld"
#define PRIiMAX     "lli"
#define PRIoMAX     "llo"
#define PRIuMAX     "llu"
#define PRIxMAX     "llx"
#define PRIXMAX     "llX"
#define SCNdMAX     "lld"
#define SCNiMAX     "lli"
#define SCNoMAX     "llo"
#define SCNuMAX     "llu"
#define SCNxMAX     "llx"
#define SCNXMAX     "llX"
#define PRIdPTR     "d"
#define PRIiPTR     "i"
#define PRIoPTR     "o"
#define PRIuPTR     "u"
#define PRIxPTR     "x"
#define PRIXPTR     "X"
#define SCNdPTR     "d"
#define SCNiPTR     "i"
#define SCNoPTR     "o"
#define SCNuPTR     "u"
#define SCNxPTR     "x"
#define SCNXPTR     "X"

#endif

