#ifndef __DIRECT_H
#define __DIRECT_H

#include <_defs.h>
#include <dos.h> /* struct ffblk */
#include <sys/types.h> /* ino_t */
#include <errno.h>

#ifndef _MAX_PATH
#ifndef __CLIB_LFN__
#define _MAX_DIR            67
#define _MAX_FNAME          9
#ifndef _MAX_NAME
#define _MAX_NAME           13
#endif
#define _MAX_EXT            5
#define _MAX_PATH           80
#define _MAX_DRIVE          3
#else
#define _MAX_DIR            256
#define _MAX_FNAME          256
#ifndef _MAX_NAME
#define _MAX_NAME           256
#endif
#define _MAX_EXT            256
#define _MAX_PATH           260
#define _MAX_DRIVE          3
#define _SHORT_MAX_DIR      67
#define _SHORT_MAX_FNAME    9
#define _SHORT_MAX_NAME     13
#define _SHORT_MAX_EXT      5
#define _SHORT_MAX_PATH     80
#define _SHORT_MAX_DRIVE    3
#endif
#define MAXDIR      _MAX_DIR
#define MAXFILE     _MAX_FNAME
#define MAXEXT      _MAX_EXT
#define MAXPATH     _MAX_PATH
#define MAXDRIVE    _MAX_DRIVE
#endif

#ifdef __WATCOMC__
#pragma pack( __push, 1 )
#endif

struct dirent {
    unsigned short     d_ctime;         /* creation time */
    unsigned short     d_cdate;         /* creation date */
    unsigned short     d_atime;         /* last access time */
    unsigned short     d_adate;         /* last access date */
    char               d_dta[ 13 ];     /* reserved for DOS */
    char               d_attr;          /* file's attribute */
    unsigned short     d_time;          /* file's time */
    unsigned short     d_date;          /* file's date */
    long               d_size;          /* file's size */
    char               d_name[ 260 ];   /* file's name */
    ino_t              d_ino;           /* lfn handle */
    char               d_first;         /* flag for 1st time */
    ssize_t            d_loc;           /* Location in directory */
    size_t             d_namlen;        /* Length of d_name */
    size_t             d_reclen;        /* Length of the record */
    char               d_fnamused[ 260 ];/* path specified to opendir */
};
typedef struct dirent  DIR;

struct FTW {
    int base, level;
};

#ifdef __WATCOMC__
#pragma pack( __pop )
#endif

extern int  alphasort( const struct dirent *d1, const struct dirent *d2 );
extern int  chdir( const char *path );
extern int  _chdrive( int disk );
extern int  closedir( DIR *dirp );
extern int  findfirst( const char *filename, void *strptr, int attrib );
extern int  findnext( void *strptr );
#ifdef __CLIB_LFN__
extern int  findclose( void *strptr );
#else
#define     findclose( x ) ( 0 )
#endif
extern void fnmerge( char *p, const char *d, const char *di,
                              const char *n, const char *e );
extern int  fnsplit( const char *p, char *d, char *di, char *n, char *e );
extern int  ftw( char *directory,
                 int( *funcptr )( const char *name,
                                  const struct stat *ptr,
                                  int flag ),
                 int depth );
extern int  getcurdir( int drive, char *pathbuf );
extern char*_getdcwd( int drive, char *pathbuf, size_t length );
extern char*getcwd( char *pathbuf, size_t length );
extern int  getdisk( void );
extern int  _getdrive( void );
extern int  mkdir( const char *path, ... );
extern char*mktemp( char *template );
extern int  nftw( char *directory,
                  int( *funcptr )( const char *name,
                                   const struct stat *ptr, int flag,
                                   struct FTW *dinfo ),
                  int depth, int flags );
extern DIR  *opendir( const char *name );
extern DIR  *readdir( DIR *dirp );
extern int   readdir_r( DIR * restrict dirp,
                        struct dirent * restrict entry,
                        struct dirent ** restrict result );
extern void rewinddir( DIR *dirp );
extern int  rmdir( const char *path );
extern int  scandir( char *name, struct dirent ***list,
                     int ( *selector )( const struct dirent *dent ),
                     int ( *sorter )( const void *m1, const void *m2 ) );
extern char*searchpath( const char *filename );
extern void seekdir( DIR *dirp, long loc );
extern int  setdisk( int disk );
extern long telldir( DIR *dirp );

#define WILDCARDS               0x01
#define FILENAME                0x02
#define DIRECTORY               0x04
#define EXTENSION               0x08
#define DRIVE                   0x10

#define dirfd( x )              ( -1 )
#define telldir( dp )           ( ( long )dp->d_loc )

#define FTW_F                   0
#define FTW_D                   1
#define FTW_DNR                 2
#define FTW_DP                  3
#define FTW_NS                  4
#define FTW_SL                  5
#define FTW_SLN                 6
#define FTW_PHYS                0x01
#define FTW_MOUNT               0x02
#define FTW_DEPTH               0x04
#define FTW_CHDIR               0x08

#endif

