#ifndef __CTYPE_H
#define __CTYPE_H

#include <_defs.h>

int isalnum( int ch );
int isalpha( int ch );
int isascii( int ch );
int isblank( int ch );
int iscntrl( int ch );
int isdigit( int ch );
int isgraph( int ch );
int islower( int ch );
int isprint( int ch );
int ispunct( int ch );
int isspace( int ch );
int isupper( int ch );
int isxdigit( int ch );
int tolower( int ch );
int toupper( int ch );

#define isalnum( ch )   ( ( ( ch >= 'a' && ch <= 'z' ) ||\
                        ( ch >= 'A' && ch <= 'Z' ) ||\
                        ( ch >= '0' && ch <= '9' ) ) )
#define isalpha( ch )   ( ( ( ch >= 'a' && ch <= 'z' ) ||\
                        ( ch >= 'A' && ch <= 'Z' ) ) )
#define isascii( ch )   ( ( ch >= 0 && ch <= 127 ) )
#define isblank( ch )   ( ( ch == ' ' || ch == '\t' ) )
#define iscntrl( ch )   ( ( ch >= 0 && ch <= 0x1F ) || ch == 0x7F )
#define isdigit( ch )   ( ( ch >= '0' && ch <= '9' ) )
#define isgraph( ch )   ( ( ch >= 0x20 && ch <= 0x7E && ch != ' ' ) )
#define islower( ch )   ( ( ch >= 'a' && ch <= 'z' ) )
#define isprint( ch )   ( ( ch >= 0x20 && ch <= 0x7E ) )
#define ispunct( ch )   ( ( ch >= 0x21 && ch <= 0x2F ) ||\
                          ( ch >= 0x3A && ch <= 0x40 ) ||\
                          ( ch >= 0x5B && ch <= 0x60 ) ||\
                          ( ch >= 0x7B && ch <= 0x7E ) )
#define isspace( ch )   ( ( ch >= 0x09 && ch <= 0x0D ) || ch == 0x20 )
#define isupper( ch )   ( ( ch >= 'A' && ch <= 'Z' ) )
#define isxdigit( ch )  ( ( ( ch >= 'a' && ch <= 'f' ) ||\
                        ( ch >= 'A' && ch <= 'F' ) ||\
                        ( ch >= '0' && ch <= '9' ) ) )
#define toascii( ch )   ( ch & 0177 )
#define _tolower( ch )  ( ( ch - 'A' ) + 'a' )
#define _toupper( ch )  ( ( ch - 'a' ) + 'A' )

#endif

