#include <fcntl.h>
#include <io.h>
#include <stdarg.h>
#include <unistd.h>

int fcntl( int fildes, int cmd, ... )
{
    va_list args;

    va_start( args, cmd );
    if( cmd == F_DUPFD ) return( dup( fildes ) );
    if( cmd == F_GETFD || cmd == F_SETFD ) return( 0 ); /* No flags supported */
    if( cmd == F_GETOWN || cmd == F_SETOWN || cmd == F_GETFL || cmd == F_SETFL )
        return( -1 );
    if( cmd == F_SETLK || cmd == F_GETLK || cmd == F_SETLKW ) {
        struct flock *blk = va_arg( args, struct flock * );
        long offset = 0;

        if( cmd == F_GETLK ) {
            blk->l_type = F_UNLCK;
            return( 0 );
        }
        if( cmd == F_SETLKW ) {
            while( fcntl( fildes, F_SETLK, blk ) );
            return( 0 );
        }
        if( blk->l_whence == SEEK_CUR ) offset = tell( fildes );
        else if( blk->l_whence == SEEK_END ) offset = filelength( fildes );
        offset += blk->l_start;

        if( blk->l_type == F_UNLCK ) return( unlock( fildes,
                                                     offset,
                                                     blk->l_len ?
                                                     blk->l_len :
                                                     filelength( fildes ) ) );
        return( lock( fildes, offset,
                      blk->l_len ? blk->l_len : filelength( fildes ) ) );
        
    }

    return( -1 );
}

