#include <dos.h>
#include <string.h>

/*
 * Borland/Watcom-alike intr function.  Use "void *" because a program
 * designed for Watcom would use "union REGPACK" and a program designed
 * for the Borland family of compilers would use "struct REGPACK".
 * Also, programs designed for this CLIB can also use "union _INTREGS" or
 * "union _INTR" (some compilers only).
 */
int intdos( union REGS *inregs, union REGS *outregs )
{
    union _INTR r;

    memcpy( &r, inregs, sizeof( union REGS ) );
    _segread( &r );
    r.flags = inregs->x.flags;
    _callint( 0x21, &r, &r );
    memcpy( outregs, &r, sizeof( union REGS ) );
    outregs->x.flags = r.flags;
    outregs->x.cflag = r.cflag;

    return( r.ax );
}

