#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <errno.h>

int __dlcreat( const char *path, int attr );
#pragma aux __dlcreat = \
    "mov ax, 0x716C"    \
    "mov dx, 0x12"      \
    "mov bx, 0x0001"    \
    "stc"               \
    "int 0x21"          \
    "jnc finish"        \
    "sbb ax, ax"        \
    "finish:"           \
    parm [si] [cx]      \
    value [ax]          \
    modify [ax bx cx dx si];

int __docreat( const char *path, int attr );
#pragma aux __docreat = \
    "mov ah, 0x3C"      \
    "int 0x21"          \
    "jnc finish"        \
    "mov errno, ax"     \
    "mov _doserrno, ax" \
    "sbb ax, ax"        \
    "finish:"           \
    parm [dx] [cx]      \
    value [ax]          \
    modify [ax cx dx];

unsigned _dos_creat( const char *path, int attr, unsigned *handle )
{
#ifndef __CLIB_LFN__
    register int retval = __docreat( path, attr );

    if( retval < 0 ) return( _doserrno );
#else
    register int oldstderr = dup( 2 );
    register int retval = __dlcreat( path, attr );

    if( retval < 0 ) retval = __docreat( path, attr );
    if( retval < 0 ) {
        _dos_close( oldstderr );
        return( _doserrno );
    }
#endif
#ifndef __CLIB_LFN__
    *handle = retval;

    return( 0 );
#else
    _dos_close( 2 );
    dup2( oldstderr, 2 );
    _dos_close( oldstderr );
    _dos_close( retval );

    return( _dos_open( path, O_WRONLY, handle ) );
#endif
}
