#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <errno.h>

int __dlcrnew( const char *path, int attr );
#pragma aux __dlcrnew = \
    "mov ax, 0x716C"    \
    "mov dx, 0x10"      \
    "mov bx, 0x0001"    \
    "stc"               \
    "int 0x21"          \
    "jnc end"           \
    "sbb ax, ax"        \
    "end:"              \
    parm [si] [cx]      \
    value [ax]          \
    modify [ax bx cx dx si];

int __docrnew( const char *path, int attr );
#pragma aux __docrnew = \
    "mov ah, 0x5B"      \
    "int 0x21"          \
    "jnc end"           \
    "mov errno, ax"     \
    "mov _doserrno, ax" \
    "sbb ax, ax"        \
    "end:"              \
    parm [dx] [cx]      \
    value [ax]          \
    modify [ax cx dx];

unsigned _dos_creatnew( const char *path, int attr, unsigned *handle )
{
#ifndef __CLIB_LFN__
    register int retval = __docrnew( path, attr );

    if( retval < 0 ) return( _doserrno );

    *handle = retval;

    return( 0 );
#else
    register int oldstderr = dup( 2 );
    register int retval = __dlcrnew( path, attr );

    if( retval < 0 ) __docrnew( path, attr );
    if( retval < 0 ) {
        _dos_close( oldstderr );
        return( _doserrno );
    }

    _dos_close( 2 );
    dup2( oldstderr, 2 );
    _dos_close( oldstderr );
    _dos_close( retval );

    return( _dos_open( path, O_WRONLY, handle ) );
#endif
}
