#include <string.h>
#include <dos.h>
#include <dir.h>
#include <io.h>
#include <stdlib.h>
#include <limits.h>

char *searchpath( const char *filename )
{
    static char fullpath[ PATH_MAX ];
    char *envptr = getenv( "PATH" );

    if( access( filename, E_OK ) == 0 ) 
        return( strcpy( fullpath, __retsfn( filename ) ) );

    if( envptr == NULL ) return( NULL );

    while( *envptr ) {
        char *tok = strchr( envptr, ';' );
        int toklen;

        if( *tok ) toklen = tok - envptr;
        else toklen = strlen( envptr );

        memcpy( fullpath, envptr, toklen );
        strcpy( fullpath + toklen, "\\" );
        strcpy( fullpath + toklen + 1, filename );

        if( access( fullpath, E_OK ) == 0 )
            return( strcpy( fullpath, __retsfn( fullpath ) ) );
        envptr = tok;
        if( envptr ) envptr++;
    }

    return( NULL );
}

